;
;  Written by L. Bradshaw
;  1/01/93
;  CIS Message tracking system - demo app for Developer's conference
;
;  The purpose of this program is to build the main library by playing
;  all component programs.
;
;
;              t\  - all temporary data files.  mostly used during prob. resolution
;
;              d\  - all main data files.
;                    CIS_MSG is the cis message table -- not normalized --
;                    CIS_DUP is the duplicate cis message table
;                    CIS_SET is the criteria selection set table
;
;  Program file naming conventions <usually followed> are XXXX_A_N  where
;
;          XXXX indicates the category of program, Control is abbreviated CTRL
;          A    indicates the contents,  by program type from
;                { U - Utility,
;                  M - Menu and main,
;                  S - Settings subsystem,
;                  R - Reporting subsystem,
;                  D - Depreciation subsystem
;                }
;         N     serializes the source code so that if there are 5 files
;               composing the Reporting Subsystem,  then they will be
;               numbered 1..5, in order.  Also,  related programs are in
;               the same file,  or the next file in order.
;
;               Except for programs qualifying as utilities which are
;               usually but not always placed in the Utility file.
;
;  System Overview:
;
;  DATA LOAD PROCESS
;
;
;  Data Flow:
;
;  Flow Of Control:
;
;       The application is initiated with the main program "main()".
;       This program :
;
;            o initializes the Pdox environment
;            o verifies the existence of all essential tables and files
;            o displays the main menu
;            o traps all menu selections and invokes the appropriate program.
;              after completion,  all invoked programs return control to main(),
;              which then re-displays the main menu.
;
;  Error Handling:
;
;       The application features a sophisticated error handling procedure
;       which documents some system information in a file
;       in the default directory -> usually a LAN users home directory.
;
;       The file name is "errorlog.sc",  and is appended to if it already exists.
;
;       All problem resolution efforts should begin by located and reviewing this file.
;
libname   = "l\\MAIN"
CREATELIB libname SIZE 300
PLAY "s\\cispars1"   ;main CIS message parsing program
PLAY "s\\cis_main"   ;utility programs
PLAY "s\\critset3"   ;criteria selection/settings programs
PLAY "s\\cis_util"    ;utility programs

RELEASE PROCS ALL
RELEASE VARS ALL

AUTOLIB = "l\\MAIN"
main()

RESET
RELEASE PROCS ALL
RELEASE VARS ALL
