
;*************************************************************************
;*************************************************************************
; Formatted Source Listing
; Date : 06/14/93
; Time : 15:40:27
;
; System : CISMSG  The PARADOX-CIS Message Program
; File Name : C:\CIS\BATSYS.SC
; By : James Cap Walker and Mark Houpt with HELP from Freinds!
; Last modified 05/16/93  11:29:08 am
; This program is represents a collection of code by:
; Tony Goodman
; Dan Erhmann
; Angelo Loudon
; Dan Paolini
; Desmond Nolan
; John Nelson
; Michael Hyatt
; James Cap Walker
;
;*************************************************************************


; This program for builing LIBS is the work of Michael J. Hyatt


LIBNAME = "Paradox"
PROC LB_SETUP.U(LIBNAME)
    
    ; CreateLib LibName                     ; Comment this line out if you
    ; only want to *add* to a library
    PERCENTDONE.A = "0% Completed"
    PERCENTDONE.N = 0
    COMPLETE.A    = ""
    ISFIRSTTIME.L = TRUE
    DYNARRAY LBWATTR.Y[]
    LBWATTR.Y["HasFrame"] = FALSE
    
    DYNARRAY COLORS.Y[]
    COLORS.Y[1] = 63                         ; Window border
    COLORS.Y[2] = 48                         ; GUI Lolite
    COLORS.Y[3] = 59                         ; GUI Hilite
    COLORS.Y[4] = 48                         ; Window field names
    COLORS.Y[5] = 63                         ; Window field values
    COLORS.Y[6] = 59                         ; Status bar
    
    
    WINDOW CREATE @6,17 HEIGHT 11 WIDTH 45 TO LB.H
    WINDOW SETATTRIBUTES LB.H FROM LBWATTR.Y
    SETCANVAS LB.H
    
    FRAME DOUBLE FROM 0,0 TO 8,42
    PAINTCANVAS ATTRIBUTE COLORS.Y[1] 0,0,0,41
    PAINTCANVAS ATTRIBUTE COLORS.Y[1] 0,0,8,0
    PAINTCANVAS ATTRIBUTE COLORS.Y[1] 8,1,8,42
    PAINTCANVAS ATTRIBUTE COLORS.Y[1] 0,42,8,42
    
    FRAME SINGLE FROM 1,2 TO 7,40
    PAINTCANVAS ATTRIBUTE COLORS.Y[2] 1,2,1,40
    PAINTCANVAS ATTRIBUTE COLORS.Y[2] 1,2,7,2
    PAINTCANVAS ATTRIBUTE COLORS.Y[3] 7,3,7,40
    PAINTCANVAS ATTRIBUTE COLORS.Y[3] 1,40,7,40
    
    ECHO NORMAL
    STYLE ATTRIBUTE COLORS.Y[1]
    @0, 13 ?? " Library Builder "
    
    STYLE ATTRIBUTE COLORS.Y[4]
    @2,5 ?? "Library:"
    
    STYLE ATTRIBUTE COLORS.Y[5]
    @2,14 ?? FORMAT("cc", LIBNAME)
    
    STYLE ATTRIBUTE COLORS.Y[4]
    @3,6 ?? "Script:"
    
    @4,8 ?? "Proc:"
    
    @5,5 ?? "Percent:"
    
    @6,4 ?? "Complete:"
    
ENDPROC


PROC LB_PROCESS.U(SCRIPT.A)
    PRIVATE PROCNAME.A
    
    PROCNAME.A = "LB_Process.u"
    
    STYLE ATTRIBUTE COLORS.Y[5]
    @3, 14 ?? SCRIPT.A
    
    PLAY SCRIPT.A
    
ENDPROC



PROC LB_DISPLAYPROGRESS.U(PROCTOTAL.N, PROCNAME.A)
    
    PROCSTEP.N = PROCSTEP.N + 1
    
    PERCENTDONE.N = INT((PROCSTEP.N / PROCTOTAL.N) * 100)
    COMPLETE.A = FILL("", INT(ROUND(PERCENTDONE.N, - 1) / 4))
    PERCENTDONE.A = STRVAL(PERCENTDONE.N) + "% Completed"
    STYLE ATTRIBUTE COLORS.Y[5]
    @4, 14 ?? FORMAT("w26", PROCNAME.A)
    @5, 14 ?? PERCENTDONE.A
    STYLE ATTRIBUTE COLORS.Y[6]
    @6, 14 ?? COMPLETE.A
    
    RETURN TRUE
    
ENDPROC



PROC LB_COMPLETE.U(LIBNAME)
    PRIVATE PROCNAME.A
    
    PROCNAME.A = "LB_Complete.u"
    
    SLEEP 1000
    
    OK.U("Done", "The " + FORMAT("cc", LIBNAME) +
    " library was/successfully compiled.", TRUE, TRUE)
    WINDOW CLOSE
    
ENDPROC



;----------------------------------------------------------------------------

LIBNAME = "Paradox"                      ; Change this to the name of the
; library you want to write the
; procedures to

AUTOLIB = LIBNAME
LB_SETUP.U(LIBNAME)
LB_PROCESS.U("CisLibSc")
SLEEP 500
LB_SETUP.U(LIBNAME)
LB_PROCESS.U("Batsys")
LB_COMPLETE.U(LIBNAME)
MENU {} {Desktop} {Empty}

RELEASE VARS LIBNAME
RESET
