;*************************************************************************
; Formatted Source Listing
; Date : 11/02/93
; Time : 15:01:18
;
; System : CISMSG  The PARADOX-CIS Message Program
; File Name : C:\CIS\BATSYS.SC
; By : James Cap Walker and Mark Houpt with HELP from Freinds!
; Last modified 05/16/93  11:29:08 am
; Portion Copyright (c) 1992-1993  BAT-Systems Consulting
; This program is represents a collection of code by:
; Tony Goodman
; Dan Erhmann
; Angelo Loudon
; Dan Paolini
; Desmond Nolan
; John Nelson
; Michael Hyatt
; James Cap Walker
; Michael J. Hyatt
; Norm Bowler
; David Gassner
;*************************************************************************



LIBNAME="Paradox"


PROCSTEP.N = 0
PROCTOTAL.N = 46

;BSC
; PROCEDURE   : MainMenu
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: Generated by Weston Brothers wbsLIB
;
;BSC

PROC MAINMENU()
   IF NOT ISASSIGNED(AUTOLIB) THEN
      AUTOLIB = "Paradox"
   ENDIF
   IF SETUP <> 1 THEN
      START.M()
   ENDIF
   MENUSEL="Messages"
   SPLASHSCR(1)
   WHILE TRUE
      SYSINFO TO SYSVAL
      SETCANVAS DEFAULT
      PAINTCANVAS FILL "" ATTRIBUTE SYSCOLOR(1000) 1, 0, SYSVAL["SCREENHEIGHT"] - 2, SYSVAL["SCREENWIDTH"] - 1
      RELEASE VARS SYSVAL
      PROMPT ""
      SHOWPULLDOWN
         "" : "System Menu" : ""
         SUBMENU
            "About" : "About Box" : "/About",
            "Clock" : "Clock" : "/Clock",
            "System" : "System Information" : "/System",
            "" : "" : "/",
            "Backup" : "Backup All Files" : "/Backup",
            "Pack Data" : "Remove Deleted File Space in Tables" : "/Pack",
            "" : "" : "/",
            "Shell to ~D~OS" : "" : "/Shell to DOS"
         ENDSUBMENU,
         "Messages" : "Messages Menu" : "Messages"
         SUBMENU
            "View ALL Messages" : "View All Stored Messages" : "Messages/View ALL",
            "" : "" : "Messages/",
            "~C~onvert New Messages  ~Alt-M~" : "Convert New CIS Messages" : "Messages/Convert New CIS Messages",
            "View ~L~ast Import" : "View most recent Import of Messages" : "Messages/View Last Import",
            "" : "" : "Messages/",
            "~Q~uery Message Database" : "Query Message Database for Specific Forums" : ""
            SUBMENU
               "Query By ~F~orum Only" : "Query Message Database for Specific Forums" : "Messages/Query Message Database",
               "Query By ~S~ection Only" : "Query Message Database for Specific Section" : "Messages/Query Message Database Section",
               "~Q~uery Section By Subject" : "Query Message Sections for Selected Subjects" : "Messages/Query Message Database Section-Subject",
               "~U~ser Defined Query" : "Query Message Sections by User Defined Query" : "Messages/Query Message Database UserD"
            ENDSUBMENU,
            "View Query ~R~esults" : "View Results table for Message Query" : "Messages/View Query Results"
         ENDSUBMENU,
         "Catalogs" : "Catalog Data Libraries" : "Catalogs"
         SUBMENU
            "View ALL Catalogs" : "View ALL files in CAT Table" : "Catalogs/View ALL Files",
            "" : "" : "Catalogs/",
            "~C~onvert New Catalogs  ~Alt-C~" : "Convert and Import New CAT Files" : "Catalogs/Convert and Import CAT Files",
            "View ~L~ast Import" : "View most recent Inport of Catalog" : "Catalogs/View Last Import",
            "" : "" : "Catalogs/",
            "Query Catalog Database" : "Query Catalog Database for Specific Forums" : ""
            SUBMENU
               "Query By ~F~orum" : "Query Catalog Database for Specific Forums" : "Catalogs/Query Message Database",
               "Query By Forum-~L~ibrary" : "Query Catalog Database for Specific Library" : "Catalogs Library"
            ENDSUBMENU,
            "View Query ~R~esults" : "View Results table for Catalog Query" : "Catalogs/View Query Results"
         ENDSUBMENU,
         "Reports" : "Reports Menu" : "Reports"
         SUBMENU
            "All Forum Messages" : "Report all Forum Messages" : "Reports/All Forum Messages",
            "Last Forum Messages" : "Report forum Messages from Last Import" : "Reports/Last Forum Messages",
            "Query Message Report" : "Report all Messages in Most Recent Query" : "Reports/Query Message Report",
            "" : "" : "Reports/",
            "Catalog Report" : "Report ALL Catalog Entries" : "Reports/Catalog Report"
         ENDSUBMENU,
         "Setup" : "Setup Menu" : "Setup"
         SUBMENU
            "Set~U~p" :  "SetUp Directory for MSG and CAT Files" : "/SetUp",
            "" : "" : "/",
            "Documentation" : "Program Documentation" : "/DocFile"
         ENDSUBMENU,


         "Exit" : "Exit Menu" : "Exit"
         SUBMENU
            "Exit to Paradox" : "Exit to Paradox if Available" : "Exit/Exit to Paradox",
            "~Q~uit Program   ~Ctrl-X~" : "" : "Exit/Quit Program"
         ENDSUBMENU
      ENDMENU
   UNTIL 24,-59,-50,-46
   GETMENUSELECTION KEYTO KEYCODE TO MENUSEL
 ; **************************************************************
 ; IF YOU HAVE PDOX V4.5 COMMENT OUT  THE LINE ABOVE AND UNCOMMENT
 ; THE GETMENUSELECTION LINE BELOW FOR STICKY MENUS.  Run Makelib
 ; **************************************************************
 ;  GETMENUSELECTION DEFAULT Menusel KEYTO KEYCODE TO MENUSEL

   SWITCH
      CASE KEYCODE = 24:
         ;Ctrl - X
         SetScreen()
         LEAVEAPP(2)

      CASE KEYCODE = -59:
         ; F1
         SetScreen()
         VIEWDOC()
         PROMPT ""
         SPLASHSCR(2)

      CASE KEYCODE = -50:
         ; Alt-M
         SetScreen()
         SWITCH
            CASE FILEHANDLE[1] = 1 OR FILEHANDLE[1] =BLANKNUM():
               MTHIMPORTFILE(1,1,TRUE,1,1) ;msg
            CASE FILEHANDLE[1] = 2:
               MTHIMPORTFILE(1,2,TRUE,1,1) ;mes Ozcis
            CASE FILEHANDLE[1] = 3:
               MTHIMPORTFILE(1,3,TRUE,1,1) ;SAV
            CASE FILEHANDLE[1] = 4:
               MTHIMPORTFILE(1,4,TRUE,1,1) ;PRG Ozcis

         ENDSWITCH
         SPLASHSCR(2)

      CASE KEYCODE = -46:
         ; Alt-C
         SetScreen()
         SWITCH
            CASE FILEHANDLE[1] = 1 OR FILEHANDLE[1] = 3 OR FILEHANDLE[1]= 4 OR FILEHANDLE[1] =BLANKNUM():
               MTHIMPORTFILE(2,1,TRUE,1,1) ;cat not ozcis
            Otherwise:
               MTHIMPORTFILE(2,2,TRUE,1,1) ;cat ozcis
         ENDSWITCH
         SPLASHSCR(2)


      CASE RETVAL = FALSE :
         ; click on nothing
         BEEPEM.U("illegal")


      CASE MENUSEL = "/About" :
         SetScreen()
         SHOWABOUTBOX()
         SPLASHSCR(2)


      CASE MENUSEL = "/Clock" :
         SetScreen()
         TIMEDISPLAY()
         SPLASHSCR(2)

      CASE MENUSEL = "/System" :
         SetScreen()
         SYSINFOPROC()
         SPLASHSCR(2)

      CASE MENUSEL = "/SetUp" :
         SetScreen()
         START.M()
         SPLASHSCR(2)


      CASE MENUSEL = "/Backup" :
         SetScreen()
         BACKUPMANAGER()
         SPLASHSCR(2)


      CASE MENUSEL = "/Pack" :
         SetScreen()
         PACKDATA()
         SPLASHSCR(2)

      CASE MENUSEL = "/DocFile" :
         SetScreen()
         VIEWDOC()
         SPLASHSCR(2)

      CASE MENUSEL = "/" :

      CASE MENUSEL = "/Shell to DOS" :
         SetScreen()
         RUN BIG "command"
         SPLASHSCR(2)


      CASE MENUSEL = "Messages/View ALL" :
         SetScreen()
         ICISTAT1UPDATE("Icistat",2)
         SPLASHSCR(2)

      CASE MENUSEL = "Messages/" :
      CASE MENUSEL = "Messages/Convert New CIS Messages" :
         SetScreen()
         SWITCH
            CASE FILEHANDLE[1] = 1 OR FILEHANDLE[1] =BLANKNUM():
               MTHIMPORTFILE(1,1,TRUE,1,1) ;msg
            CASE FILEHANDLE[1] = 2:
               MTHIMPORTFILE(1,2,TRUE,1,1) ;mes Ozcis
            CASE FILEHANDLE[1] = 3:
               MTHIMPORTFILE(1,3,TRUE,1,1) ;SAV
            CASE FILEHANDLE[1] = 4:
               MTHIMPORTFILE(1,4,TRUE,1,1) ;PRG Ozcis
         ENDSWITCH
         SPLASHSCR(2)

      CASE MENUSEL = "Messages/View Last Import" :
         SetScreen()
         ICISTAT1UPDATE("Last",2)
         IF FILEHANDLE[9] = 1 THEN
            ADDRECS()
         ENDIF
         SPLASHSCR(2)

      CASE MENUSEL = "Messages/" :

      CASE MENUSEL = "Messages/Query Message Database" :
         SetScreen()
         GETDIAG(1)
         SPLASHSCR(2)

      CASE MENUSEL = "Messages/Query Message Database Section" :
         SetScreen()
         GETDIAG(3)
         RELEASE VARS ALLSECT.Y, SHOWSECT.Y
         SPLASHSCR(2)

      CASE MENUSEL = "Messages/Query Message Database Section-Subject" :
         SetScreen()
         GETDIAG(4)
         RELEASE VARS ALLSECT.Y, SHOWSECT.Y
         SPLASHSCR(2)

      CASE MENUSEL = "Messages/Query Message Database UserD":
         oldlib=autolib
         SetScreen()
         Autolib="Paradox,QryLib"
         UserDefQryView()
         Autolib=oldlib
         SPLASHSCR(2)


      CASE MENUSEL = "Messages/View Query Results" :
         SetScreen()
         ICISTAT1UPDATE("QueryMsg",1)
         SPLASHSCR(2)

      CASE MENUSEL = "Catalogs/View ALL Files" :
         SetScreen()
         ICISTAT1UPDATE("Idl",1)
         SPLASHSCR(2)

      CASE MENUSEL = "Catalogs/Convert and Import CAT Files" :
         SetScreen()
         SWITCH
            CASE FILEHANDLE[1] = 1 OR FILEHANDLE[1] = 3 OR FILEHANDLE[1]= 4 OR FILEHANDLE[1] =BLANKNUM():
               MTHIMPORTFILE(2,1,TRUE,1,1) ;cat not ozcis
            Otherwise:
               MTHIMPORTFILE(2,2,TRUE,1,1) ;cat ozcis
         ENDSWITCH
         SPLASHSCR(2)

      CASE MENUSEL = "Catalogs/View Last Import" :
         SetScreen()
         ICISTAT1UPDATE("lastdl",1)
         SPLASHSCR(2)

      CASE MENUSEL = "Catalogs/" :
      CASE MENUSEL = "Catalogs/Query Message Database" :
         SetScreen()
         GETDIAG(2)
         SPLASHSCR(2)

      CASE MENUSEL = "Catalogs Library" :
         SetScreen()
         GETCATSECT()
         SPLASHSCR(2)


      CASE MENUSEL = "Catalogs/View Query Results" :
         SetScreen()
         ICISTAT1UPDATE("QueryCat",1)
         SPLASHSCR(2)


      CASE MENUSEL = "WorkSheets/Msg Count" :
         SetScreen()
         GETMSGCOUNT()
         SPLASHSCR(2)

      CASE MENUSEL = "Reports/All Forum Messages" :
         SetScreen()
         GETRPT(1)
         SPLASHSCR(2)

      CASE MENUSEL = "Reports/Last Forum Messages" :
         SetScreen()
         GETRPT(2)
         SPLASHSCR(2)

      CASE MENUSEL = "Reports/Query Message Report" :
         SetScreen()
         GETRPT(3)
         SPLASHSCR(2)

      CASE MENUSEL = "Reports/" :
      CASE MENUSEL = "Reports/Catalog Report" :
         SetScreen()
         GETRPT(4)
         SPLASHSCR(2)

      CASE MENUSEL = "Exit/Exit to Paradox" :
         SetScreen()
         LEAVEAPP(1)


      CASE MENUSEL = "Exit/Quit Program" :
         SetScreen()
         LEAVEAPP(2)


   ENDSWITCH

   ; Autolib = SaveAutolib
ENDWHILE

CLEARPULLDOWN

ENDPROC
WRITELIB LIBNAME MAINMENU
RELEASE PROCS MAINMENU
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "MainMenu" )



;BSC
; PROCEDURE   : Icistat1Update
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: View Message and Catalog Procedure
;
;BSC

PROC ICISTAT1UPDATE(TBLS, NBR)
   PRIVATE  TBLS, NBR

   OKPRINT = NBR ;initualize variable to allow printing in coedit mode
   WINM = 1 ; initualize variable to track memo window size
   WINTOCLOSE = 1 ; track variable that count windows to close
   ; Sets up buttons required by Tony Goodman's GUIButton
   ; Speedbar Procedure.
   ;
   DYNARRAY BUTTONS[]

   DYNARRAY BUTTONS[]
   BUTTONS["Quit"]="QuitView()"
   IF NBR = 1 THEN
      BUTTONS["System"]="SysInfoProc()" ; view mode button
      BUTTONS["Print"]="DT_Rec_PRINT_CUSTOM(1)"
   ELSE
      BUTTONS["Delete"]="DelMsg()" ; coedit mode button
      BUTTONS["Print"]="DT_Rec_PRINT_CUSTOM(2)"
   ENDIF
   BUTTONS[">>"]="End"
   BUTTONS[">"]= "PgDn"
   BUTTONS["<"]= "PgUp"
   BUTTONS["<<"]="Home"
   BUTTONS["Find"]="Zoom"
   BUTTONS["Sort"]= "OrderTable"
   BUTTONS["Help"]= "HelpMeDlg(3)"

   ECHO OFF
   IF NRECORDS(TBLS) >= 1 THEN
      IF NBR > 1 THEN
         COEDIT TBLS
         IMAGERIGHTS READONLY
      ELSE
         VIEW TBLS
      ENDIF
      SOURCETBLWIN = GETWINDOW()
      WINDOW MOVE SOURCETBLWIN TO 10,-200
      ;WINDOW HANDLE FORM TO SOURCEFRM
      PICKFORM 1
      FORMWINDOW=GETWINDOW()
      MAXWINDOW(FORMWINDOW) ; procedure to setup form window
      FIXMSGBOX(1) ; proceedure to setup memo window and make form current
      BUTTON_OBJECTS(BUTTONS) ;Calls Setup for the Buttons
      IF NBR > 1 THEN
         SHOWPULLDOWN
            ""       :  "Display Systems Information"             : "AppInfo",
            "Window"    :  "Save Records and Return"                 : ""
            SUBMENU
               "P~r~int"     :   " Print Current Record"  : "PrintRec",
               "Memo Window" :   "Move to Memo Window"    : "SelWin1",
               "Form ~W~indow" :   "Move to Form Window"    : "SelWin2",
               "Help"        : "Open Help Window"         : "HelpWind"
            ENDSUBMENU,
            "Record"      :  "Delete or Undo Deletes"     : ""
            SUBMENU
               "Delete"    :   "Delete Current Message"  : "DelMsg",
               "Undo"      :   "Undo Last Delete"        : "UndoDel",
               "~F~irst"    :   " Moveto Leaselog Table"  : "FirstRec",
               "~L~ast"    :   " Moveto Leaselog Table"  : "LastRec",
               "~N~ext"    :   " Moveto Leaselog Table"  : "NextRec",
               "~P~revious"    :   " Moveto Leaselog Table"  : "PrevRec"
            ENDSUBMENU,

            "~E~xit"      :  "Exit View Screen"                     : "QuitView"
         ENDMENU
      ELSE
         SHOWPULLDOWN
            ""       :  "Display Systems Information"             : "AppInfo",
            "~T~able"    :  "Save Records and Return"                 : ""
            SUBMENU
               "~F~irst"    :   " Moveto Leaselog Table"  : "FirstRec",
               "~L~ast"    :   " Moveto Leaselog Table"  : "LastRec",
               "~N~ext"    :   " Moveto Leaselog Table"  : "NextRec",
               "~P~revious"    :   " Moveto Leaselog Table"  : "PrevRec",
               "P~r~int"     :   " Print Current Record"  : "PrintRec",
               "Memo Window" :   "Move to Memo Window"    : "SelWin1",
               "Form ~W~indow" :   "Move to Form Window"    : "SelWin2",
               "Help"        : "Open Help Window"         : "HelpWind"

            ENDSUBMENU,
            "~E~xit"      :  "Exit View Screen"                     : "QuitView"
         ENDMENU
      ENDIF
      PROMPT ""
      WAIT WORKSPACE
      PROC "DelMsgWait"
         KEY "DOS" , "DOSBIG" , "F2" , "ZOOM" , "FIELDVIEW" , -108, "F4" , "F3" , 16, "PgDn" , "PgUp" ,-49, -25, "DEL" , "INS" , 21
         MESSAGE "MENUSELECT" , "MAXIMIZE"
         MOUSE "DOWN" ,"AUTO"
         TRIGGER "ARRIVETABLE"
      ENDWAIT
      PROMPT ""
      ECHO OFF
   ELSE
      OK.U("FILE EMPTY", "There are NO records//in the Table" , TRUE,TRUE)
      ECHO OFF
   ENDIF
ENDPROC

WRITELIB LIBNAME ICISTAT1UPDATE
RELEASE PROCS ICISTAT1UPDATE
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "Icistat1Update" )




;BSC
; PROCEDURE   : DeleteMsgBox
; AUTHOR      : Mark Schoen
; COPYRIGHT   : (C) 1993 Mark Schoen
; PARAMETERS  : None
;
;
;
; RETURNS     : True if YES False if Cancel or ESC
;
; Special Info:
;
;BSC
PROC DELETEMSGBOX()
   ; PaintPAL_Generated_Code_Begin(449941240)
   OKBUTTON = "Cancel"
   SHOWDIALOG
      "DELETE WARNING"
      @6,15 HEIGHT 13 WIDTH 49

      PAINTCANVAS FILL " " ATTRIBUTE 112 3,8,3,40

      PAINTCANVAS FILL " " ATTRIBUTE 112 5,14,5,36

      PAINTCANVAS FILL " " ATTRIBUTE 207 1,12,1,34

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,2 TO 10,45
      PAINTCANVAS ATTRIBUTE 127 0,2,0,45
      PAINTCANVAS ATTRIBUTE 112 10,2,10,45
      PAINTCANVAS ATTRIBUTE 127 0,2,10,2
      PAINTCANVAS ATTRIBUTE 112 0,45,10,45
      ; PaintPAL_Frame_End

      @3,8
      ?? " Are You Sure You Want To Delete"

      @5,14
      ?? "Message #" +" "+[msg number]

      @1,12
      ?? "    W A R N I N G..."

      PAINTCANVAS ATTRIBUTE 112 3,7,3,39

      PAINTCANVAS ATTRIBUTE 112 5,12,5,34

      PAINTCANVAS ATTRIBUTE 207 1,12,1,34

      PUSHBUTTON @8,8 WIDTH 10
         "~O~k"
         OK
         DEFAULT
         VALUE "OK"
         TAG "OK"
         TO OKBUTTON

      PUSHBUTTON @8,28 WIDTH 12
         "~C~ancel"
         CANCEL
         VALUE "Cancel"
         TAG "Cancel"
         TO OKBUTTON
   ENDDIALOG
   IF OKBUTTON = "OK" THEN
      RETVAL = TRUE ; allows record to be delete
   ELSE
      RETVAL = FALSE ; cancel or esc chosen - do not delete record
   ENDIF
   RETURN RETVAL
   ; PaintPAL_Generated_Code_End(449941240)

ENDPROC
WRITELIB LIBNAME DELETEMSGBOX
RELEASE PROCS DELETEMSGBOX
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DeleteMsgBox" )


;BSC
; PROCEDURE   : DelMsg
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : none
;
;
;
; RETURNS     : Processes del key and returns 0 or return 1 if canceled
;
; Special Info: Used with Button Bar Delete
;
;BSC
PROC DELMSG()
   PRIVATE  OKDELETE

   OKDELETE = ""
   IF FILEHANDLE[8] = 1 THEN ; do we show delete warning box
      OKDELETE=DELETEMSGBOX() ; yes if fh[8] = 1
   ELSE
      OKDELETE = TRUE ; otherwise allow delete
   ENDIF
   IF WINM = 2 THEN ; if in maximized memo window
      IF OKDELETE = TRUE THEN
         IMAGERIGHTS
         ECHO OFF
         WINDOW SELECT FORMWINDOW ; moves active window to Form
         DEL
         IMAGERIGHTS READONLY
         WINDOW SELECT MEMOWINDOW ; moves active window to memo
         ECHO NORMAL
         RETURN 1
      ENDIF
   ELSE
      IF OKDELETE = TRUE THEN
         IMAGERIGHTS ; allow delete
         WINDOW SELECT FORMWINDOW ; moves active window to Form
         DEL
         IMAGERIGHTS READONLY ; back to view only
         RETURN 1
      ELSE
         RETURN 1
      ENDIF
   ENDIF
   RETURN 1
ENDPROC

WRITELIB LIBNAME DELMSG
RELEASE PROCS DELMSG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DelMsg" )


;BSC
; PROCEDURE   :
; AUTHOR      : Mark Schoen and Mark T. Houpt
; COPYRIGHT   : (C) 1993 Mark Schoen
; PARAMETERS  :
;
;
;
; RETURNS     :
;
; Special Info:  WaitProc for Icistat Table allowing Deletes
;
;BSC
PROC DELMSGWAIT(EVENTTYPE,EVENTRECORD,CYCLENUMBER)

   ECHO OFF
   SWITCH
         ; Tony Goodman's GUIBUTON handling routine
         ;
      CASE EVENTRECORD["TYPE"] = "MOUSE":
         WINHANDLE=WINDOWAT(EVENTRECORD["Row"],EVENTRECORD["Col"])
         IF WINHANDLE >0 THEN
            WINDOW GETATTRIBUTES WINHANDLE TO WINATTRIB

            IF MATCH(WINATTRIB["Title"],"..;METHOD") THEN
               GUIFRAME(WINHANDLE,"In")
               IF EVENTRECORD["Action"]="DOWN" THEN
                  SLEEP 100
               ENDIF
               GUIFRAME(WINHANDLE,"Out")

               EXECUTE WINATTRIB["Title"] ;Execute Button Method
               IF ISASSIGNED(RETVAL) AND
               (RETVAL=1 OR RETVAL=2 OR RETVAL=0) THEN
                  RETURN RETVAL ;Return a 0 or 1 or 2
               ELSE
                  RETURN 1 ;Return to Wait
               ENDIF
            ELSE

               RETURN 0
            ENDIF
         ENDIF
         RETURN 0 ;Process the Mouse EVENTRECORD normally
         ;
      CASE EVENTRECORD["TYPE"] = "KEY" :
         SWITCH
            CASE EVENTRECORD["Keycode"] = ASC("DEL") :
               IF okprint > 1 THEN
                  OKDELETE = ""
                  IF FILEHANDLE[8] = 1 THEN
                     OKDELETE=DELETEMSGBOX()
                  ELSE
                     OKDELETE = TRUE
                  ENDIF
                  IF WINM = 2 THEN
                     IF OKDELETE = TRUE THEN
                        IMAGERIGHTS
                        ECHO OFF
                        WINDOW SELECT FORMWINDOW ; moves active window to Form
                        DEL
                        IMAGERIGHTS READONLY
                        WINDOW SELECT MEMOWINDOW ; moves active window to
                        ECHO NORMAL
                        RETURN 1
                     ENDIF
                  ELSE
                     IF OKDELETE = TRUE THEN
                        IMAGERIGHTS
                        WINDOW SELECT FORMWINDOW ; moves active window to Form
                        DEL
                        IMAGERIGHTS READONLY
                        RETURN 1
                     ELSE
                        RETURN 1
                     ENDIF
                  ENDIF
               ENDIF
               RETURN 1
            CASE EVENTRECORD["Keycode"] = ASC("F2") :
               WINDOW SELECT FORMWINDOW ; moves active window to memo
               IF okprint > 1 THEN
                  DO_IT!
               ENDIF
               QUITVIEW()
               RETURN 2
            CASE EVENTRECORD["KEYCODE"] = ASC("F3"):
               DOWNIMAGE
               RETURN 1
            CASE EVENTRECORD["KEYCODE"] = ASC("F4"):
               UPIMAGE
               RETURN 1
            CASE EVENTRECORD["KEYCODE"] = ASC("PgUp"):
               PGUP
               RETURN 1
            CASE EVENTRECORD["KEYCODE"] = ASC("PgDn"):
               PGDN
               RETURN 1
            CASE EVENTRECORD["Keycode"] = ASC("INS") :
               MESSAGE "You cannot use INSERT mode here"
               RETURN 1
            CASE EVENTRECORD["KEYCODE"] = -108:
               ; fieldview key
               RETURN 0
            CASE EVENTRECORD["KEYCODE"] = 21:
               IF OKPRINT > 1 THEN
                  UNDO
               ENDIF
               RETURN 1
            CASE EVENTRECORD["KEYCODE"] = -49:
               ; Alt-N
               IF NOT ATLAST() THEN
                  ECHO OFF
                  WINDOW SELECT FORMWINDOW ; moves active window to form
                  PGDN ; moves to next record
                  WINDOW SELECT MEMOWINDOW ; moves active window to memo
                  ECHO NORMAL
               ELSE
                  BEEPEM.U("illegal")
               ENDIF
               RETURN 1
            CASE EVENTRECORD["KEYCODE"] = -25:
               ; Alt-P
               IF NOT ATFIRST() THEN
                  ECHO OFF
                  WINDOW SELECT FORMWINDOW ; moves active window to form
                  PGUP ; moves to prior record
                  WINDOW SELECT MEMOWINDOW ; moves active window to memo
                  ECHO NORMAL
               ELSE
                  BEEPEM.U("illegal")
               ENDIF
               RETURN 1
            CASE EVENTRECORD["KEYCODE"] = ASC("FIELDVIEW"):
               RETURN 0 ;FieldView Key
               OTHERWISE:
               RETURN 0

         ENDSWITCH
      CASE EVENTRECORD["MESSAGE"] = "MENUSELECT" :
         SWITCH
            CASE EVENTRECORD["MENUTAG"] = "AppInfo":
               SHOWABOUTBOX()
               RETURN 1
            CASE EVENTRECORD["MENUTAG"] = "UndoDel":
               UNDO
               RETURN 1
            CASE EVENTRECORD["MENUTAG"] = "DelMsg":
               DELMSG()
               RETURN 1
            CASE EVENTRECORD["MENUTAG"] = "QuitView":
               QUITVIEW() ; return to Main Menu
               IF OKPRint > 1 THEN
                  DO_IT!
               ENDIF
               RETURN 2
            CASE EVENTRECORD["MENUTAG"] = "FirstRec":
               HOME ; Move to first record
               RETURN 1
            CASE EVENTRECORD["MENUTAG"] = "LastRec":
               END ; move to last record
               RETURN 1
            CASE EVENTRECORD["MENUTAG"] = "PrevRec":
               PGUP ; move to previous record
               RETURN 1
            CASE EVENTRECORD["MENUTAG"] = "NextRec":
               PGDN ; move to next record
               RETURN 1
            CASE EVENTRECORD["MENUTAG"] = "PrintRec":
               ; Kallista's Print Current Record
               IF OKPRINT = 1 THEN
                  DT_REC_PRINT_CUSTOM(1)
               ELSE
                  DT_REC_PRINT_CUSTOM(2)
               ENDIF
               RETURN 1
            CASE EVENTRECORD["MENUTAG"] = "SelWin1":
               WINDOW SELECT MEMOWINDOW ; moves active window to memo
               RETURN 1 ; top window in view screen
            CASE EVENTRECORD["MENUTAG"] = "SelWin2":
               WINDOW SELECT FORMWINDOW ; moves active window to form
               MOVETO [FORUM] ; fieldview window
               WINTOCLOSE = 2 ; sets variable for window close procedure
               RETURN 1 ; as to how many windows to close
            CASE EVENTRECORD["MENUTAG"] = "HelpWind":
               HELPMEDLG(3) ; displays help diag - param sets message to display
               RETURN 1
               OTHERWISE:
               RETURN 0
         ENDSWITCH
      CASE EVENTRECORD["MESSAGE"] = "MAXIMIZE" :
         IF WINM = 1 THEN
            WINDOW RESIZE GETWINDOW() TO 21, 80 ; maximizes memo window
            WINDOW MOVE GETWINDOW() TO 1, 0
            SETWINDOW(GETWINDOW(),1)
            WINM = 2 ; sets variable so program knows window is maxed
         ELSE
            IF UPPER(TABLE()) = "IDL" OR UPPER(TABLE()) = "LASTDL" OR UPPER(TABLE()) = "QUERYCAt" THEN
               WINDOW RESIZE GETWINDOW() TO 11, 80 ; returns memo window to original size
               WINDOW MOVE GETWINDOW() TO 11, 0
            ELSE
               WINDOW RESIZE GETWINDOW() TO 13, 80 ; returns memo window to original size
               WINDOW MOVE GETWINDOW() TO 9, 0
            ENDIF
            SETWINDOW(GETWINDOW(),1)
            WINM = 1 ; set variable to prog knows memo window is normal size
         ENDIF
         RETURN 1
         OTHERWISE:
         RETURN 0
   ENDSWITCH
ENDPROC
WRITELIB LIBNAME DELMSGWAIT
RELEASE PROCS DELMSGWAIT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DelMsgWait" )





;BSC
; PROCEDURE   : QuitView
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: Closes all open windows when exiting View
;               including ButtonBar
;BSC

PROC QUITVIEW()
   ECHO OFF
   IF ISFIELDVIEW() THEN
      IF SEARCH("M", FIELDTYPE()) > 0 THEN
         WINDOW
         CLOSE ; cancel memo field changes
      ELSE
         DO_IT! ; end non-memo fieldview
      ENDIF
   ENDIF
   IF SYSMODE() <> "Main"
   THEN
      DO_IT!
   ENDIF

   MESSAGE ""
   WINDOW LIST TO ALLWINDOWS
   SWITCH
      CASE WINTOCLOSE = 1:
         FOR WINDOWHANDLE FROM 1 TO ARRAYSIZE(ALLWINDOWS)-1 ; gathers array of all open
            WINDOW SELECT ALLWINDOWS[windowhandle] ; windows then closes windows
            WINDOW
            CLOSE
         ENDFOR
      CASE WINTOCLOSE = 2:
         FOR WINDOWHANDLE FROM 1 TO ARRAYSIZE(ALLWINDOWS)-2 ; gathers array of all open
            WINDOW SELECT ALLWINDOWS[windowhandle] ; windows then closes windows
            WINDOW
            CLOSE
         ENDFOR
   ENDSWITCH
   MESSAGE ""
   WBSFILLSCREEN()
   CLEARALL
   RELEASE VARS ALLWINDOWS
   RETURN 2
ENDPROC
WRITELIB LIBNAME QUITVIEW
RELEASE PROCS QUITVIEW
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "QuitView" )



;BSC
; PROCEDURE   : GetDiag
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : (nbr) is the param indicating what type of query was
;               requested 1 forum  2 Section,  3 Subject
; RETURNS     : n/a
; Special Info: calls dialog box for Message query and checks to see if
;               cancel or escape was pressed
;BSC
PROC GETDIAG(NBR)
   PRIVATE  NBR

   CLEARALL
   SWITCH
      CASE NBR = 1:
         ANS=CISDIAG(1)
         IF ANS <> "Cancel" THEN ; Cancel or Escape not pressed
            QUERYFORMSG(1) ; begins for forum query
         ELSE
            MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, FALSE)
            SLEEP 2000
            CLEARMESSAGE.U()
         ENDIF
      CASE NBR = 2:
         ANS=CISDIAG(2)
         IF ANS <> "Cancel" THEN
            QUERYFORCAT() ; begins catalog query
         ELSE
            MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, FALSE)
            SLEEP 2000
            CLEARMESSAGE.U()
         ENDIF
      CASE NBR = 3:
         ANS=GETSECTIONSDLG.A()
         IF ANS <> "Cancel" THEN
            QUERYFORMSG(2) ; begins section query
         ELSE
            MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, FALSE)
            SLEEP 2000
            CLEARMESSAGE.U()
         ENDIF

      CASE NBR = 4:
         ANS=GETSECTIONSDLG.A()
         IF ANS <> "Cancel" THEN
            QUERYFORMSG(3) ; begins subject query
         ELSE
            MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, FALSE)
            SLEEP 2000
            CLEARMESSAGE.U()
         ENDIF

   ENDSWITCH
ENDPROC
WRITELIB LIBNAME GETDIAG
RELEASE PROCS GETDIAG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetDiag" )





;BSC
; PROCEDURE   : CisDiag
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     : RetVal
; Special Info: Build array of Forum Names for Diag Box
;BSC

PROC CISDIAG(NBR)
   PRIVATE  I,J,NBR,MTABLE1, MTABLE2, FNAME

   IF FILEHANDLE[6] <> 1 THEN ; program has already run autobuild of forums list
      RSP=YESNO.L("UPDATE", "Do you wish to Update your Forum List?" ,TRUE,TRUE)
   ELSE
      RSP = TRUE
      VIEW "start"
      IF [forum] <> 2 THEN
         COEDIT "Start"
         [forum] = 2
         FILEHANDLE[6] = 2 ; lets program know auto pass has already been done
         DO_IT!
      ENDIF
      CLEARALL
   ENDIF
   IF RSP= TRUE THEN

      MESSAGE.U("FORUMS", "Gathering Forum Names/" + "Please Wait..." , TRUE, FALSE)
      SWITCH
         CASE NBR = 1:
            ;  dsQueryToPAL: Begin Query
            ;     Generated: June 14, 1993 - 23:25:46
            ;   Description:
            ;

            {Ask} SELECT "Icistat"
            MOVETO [Forum] CHECK
            DO_IT!
         CASE NBR = 2:
            ;  dsQueryToPAL: Begin Query
            ;     Generated: June 14, 1993 - 23:25:46
            ;   Description:
            ;

            {Ask} SELECT "Idl"
            MOVETO [Forum] CHECK
            DO_IT!

      ENDSWITCH
      IF NRECORDS("Answer") >=1 THEN
         EMPTY "Forum"
         ADD "Answer" "Forum"

      ENDIF
   ENDIF

   VIEW "forum"
   J = NRECORDS("forum") ; build array of foru names and include
   ARRAY FORUMS[j+1] ; ALL forums as a first choice
   FORUMS[1] = "ALL"
   FOR I FROM 1 TO J
      MOVETO RECORD(I)
      FORUMS[i+1] = [forum]
   ENDFOR
   CLEARALL
   CLEARMESSAGE.U()
   ; PaintPAL_Generated_Code_Begin(428099811)

   OKCANCEL = "Cancel"
   FORUM.A=1
   SDATE=BLANKDATE()
   EDATE=BLANKDATE()
   PICKRB=2


   SHOWDIALOG
      "Forum Query Dialog"
      PROC "CisDiagPROC"
      KEY 13

      @3,15 HEIGHT 18 WIDTH 49

      PAINTCANVAS FILL "Pick Forum" ATTRIBUTE 112 2,5,2,14

      PAINTCANVAS FILL "Date Range" ATTRIBUTE 112 5,31,5,40

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 1,2 TO 3,18
      PAINTCANVAS ATTRIBUTE 127 1,2,1,18
      PAINTCANVAS ATTRIBUTE 127 1,2,3,2
      PAINTCANVAS ATTRIBUTE 112 3,3,3,18
      PAINTCANVAS ATTRIBUTE 112 1,18,3,18
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 4,27 TO 6,44
      PAINTCANVAS ATTRIBUTE 127 4,27,4,44
      PAINTCANVAS ATTRIBUTE 127 4,27,6,27
      PAINTCANVAS ATTRIBUTE 112 6,28,6,44
      PAINTCANVAS ATTRIBUTE 112 4,44,6,44
      ; PaintPAL_Frame_End

      PICKARRAY @5,2 HEIGHT 9 WIDTH 17
         COLUMNS 1
         FORUMS
         TAG "ForumTag"
         TO FORUM.A

      RADIOBUTTONS @1,28 HEIGHT 2 WIDTH 12
         "All",
         "Todays"
         TAG "RBtag"
         TO PICKRB

      ACCEPT @8,30 WIDTH 12
      "D"
      TAG "SdateTag"
      TO SDATE

      LABEL @7,30
         "Start Date"
         FOR "SdateTag"

      ACCEPT @10,30 WIDTH 12
      "D"

      TAG "EdateTag"
      TO EDATE

      LABEL @9,30
         "End Date"
         FOR "EdateTag"


      PUSHBUTTON @13,24 WIDTH 8
         "~O~k"
         OK
         DEFAULT
         VALUE "Ok"
         TAG "OkTag"
         TO OKCANCEL

      PUSHBUTTON @13,33 WIDTH 12
         "~C~ancel"
         CANCEL
         VALUE ""
         TAG "CancelTag"
         TO OKCANCEL


   ENDDIALOG
   IF OKCANCEL <> "Cancel" THEN
      RETURN "PickRb" ; if selection make return array handle
   ELSE
      RETURN OKCANCEL ; esc or cancel chosen
   ENDIF
   ; PaintPAL_Generated_Code_End(428099811)

ENDPROC
WRITELIB LIBNAME CISDIAG
RELEASE PROCS CISDIAG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "CisDiag" )



;BSC
; PROCEDURE   : QueryForMsg
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: Query for designated messages
;BSC

PROC QUERYFORMSG(NBR)
   PRIVATE  NBR, QGOON

   QGOON = 1
   IF NBR <> 3 THEN
      MESSAGE.U("MESSAGE QUERY", "Getting messages/" + "Please wait..." , TRUE, FALSE)
   ELSE
      MESSAGE.U("MESSAGE QUERY", "Getting Subjects/" + "Please wait..." , TRUE, FALSE)
   ENDIF
   DAT=""
   SWITCH
      CASE NBR=1:
         FM=FORUMS[forum.a] ; name of forum chosen
         QGOON = 2


      CASE NBR = 2 OR NBR = 3:
         ATF=SEARCH("|",SHOWSECTINDEX.A)
         FM=SUBSTR(SHOWSECTINDEX.A,1,(ATF-1)) ; name of forum chosen
         ;  DataStar Code-Dan Paolini
         ;  dsQueryToPAL: Begin Query
         ;     Generated: June  5, 1993 - 11:27:12
         ;   Description:
         IF ISTABLE("Answer") THEN
            EMPTY "Answer"
         ENDIF
         {Ask} SELECT "Icistat"
         MOVETO [Forum] CHECK
         MOVETO [Sect Number] CHECK
         MOVETO [Sect Name] CHECK
         [Forum] = FM ; assing forum name to forum field for query
         [Sect Name] = ANS ; assign section name to field for query

         DO_IT!
         IF NRECORDS("Answer") >= 1 THEN
            VIEW "answer"
            SECT = [sect number] ; assign section number to field for query
            CLEARALL
            QGOON = 2 ; query go on varibale set
         ELSE
            CLEARALL
            CLEARMESSAGE.U()
            QGOON = 1 ; do not go on as there are no records to process
         ENDIF
   ENDSWITCH
   ;  DataStar Code-Dan Paolini
   ;  dsQueryToPAL: Begin Query
   ;     Generated: June  5, 1993 - 11:33:07
   ;   Description:
   ;
   IF QGOON <> 1 THEN ; there are records to process for query

      {Ask} SELECT "Icistat"
      CTRLHOME CHECK



      IF SDATE = BLANKDATE() AND EDATE= BLANKDATE() THEN
         IF PICKRB = 2 THEN ; only todays messages requested
            DAT = TODAY()
         ENDIF
      ENDIF
      IF SDATE > BLANKDATE() AND EDATE = BLANKDATE() THEN
         DAT = ">=" + STRVAL(SDATE)
      ENDIF
      IF SDATE= BLANKDATE() AND EDATE> BLANKDATE() THEN
         DAT= "<=" + STRVAL(EDATE)
      ENDIF
      IF SDATE > BLANKDATE() AND EDATE > BLANKDATE() THEN
         DAT = ">=" + STRVAL(SDATE) + ", <=" + STRVAL(EDATE)
      ENDIF
      SWITCH

         CASE NBR= 1:
            IF FORUM.A > 1 THEN
               MOVETO [Forum]
               TYPEIN FM
            ENDIF

         CASE NBR = 2 OR NBR = 3:
            IF FM > "" THEN
               MOVETO [Forum]
               TYPEIN FM
            ENDIF
            IF ANS > "" THEN
               MOVETO [SECT NUMBER]
               TYPEIN SECT
            ENDIF
      ENDSWITCH


      IF DAT > "" OR PICKRB = 2 THEN
         MOVETO [date]
         TYPEIN DAT ; type in chosen date range for query
      ENDIF

      DO_IT!

      EMPTY "QueryMsg"
      ADD "Answer" "QueryMsg"
      CLEARMESSAGE.U()
      CLEARALL
      IF NRECORDS("Answer") >= 1 THEN
         GOON1 = "" ; set initual valuse for go on
         IF NBR = 3 THEN ; section query
            GOON1=1
            GOON1=GETSUBJECT() ; returns "Esc" if escape was pressed
         ENDIF
         IF GOON1 <> "1" THEN
            OK.U("MESSAGE QUERY", "You May View Your Messages Now..." , TRUE, TRUE)
         ELSE
            MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, FALSE)
            SLEEP 2000
            CLEARMESSAGE.U()
            SLEEP 2000
         ENDIF
      ELSE
         OK.U("So Sorry", "No Records Found..." , TRUE,TRUE)
         SLEEP 3000
      ENDIF
   ELSE
      OK.U("So Sorry", "No Records Found..." , TRUE,TRUE)
      SLEEP 3000
   ENDIF
   CLEARMESSAGE.U()
   RELEASE VARS FORUM, FORUM.A,FORUMS, SDATE, EDATE, PICKRB,DAT, FORUM.Y, SHOWSECT.Y, ANS, ATF, ALLSECT.Y, A, INDEX.A, FM, SECT, SELFILES, FILES
ENDPROC
WRITELIB LIBNAME QUERYFORMSG
RELEASE PROCS QUERYFORMSG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "QueryForMsg" )




;BSC
; PROCEDURE   : getSectionsDLG.a
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  :
; RETURNS     : Forun Section Name or Cancel
; Special Info: Adapted from Example D9 from Pdox Video Conference by
;               Kevin Smith
;BSC

PROC GETSECTIONSDLG.A()
   PRIVATE  MTABLE1,MTABLE2,MTABLE3,FNAME,FNAME2,RSP,HELPME.A, FORUMS.Y, MTHFLD, STUFFWITH

   IF FILEHANDLE[7] <> 1 THEN
      RSP=YESNO.L("UPDATE", "Do you wish to Update your Forum List?" ,TRUE,TRUE)
   ELSE
      RSP = TRUE
      VIEW "Start"
      IF [section] <> 2 THEN
         COEDIT "Start"
         [Section] = 2
         FILEHANDLE[7] = 2
         DO_IT!
      ENDIF
      CLEARALL
   ENDIF

   IF RSP = TRUE THEN
      MESSAGE.U("FORUMS", "Gathering Forum Names/" + "Please Wait..." , TRUE, FALSE)
      ;  dsQueryToPAL: Begin Query
      ;     Generated: June 14, 1993 - 23:25:46
      ;   Description:
      ;

      {Ask} SELECT "Icistat"
      MOVETO [Forum] CHECK
      DO_IT!

      IF NRECORDS("answer") >= 1 THEN
         EMPTY "Forum"
         ADD "answer" "forum"
      ENDIF
      CLEARALL
      CLEARMESSAGE.U()
      MESSAGE.U("FORUMS", "Gathering Section Names/" + "Please Wait..." , TRUE, FALSE)


      ;  dsQueryToPAL: Begin Query
      ;     Generated: June 14, 1993 - 23:26:16
      ;   Description:
      ;

      {Ask} SELECT "Icistat"
      MOVETO [Forum] CHECK
      MOVETO [Sect Number] CHECK
      DO_IT!
      CLEARALL
      IF NRECORDS("Answer") >= 1 THEN
         EMPTY "MsgDlg1"
         ADD "Answer" "MsgDlg1"
      ENDIF

      {Ask} SELECT "Msgdlg1"
      "FAST DELETE"
      [Sect Number] = "S0"

      DO_IT!

      ;  DataStar Code-Dan Paolini
      ;  dsQueryToPAL: Begin Query
      ;     Generated: June  5, 1993 - 11:35:41
      ;   Description:
      ;
      EMPTY"answer"
      ;  dsQueryToPAL: Begin Query
      ;     Generated: June 14, 1993 - 23:27:02
      ;   Description:
      ;

      {Ask} SELECT "Msgdlg1"
      [Forum] = "_a"
      [Sect Number] = "_b"

      {Ask} SELECT "Icistat"
      MOVETO [Forum] CHECK
      [Forum] = "_a"
      [Sect Number] = "_b"
      MOVETO [Sect Name] CHECK

      DO_IT!

      IF NRECORDS("answer") >= 1 THEN
         CLEARALL
         CLEARMESSAGE.U()
         IF NOT ISASSIGNED(FILEHANDLE[5]) THEN
            FILEHANDLE[5] = 1
         ENDIF
         IF FILEHANDLE[5] <> 2 THEN ; if this process has not been run before then run it
            ARRAY MTHFLD[1] ; array of field names
            MTHFLD[1] = "Sect Name"
            STUFFWITH = " " ; change commas to space
            CUTCOMMA("answer",MTHFLD,STUFFWITH) ; call procedure to remove commas

            ARRAY MTHFLD[2]
            MTHFLD[1] = "Sect Name"
            MTHFLD[2] = "Subject" ; remove commas from both section name and subject
            STUFFWITH = " "
            CUTCOMMA("icistat",MTHFLD,STUFFWITH)

            COEDIT "Start"
            [DoScan] = 2
            DO_IT!
            FILEHANDLE[5] = 2 ; tell program it does not need to run process again
            EMPTY "Msgdlg2"
            ADD "answer" "MsgDlg2" ; from Section name field
            CLEARALL
         ELSE
            EMPTY "MsgDlg2"
            ADD "answer" "MsgDlg2" ; from Section name field
            CLEARALL
         ENDIF
         CLEARALL
      ENDIF
   ENDIF
   VIEW "forum"
   VIEW "msgdlg2"
   DYNARRAY FORUMS.Y[] ; build dynarry of forum
   DYNARRAY ALLSECT.Y [] ; section names
   DYNARRAY SHOWSECT.Y []
   SYSINFO TO SYS.Y
   MOVETO "forum"
   SCAN
      FORUMS.Y[ [forum] ] = [forum]
   ENDSCAN
   MOVETO "msgdlg2"
   SCAN
      ALLSECT.Y[ [forum] + "|" + STRVAL([#]) ] = [sect name]
   ENDSCAN
   CLEARALL

   ; PaintPAL_Generated_Code_Begin(449009266)

   SDATE=BLANKDATE()
   EDATE=BLANKDATE()
   OKCANCEL = "Cancel"
   PICKRB=2

   SHOWDIALOG
      "Forums and Sections" ; D:\CIS\F-SECT.DLG
      PROC "updateDLG.l"
      TRIGGER "OPEN" , "UPDATE"
      KEY 13
      @2,4 HEIGHT 22 WIDTH 70

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,0 TO 19,67
      PAINTCANVAS ATTRIBUTE 127 0,0,0,67
      PAINTCANVAS ATTRIBUTE 112 19,0,19,67
      PAINTCANVAS ATTRIBUTE 127 0,0,19,0
      PAINTCANVAS ATTRIBUTE 112 0,67,19,67
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 2,1 TO 14,31
      PAINTCANVAS ATTRIBUTE 112 2,1,2,31
      PAINTCANVAS ATTRIBUTE 127 14,1,14,31
      PAINTCANVAS ATTRIBUTE 112 2,1,14,1
      PAINTCANVAS ATTRIBUTE 127 2,31,14,31
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 2,34 TO 14,66
      PAINTCANVAS ATTRIBUTE 112 2,34,2,66
      PAINTCANVAS ATTRIBUTE 127 14,34,14,66
      PAINTCANVAS ATTRIBUTE 112 2,34,14,34
      PAINTCANVAS ATTRIBUTE 127 2,66,14,66
      ; PaintPAL_Frame_End

      ; PaintPAL_Static_Text_Begin
      PAINTCANVAS FILL " " ATTRIBUTE 112 1,3,1,8
      @1,3
      ?? "Forums"
      PAINTCANVAS ATTRIBUTE 112 1,3,1,8
      ; PaintPAL_Static_Text_End

      ; PaintPAL_Static_Text_Begin
      PAINTCANVAS FILL " " ATTRIBUTE 112 1,36,1,43
      @1,36
      ?? "Sections"
      PAINTCANVAS ATTRIBUTE 112 1,36,1,43
      ; PaintPAL_Static_Text_End

      PICKDYNARRAY @3,2 HEIGHT 11 WIDTH 28
         FORUMS.Y
         TAG "showTag"
         TO SHOWINDEX.A

      PICKDYNARRAY @3,35 HEIGHT 11 WIDTH 30
         SHOWSECT.Y
         TAG "charTag"
         TO SHOWSECTINDEX.A

      RADIOBUTTONS @16,2 HEIGHT 2 WIDTH 15
         "ALL Dates",
         "Today"
         TAG "RBtag"
         TO PICKRB

      LABEL @15,2
         "Date Set"
         FOR "RBtag"

      ACCEPT @16,19 WIDTH 12
      "D"
      TAG "SdateTag"
      TO SDATE

      LABEL @15,18
         "Start Date:"
         FOR "SdateTag"

      ACCEPT @18,19 WIDTH 12
      "D"
      TAG "EdateTag"
      TO EDATE

      LABEL @17,18
         "End Date:"
         FOR "EdateTag"

      PUSHBUTTON @16,33 WIDTH 10
         "~O~K"
         OK
         DEFAULT
         VALUE ""
         TAG "okTag"
         TO OKCANCEL

      PUSHBUTTON @16,45 WIDTH 8
         "~H~elp"
         VALUE HELPMEDLG(4)
         TAG "HelpTag"
         TO HELPME.A

      PUSHBUTTON @16,55 WIDTH 10
         "~C~ancel"
         CANCEL
         VALUE ""
         TAG "cancelTag"
         TO OKCANCEL
   ENDDIALOG

   ; PaintPAL_Generated_Code_End(449009266)


   IF RETVAL THEN
      RETURN SHOWSECT.Y[ShowSectIndex.a]
   ELSE
      RETURN "Cancel"
   ENDIF


ENDPROC
WRITELIB LIBNAME GETSECTIONSDLG.A
RELEASE PROCS GETSECTIONSDLG.A
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetSectionsDLG" )




;BSC
; PROCEDURE   : UpdateShowSect
; Special Info: Adapted from Example D9 from Pdox Video Conference by
;               Kevin Smith
;BSC
PROC UPDATESHOWSECT.U(SHOWCODE.A)
   DYNARRAY SHOWSECT.Y []
   FOREACH INDEX.A IN ALLSECT.Y
      IF MATCH( INDEX.A +"|", SHOWCODE.A +"|..") THEN
         SHOWSECT.Y[index.a] = ALLSECT.Y[index.a]
      ENDIF
   ENDFOREACH
ENDPROC
WRITELIB LIBNAME UPDATESHOWSECT.U
RELEASE PROCS UPDATESHOWSECT.U
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "UpdateShowSet.u" )




;BSC
; PROCEDURE   : UpdateDlg.l
; PARAMETERS  :
; Special Info: Adapted from Example D9 from Pdox Video Conference by
;               Kevin Smith
;BSC
PROC UPDATEDLG.L (TRIGGER.A, TAG.A, EVENTVALUE.V, CBLABEL.A)
   SWITCH
      CASE
         TRIGGER.A = "EVENT" AND EVENTVALUE.V["KeyCode"]=13 ; <<<<<< This works
         AND TAG.A="okTag" OR TAG.A="cancelTag" OR TAG.A ="HelpTag":
         RETURN TRUE
      CASE TRIGGER.A = "EVENT" AND EVENTVALUE.V["KeyCode"]=13:
         ; <<<<<< This works
         RELEASE VARS EVENTVALUE.V["ScanCode"]
         EVENTVALUE.V["KeyCode"] = 9
         RETURN TRUE
      CASE TRIGGER.A = "OPEN" OR TAG.A = "showTag" :
         UPDATESHOWSECT.U(CONTROLVALUE("showTag"))
         ; Don't simply use EventValue.v because this could be an OPEN trigger.
         REFRESHCONTROL "charTag"
         RETURN TRUE
   ENDSWITCH
ENDPROC
WRITELIB LIBNAME UPDATEDLG.L
RELEASE PROCS UPDATEDLG.L
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "UpdateDLG.l" )





;BSC
; PROCEDURE   : QueryForCAT
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: Query for designated Catalog Files
;BSC

PROC QUERYFORCAT()
   MESSAGE.U("CATALOG QUERY", "Getting catalogs/" + "Please wait..." , TRUE, FALSE)
   DAT=""

   {Ask} SELECT "Idl"
   CTRLHOME CHECK

   IF NOT ISASSIGNED(FM) THEN
      FM=FORUMS[forum.a]
   ENDIF
   IF SDATE = BLANKDATE() AND EDATE= BLANKDATE() THEN
      IF PICKRB = 2 THEN
         DAT = TODAY()
      ENDIF
   ENDIF
   IF SDATE > BLANKDATE() AND EDATE = BLANKDATE() THEN
      DAT = ">=" + STRVAL(SDATE)
   ENDIF
   IF SDATE= BLANKDATE() AND EDATE> BLANKDATE() THEN
      DAT= "<=" + STRVAL(EDATE)
   ENDIF
   IF SDATE > BLANKDATE() AND EDATE > BLANKDATE() THEN
      DAT = ">=" + STRVAL(SDATE) + ", <=" + STRVAL(EDATE)
   ENDIF

   IF ISASSIGNED(FORUM.A) THEN
      IF FORUM.A > 1 THEN
         MOVETO [Forum]
         TYPEIN FM
      ENDIF
   ELSE
      IF FM > "" THEN
         MOVETO [Forum]
         TYPEIN FM
      ENDIF
   ENDIF

   IF ISASSIGNED(LB) THEN
      MOVETO [library]
      TYPEIN LB
   ENDIF


   IF DAT > "" OR PICKRB = 2 THEN
      MOVETO [date]
      TYPEIN DAT
   ENDIF

   DO_IT!

   EMPTY "QueryCat"
   ADD "Answer" "QueryCat"
   CLEARMESSAGE.U()
   CLEARALL
   IF NRECORDS("Answer") > 0 THEN

      OK.U("MESSAGE QUERY", "You May View Your Messages Now..." , TRUE, TRUE)
      SLEEP 2000
   ELSE
      OK.U("So Sorry", "No Records Found..." , TRUE,TRUE)
      SLEEP 3000
   ENDIF
   CLEARMESSAGE.U()
   RELEASE VARS FORUM, FORUM.A,FORUMS, SDATE, EDATE, PICKRB,DAT
ENDPROC
WRITELIB LIBNAME QUERYFORCAT
RELEASE PROCS QUERYFORCAT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "QueryForCat" )


;BSC
; PROCEDURE   : MtHImportFile
; AUTHOR      : Mark T. Houpt
; PARAMETERS
; Typ.n= 1 for MSG files 2 for Cat Files
; nbr =1 for TapCis 2 for OzCIS
; goon1 goon and mthgoon (as in go on) are branching params used
; in proceedure below  all start at 1
; RETURNS     :
; Special Info: Import MSG and CAT file routine
;BSC

proc MTHIMPORTFILE( TYP.N, NBR, GOON1, GOON, MTHGOON )
   private  GETRSP, NBR, GOON, GOON1, Z, I, M, X, MTHGOON, CW.N, MSG.A,OKFILEDIR,OKCURDIR,MTHFLD,NEWVAL,STUFFWITH,STUFF,TBL.A

   if FILEHANDLE[9] = 1 and nrecords( "Last" ) >= 1 and TYP.N = 1 then
      GETRSP = YESNO.L( "UPDATE MASTER TABLE", "Last Batch not Posted to Master//Yes to POST it Now//No to ERASE entries//", TRUE, TRUE )
      if GETRSP = TRUE then
         MESSAGE.U( "ADDING RECORDS", "Updating Master Message File//Please Wait...", TRUE, FALSE )
         add "Last" "Icistat"
         clearall
         coedit "start"
         [batch] = 2
         FILEHANDLE[9] = 2
         do_it!
         clearall
         CLEARMESSAGE.U()
      else
         coedit "start"
         [batch] = 2
         FILEHANDLE[9] = 2
         do_it!
         clearall
      endif
   endif

   OKFILEDIR = blanknum()
   OKCURDIR = blanknum()
   if not isassigned( FILEHANDLE[3] ) then
      START.M()
   endif
   if isassigned( FILEHANDLE[2] ) then
      OKFILEDIR = direxists( FILEHANDLE[2] )
      if isassigned( FILEHANDLE[4] ) then
         OKCURDIR = direxists( FILEHANDLE[2] )
      endif
   endif
   if OKFILEDIR = 1 and OKCURDIR = 1 then
      if istable( "DosDIR" ) then
         empty "DosDir"
      endif
      GetFileSize( Nbr, Typ.n )
      if nrecords( "DosDir" ) >= 1 then
         if upper( FILEHANDLE[2] ) <> upper( directory() ) then
            GOON1 = DLGGETFILES( TYP.N )
            if GOON1 = TRUE then
               switch
                  case TYP.N = 1:
                     MTHPROGRESSMSG.U( 8, 18, "Processing Message File", "", 127, 113, 0 )
                  case TYP.N = 2:
                     MTHPROGRESSMSG.U( 8, 18, "Processing Catalog File", "", 127, 113, 0 )
               endswitch
               foreach ELEMENT in MTHFILESELECT
                  switch
                     case TYP.N = 1:
                        MTHPROGRESSMSG.U( 8, 18, "Processing Message File", ELEMENT, 127, 113, 1 )
                     case TYP.N = 2:
                        MTHPROGRESSMSG.U( 8, 18, "Processing Catalog File", ELEMENT, 127, 113, 1 )
                  endswitch

                  switch
                     case TYP.N = 1:
                        if NBR = 2 or NBR=3 or NBR=4 then
                           clearall
                           run big norefresh "Import Oz1msg " + FILEHANDLE[2] + " " + ELEMENT + " " + FILEHANDLE[4]
                           GOON = 2
                        else
                           run big norefresh "Import Tc1msg " + FILEHANDLE[2] + " " + ELEMENT + " " + FILEHANDLE[4]
                           GOON = 1
                        endif
                     case TYP.N = 2:
                        if NBR = 2 then
                           run big norefresh "Import Oz1cat " + FILEHANDLE[2] + " " + ELEMENT + " " + FILEHANDLE[4]
                           GOON = 2
                        else
                           run big norefresh "Import Tc1cat " + FILEHANDLE[2] + " " + ELEMENT + " " + FILEHANDLE[4]
                           GOON = 1
                        endif
                  endswitch
               endforeach

               switch
                  case TYP.N = 1:
                     MTHPROGRESSMSG.U( 8, 18, "Processing Message File", "", 127, 113, - 1 )
                     MESSAGE.U( "IMPORTING", "    Importing CIS Messages    //Please Wait...", TRUE, FALSE )
                  case TYP.N = 2:
                     MTHPROGRESSMSG.U( 8, 18, "Processing Catalog File", "", 127, 113, - 1 )
                     MESSAGE.U( "IMPORTING", "    Importing CIS Catalogs    //Please Wait...", TRUE, FALSE )
               endswitch
            endif
         else
            if GOON1 = TRUE then
               switch
                  case TYP.N = 1:
                     Switch
                     case NBR = 2:
                        MESSAGE.U( "IMPORTING", "    Importing CIS Messages    //Please Wait...", TRUE, FALSE )
                        run big norefresh "Import Oz2msg"
                        GOON = 2
                     case NBR = 3:
                        MESSAGE.U( "IMPORTING", "    Importing CIS Messages    //Please Wait...", TRUE, FALSE )
                        run big norefresh "Import Oz3msg"
                        GOON = 2
                     case NBR = 4:
                        MESSAGE.U( "IMPORTING", "    Importing CIS Messages    //Please Wait...", TRUE, FALSE )
                        run big norefresh "Import Oz4msg"
                        GOON = 2
                     otherwise:
                        MESSAGE.U( "IMPORTING", "    Importing CIS Messages    //Please Wait...", TRUE, FALSE )
                        run big norefresh "CISTATS > junk"
                        GOON = 1
                     endswitch
                  case TYP.N = 2:
                     if NBR = 2 then
                        MESSAGE.U( "IMPORTING", "    Importing CIS Catalog    //Please Wait...", TRUE, FALSE )
                        run big norefresh "Import Oz2cat"
                        GOON = 2
                     else
                        MESSAGE.U( "IMPORTING", "    Importing CIS Catalogs    //Please Wait...", TRUE, FALSE )
                        run big norefresh "DLS > junk"
                        GOON = 1
                     endif
               endswitch
            endif
         endif

         clearall
         if GOON1 = TRUE then
            switch
               case TYP.N = 1:
                  empty "last"
                  if istable( "Cistat" ) and nrecords( "Cistat" ) >= 1 then
                     add "cistat" "Last"
                     delete "cistat"
                     clearall
                     CLEARMESSAGE.U()

                     array MTHFLD[2]
                     MTHFLD[1] = "Sect Name"
                     MTHFLD[2] = "Subject"
                     STUFFWITH = " "
                     CUTCOMMA( "Last", MTHFLD, STUFFWITH )
                     clearall
                     MESSAGE.U( "IMPORTING", "Updating Forum-Section-Subject Files//Please Wait...", TRUE, FALSE )
                     {Ask} select "Last"
                     moveto[Forum] check
                     moveto[Sect Number] check
                     moveto[Sect Name] check
                     moveto[subject] check
                     do_it!
                     if istable( "Answer" ) and nrecords( "Answer" ) >= 1 then
                        rename "Answer" "Ftmp"
                        clearall
                        {Ask} select "Ftmp"
                        moveto[Forum] check
                        moveto[Sect Number] check
                        do_it!
                        if istable( "Answer" ) and nrecords( "Answer" ) >= 1 then
                           add "Answer" "MsgDlg1"
                        endif
                        clearall

                        {Ask} select "Ftmp"
                        moveto[Forum] check
                        moveto[Sect Name] check
                        do_it!
                        if istable( "Answer" ) and nrecords( "Answer" ) >= 1 then
                           add "Answer" "MsgDlg2"
                        endif
                        clearall
                        {Ask} select "Ftmp"
                        moveto[Forum] check
                        do_it!
                        if istable( "Answer" ) and nrecords( "Answer" ) >= 1 then
                           add "Answer" "Forum"
                        endif
                        clearall

                        {Ask} select "Ftmp"
                        moveto[Forum] check
                        moveto[Sect Number] check
                        moveto[subject] check
                        do_it!
                        if istable( "Answer" ) and nrecords( "Answer" ) >= 1 then
                           menu {Modify} {Restructure} {Answer}
                           end
                           down "get"
                           right
                           "a1" DO_IT!
                           if istable( "answer" ) then
                              add "answer" "Subject"
                           endif
                           clearall
                        endif
                     endif
                     if istable( "Ftmp" ) then
                        delete "Ftmp"
                     endif

                     clearall
                     coedit "start"
                     [batch] = 1
                     do_it!
                     FILEHANDLE[9] = 1
                     clearall
                     if iswindow( MSG.H ) then
                        CLEARMESSAGE.U()
                     endif
                     OK.U( "RECORDS IMPORTED", "You may view your most recent imported/" + "Forum Messages now...", TRUE, TRUE )
                  else
                     clearall
                     if GOON1 = FALSE then
                        MESSAGE.U( "Cancel", "Operation Canceled...", TRUE, FALSE )
                        sleep 2000
                        CLEARMESSAGE.U()
                     else
                        OK.U( "NOTICE", "No files to import", TRUE, TRUE )
                     endif
                  endif

               case TYP.N = 2:
                  empty "lastdl"
                  if istable( "dl" ) then
                     if nrecords( "dl" ) >= 1 then
                        add "dl" "Lastdl"
                        add "LastDL" "Idl"
                        delete "dl"
                        clearall
                        OK.U( "RECORDS IMPORTED", "You may view your most recent imported/" + "Catalog Messages now...", TRUE, TRUE )
                     else
                        OK.U( "NOTICE", "No files to import", TRUE, TRUE )
                        if istable( "DL" ) then
                           del "dl"
                        endif
                     endif
                     CLEARMESSAGE.U()
                  endif
            endswitch
         endif
      else
         clearall
         if GOON1 = FALSE then
            MESSAGE.U( "Cancel", "Operation Canceled...", TRUE, FALSE )
            sleep 2000
            CLEARMESSAGE.U()
         else
            OK.U( "NOTICE", "No files to import", TRUE, TRUE )
         endif
      endif
   else
      OK.U( "NOTICE", "Can Not locate message or cat file directory//Please check SetUp...", TRUE, TRUE )
   endif
   CLEARMESSAGE.U()
   release vars MTHFILECHOICE, MTHFILESELECT
endproc
writelib LIBNAME MTHIMPORTFILE
release procs MTHIMPORTFILE
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "MtHImportFile" )



;================================================
;     System Menu and Associated Procedures
;================================================
; Desmond Nolan
;================================================
PROC TIMEUPDATE(TRIGGERTYPE, TAGVALUE, EVENTVALUE, ELEMENTVALUE)

   REPAINTDIALOG
   RETURN TRUE

ENDPROC
WRITELIB LIBNAME TIMEUPDATE
RELEASE PROCS TIMEUPDATE
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "TimeUpdate" )


;================================================
; Desmond Nolan
;================================================

PROC TIMEDISPLAY()
   ; PaintPAL_Generated_Code_Begin(448642109)

   SHOWDIALOG
      "Current Time" ; H:\PALP\CLOCK.DLG
      PROC "TimeUpdate"
      IDLE

      @6,28 HEIGHT 12 WIDTH 24

      PAINTCANVAS BORDER ATTRIBUTE 112 1,5,5,16

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 1,4 TO 5,17
      PAINTCANVAS ATTRIBUTE 127 1,4,1,17
      PAINTCANVAS ATTRIBUTE 112 5,4,5,17
      PAINTCANVAS ATTRIBUTE 127 1,4,5,4
      PAINTCANVAS ATTRIBUTE 112 1,17,5,17
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,1 TO 9,20
      PAINTCANVAS ATTRIBUTE 112 0,1,0,20
      PAINTCANVAS ATTRIBUTE 127 9,1,9,20
      PAINTCANVAS ATTRIBUTE 112 0,1,9,1
      PAINTCANVAS ATTRIBUTE 127 0,20,9,20
      ; PaintPAL_Frame_End

      @3,6
      ?? FORMAT("W10,AC",TIME())

      PAINTCANVAS ATTRIBUTE 15+16 2,6,4,15

      PUSHBUTTON @7,6 WIDTH 10
         "~O~k"
         OK
         DEFAULT
         VALUE "Accept"
         TAG "Yes"
         TO BUTTONVALUE
   ENDDIALOG

   ; PaintPAL_Generated_Code_End(448642109)

ENDPROC
WRITELIB LIBNAME TIMEDISPLAY
RELEASE PROCS TIMEDISPLAY
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "TimeDisplay" )



;================================================
; Desmond Nolan
;================================================

PROC SYSINFOPROC()

   PRIVATE  WINATTRS,
            SYSARRAY,
            WAITFORUSER,
            PDOXCNTRLMEMPOOLSIZE,
            PDOXCODEPOOLFREE,
            PDOXMEMLEFT,
            DISKSPACE,
            PDOXRUNTIME,
            PDOXVERSION

   DYNARRAY WINATTRS[]
   WINATTRS["TITLE"] = "System Information"

   SYSINFO TO SYSARRAY

   SWITCH
      CASE SYSARRAY["LANGUAGE"] = "001" :
         SYSARRAY["LANGUAGE"] = "English"
      CASE SYSARRAY["LANGUAGE"] = "033" :
         SYSARRAY["LANGUAGE"] = "French"
      CASE SYSARRAY["LANGUAGE"] = "034" :
         SYSARRAY["LANGUAGE"] = "Spanish"
      CASE SYSARRAY["LANGUAGE"] = "039" :
         SYSARRAY["LANGUAGE"] = "Italian"
      CASE SYSARRAY["LANGUAGE"] = "045" :
         SYSARRAY["LANGUAGE"] = "Danish"
      CASE SYSARRAY["LANGUAGE"] = "046" :
         SYSARRAY["LANGUAGE"] = "Swedish"
      CASE SYSARRAY["LANGUAGE"] = "049" :
         SYSARRAY["LANGUAGE"] = "German"
   ENDSWITCH

   PDOXCODEPOOLFREE = RMEMLEFT()
   PDOXCNTRLMEMPOOLSIZE = MEMLEFT()
   DISKSPACE = DRIVESPACE(SUBSTR(DIRECTORY(),1,1))

   SYSARRAY["PDOXRUNTIME"] = ISRUNTIME()
   SYSARRAY["PDOXVERSION"] = VERSION()
   SYSARRAY["EXTENDED"] = FORMAT("W12,AR,EC", SYSARRAY["EXTENDED"])
   SYSARRAY["EXPANDED"] = FORMAT("W12,AR,EC", SYSARRAY["EXPANDED"])
   SYSARRAY["DISKSPACE"] = FORMAT("W12,AR,EC",DISKSPACE)
   SYSARRAY["PDOXCODEPOOLFREE"] = FORMAT("W12,AR,EC",PDOXCODEPOOLFREE)
   SYSARRAY["PDOXCNTRLMEMPOOLSIZE"] = FORMAT("W12,AR,EC", PDOXCNTRLMEMPOOLSIZE)

   MESSAGE ""

   NHEIGHT=21
   NWIDTH=45
   TAGVALUE=""
   SHOWDIALOG
      "System"
      PROC "DiagProc"
      @2,19 HEIGHT NHEIGHT WIDTH NWIDTH
      FRAME SINGLE FROM 0,0 TO (NHEIGHT-1)-2,(NWIDTH-1)-2
      PAINTCANVAS ATTRIBUTE 112 ALL
      PAINTCANVAS ATTRIBUTE 127 0,0,0,(NWIDTH-1)-2
      PAINTCANVAS ATTRIBUTE 127 0,0,(NHEIGHT-1)-2,0
      @ 1,2 ?? "Extended memory  =  " , SYSARRAY["EXTENDED"]
      @ 2,2 ?? "Expanded memory  =  " , SYSARRAY["EXPANDED"]
      @ 3,2 ?? "Disk space free  =  " , SYSARRAY["DISKSPACE"]
      @ 4,2 ?? "Code pool free   =  " , SYSARRAY["PDOXCODEPOOLFREE"]
      @ 5,2 ?? "Central mem pool =  " , SYSARRAY["PDOXCNTRLMEMPOOLSIZE"]

      @ 7,2 ?? "Mouse present    =  " , SYSARRAY["MOUSE"]
      @ 8,2 ?? "Language         =  " , SYSARRAY["LANGUAGE"]
      @ 9,2 ?? "Autosave (secs)  =  " , SYSARRAY["AUTOSAVE"]

      @11,2 ?? "Paradox mode     =  " , SYSARRAY["UIMODE"]
      @12,2 ?? "Screen rows/cols =  " , SYSARRAY["SCREENHEIGHT"], "/" ,
      SYSARRAY["SCREENWIDTH"]
      @13,2 ?? "Paradox runtime  =  " , SYSARRAY["PDOXRUNTIME"]
      @14,2 ?? "Paradox version  =  " , SYSARRAY["PDOXVERSION"]
      @15,2 ?? "Paradox build    =  " , SYSARRAY["BUILD"]

      PUSHBUTTON @16,15 WIDTH 10
         "~O~k"
         OK
         DEFAULT
         VALUE "Yes"
         TAG "OkTag"
         TO BUTTONVALUE

   ENDDIALOG

ENDPROC
WRITELIB LIBNAME SYSINFOPROC
RELEASE PROCS SYSINFOPROC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "SysInfoProc" )

;================================================
; Desmond Nolan
;================================================

PROC DIAGPROC(TRIGGERTYPE,TAGVELUE,EVENTVALUE,ELEMENTVALUE)
   IF TRIGGERTYPE= "OPEN" AND TAGVALUE ="OKTag" THEN
      WINDOW HANDLE DIALOG TO HDLDIALOG
      DYNARRAY DIAGATTR[]
      DIAGATTR["HASFRAME"]=FALSE
      DIAGATTR["HASSHADOW"]=FALSE
      WINDOW SETATTRIBUTES HDLDIALOG FROM DIAGATTR
   ENDIF
ENDPROC
WRITELIB LIBNAME DIAGPROC
RELEASE PROCS DIAGPROC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DiagProc" )



; ---------------------------------------------------------------------------
; Proc name : MaxWindow()
; Purpose   : Maximizes and removes frame/shadow from a named window
; Returns   : *None*
; Comments  : Used primarily for main Invoice form
; Adapted from Greaves and Lindsay Paradox 4 Developer's Guide
; ---------------------------------------------------------------------------
PROC MAXWINDOW(WINHANDLE)
   PRIVATE  PROCWIN

   IF ISWINDOW(WINHANDLE)
   THEN
      DYNARRAY PROCWIN[]
      PROCWIN["HASSHADOW"] = FALSE
      PROCWIN["HASFRAME"] = FALSE
      PROCWIN["CANMOVE"] = FALSE
      PROCWIN["CANRESIZE"] = FALSE
      PROCWIN["CANCLOSE"] = FALSE
      PROCWIN["MAXIMIZED"] = FALSE
      WINDOW SETATTRIBUTES WINHANDLE FROM PROCWIN
   ENDIF
   RETURN ISWINDOW(WINHANDLE)
ENDPROC

WRITELIB LIBNAME MAXWINDOW
RELEASE PROCS MAXWINDOW
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "MaxWindow" )



PROC SETWINDOW(WINHANDLE,NBR)
   PRIVATE  SPROCWIN,NBR

   IF ISWINDOW(WINHANDLE)
   THEN
      DYNARRAY SPROCWIN[]
      SPROCWIN["HASSHADOW"] = FALSE
      IF NBR=1 THEN
         SPROCWIN["HASFRAME"] = TRUE
      ELSE
         SPROCWIN["HASFRAME"] = FALSE
      ENDIF
      SPROCWIN["CANMOVE"] = FALSE
      SPROCWIN["CANRESIZE"] = FALSE
      SPROCWIN["CANCLOSE"] = FALSE
      WINDOW SETATTRIBUTES WINHANDLE FROM SPROCWIN
   ENDIF
   RETURN ISWINDOW(WINHANDLE)
ENDPROC
WRITELIB LIBNAME SETWINDOW
RELEASE PROCS SETWINDOW
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "SetWindow" )



PROC LEAVEAPP(ALL)

   IF ALL = 1 THEN

      IF ISRUNTIME() THEN
         OK.U("NOTICE","You may not enter Paradox//when using the Run-Time Version//Please choose Quit to Exit Program...",TRUE,TRUE)
         SPLASHSCR(2)
      ELSE
         IF SYSMODE() <> "Main"
         THEN
            DO_IT!
         ENDIF
         APPINTRO()
         ALTSPACE {Desktop} {Empty}
         SAVEVARS ALL
         RESET
         QUIT "Back in Paradox Now..."
      ENDIF
   ELSE
      IF SYSMODE() <> "Main"
      THEN
         DO_IT!
      ENDIF
      APPINTRO()
      ALTSPACE {Desktop} {Empty}
      SAVEVARS ALL
      RESET
      EXIT
   ENDIF
ENDPROC
WRITELIB LIBNAME LEAVEAPP
RELEASE PROCS LEAVEAPP
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "LeaveApp" )





PROC APPINTRO()
   PRIVATE  WINDOWATTS

   DYNARRAY WINDOWATTS[]
   WINDOWATTS["HASFRAME"] = FALSE
   WINDOWATTS["ORIGINROW"] = 6
   WINDOWATTS["ORIGINCOL"] = 17
   WINDOWATTS["FLOATING"] = TRUE
   WINDOWATTS["HEIGHT"] = 10
   WINDOWATTS["WIDTH"] = 45
   WINDOWATTS["HASSHADOW"] = FALSE

   WINDOW
   CREATE ATTRIBUTES WINDOWATTS TO INFOWINDOW

   CURSOR OFF
   CANVAS OFF

   @1,0 ?? FORMAT("W44,AC", "CIS ACTIVITY CENTER" )
   @3,0 ?? FORMAT("W44,AC", "Mouse & Squirrel Software" )
   @4,0 ?? FORMAT("W44,AC", "Copyright @1992-93" )
   @7,0 ?? FORMAT("W44,D2,AC", TODAY())
   @8,12 ?? "Leaving Application..."

   PAINTCANVAS ATTRIBUTE 15+16 0,0,9,44
   STYLE ATTRIBUTE 15+16+128
   ?? "..."
   STYLE
   CANVAS ON
   CURSOR NORMAL
   SLEEP 2000
ENDPROC

WRITELIB LIBNAME APPINTRO
RELEASE PROCS APPINTRO
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "AppIntro" )




;BSC
; PROCEDURE   : GetRsp
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : N\A
; RETURNS     : N\A
; Special Info: Diag to get printer output location
;BSC
PROC GETRSP()
   PRIVATE  NHEIGHT, NWIDTH

   RSP = ""
   NHEIGHT=12
   NWIDTH=21

   ; PaintPAL_Generated_Code_Begin(447826908)

   SHOWDIALOG
      "Print To"
      @6,29 HEIGHT NHEIGHT WIDTH NWIDTH

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,1 TO 9,17
      PAINTCANVAS ATTRIBUTE 112 0,1,0,17
      PAINTCANVAS ATTRIBUTE 127 9,1,9,17
      PAINTCANVAS ATTRIBUTE 112 0,1,9,1
      PAINTCANVAS ATTRIBUTE 127 0,17,9,17
      ; PaintPAL_Frame_End

      PUSHBUTTON @1,4 WIDTH 11
         "~S~creen"
         OK
         VALUE "S"
         TAG "Stag"
         TO RSP

      PUSHBUTTON @4,4 WIDTH 11
         "~P~rinter"
         OK
         DEFAULT
         VALUE "P"
         TAG "Ptag"
         TO RSP

      PUSHBUTTON @7,4 WIDTH 11
         "~C~ancel"
         CANCEL
         VALUE ""
         TAG "Cancel"
         TO CANCELTAG
   ENDDIALOG

   ; PaintPAL_Generated_Code_End(447826908)

   IF ISBLANK (RSP)
   THEN
      RETURNED = 1
      RETURN RSP
   ELSE
      RETURNED = 2
      RETURN RSP
   ENDIF
ENDPROC
WRITELIB LIBNAME GETRSP
RELEASE PROCS GETRSP
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetRsp" )



;BSC
; PROCEDURE   : GetPort
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : N\A
; RETURNS     : N\A
; Special Info: Diag to get printer Port and Type info
;BSC
PROC GETPORT()
   PRIVATE  OKCANCEL,PRINTVAL

   ; Portions adapted from PrintM.zip in PDODOS libs by John Nelson
   ; JRN Enterprise

   ; PaintPAL_Generated_Code_Begin(447839100)

   OKCANCEL=""
   PRINTERTYPE=BLANKNUM()
   PRINTVAL= BLANKNUM()

   SHOWDIALOG
      "Select Printer Type and Port" ; C:\CIS\RPT.DLG
      PROC "CisDiagPROC"
      KEY 13

      @6,16 HEIGHT 12 WIDTH 47

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,1 TO 9,43
      PAINTCANVAS ATTRIBUTE 127 0,1,0,43
      PAINTCANVAS ATTRIBUTE 112 9,1,9,43
      PAINTCANVAS ATTRIBUTE 127 0,1,9,1
      PAINTCANVAS ATTRIBUTE 112 0,43,9,43
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 1,20 TO 5,41
      PAINTCANVAS ATTRIBUTE 112 1,20,1,41
      PAINTCANVAS ATTRIBUTE 127 5,20,5,41
      PAINTCANVAS ATTRIBUTE 112 1,20,5,20
      PAINTCANVAS ATTRIBUTE 127 1,41,5,41
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 1,3 TO 8,16
      PAINTCANVAS ATTRIBUTE 112 1,3,1,16
      PAINTCANVAS ATTRIBUTE 127 8,3,8,16
      PAINTCANVAS ATTRIBUTE 112 1,3,8,3
      PAINTCANVAS ATTRIBUTE 127 1,16,8,16
      ; PaintPAL_Frame_End

      RADIOBUTTONS @3,5 HEIGHT 5 WIDTH 10
         "Lpt1",
         "Lpt2",
         "Lpt3",
         "Com1",
         "Com2"
         TAG "PrinttoTag"
         TO PRINTVAL

      LABEL @2,5
         "Print To"
         FOR "PrinttoTag"

      RADIOBUTTONS @3,22 HEIGHT 2 WIDTH 19
         "Dot Matrix",
         "Laser Printer"
         TAG "PrinterTag"
         TO PRINTTYPE

      LABEL @2,22
         "Printer Type"
         FOR "PrinterTag"

      PUSHBUTTON @7,21 WIDTH 6
         "~O~k"
         OK
         DEFAULT
         VALUE "OK"
         TAG "OKTag"
         TO OKCANCEL

      PUSHBUTTON @7,31 WIDTH 10
         "~C~ancel"
         CANCEL
         VALUE "Cancel"
         TAG "CancelTag"
         TO OKCANCEL
   ENDDIALOG

   ; PaintPAL_Generated_Code_End(447839100)

   IF OKCANCEL > "" THEN
      RETURNED = 2
      SWITCH
         CASE PRINTVAL = 1:
            PRTV="LPT1"
         CASE PRINTVAL = 2:
            PRTV="LPT2"
         CASE PRINTVAL = 3:
            PRTV="LPT3"
         CASE PRINTVAL = 4:
            PRTV="COM1"
         CASE PRINTVAL = 5:
            PRTV="COM2"
      ENDSWITCH
      RETURN OKCANCEL
   ELSE
      RETURNED = 1
      RETURN PRINTERTYPE
   ENDIF
ENDPROC
WRITELIB LIBNAME GETPORT
RELEASE PROCS GETPORT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetPort" )



PROC GETRPT(NBR)
   PRIVATE  NBR,RSP,PRINTERTYPE,PRTV,RETURNED

   ; Portions adapted from PrintM.zip in PDODOS libs by John Nelson
   ; JRN Enterprise

   RSP=GETRSP()
   IF UPPER(RSP) = "S" OR UPPER(RSP) = "P" THEN
      SWITCH
         CASE NBR = 1:
            SWITCH
               CASE UPPER(RSP) = "P":
                  PRINTERTYPE=GETPORT()
                  IF RETURNED <> 1 THEN
                     IF PRTV <> "LPT1" THEN
                        IF PRINTTYPE = 1 THEN
                           ;select the report and change the settings
                           MENU {Report} {Change} {Icistat} {1}
                           ENTER
                           {Setting} {Setup} {Custom} SELECT PRTV
                           ENTER
                           ENTER
                           DO_IT!
                        ELSE
                           ;select the report and change the settings
                           MENU {Report} {Change} {Icistat} {2}
                           ENTER
                           {Setting} {Setup} {Custom} SELECT PRTV
                           ENTER
                           ENTER
                           DO_IT!
                        ENDIF
                     ENDIF
                     MESSAGE.U("REPORT", "Printing Report//Please Wait..." ,TRUE,FALSE)
                     IF PRINTTYPE=1 THEN
                        REPORT "Icistat" 1
                     ELSE
                        REPORT "Icistat" 2
                     ENDIF
                     CLEARMESSAGE.U()
                  ENDIF
               CASE UPPER(RSP) = "S":
                  MESSAGE.U("REPORT", "Printing Report to Screen//Please Wait..." ,TRUE,FALSE)
                  {Report} {Output} {Icistat} {1} {File} {CisMsg} {Replace}
                  CLEARALL
                  CLEARMESSAGE.U()
                  VIEWFILEEDITORWIN("CisMsg.rpt" ;" file name to edit
                  ,"MESSAGE REPORT" ; title of window
                  ,"FileEditWaitMenu" ;procedure to call on startup
                  ,"" ;procedure on close
                  ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
            ENDSWITCH
         CASE NBR = 2:
            SWITCH
               CASE UPPER(RSP) = "P":
                  PRINTERTYPE=GETPORT()
                  IF RETURNED <> 1 THEN
                     IF PRTV <> "LPT1" THEN
                        IF PRINTTYPE = 1 THEN
                           ;select the report and change the settings
                           MENU {Report} {Change} {Last} {1}
                           ENTER
                           {Setting} {Setup} {Custom} SELECT PRTV
                           ENTER
                           ENTER
                           DO_IT!
                        ELSE
                           ;select the report and change the settings
                           MENU {Report} {Change} {Last} {2}
                           ENTER
                           {Setting} {Setup} {Custom} SELECT PRTV
                           ENTER
                           ENTER
                           DO_IT!
                        ENDIF
                     ENDIF
                     MESSAGE.U("REPORT", "Printing Report//Please Wait..." ,TRUE,FALSE)
                     IF PRINTTYPE=1 THEN
                        REPORT "Last" 1
                     ELSE
                        REPORT "Last" 2
                     ENDIF
                     CLEARMESSAGE.U()
                  ENDIF
               CASE UPPER(RSP) = "S":
                  MESSAGE.U("REPORT", "Printing Report to Screen//Please Wait..." ,TRUE,FALSE)
                  {Report} {Output} {last} {1} {File} {CisMsg} {Replace}
                  CLEARALL
                  CLEARMESSAGE.U()
                  VIEWFILEEDITORWIN("CisMsg.rpt" ;"Readme.txt" file name to edit
                  ,"MESSAGE REPORT" ;title of window
                  ,"FileEditWaitMenu" ;procedure to call on startup
                  ,"" ;procedure on close
                  ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
            ENDSWITCH
         CASE NBR = 3:
            SWITCH
               CASE UPPER(RSP) = "P":
                  PRINTERTYPE=GETPORT()
                  IF RETURNED <> 1 THEN
                     IF PRTV <> "LPT1" THEN
                        IF PRINTTYPE = 1 THEN
                           ;select the report and change the settings
                           MENU {Report} {Change} {QueryMsg} {1}
                           ENTER
                           {Setting} {Setup} {Custom} SELECT PRTV
                           ENTER
                           ENTER
                           DO_IT!
                        ELSE
                           ;select the report and change the settings
                           MENU {Report} {Change} {QueryMsg} {2}
                           ENTER
                           {Setting} {Setup} {Custom} SELECT PRTV
                           ENTER
                           ENTER
                           DO_IT!
                        ENDIF
                     ENDIF
                     MESSAGE.U("REPORT", "Printing Report//Please Wait..." ,TRUE,FALSE)
                     IF PRINTTYPE=1 THEN
                        REPORT "QueryMsg" 1
                     ELSE
                        REPORT "QueryMsg" 2
                     ENDIF
                     CLEARMESSAGE.U()
                  ENDIF
               CASE UPPER(RSP) = "S":
                  MESSAGE.U("REPORT", "Printing Report to Screen//Please Wait..." ,TRUE,FALSE)
                  {Report} {Output} {QueryMsg} {1} {File} {CisMsg} {Replace}
                  CLEARALL
                  CLEARMESSAGE.U()
                  VIEWFILEEDITORWIN("CisMsg.rpt" ;"Readme.txt" file name to edit
                  ,"MESSAGE REPORT" ;title of window
                  ,"FileEditWaitMenu" ;procedure to call on startup
                  ,"" ;procedure on close
                  ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
            ENDSWITCH
         CASE NBR = 4:
            SWITCH
               CASE UPPER(RSP) = "P":
                  PRINTERTYPE=GETPORT()
                  IF RETURNED <> 1 THEN
                     IF PRTV <> "LPT1" THEN
                        IF PRINTTYPE = 1 THEN
                           ;select the report and change the settings
                           MENU {Report} {Change} {Idl} {1}
                           ENTER
                           {Setting} {Setup} {Custom} SELECT PRTV
                           ENTER
                           ENTER
                           DO_IT!
                        ELSE
                           ;select the report and change the settings
                           MENU {Report} {Change} {Idl} {2}
                           ENTER
                           {Setting} {Setup} {Custom} SELECT PRTV
                           ENTER
                           ENTER
                           DO_IT!
                        ENDIF
                     ENDIF
                     MESSAGE.U("REPORT", "Printing Report//Please Wait..." ,TRUE,FALSE)
                     IF PRINTTYPE=1 THEN
                        REPORT "Idl" 1
                     ELSE
                        REPORT "Idl" 2
                     ENDIF
                     CLEARMESSAGE.U()
                  ENDIF
               CASE UPPER(RSP) = "S":
                  MESSAGE.U("REPORT", "Printing Report to Screen//Please Wait..." ,TRUE,FALSE)
                  {Report} {Output} {Idl} {1} {File} {CisCat} {Replace}
                  CLEARALL
                  CLEARMESSAGE.U()

                  VIEWFILEEDITORWIN("CisCat.rpt" ;"Readme.txt" file name to edit
                  ,"MESSAGE REPORT" ;title of window
                  ,"FileEditWaitMenu" ;procedure to call on startup
                  ,"" ;procedure on close
                  ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
            ENDSWITCH
      ENDSWITCH
      CLEARALL
   ENDIF
ENDPROC
WRITELIB LIBNAME GETRPT
RELEASE PROCS GETRPT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetRpt" )



; This Scirpt is a collection of proceedures for using the Paradox 4.0 File
; editor like you would Readme com in your script
;
;             Written 1/25/93
;             Brian Bushay
;             1715 Emerson Ave N
;             Minneapolis, MN 55411
;             CIS 76711,516
;
;
; More great work by Brian
; ================================================================================
; ==============================ViewFileEditorWin()  ==============================
; ================================================================================
; View a report in the Editor Window
PROC VIEWFILEEDITORWIN(FILE.A ;file name to edit
   ;the followning paramaters can be blank strings ""
   ,TITLE.A ;title of window
   ,STARTUP.PROC ;procedure to call on startup
   ,CLOSE.PROC ;procedure on close
   ,MENUHANDLER.PROC) ;procedure to evaluate menu choices
   PRIVATE  RET,PROCNAME.A

   ,STARTKEYS.Y ;keyboard state on entry to this Proc
   ,WIND.Y ;dynarray holding attributes of editor Window
   ,EDITOR.W ;holds handle of editor window
   ,SCROLL.Y ;dynarray to hold state of Scroll lock
   PROCNAME.A = "ViewFileEditorWin"
   ;Echo Off
   EDITOR
   OPEN FILE.A ;open the edit session
   WINDOW LIST TO WINS
   ALLWIN=ARRAYSIZE(WINS)
   WINDOW SELECT WINS[allwin]
   EDITOR.W = GETWINDOW() ;try to get editor window handle
   WINDOW SELECT EDITOR.W
   WINDOW GETATTRIBUTES EDITOR.W TO WIND.Y
   ;check if the handle GetWindow() returned is for an editor session
   IF SEARCH(UPPER(FILE.A),UPPER(WIND.Y["Title"])) = 0 THEN ;oops not the correct handle
      EDITOR.W = GETEDITORWINDOW(WIND.Y,FILE.A)
   ENDIF
   IF ISASSIGNED(WINDOWLBL.A) THEN ;If a custom window title is to be used
      WIND.Y["Title"] = WINDOWLBL.A
   ELSE
      WIND.Y["Title"] = "" ;Use no title for window
   ENDIF
   {Options} {WordWrap} {Clear} ;remove default WordWrap behavior
   GETKEYBOARDSTATE TO STARTKEYS.Y ;record current keyboard state
   DYNARRAY SCROLL.Y[] ;create dynarray
   SCROLL.Y["Scroll Lock"]= TRUE ;start out with scroll lock on
   SETKEYBOARDSTATE FROM SCROLL.Y
   WINDOW SETATTRIBUTES EDITOR.W FROM WIND.Y ;sets new window title
   WINMAX ;Maximize editor window
   ;IF you don't want the following default Prompt then use the startUp.proc
   ;paramater to set up a custom prompt
   PROMPT "*Print to Screen*    "
   MESSAGE ""
   IF NOT ISBLANK(STARTUP.PROC) THEN ;use startup proceedure to set custom
      EXECPROC STARTUP.PROC ;showPullDown and Promts ect
   ENDIF
   ECHO NORMAL
   IF NIMAGES() > 0 THEN ;images on workspace use WAIT
      WAIT WORKSPACE
      PROC "FileEditWaitHandler"
         ; no event argument traps for all events except Idle
      ENDWAIT
   ELSE ;No images so use GetEvent
      WHILE TRUE
         GETEVENT TO EVENT.Y
         FILEEDITWAITHANDLER("EVENT",EVENT.Y,0) ;event Processing procedure
         SWITCH ;can be shared with WAIT
            CASE RETVAL = 0 :
               EXECEVENT EVENT.Y
            CASE RETVAL = 1 :
               ;do nothing
               OTHERWISE:
               QUITLOOP
         ENDSWITCH
      ENDWHILE
   ENDIF
   ECHO OFF
   SETKEYBOARDSTATE FROM STARTKEYS.Y ;Restore keyboard state on entry
   WINDOW SELECT EDITOR.W ;make sure the editor window is current
   WINDOW
   CLOSE

   IF NOT ISBLANK(CLOSE.PROC) THEN ;Use close.proc to reset menus and Prompt if desired
      EXECPROC CLOSE.PROC ;ect
   ENDIF

ENDPROC

WRITELIB LIBNAME VIEWFILEEDITORWIN
RELEASE PROCS VIEWFILEEDITORWIN
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "ViewFileEditorWin" )


; ================================================================================
; ==============================GetEditorWindow()  ==============================
; ================================================================================
; Gets a window handle of an Edit session even when floating window is on workspace
; Thanks to Dan Paolini for this technique

PROC GETEDITORWINDOW(WINATT.Y ;dynarray to hold window attributes
   ,FILENM.A);file name same AS WINDOW title
   PRIVATE  RET,PROCNAME.A,
            WINDOWS.R,
            ELEMENTS.N,
            CNTR

   PROCNAME.A = "GetEditorWindow"
   WINDOW LIST TO WINDOWS.R ;Get a list of all Windows
   ELEMENTS.N = ARRAYSIZE(WINDOWS.R)
   FOR CNTR FROM 1 TO ELEMENTS.N
      WINDOW SELECT WINDOWS.R[cntr]
      WINDOW GETATTRIBUTES WINDOWS.R[cntr] TO WINATT.Y
      IF SEARCH(UPPER(FILE.A),UPPER(WIND.Y["Title"])) >0 THEN
         QUITLOOP
      ENDIF
   ENDFOR
   RETURN IIF(CNTR>ELEMENTS.N,0,WINDOWS.R[cntr]) ; 0 no Editor Window found
ENDPROC
WRITELIB LIBNAME GETEDITORWINDOW
RELEASE PROCS GETEDITORWINDOW
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetEditorWindow" )

; ================================================================================
; ==============================FileEditWaitHandler()  ==============================
; ================================================================================
; Handles keys passed from Wait sessions on the Editor

PROC FILEEDITWAITHANDLER(TRIGER.A,EVENT.Y,CYCLE.N)
   PRIVATE  RET,PROCNAME.A

   PROCNAME.A = "FileEditWaitHandler"
   RET = 1
   SWITCH
      CASE TRIGER.A <> "EVENT":
         SWITCH
            CASE TRIGER.A = "ARRIVEWINDOW" :
               ;if a different window is selected the Editor window will be closed
               IF GETWINDOW() <> EDITOR.W AND GETWINDOW() <> 0 THEN
                  RET = 2 ;2 leaves Wait
               ENDIF
               OTHERWISE:
         ENDSWITCH
      CASE EVENT.Y["Type"] = "MOUSE" :
         RET = 0
      CASE EVENT.Y["Type"] = "KEY" :
         SWITCH
            CASE EVENT.Y["KEYCODE"] =-24 :
               ;don't allow ;to DOS keys
            CASE EVENT.Y["KEYCODE"] =15 :
               ;don't allow
               ;Internal windows like Zoom have handle of 0
               ;so no more key strokes excluded if handle is 0
            CASE GETWINDOW() = 0 :
               RET = 0
            CASE
               EVENT.Y["KEYCODE"] <= -71 AND ;Home, Up, PgUp, Left
               EVENT.Y["KEYCODE"] >= -81 : RET = 0 ;End,Down,PgDn,Right
            CASE
               EVENT.Y["KEYCODE"] <= -115 AND ;Ctrl/Left Ctrl/Right
               EVENT.Y["KEYCODE"] >= -119 : RET = 0 ;Ctrl/Home Ctrl/End Ctrl/PgDn
            CASE
               EVENT.Y["KEYCODE"] = -16:
               RET = 2 ;leave the wait
            CASE
               EVENT.Y["KEYCODE"] = -31:
               GETKEYBOARDSTATE TO SCROLL.Y ;make sure information is current
               SCROLL.Y["Scroll Lock"]= (NOT SCROLL.Y["Scroll Lock"])
               SETKEYBOARDSTATE FROM SCROLL.Y
               RET = 1

            CASE EVENT.Y["KEYCODE"] = -132 :
               RET = 0 ;Ctrl/PgUp
            CASE EVENT.Y["KEYCODE"] = 26 :
               RET = 0 ;Zoom
            CASE EVENT.Y["KEYCODE"] = -44 :
               RET = 0 ;ZoomNext
            CASE EVENT.Y["KEYCODE"] = 27 :
               RET = 2 ;Esc
               OTHERWISE: RET = 1 ;All other keys do not process
         ENDSWITCH
      CASE EVENT.Y["Type"] = "MESSAGE" :
         SWITCH
            CASE
               EVENT.Y["Message"] = "MENUSELECT"
               OR EVENT.Y["Message"] = "MENUKEY" :
               ;check if a Proc is defined to handle Menu selections
               IF NOT ISBLANK(MENUHANDLER.PROC) THEN ;use menu handling proceed ure if
                  EXECPROC MENUHANDLER.PROC ;it is defined
                  RET = RETVAL
               ENDIF
            CASE EVENT.Y["Message"] = "CLOSE" :
               RETURN 2 ;user moused close Bar
               OTHERWISE: RET = 0
         ENDSWITCH
         OTHERWISE:
         MESSAGE EVENT.Y["type"] ;just incase anything slips by
   ENDSWITCH
   RETURN RET
ENDPROC
WRITELIB LIBNAME FILEEDITWAITHANDLER
RELEASE PROCS FILEEDITWAITHANDLER
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "FileditWaitHandler" )

; ================================================================================
; ==============================FileEditWaitMenu()  ==============================
; ================================================================================
; Menu to put up for File Edit Session
PROC FILEEDITWAITMENU()
   PRIVATE  RET,PROCNAME.A

   PROCNAME.A = "FileEditWaitMenu"
   ;puts up single choice show Pulldown
   SHOWPULLDOWN
      "Quit"          : "Leave File Viewer "                : "27",
      "Scroll Toggel" : "Toggel Scroll Lock"                : "Scroll"
   ENDMENU
ENDPROC

WRITELIB LIBNAME FILEEDITWAITMENU
RELEASE PROCS FILEEDITWAITMENU
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "FileEditWaitMenu" )

; ================================================================================
; ==============================FileEditWaitMenuHandler()  ==============================
; ================================================================================
; Proceedure to handle Menu selections while in File editor
PROC FILEEDITWAITMENUHANDLER()
   PRIVATE  RET,PROCNAME.A

   PROCNAME.A = "FileEditWaitMenuHandler"
   SWITCH
      CASE EVENT.Y["MENUTAG"] = "27" :
         RET = 2 ;leave the wait
      CASE EVENT.Y["MENUTAG"] = "Scroll" :
         GETKEYBOARDSTATE TO SCROLL.Y ;make sure information is current
         SCROLL.Y["Scroll Lock"]= (NOT SCROLL.Y["Scroll Lock"])
         SETKEYBOARDSTATE FROM SCROLL.Y
         RET = 1
         OTHERWISE: RET = 1 ;Do nothhing
   ENDSWITCH
   RETURN RET
ENDPROC
WRITELIB LIBNAME FILEEDITWAITMENUHANDLER
RELEASE PROCS FILEEDITWAITMENUHANDLER
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "FileEditWaitMenuHandler" )


PROC VIEWDOC()
   VIEWFILEEDITORWIN("CisMsg.txt" ;" file name to edit
   ,"Program Documentation" ; title of window
   ,"FileEditWaitMenu" ;procedure to call on startup
   ,"" ;procedure on close
   ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
ENDPROC
WRITELIB LIBNAME VIEWDOC
RELEASE PROCS VIEWDOC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "ViewDoc" )


; -------------------------------------------------------------------
; DesktopPlus for Paradox, version 4.0
; PRINTREC.SC
; Copyright 1988-92 Kallista, Inc. - All Rights Reserved
; used with expressed consent for CISMSG Application
; altered to work with open FieldView Window
; -------------------------------------------------------------------
PROC DT_REC_PRINT_CUSTOM(NBR)
   PRIVATE  FIELDVALUES, ; fixed array to hold the record's values
            WASFORMVIEW, ; Were we in formview when the routine startred
            CURRENTWINDOW,;
            CURRENTTABLE, ;
            REPORTSPEC ;

   IF NBR > 1 THEN
      DO_IT!
   ENDIF
   WINDOW SELECT FORMWINDOW
   MOVETO [FORUM]
   WINTOCLOSE = 2
   MODE=SYSMODE()
   TBL=TABLE()
   FRM=FORM()
   BU=2
   ;IF MODE="View" OR MODE= "Main" THEN
   ECHO OFF
   MESSAGE "Checking printer status"
   IF NOT PRINTERSTATUS() THEN
      EXITMESSAGE = "Print not found"
      RETURN TRUE
   ENDIF

   IF IMAGETYPE() <> "Display" THEN
      EXITMESSAGE = "Not in a display image"
      RETURN TRUE
   ENDIF

   IF NIMAGERECORDS() = 0 THEN
      EXITMESSAGE = "Current image is empty"
      RETURN TRUE
   ENDIF

   MESSAGE "Building report list"

   CURRENTTABLE = TBL
   DYNARRAY REPORTLIST[]

   ; Build a list of the available report specs
   DO_IT!
   MENU {Report} {Change} SELECT CURRENTTABLE
   CURRENTCHOICE = MENUCHOICE()
   WHILE TRUE
      REPINDEX = MENUCHOICE()
      REPORTLIST[RepIndex] = REPINDEX
      ENTER
      REPORTLIST[RepIndex] = REPORTLIST[RepIndex] + " - " + MENUCHOICE()
      ESC
      DOWN
      IF MENUCHOICE() = CURRENTCHOICE THEN
         QUITLOOP
      ENDIF
      CURRENTCHOICE = MENUCHOICE()
   ENDWHILE
   MENU ESC

   ; Hide the Paradox menu


   MESSAGE ""
   REPORTSPEC = ""
   EXITCONTROL = FALSE
   ; PaintPAL_Generated_Code_Begin(449559734)

   SHOWDIALOG
      "Custom Reports"
      @6,20 HEIGHT 14 WIDTH 43

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,1 TO 9,39
      PAINTCANVAS ATTRIBUTE 112 0,1,0,39
      PAINTCANVAS ATTRIBUTE 127 9,1,9,39
      PAINTCANVAS ATTRIBUTE 112 0,1,9,1
      PAINTCANVAS ATTRIBUTE 127 0,39,9,39
      ; PaintPAL_Frame_End

      PICKDYNARRAY @1,2 HEIGHT 8 WIDTH 36
         REPORTLIST
         TAG "ReportList"
         TO REPORTSPEC

      PUSHBUTTON @10,7 WIDTH 10
         "~O~K"
         OK
         DEFAULT
         VALUE TRUE
         TAG "Accept"
         TO EXITCONTROL

      PUSHBUTTON @10,22 WIDTH 10
         "~C~ancel"
         CANCEL
         VALUE FALSE
         TAG "Cancel"
         TO EXITCONTROL
   ENDDIALOG

   ; PaintPAL_Generated_Code_End(449559734)


   IF EXITCONTROL = TRUE THEN

      MESSAGE "Printing current record"

      ;       Check whether form or table view

      ;         if isformview() then
      ;            formkey
      ;            WasFormView = True
      ;         else
      ;            WasFormView = false
      ;         endif
      CTRLHOME
      MOVETO TBL
      COPYTOARRAY FIELDVALUES

      ; Query table to get the current record
      DTTBL="MH"
      CREATE DTTBL+"$temp$" LIKE CURRENTTABLE
      VIEW DTTBL+"$temp$"
      COEDITKEY
      COPYFROMARRAY FIELDVALUES
      DO_IT!
      CLEARIMAGE

      COPYREPORT CURRENTTABLE REPORTSPEC DTTBL+"$temp$" REPORTSPEC
      REPORT DTTBL+"$temp$" REPORTSPEC

      ; Cleanup

      DELETE DTTBL+"$temp$"
      MESSAGE ""
      MOVETO TBL
      PICKFORM FRM
      FIXMSGBOX(2)
      IF NBR = 2 THEN
         COEDITKEY
         IMAGERIGHTS READONLY
      ENDIF
      RETURN TRUE
   ELSE
      MOVETO TBL
      PICKFORM FRM
      FIXMSGBOX(2)
      IF NBR = 2 THEN
         COEDITKEY
         IMAGERIGHTS READONLY
      ENDIF

      RETURN FALSE
   ENDIF
   ECHO NORMAL
ENDPROC

WRITELIB LIBNAME DT_REC_PRINT_CUSTOM
RELEASE PROCS DT_REC_PRINT_CUSTOM
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DT_REC_PRINT_CUSTOM" )


;BSC
; PROCEDURE   :start.m
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : N\A
; RETURNS     : N\A
; Special Info: Diag to get CIS Prog Type and directory
;BSC

PROC START.M()
   PRIVATE  HELPME.A, PROGTYPE, FILEDIR, DLG.H

   ; PaintPAL_Generated_Code_Begin(448222737)

   IF NOT ISASSIGNED(FILEHANDLE[1]) THEN
      FILEHANDLE[1] = 1
   ENDIF
   IF NOT ISASSIGNED(FILEHANDLE[2]) THEN
      FILEHANDLE[2] = DIRECTORY()
   ENDIF


   PROGTYPE = FILEHANDLE[1]
   FILEDIR = FILEHANDLE[2]
   OKCANCEL = "Cancel"
   HELPME.A = ""

   ; PaintPAL_Color_Setup_Begin
   GETCOLORS TO PaintPAL.OriginalPalette
   DYNARRAY PaintPAL.ColorDeviations[]
   PaintPAL.ColorDeviations[1038] = 116  ;Label Selected
   SETCOLORS FROM PaintPAL.ColorDeviations
   RELEASE VARS PaintPAL.ColorDeviations
   ; PaintPAL_Color_Setup_End

   SHOWDIALOG "Program SetUp"  ; D:\PALP3\SETUP.DLG
      PROC "DlgGetHelp"
         TRIGGER "OPEN", "UPDATE", "ACCEPT"

      @2,15 HEIGHT 20 WIDTH 48

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,1 TO 17,44
      PAINTCANVAS ATTRIBUTE 127 0,1,0,44
      PAINTCANVAS ATTRIBUTE 112 17,1,17,44
      PAINTCANVAS ATTRIBUTE 127 0,1,17,1
      PAINTCANVAS ATTRIBUTE 112 0,44,17,44
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 1,3 TO 11,42
      PAINTCANVAS ATTRIBUTE 112 1,3,1,42
      PAINTCANVAS ATTRIBUTE 127 11,3,11,42
      PAINTCANVAS ATTRIBUTE 112 1,3,11,3
      PAINTCANVAS ATTRIBUTE 127 1,42,11,42
      ; PaintPAL_Frame_End

      RADIOBUTTONS @3,10 HEIGHT 4 WIDTH 26
         ".MSG OzCIS-Tapcis-GCP",
         ".MES OzCIS v1.2",
         ".SAV OzCIS-Tapcis-GCP",
         ".PRG OzCIS-Tapcis-GCP"
         TAG "ProgTag"
         TO PROGTYPE

      LABEL @2,10
         "Message Import File Type"
         FOR "ProgTag"

      RADIOBUTTONS @9,18 HEIGHT 2 WIDTH 9
         "Yes",
         "No"
         TAG "ConFDeltag"
         TO CONFIRMDEL

      LABEL @8,15
         "Confirm Deletes"
         FOR "ConFDeltag"

      ACCEPT @13,3 WIDTH 40
         "A50"
         TAG "LocationTag"
         TO FILEDIR

      LABEL @12,7
         "Location of MSG and CAT Files "
         FOR "LocationTag"

      PUSHBUTTON @15,5 WIDTH 8
         "~O~k"
         OK
         DEFAULT
         VALUE "OK"
         TAG "OkTag"
         TO OKCANCEL

      PUSHBUTTON @15,18 WIDTH 8
         "~H~elp"
         VALUE HELPMEDLG(1)
         TAG "HelpTag"
         TO HELPME.A

      PUSHBUTTON @15,31 WIDTH 10
         "~C~ancel"
         CANCEL
         VALUE "Cancel"
         TAG "CancelTag"
         TO OKCANCEL
   ENDDIALOG

   ; PaintPAL_Color_Cleanup_Begin
   SETCOLORS FROM PaintPAL.OriginalPalette
   RELEASE VARS PaintPAL.OriginalPalette
   ; PaintPAL_Color_Cleanup_End

   ; PaintPAL_Generated_Code_End(448222737)

   IF OKCANCEL = "OK" THEN
      COEDIT "Start"
      [type] = PROGTYPE
      FILEHANDLE[1] = PROGTYPE
      IF FILEDIR > "" THEN
         A=LEN(FILEDIR)
         IF SUBSTR(FILEDIR, A,1) <> "\\" THEN
            FILEDIR = FILEDIR +"\\"
         ENDIF
         [directory] = FILEDIR
         FILEHANDLE[2] = FILEDIR
      ELSE
         FILEHANDLE[2] = DIRECTORY()
      ENDIF
      [done] = "Y"
      FILEHANDLE[3] = "Y"
      FILEHANDLE[8] = CONFIRMDEL
      [deletes] = CONFIRMDEL
      DO_IT!
      CLEARALL
   ENDIF
ENDPROC
WRITELIB LIBNAME START.M
RELEASE PROCS START.M
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "Start.m" )



PROC DLGGETHELP(EVENTTYPE, TAGVALUE, EVENTVALUE, ELEMENTVALUE)
   SWITCH
      CASE EVENTTYPE = "ACCEPT" :
         IF HELPME.A > "" THEN
            REPAINTDIALOG
            RETURN FALSE
         ENDIF
      CASE EVENTTYPE = "UPDATE" :
      CASE EVENTTYPE = "OPEN" :
         WINDOW HANDLE DIALOG TO DLG.H
   ENDSWITCH
ENDPROC
WRITELIB LIBNAME DLGGETHELP
RELEASE PROCS DLGGETHELP
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DlgGetHelp" )



PROC HELPMEDLG(NBR) ; Displays available printer
   PRIVATE  NBR

   SWITCH
      CASE NBR = 1:
         OK.U("HELP", "Use the Arrow Keys or Mouse to choose the/correct CIS program.//Enter the directory where your message and /catalog files are located..." ,TRUE,FALSE)
      CASE NBR = 2:
         OK.U("HELP", "Use the Arrow Keys and Space Bar/or Mouse to choose the/files to import..." ,TRUE,FALSE)
      CASE NBR = 3:
         OK.U("Help","Use Mouse on SpeedBar to move back/and forth through the records//Or Press F10 for Menu Items//Memo Window can be Maximized",TRUE,FALSE)
      CASE NBR = 4:
         OK.U("Help","Select you Forum by scrolling through list/Tab or Mouse to Sections list/Choose Section//Enter date range/or Choose ALL or Today...",TRUE,FALSE)
      CASE NBR = 5:
         OK.U("HELP", "Use the Arrow Keys and Space Bar/or Double-Click with the Mouse/to choose the Subjects..." ,TRUE,FALSE)
   ENDSWITCH
   RETURN FALSE
ENDPROC
WRITELIB LIBNAME HELPMEDLG
RELEASE PROCS HELPMEDLG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "HelpMeDlg" )


PROC GetFileSize(Nbr, Typ.n)
   PRIVATE  i,nam,siz,dat,mm,dd,yy

   IF IsFile("FileList.txt") THEN
      Editor New "FileList.txt" DO_IT! ;Deletes old file
   ENDIF


   SWITCH
      CASE NBR = 2 AND TYP.N= 1 :
         IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
            RUN NOREFRESH "GetFiles " + Filehandle[2]+ "*.mes"
         ELSE
            RUN NOREFRESH "GetFiles *.mes"
         ENDIF
      CASE NBR = 1 AND TYP.N = 1:
         IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
            RUN NOREFRESH "GetFiles " + Filehandle[2]+ "*.msg"
         ELSE
            RUN NOREFRESH "GetFiles *.msg"
         ENDIF
      CASE NBR = 3 AND TYP.N= 1 :
         IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
            RUN NOREFRESH "GetFiles " + Filehandle[2]+ "*.sav"
         ELSE
            RUN NOREFRESH "GetFiles *.sav"
         ENDIF
      CASE NBR = 4 AND TYP.N = 1:
         IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
            RUN NOREFRESH "GetFiles " + Filehandle[2]+ "*.prg"
         ELSE
            RUN NOREFRESH "GetFiles *.prg"
         ENDIF

      CASE NBR = 1 Or NBR=3 or NBR=4 AND TYP.N= 2 :
         IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
            RUN NOREFRESH "GetFiles " + Filehandle[2]+ "*.Cat"
         ELSE
            RUN NOREFRESH "GetFiles *.Cat"
         ENDIF
      CASE NBR = 2 AND TYP.N = 2:
         IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
            RUN NOREFRESH "GetFiles " + Filehandle[2]+ "*.l*"
         ELSE
            RUN NOREFRESH "GetFiles *.l*"
         ENDIF

   ENDSWITCH

   CLEARALL
   Message.u("CHECKING FILES", "Checking Import files for Blank entries..." ,true,false)
   IF istable("Ddir") THEN
      DELETE "DDIR"
   ENDIF
   IF IsFile("FILELIST.TXT") THEN
      {Tools} {ExportImport} {Import} {ASCII} {Text} {Filelist} {ddir}
      CLEARALL
      IF ISTABLE ("DOSDIR") THEN
         Delete "DOSDIR"
      ENDIF
         CREATE "DOSDIR"
         "NAME"    :   "A12*",
         "SIZE"    :   "N",
         "DATE"    :   "D"
      CLEARALL
      IF Istable("DDIR") THEN
         IF Nrecords("DDIR") >= 1 THEN
            recs = Nrecords("DDIR")
            VIEW "DDir"
            COEDIT "DosDIR"
            FOR i FROM 1 TO recs
               MOVETO "DDir"
               MOVETO record(i)
               nam=substr([text],1,12)
               siz=Numval(substr([text],14,12))
               MM=Substr([text],26,2)
               DD=Substr([text],29,2)
               YY=Substr([text],34,2)
               dat=Dateval(mm+"/"+dd+"/"+yy)
               MOVETO "DosDir"
               IF i > 1 THEN
                  END
                  DOWN
               ENDIF
               [name] = nam
               [size] = siz
               [date] = Dat
            ENDFOR

            DO_IT!

            VIEW "DosDir"

            SCAN
               SWITCH
                  CASE typ.n = 1:

                     IF [size] <= 380 THEN
                        FILEDEL=[name]
                        IF FILEHANDLE[2] = SDIR() THEN
                           RUN NOREFRESH "del " +FILEHANDLE[2]+FILEDEL + " > junk"
                        ENDIF
                     ENDIF
                  CASE typ.n = 2:

                     IF [size] <= 100 THEN
                        FILEDEL=[name]
                        IF FILEHANDLE[2] = SDIR() THEN
                           RUN NOREFRESH "del " +FILEHANDLE[2]+FILEDEL + " > junk"
                        ENDIF
                     ENDIF
               ENDSWITCH
            ENDSCAN
            CLEARALL
            CLEARMESSAGE.U()
         ELSE
            CLEARALL
            CLEARMESSAGE.U()
            wbsFillScreen()
         ENDIF
      ELSE
         CLEARALL
         CLEARMESSAGE.U()
         wbsFillScreen()
      ENDIF
   ELSE
      CLEARALL
      CLEARMESSAGE.U()
      wbsFillScreen()
   ENDIF

ENDPROC
WRITELIB LIBNAME GetFileSize
RELEASE PROCS GetFileSize
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetFileSize" )

;Ŀ
;                                                                           
; Copyright (c) 1992   Martin W. Rudy   All Rights Reserved                 
; This program can be used/copied/modified without charge provided this     
; copyright notice is included without change, and that any accompanying    
; documentation includes "Portions of this code Copyright (c) 1992,         
; Martin W. Rudy  All Rights Reserved"                                      
;                                                                           
;

; This is an example of displaying a list of values in a picklist and allowing
; multiple values to be selected.  As elements in the picklist are selected
; they are placed in a second picklist.  Dynarray elements can be moved
; between the picklists using the pushbuttons, spacebar on the current
; element, or double click with the mouse.


PROC DLGGETFILES(NBR)
   PRIVATE  SYSINFO_BAG, ; Dynamic array for SYSINFO
            OKCANCEL, ; Pushbutton variable
            ADDITEM, ; Pushbutton variable
            ADDALL, ; Pushbutton variable
            REMOVEITEM, ; Pushbutton variable
            REMOVEALL, ; Pushbutton variable
            MTHINFILE, ; Picklist variable
            MTHOUTFILE, ; Picklist variable
            HELPME.A

   OKCANCEL = "Cancel"
   DYNARRAY MTHFILECHOICE[] ; values does not exist
   SWITCH
      CASE NBR = 1:
         VIEW "DosDir" ; create it
         SCAN
            IF [size] > 380 THEN
               MTHFILECHOICE[[Name]] = [Name]
            ENDIF
         ENDSCAN
         CLEARIMAGE
      CASE NBR= 2:
         VIEW "DosDir" ; create it
         SCAN
            IF [size] > 100 THEN
               MTHFILECHOICE[[Name]] = [Name]
            ENDIF
         ENDSCAN
         CLEARIMAGE
   ENDSWITCH
   DYNARRAY MTHFILESELECT[] ; Create dynarray for selected
   ; values
   SYSINFO TO SYSINFO_BAG ; Get screen height and width
   HELPME.A = ""
   ; PaintPAL_Generated_Code_Begin(448885377)

   SHOWDIALOG
      "Files to Import" ; D:\CIS\IMPORT1.DLG
      PROC "DlgGetFilesProc"
      TRIGGER "UPDATE" , "SELECT"

      @INT((SYSINFO_BAG["ScreenHeight"]-17)/2),INT((SYSINFO_BAG["ScreenWidth"]-66)/2) HEIGHT 19 WIDTH 68

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,0 TO 16,65
      PAINTCANVAS ATTRIBUTE 112 0,0,0,65
      PAINTCANVAS ATTRIBUTE 127 16,0,16,65
      PAINTCANVAS ATTRIBUTE 112 0,0,16,0
      PAINTCANVAS ATTRIBUTE 127 0,65,16,65
      ; PaintPAL_Frame_End

      PICKDYNARRAYINDEX @2,2 HEIGHT 13 WIDTH 21
         MTHFILECHOICE
         TAG "mthinfilelist"
         TO MTHINFILE

      LABEL @1,1
         "Files Available"
         FOR "mthinfilelist"

      PUSHBUTTON @2,24 WIDTH 17
         "Add ~I~tem >"
         VALUE "AddItem"
         TAG "AddItem"
         TO ADDITEM

      PUSHBUTTON @4,24 WIDTH 17
         "~A~dd All >>"
         VALUE "AddAll"
         TAG "AddAll"
         TO ADDALL

      PUSHBUTTON @6,24 WIDTH 17
         "< Re~m~ove Item"
         VALUE "RemoveItem"
         TAG "RemoveItem"
         TO REMOVEITEM

      PUSHBUTTON @8,24 WIDTH 17
         "<< ~R~emove All"
         VALUE "RemoveAll"
         TAG "RemoveAll"
         TO REMOVEALL

      PICKDYNARRAYINDEX @2,42 HEIGHT 13 WIDTH 21
         MTHFILESELECT
         TAG "MtHOutFile"
         TO MTHOUTFILE

      LABEL @1,41
         "Files Chosen"
         FOR "MtHOutFile"

      PUSHBUTTON @10,24 WIDTH 17
         "~O~K"
         OK
         VALUE "OK"
         TAG "OK"
         TO OKCANCEL

      PUSHBUTTON @12,24 WIDTH 17
         "~C~ancel"
         CANCEL
         VALUE "Cancel"
         TAG "Cancel"
         TO OKCANCEL

      PUSHBUTTON @14,24 WIDTH 17
         "~H~elp"
         VALUE HELPMEDLG(2)
         TAG ""
         TO HELPME.A
   ENDDIALOG

   ; PaintPAL_Generated_Code_End(448885377)


   IF RETVAL = FALSE OR OKCANCEL <> "OK" OR ; If the dialog box was
   DYNARRAYSIZE(MTHFILESELECT) = 0 THEN ; cancelled or no departments
      RETURN FALSE ; selected than return False
   ELSE ; otherwise return True
      RETURN TRUE
   ENDIF

ENDPROC
WRITELIB LIBNAME DLGGETFILES
RELEASE PROCS DLGGETFILES
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DlgGetFiles" )




PROC DLGGETFILESPROC(TRIGGERTYPE,TAGVALUE,EVENTVALUE,ELEMENTVALUE)
   SWITCH
      CASE TRIGGERTYPE="UPDATE":
         SWITCH
            CASE TAGVALUE = "AddItem" :
               IF DYNARRAYSIZE(MTHFILECHOICE) = 0 THEN
                  RETURN FALSE
               ENDIF
               MTHFILESELECT[CONTROLVALUE("mthinfilelist")] = MTHFILECHOICE[CONTROLVALUE("mthinfilelist")]
               RELEASE VARS MTHFILECHOICE[CONTROLVALUE("mthinfilelist")]
               SELECTCONTROL "mthinfilelist"
               REFRESHDIALOG
            CASE TAGVALUE = "AddAll" :
               IF DYNARRAYSIZE(MTHFILECHOICE) = 0 THEN
                  RETURN FALSE
               ENDIF
               FOREACH ELEMENT IN MTHFILECHOICE
                  MTHFILESELECT[element] = MTHFILECHOICE[element]
               ENDFOREACH
               DYNARRAY MTHFILECHOICE[]
               SELECTCONTROL "MtHOutFile"
               REFRESHDIALOG
            CASE TAGVALUE = "RemoveItem" :
               IF DYNARRAYSIZE(MTHFILESELECT) = 0 THEN
                  RETURN FALSE
               ENDIF
               MTHFILECHOICE[CONTROLVALUE("MtHOutFile")] = MTHFILESELECT[CONTROLVALUE("MtHOutFile")]
               RELEASE VARS MTHFILESELECT[CONTROLVALUE("MtHOutFile")]
               REFRESHDIALOG
               IF DYNARRAYSIZE(MTHFILESELECT) > 0 THEN
                  SELECTCONTROL "mthinfilelist"
               ELSE
                  SELECTCONTROL "MtHOutFile"
               ENDIF
            CASE TAGVALUE = "RemoveAll" :
               IF DYNARRAYSIZE(MTHFILESELECT) = 0 THEN
                  RETURN FALSE
               ENDIF
               FOREACH ELEMENT IN MTHFILESELECT
                  MTHFILECHOICE[element] = MTHFILESELECT[element]
               ENDFOREACH
               DYNARRAY MTHFILESELECT[]
               SELECTCONTROL "mthinfilelist"
               REFRESHDIALOG
         ENDSWITCH
      CASE TRIGGERTYPE = "SELECT" :
         SWITCH
            CASE TAGVALUE = "mthinfilelist" :
               MTHFILESELECT[CONTROLVALUE("mthinfilelist")] = MTHFILECHOICE[CONTROLVALUE("mthinfilelist")]
               RELEASE VARS MTHFILECHOICE[CONTROLVALUE("mthinfilelist")]
               REFRESHDIALOG
               REPAINTDIALOG
            CASE TAGVALUE = "MtHOutFile" :
               MTHFILECHOICE[CONTROLVALUE("MtHOutFile")] = MTHFILESELECT[CONTROLVALUE("MtHOutFile")]
               RELEASE VARS MTHFILESELECT[CONTROLVALUE("MtHOutFile")]
               REFRESHDIALOG
               REPAINTDIALOG
         ENDSWITCH
   ENDSWITCH
   RETURN TRUE
ENDPROC
WRITELIB LIBNAME DLGGETFILESPROC
RELEASE PROCS DLGGETFILESPROC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DlgGetFilesProc" )



PROC GETSUBJECT()
   ;  dsQueryToPAL: Begin Query
   ;     Generated: June  5, 1993 - 11:27:12
   ;   Description:
   ;

   {Ask} SELECT "Subject"
         [Get] = "changeto blank"
  DO_IT!
   clearall
   {Ask} SELECT "Subject"
   MOVETO [Forum] CHECK
   MOVETO [Sect Number] CHECK
   MOVETO [Subject] CHECK
   [Forum] = FM
   [Sect Number] = SECT
   DO_IT!
   CLEARALL
   IF NRECORDS("answer") >= 1 THEN
      MENU {Modify} {Restructure} {Answer}
      END
      DOWN "get"
      RIGHT
      "a1" DO_IT!
      ;EMPTY "Subject"
      ;ADD "answer" "Subject"
      CLEARALL
      RECORDS=NRECORDS("answer")
      VIEW "Answer"
      DYNARRAY RECS[] ;Initialize Arrays
      DYNARRAY SUBJECTCHOICES[]

      SCAN
         RECS[Recno()] = [Subject] ;Format Array Elements
         ; Format("W5,AL",Recno()) + [Subject]
         ; SubjectChoices[Recno()] = True     ;Start with All Selected
      ENDSCAN

      CLEARALL ;Clear table image
      MARKARRAY(RECS,SUBJECTCHOICES,"Subjects") ;Proc Call
      GOON2 = 1
      COEDIT "answer"
      FOR X FROM 1 TO RECORDS
         IF ISASSIGNED(SUBJECTCHOICES[x]) AND Upper(SUBJECTCHOICES[x]) = "TRUE" THEN
            MOVETO RECORD(X)
            GOON2 = 2
            [get] = "X"
         ENDIF
      ENDFOR
      DO_IT!


      ;  dsQueryToPAL: Begin Query
      ;     Generated: June  5, 1993 - 11:24:03
      ;   Description:
      ;
      IF GOON2 <> 1 THEN

         {Ask} SELECT "Answer"
         [Forum] = "_a"
         [Sect Number] = "_b"
         [Subject] = "_c"
         [Get] = "X"

         {Ask} SELECT "QueryMsg"
         CTRLHOME CHECK
         [Forum] = "_a"
         [Sect Number] = "_b"
         [Subject] = "_c"

         ; [Subject->Forum] = FM
         ; [Subject->Sect Number] = SECT

         DO_IT!
         CLEARALL
         IF NRECORDS("Answer") >=1 THEN
            EMPTY "querymsg"
            ADD "answer" "querymsg"
            GOON1=2
         ELSE
            GOON1 = 1
         ENDIF
      ELSE
         GOON1 = 1
      ENDIF
   ELSE
      GOON1 = 1
   ENDIF
   RELEASE VARS SUBJECTCHOICES, REC, RECS, GOON2
   CLEARALL
   RETURN GOON1
ENDPROC
WRITELIB LIBNAME GETSUBJECT
RELEASE PROCS GETSUBJECT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetSubject" )



;BSC
; PROCEDURE   : PackDataDlg
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  :
; RETURNS     :  OkCancel
; Special Info: Adapted from Code presented at the Paradox Video Conference
;               By Kevin Smith
;BSC
PROC PACKDATADLG()
   ; PaintPAL_Generated_Code_Begin(449953548)
   OKCANCEL = "Cancel"
   MSG.L = FALSE
   CAT.L = FALSE

   SHOWDIALOG
      "Which Files to Pack?" ; D:\CIS\PACK.DLG
      PROC "CisDiagPROC"
      KEY 13

      @7,21 HEIGHT 11 WIDTH 38

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,1 TO 8,34
      PAINTCANVAS ATTRIBUTE 127 0,1,0,34
      PAINTCANVAS ATTRIBUTE 112 8,1,8,34
      PAINTCANVAS ATTRIBUTE 127 0,1,8,1
      PAINTCANVAS ATTRIBUTE 112 0,34,8,34
      ; PaintPAL_Frame_End

      CHECKBOXES @2,3 HEIGHT 2 WIDTH 30
      TAG "magTag"
      "Pack Main Message File" TO MSG.L,
      "Pack Main Catalog File" TO CAT.L

      PUSHBUTTON @6,4 WIDTH 10
         "~O~k"
         OK
         DEFAULT
         VALUE "OK"
         TAG "OkTag"
         TO OKCANCEL

      PUSHBUTTON @6,21 WIDTH 10
         "~C~ancel"
         CANCEL
         VALUE "Cancel"
         TAG "CancelTag"
         TO OKCANCEL
   ENDDIALOG

   ; PaintPAL_Generated_Code_End(449953548)
   RETURN OKCANCEL

ENDPROC
WRITELIB LIBNAME PACKDATADLG
RELEASE PROCS PACKDATADLG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "PackDataDlg" )


;BSC
; PROCEDURE   : PackData
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : n/a
; RETURNS     : none
; Special Info: Pack main data tables
;BSC
PROC PACKDATA()
   PRIVATE  MSG.L, CAT.L, GOON

   GOON = PACKDATADLG()
   IF GOON = "OK" THEN
      IF MSG.L = TRUE THEN
         MESSAGE.U("Packing Data", "Restructuring Message file//Please Wait..." , TRUE, FALSE)
         {Modify} {Restructure} {Icistat}
         DO_IT!
         CLEARALL
         CLEARMESSAGE.U()
      ENDIF
      IF CAT.L = TRUE THEN
         MESSAGE.U("Packing Data", "Restructuring Catalog file//Please Wait..." , TRUE, FALSE)
         {Modify} {Restructure} {Idl}
         DO_IT!
         CLEARALL
         CLEARMESSAGE.U()
      ENDIF

   ELSE
      MESSAGE.U("Cancelled", "Operation Cancelled..." , TRUE, FALSE)
      SLEEP 1500
      CLEARMESSAGE.U()
   ENDIF
ENDPROC
WRITELIB LIBNAME PACKDATA
RELEASE PROCS PACKDATA
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "PackData" )

;BSC
; PROCEDURE   : AddRecs()
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  :
; RETURNS     :
; Special Info: Posts records to master message table
;               sets FILEHANDLE[9] = 2
;BSC
PROC ADDRECS()
   PRIVATE  RSP

   SHOWPULLDOWN
   ENDMENU
   WBSFILLSCREEN()
   RSP =CONTINUECANCEL.L("UPDATE MASTER TABLE", "Add Last Import to Master Message File" , TRUE, FALSE)
   IF RSP = TRUE THEN
      MESSAGE.U("ADDING RECORDS", "Updating Master Message File//Please Wait..." ,TRUE,FALSE)
      ADD "Last" "Icistat"
      CLEARALL
      COEDIT "start"
      [batch] = 2
      FILEHANDLE[9] = 2
      DO_IT!
      CLEARALL
      CLEARMESSAGE.U()
   ENDIF
ENDPROC
WRITELIB LIBNAME ADDRECS
RELEASE PROCS ADDRECS
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "AddRecs" )



;BSC
; PROCEDURE   : CisDiagProc
; PARAMETERS  :
; Special Info: Converts Tab to Enter
;BSC
PROC CISDIAGPROC(TRIGGER.A, TAG.A, EVENTVALUE.V, CBLABEL.A)
   SWITCH
      CASE
         TRIGGER.A = "EVENT" AND EVENTVALUE.V["KeyCode"]=13 ; <<<<<< This works
         AND UPPER(TAG.A)="OKTAG" OR UPPER(TAG.A)="CANCELTAG" OR UPPER(TAG.A) ="HELPTAG":
         RETURN TRUE
      CASE TRIGGER.A = "EVENT" AND EVENTVALUE.V["KeyCode"]=13:
         ; <<<<<< This works
         RELEASE VARS EVENTVALUE.V["ScanCode"]
         EVENTVALUE.V["KeyCode"] = 9
         RETURN TRUE
   ENDSWITCH
ENDPROC
WRITELIB LIBNAME CISDIAGPROC
RELEASE PROCS CISDIAGPROC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "CisDiagProc" )

;BSC
; PROCEDURE   : GetCatSect
; PARAMETERS  :
; Special Info: Query for specific Library Cat enrties
;BSC

PROC GETCATSECT()
   PRIVATE  RSP,HELPME.A,TMPMTH

   GOON1= 2
   GOON2 = 2

   IF FILEHANDLE[11] <> 1 THEN
      RSP=YESNO.L("UPDATE", "Do you wish to Update your Forum List?" ,TRUE,TRUE)
   ELSE
      RSP = TRUE
      VIEW "Start"
      IF [catalog] <> 2 THEN
         COEDIT "Start"
         [catalog] = 2
         FILEHANDLE[11] = 2
         DO_IT!
      ENDIF
      CLEARALL
   ENDIF

   IF RSP = TRUE THEN
      MESSAGE.U("FORUMS", "Gathering Forum Names/" + "Please Wait..." , TRUE, FALSE)
      ;  dsQueryToPAL: Begin Query
      ;     Generated: June 14, 1993 - 23:25:46
      ;   Description:
      ;
      ;  dsQueryToPAL: Begin Query
      ;     Generated: August  3, 1993 - 09:34:06
      ;   Description:
      ;

      {Ask} SELECT "Idl"
      MOVETO [Forum] CHECK
      MOVETO [Library] CHECK

      DO_IT!
      CLEARALL

      IF NRECORDS("Answer") >= 1 THEN
         CLEARMESSAGE.U()
         MESSAGE.U("FORUMS", "Gathering Library Names/" + "Please Wait..." , TRUE, FALSE)
      ELSE
         GOON1 = 1
      ENDIF

      EMPTY "CatSec1"
      ADD "Answer" "CatSec1"
      CLEARALL
      {Ask} SELECT "Catsec1"
      CTRLHOME CHECK
      [Forum] = "_a"
      [Library] = "_b"

      {Ask} SELECT "Icistat"
      [Forum] = "_a"
      [Sect Number] = "_b"
      MOVETO [Sect Name] CHECK
      DO_IT!
      IF NRECORDS("Answer") >= 1 THEN
         EMPTY "CatSec2"
         ADD "Answer" "CatSec2"
         CLEARALL
         CLEARMESSAGE.U()
      ELSE
         GOON2 = 1
      ENDIF
   ENDIF
   IF GOON1 <> 1 AND GOON2 <> 1 THEN
      VIEW "catsec2"
      DYNARRAY FORUMS.Y[] ; build dynarry of forum
      DYNARRAY ALLSECT.Y [] ; section names
      DYNARRAY SHOWSECT.Y []
      SYSINFO TO SYS.Y
      SCAN
         FORUMS.Y[ [forum] ] = [forum]
         ALLSECT.Y[ [forum] + "|" + STRVAL([#]) ] = [sect name]
      ENDSCAN
      CLEARALL

      ; PaintPAL_Generated_Code_Begin(453200107)

      SDATE=BLANKDATE()
      EDATE=BLANKDATE()
      OKCANCEL = "Cancel"
      PICKRB=1
      SHOWDIALOG
         "Forums and Libraries" ; D:\CIS\CAT-SEC.DLG
         PROC "updateDLG.l"
         TRIGGER "OPEN" , "UPDATE"
         KEY 13
         @2,4 HEIGHT 22 WIDTH 70

         ; PaintPAL_Frame_Begin
         FRAME SINGLE FROM 0,0 TO 19,67
         PAINTCANVAS ATTRIBUTE 127 0,0,0,67
         PAINTCANVAS ATTRIBUTE 112 19,0,19,67
         PAINTCANVAS ATTRIBUTE 127 0,0,19,0
         PAINTCANVAS ATTRIBUTE 112 0,67,19,67
         ; PaintPAL_Frame_End

         ; PaintPAL_Frame_Begin
         FRAME SINGLE FROM 2,1 TO 14,31
         PAINTCANVAS ATTRIBUTE 112 2,1,2,31
         PAINTCANVAS ATTRIBUTE 127 14,1,14,31
         PAINTCANVAS ATTRIBUTE 112 2,1,14,1
         PAINTCANVAS ATTRIBUTE 127 2,31,14,31
         ; PaintPAL_Frame_End

         ; PaintPAL_Frame_Begin
         FRAME SINGLE FROM 2,34 TO 14,66
         PAINTCANVAS ATTRIBUTE 112 2,34,2,66
         PAINTCANVAS ATTRIBUTE 127 14,34,14,66
         PAINTCANVAS ATTRIBUTE 112 2,34,14,34
         PAINTCANVAS ATTRIBUTE 127 2,66,14,66
         ; PaintPAL_Frame_End

         ; PaintPAL_Static_Text_Begin
         PAINTCANVAS FILL " " ATTRIBUTE 112 1,3,1,8
         @1,3
         ?? "Forums"
         PAINTCANVAS ATTRIBUTE 112 1,3,1,8
         ; PaintPAL_Static_Text_End

         ; PaintPAL_Static_Text_Begin
         PAINTCANVAS FILL " " ATTRIBUTE 112 1,36,1,43
         @1,36
         ?? "Sections"
         PAINTCANVAS ATTRIBUTE 112 1,36,1,43
         ; PaintPAL_Static_Text_End

         PICKDYNARRAY @3,2 HEIGHT 11 WIDTH 28
            FORUMS.Y
            TAG "showTag"
            TO SHOWINDEX.A

         PICKDYNARRAY @3,35 HEIGHT 11 WIDTH 30
            SHOWSECT.Y
            TAG "charTag"
            TO SHOWSECTINDEX.A

         ACCEPT @17,3 WIDTH 12
         "D"
         TAG "SdateTag"
         TO SDATE

         LABEL @16,2
            "Start Date:"
            FOR "SdateTag"

         ACCEPT @17,18 WIDTH 12
         "D"
         TAG "EdateTag"
         TO EDATE

         LABEL @16,17
            "End Date:"
            FOR "EdateTag"

         PUSHBUTTON @16,33 WIDTH 10
            "~O~K"
            OK
            DEFAULT
            VALUE ""
            TAG "okTag"
            TO OKCANCEL

         PUSHBUTTON @16,45 WIDTH 8
            "~H~elp"
            VALUE HELPMEDLG(4)
            TAG "HelpTag"
            TO HELPME.A

         PUSHBUTTON @16,55 WIDTH 10
            "~C~ancel"
            CANCEL
            VALUE ""
            TAG "cancelTag"
            TO OKCANCEL
      ENDDIALOG

      ; PaintPAL_Generated_Code_End(453200107)
      IF RETVAL THEN
         ATF=SEARCH("|",SHOWSECTINDEX.A)
         FM=SUBSTR(SHOWSECTINDEX.A,1,(ATF-1)) ; name of forum chosen
         REC=NUMVAL(SUBSTR(SHOWSECTINDEX.A,(ATF+1),LEN(SHOWSECTINDEX.A)-ATF))
         SAVEVARS ALL
         VIEW "CatSec2"
         MOVETO RECORD(REC)
         LB=SUBSTR([library],2,LEN([library]))
         LB=".."+LB+".."
         CLEARALL

         QUERYFORCAT()

         IF NRECORDS("Answer") >= 1 THEN
            EMPTY "QueryCat"
            ADD "Answer" "QueryCat"
            CLEARALL
            CLEARMESSAGE.U()
         ELSE
            CLEARALL
            OK.U("So Sorry", "No Records Found..." , TRUE,TRUE)
         ENDIF
      ELSE
         RETURN "Cancel"
      ENDIF
   ELSE
      CLEARALL
      OK.U("So Sorry", "No Records Found..." , TRUE,TRUE)
   ENDIF
   CLEARALL
   CLEARMESSAGE.U()
   RELEASE VARS FM, LB, PICKRB, SHOWSECTINDEX.A, FORUMS.Y, ALLSELECT.Y, SHOWSELECT.Y
ENDPROC
WRITELIB LIBNAME GETCATSECT
RELEASE PROCS GETCATSECT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetCatSect" )


;**********************************************************************
;(c) Copyright 1993, Blue Pearl Software, Mountain View, CA

;You may use this code for any purpose as long as it is not sold or
;included in any software toolkit with other tools and as long as
;the copyright notice is not removed.

;Enjoy... David Gassner, CIS:72077,2207; Tel: (415) 968-0545
;**********************************************************************

PROC MARKARRAY(LISTARRAY,CHOICES,DESC)
   PRIVATE  NULLVAR, ;Null variable - target for button values
            CHOICE ;Current Choice from Dialog Box

   FOREACH CHOICE IN LISTARRAY ;Format array with Mark characters
      IF ISASSIGNED(CHOICES[Choice]) THEN
         LISTARRAY[Choice] = FORMAT("W44",LISTARRAY[Choice]) + CHR(251)
      ELSE
         LISTARRAY[Choice] = SUBSTR(LISTARRAY[Choice],1,44)
      ENDIF
   ENDFOREACH

   RELEASE VARS CHOICE ;Clear Choice, reset cursor location
   ;to top of List
   ; PaintPAL_Generated_Code_Begin(453213130)

   NULLVAR = "Cancel"

   SHOWDIALOG
      "Select " +DESC ; D:\CIS\GETSUB.DLG
      PROC "MarkArrayProc"
      TRIGGER "SELECT" , "ACCEPT"

      @2,13 HEIGHT 20 WIDTH 54

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,0 TO 17,51
      PAINTCANVAS ATTRIBUTE 112 0,0,0,51
      PAINTCANVAS ATTRIBUTE 127 17,0,17,51
      PAINTCANVAS ATTRIBUTE 112 0,0,17,0
      PAINTCANVAS ATTRIBUTE 127 0,51,17,51
      ; PaintPAL_Frame_End

      @12,11
      ?? STRVAL(DYNARRAYSIZE(CHOICES))+" Record"+IIF(DYNARRAYSIZE(CHOICES)=1,"","s")+" Selected"

      PICKDYNARRAY @2,2 HEIGHT 10 WIDTH 47
         LISTARRAY
         TAG "Picklist"
         TO CHOICE

      LABEL @1,5
         "Mark ~S~ubjects w/SpaceBar Mouse or Button"
         FOR "Picklist"

      PUSHBUTTON @13,3 WIDTH 20
         "~M~ark/Unmark"
         OK
         DEFAULT
         VALUE "Select"
         TAG "Select"
         TO NULLVAR

      PUSHBUTTON @15,3 WIDTH 24
         "Mark/Unmark ~A~ll"
         OK
         VALUE "MarkAll"
         TAG "MarkAll"
         TO NULLVAR

      PUSHBUTTON @13,29 WIDTH 20
         "~F~inished"
         CANCEL
         VALUE "Finished"
         TAG "Finished"
         TO NULLVAR

      PUSHBUTTON @15,33 WIDTH 8
         "~H~elp"
         VALUE HELPMEDLG(5)
         TAG "OkBtn"
         TO HELPME.A
   ENDDIALOG

   IF NULLVAR = "Finished" THEN
      RETURN "OK"
   ELSE
      RETURN "Esc"
   ENDIF

   ; PaintPAL_Generated_Code_End(453213130)
ENDPROC
WRITELIB LIBNAME MARKARRAY
RELEASE PROCS MARKAARRAY
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "MarkArray" )

;**********************************************************************
;(c) Copyright 1993, Blue Pearl Software, Mountain View, CA

;You may use this code for any purpose as long as it is not sold or
;included in any software toolkit with other tools and as long as
;the copyright notice is not removed.

;Enjoy... David Gassner, CIS:72077,2207; Tel: (415) 968-0545
;**********************************************************************
;**********************************************************************
PROC MARKARRAYPROC(TRIGGERTYPE,ELEMENT,EVENTINFO,NA)
   PRIVATE  THISCHOICE

   IF TRIGGERTYPE = "SELECT" OR ;Double-Click, Spacebar or Mark button
   ELEMENT = "Select" THEN ;causes Mark/Unmark action

      IF ISASSIGNED(CHOICES[Choice]) THEN ;Unmark if Marked
         LISTARRAY[Choice] = SUBSTR(LISTARRAY[Choice],1,44)
         RELEASE VARS CHOICES[Choice]
      ELSE ;Mark if Unmarked
         LISTARRAY[Choice] = FORMAT("W44",LISTARRAY[Choice]) + CHR(251)
         CHOICES[Choice] = TRUE
      ENDIF

   ELSE ;MarkAll Button has been pressed

      IF DYNARRAYSIZE(CHOICES) = 0 THEN ;Mark All Records
         FOREACH THISCHOICE IN LISTARRAY
            LISTARRAY[Thischoice] = FORMAT("W44",LISTARRAY[Thischoice]) + CHR(251)
            CHOICES[Thischoice] = TRUE
         ENDFOREACH
      ELSE
         FOREACH THISCHOICE IN LISTARRAY ;Unmark All Records
            LISTARRAY[Thischoice] = SUBSTR(LISTARRAY[Thischoice],1,44)
            RELEASE VARS CHOICES[Thischoice]
         ENDFOREACH
      ENDIF
   ENDIF

   REFRESHCONTROL "Picklist"
   RESYNCDIALOG
   SELECTCONTROL "Picklist"

   RETURN FALSE ;Deny Accept or Select trigger

ENDPROC
WRITELIB LIBNAME MARKARRAYPROC
RELEASE PROCS MARKAARRAYPROC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "MarkArrayProc" )


