;*************************************************************************
; Script Listing
; Date : 12/05/91
;
; By : K.C. Stroud
; Last modified 12/05/91  09:37:18 pm
; Copyright (c) 1991  Paladin Enterprises
;*************************************************************************
; This procedure is used to increment or decrement a date field. It   
; duplicates the functionality of Quicken (c) date fields, where if   
; you press + or -, the date is incremented or decremented.           
; 
; This is how to use this procedure:
;
;   WAIT TABLE
;     PROMPT "Editing table "+TABLE(),
;            "Press [F2] to exit"
;     UNTIL "F2",       ; Post record
;           "+",        ; Call ChangeDate()
;           "-"         ; Call ChangeDate()
;     SWITCH
;       CASE RETVAL = "F2":                 ;This is a very simple example 
;         DO_IT!                            ;to illistrate how the 
;         RETURN TRUE                       ;ChangeDate() procedure is
;       CASE RETVAL = "+" OR RETVAL = "-"   ;called.
;         Direction = RETVAL
;         ChangeDate(Direction)
;     ENDSWITCH
;************************************************************************

Proc ChangeDate(Direction)
    Private
    TypeOfField    ; What type of field are we in?
    
    TypeOfField = FieldType()       ;Check to see if we are in a date field.
    If Not TypeOfField = "D" Then
        Beep
        Message "This key only works in date fields"
        Sleep 1000
        Return
    EndIf
    
    If IsBlank([]) Then             ;Check to see if the field contains a
        [] = Today()                ;date, if not make it todays date.
        Return
    EndIf
    
    If Direction = "+" Then         ;Manipulate date.
        [] = [] + 1
    Else
        [] = [] - 1
    EndIf
    
    Return
    
EndProc
