; CHECKS.SC Sample auto-numbering check register w/running balance
; Author - Ward Dorrity, ANSA Tech Support


; This script deals in a primitive way with the classic running balance
; check register problem.  The auto-numbering routine provides check numbers
; starting at 1000.  For tax and accounting purposes, you may wish to add an
; account number field (referenced to a lookup table) and an account des-
; cription field where the description is read in on table lookup.  The
; lookup table would consist of nothing more than the account numbers
; themselves and a short description of each.

; The two procs ADDEM() and BALANCE_FORWARD() do most of the work.  The
; main part of the script, i.e., the part that initiates all of the action
; can be found at the bottom of all of the proc declarations.  Check it out
; and follow the flow of logic through the model.


; There is no provision to prompt the user for a beginning balance amount.
; It is a simple matter to test for a value in this column of the CHECKS
; table, prompt the user for a beginning balance, and enter the value
; in the first record.  Likewise, no provision is made for service charges
; or other miscellaneous charges against the account, nor is a provision
; made for multiple accounts.  You are bound to enjoy inventing these
; facilities for yourself, as it only requires an extention of the logic
; and techniques employed here.  No doubt this whole thing could be more
; elegant - I leave that to you.


PROC running_balance()

SWITCH

   CASE isblank([Deposit:]) AND isblank([Amount:]):  ; No entries -
        bal = [Balance:]                             ; stand pat

   CASE not isblank([Deposit:]) AND not isblank([Amount:]):
        [Balance:] = (bal + [Deposit:]) - [Amount:] ; Compute current balance
        bal = [Balance:] ; Reassign value of current balance to BAL variable

   CASE isblank([Amount:]) AND not isblank([Deposit:]):
        [Balance:] = bal + [Deposit:] ; Compute current balance
        bal = [Balance:] ; Reassign value of current balance to BAL variable

   CASE isblank([Deposit:]) AND not isblank([Amount:]):
        [Balance:] = bal - [Amount:]  ; Compute current balance
        bal = [Balance:] ; Reassign value of current balance to BAL variable


ENDSWITCH

ENDPROC


PROC addem()        ; This procedure will set up the necessary wait loop
                    ; and conditional testing for data entry.  Note the
    WHILE (true)    ; routine under the CASE RETVAL="PGDN": statement. This
                    ; is what increments the check number field and maintains
        WAIT RECORD ; the running balance.  This could also be a proc.
            PROMPT "PRESS F2 WHEN DONE, PGDN TO ENTER ANOTHER CHECK, ESC to QUIT"
        UNTIL  "F2","ESC","PGDN"

        SWITCH

            CASE RETVAL="F2":
                if isblank([Deposit:]) AND isblank([Amount:]) then
                   running_balance()
                   Del                   ; Make sure that we don't leave a blank
                else                     ; record with a check number behind.
                   running_balance()
                endif

                Do_It!
                ClearAll
                QUITLOOP


            CASE RETVAL="PGDN":

                running_balance()   ; compute the new balance

                x = [Check #:]      ; Pick up the check number.
                Down                ; Append a new record.
                [Check #:] = x + 1  ; Bump up the check number.
                MOVETO [Paid to:]   ; Start data entry here.
                LOOP                ; Return to the Wait Record state.

            CASE RETVAL="ESC":
                CANCELEDIT  ; Cancel and remove all entries made in this
                ClearAll    ; session.
                QUITLOOP    ; Drop out of the While-Endwhile loop.

        ENDSWITCH

    ENDWHILE

ENDPROC


; Main Script Section  - Initiates the action and calls the procs defined
;                        earlier.


y = "CHECKS" ; Assign the table name to a variable - less to write later.

IF ISEMPTY(y) THEN           ; Here, we test to see if the table is empty
    EDIT y                   ; before we go into the wait loop.  An empty
    [Check #:] = 1000        ; check register must be started with a beginning
    MOVETO [Paid to:]        ; check number.  In this case, the starting
    addem()                  ; number is 1000.

ELSE

    EDIT y                          ; If we already have records in the table,
    x = CMAX("CHECKS","CHECK #:")   ; then this routine will pick up the last
    End                             ; check number, add 1 to it for a new check
    bal = [Balance:]                ; check number, assign an initial value to
                                    ; the BAL variable.
    Down                            ; Append a new record.
    [Check #:] = x + 1              ; Enter the new check number.
    addem()                         ; Call the addem proc.

ENDIF

release vars all  ; House keeping - release all variables and
release procs all ; release all procs.

QUIT ; Return to Paradox Main mode.
