; PopMenu.sc
;
; Copyright (c) 1987-1989 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  MJP 5/20/87, DCY 12/15/88
; ****************************************************************************
; This procedure creates and fills the arrays POPUPLIST, POPUPSTART, POPUPLEN,
; and POPUPNUMBER, with information from (and about) the specified tables.
; These arrays are then used by the procedure Popup to cause a popup menu to
; be created.  The procedure also reads in the Popup procedures themselves.
;
; This procedure must be called once before the Popup procedure is invoked
; (generally at the beginning of the main program) while sysmode()="Main".  It
; is called by executing the command:  SetPopup(Tables), where Tables is a
; string in the form:
;                      Table1, Table2, ... , TableN   (N<=10)
;
; The information in each of the tables specified by "Tables" will be used to
; define a seperate pop-up menu.  NOTE:  If the information in the tables is
; static (not subject to change), then the need to call this procedure at run-
; time may be eliminated.  To do this, simply call this procedure once, and
; follow the procedure call with the command:  SAVEVARS POPUPLIST,POPUPSTART,
; POPUPLEN,POPUPNUMBER.  Then simply read in the values of these arrays into
; your program.  Last, remember to read in the procedures Popup, PopDraw, and
; PopRedraw from the toolkit library.
;
; [1.01]  Allow Context sensitive search of the list by pressing 1st char of
;         selection.  Search will roll around end of list back to top.
;         NOTE: PopSearch proc behaves just like Release 2 version, but has
;         been modified to use new screen command.     SBF
;
; Changes made by Ken Rea (c) 1990
; Can be used in any form as long as user keeps notice intact.
; Author does not assume any legal responsibility for this script.
;

AppLib = "PopMenu"
Createlib AppLib


Proc SetPopup(Tables)
   Private;Tables,            ;List of tables for which to define popup menus
           TempName,          ;Array which stores the names of each table
           NumMenus,          ;Number of tables specified in "Tables" arg.
           NumItems,          ;Number of items in current table
           CurrTable,         ;Current table being looked at
           X                  ;Loop index
   Array TempName[10]
   Array PopupStart[10]       ;Stores pointer to beginning of item list
   Array PopupNumber[10]      ;Stores number of items in menu list
   Array PopupLen[10]         ;Stores length of longest menu choice
   NumMenus=0
   NumItems=0
   Tables=Tables+","
   While match(Tables,"..,..",CurrTable,Tables)    ;Process each table name
      If not istable(CurrTable)
         Then Quit "Table "+CurrTable+" does not exist."
      Endif
      NumMenus=NumMenus+1                          ;Update which menu this is
      TempName[NumMenus]=CurrTable
      PopupStart[NumMenus]=NumItems               ;NumItems is a running total
      NumItems=NumItems+nrecords(CurrTable)
   Endwhile
   If NumItems<>0
      Then Array PopupList[NumItems]  ;Stores all line items from data tables
   Endif
   For X from 1 to NumMenus
      If isempty(TempName[X])
         Then PopupNumber[X]=0
         Else View TempName[X]
              Right
              PopupNumber[X]=0
              PopupLen[X]=0
              Scan
                 PopupLen[X]=max(PopupLen[X],len([])+4)      ;Update max width
                 PopupNumber[X]=PopupNumber[X]+1
                 PopupList[PopupNumber[X]+PopupStart[X]]=[]  ;Store line item
              Endscan
              PopupLen[X]=max(PopupLen[X],10)
              ClearImage
      Endif
   Endfor
Endproc

WriteLib AppLib SetPopup
Release Procs SetPopup



; This procedure creates a pop-up window.  It is intended to be used during
; data entry (or edit), but can be used in virtually any mode.
;
; Within the popup window are menu choices which can be selected by moving the
; cursor using Up, Down, PgUp, PgDn, Home, and End.  The information for the
; procedure is contained in four array variables (PopupList, PopupStart,
; PopupLen, and PopupNumber) which are set by the SetPopup procedure.
;
; Popup takes the following arguments:
;   R--   Row position of the upper left corner where menu is to be drawn.
;   C--   Column position of the upper left corner where menu is to be drawn.
;   Num-- Number of pop-up menu.  This corresponds to the position of the
;         table name in the arguement passed to the SetPopup procedure.  (For
;         example, if we say:  SetPopup("x,y,z"), then to create a menu
;         with information from the table "y" we say:  Popup(R,C,2,Size).)
;   Size- Vertical size of the menu.  This is the number of selections that
;         will be displayed at one time.  Choices will scroll up and down to
;         reveal other choices.  It is recommended that 8088-class computers
;         only provide menus with as many choices as will fit on the screen,
;         and set Size equal to 9999 to disable scrolling.
;

Proc Popup(R, C, Num, Size, Title, Flag)
   Private;R,       ;Row position of popup window
          ;C,       ;Column position of popup window
          ;Num,     ;Popup menu number
          ;Size,    ;Number of choices to be displayed at one time
           Char,    ;Last key that was pressed
           MenuPos, ;Current position within menu
           Choice,  ;Current menu selection
           X,       ;Counter
           Title,   ;Title line for menu
           Flag     ;Used with a 1 or 2, to kick out of menu with a Right or
                    ;Left arrow (respectivly), will return a FALSE. Else will
                    ;beep.

   setswap 20000

   If PopupNumber[Num]=0
      Then Return ""
   Endif
   If Size>PopupNumber[Num]
      Then Size=PopupNumber[Num]
   Endif
   Echo Off
   Cursor Off
   @0,0
   Clear Eol
   @1,0
   Clear Eol
   @0,5
   ?? "Highlight the appropriate selection using the cursor movement keys."
   @1,10
   ?? "Press [Enter] to accept, [Esc] to cancel menu selection."
   ;Draw menu box
   Canvas Off
   SetMargin C
   TitleLen = Len(Title)
   style intense
   @ R-1, C+(Int((PopupLen[Num]/2)-(TitleLen/2))) ?? Title
   style
   @R,C
   ?? "",fill("",PopupLen[Num]-2),""
   ? " CHOOSE:",spaces(PopupLen[Num]-10),""
   ? "",fill("",PopupLen[Num]-2),""
   For X from 1 to Size
      ? " ",substr(strval(PopupList[PopupStart[Num]+X])+
             spaces(PopupLen[Num]),1,PopupLen[Num]-3),""
   Endfor
   ?  "",fill("",PopupLen[Num]-2),""
   SetMargin Off
   If Size<>PopupNumber[Num]      ;Is there more data that can't be displayed?
      Then @R+2+Size,C+1
           ?? ""                 ;Show that more items exist below
   Endif
   Canvas On
   MenuPos=1
   Choice=1
   While True
      Style Reverse               ;Highlight current selection
      PopDraw()
      Style
      Char=getchar()
      Switch
         Case Char=-72:                         ;Key was [Up]
            If Choice=1                         ;Are we already at the top?
               Then Beep
              Else If MenuPos>1                ;Can we move within the menu?
                       Then PopDraw()           ; Yes- Blank current selection
                            MenuPos=MenuPos-1   ;      Move window position
                       Else PopRedraw(Choice-2) ; No-  Redraw entire menu
                    Endif
                    Choice=Choice-1             ;Select new choice
            Endif

         Case Char=-80:                         ;Key was [Down]
            If Choice=PopupNumber[Num]          ;Are we already at the bottom?
               Then Beep
              Else If MenuPos<Size             ;Can we move within the menu?
                       Then PopDraw()           ; Yes- Blank current selection
                            MenuPos=MenuPos+1   ;      Move window position
                       Else PopRedraw(Choice-Size+1); No-  Redraw entire menu
                    Endif
                    Choice=Choice+1             ;Select new choice
            Endif

         Case Char=-71:                         ;Key was [Home]
            If MenuPos=Choice                   ;Is first selection on screen?
               Then PopDraw()                   ; Yes- Blank current selection
              Else PopRedraw(0)                ; No-  Redraw menu from start
            Endif
            MenuPos=1                           ;Position at first item
            Choice=1                            ;Select first item

         Case Char=-79:                         ;Key was [End]
            If Choice+Size-MenuPos=PopupNumber[Num];Last selection on screen?
               Then PopDraw()                   ; Yes- Blank current selection
              Else PopRedraw(PopupNumber[Num]-Size); No-  Redraw end of menu
            Endif
            MenuPos=Size                        ;Position at bottom of menu
            Choice=PopupNumber[Num]             ;Select last item

         Case Char=-73:                         ;Key was [PgUp]
            If MenuPos=Choice                   ;Are we within first screen?
               Then Beep                        ; Yes- Disallow PgUp
              Else If Choice-MenuPos-Size>0
                       Then Choice=Choice-MenuPos-Size+1
                       Else Choice=1
                    Endif
                    PopRedraw(Choice-1)         ; No-  Redraw previous page
                    MenuPos=1                   ;   Position on that item
            Endif

         Case Char=-81:                         ;Key was [PgDn]
            If Choice+Size-MenuPos=PopupNumber[Num];Are we within last screen?
               Then Beep                           ; Yes- Disallow PgDn
              Else If PopupNumber[Num]-Size<Choice+Size-MenuPos
                       Then Choice=PopupNumber[Num]-Size+1
                       Else Choice=Choice+Size-MenuPos+1
                    Endif
                    PopRedraw(Choice-1)            ; No- Redraw next page
                    MenuPos=1                      ;     Position on that item
            Endif

         Case Char=13:                          ;Key was [Enter]
            Cursor Normal
            Return PopupList[PopupStart[Num]+Choice]       ;Return selection

         Case Char=27:                          ;Key was [Esc]
            Cursor Normal
            Return "Esc"

         Case Char=-75:                          ;Key was Right arrow
           if Flag = 1 then
             Cursor Normal
             Return False
           endif
           beep

         Case Char=-77:                          ;Key was Left arrow
           if Flag = 2 then
             Cursor Normal
             Return False
           endif
           beep

         Otherwise:                             ;Illegal key
 ;          Beep
            EscEnter = Popsearch(Char)          ; [1.01] search for entry
              if (EscEnter) then                ; beginning with char
                Cursor Normal
                Return PopupList[PopupStart[Num]+Choice]       ;Return selection
              endif

      Endswitch
   Endwhile

Endproc

WriteLib AppLib Popup
Release Procs Popup


; This procedure is used by the Popup procedure.  It positions the cursor and
; redraws current menu item (in either inverse or normal text).
;
;
Proc PopDraw()
   @MenuPos+R+2,C+2
   ?? PopupList[PopupStart[Num]+Choice]

Endproc

WriteLib AppLib PopDraw
Release Procs PopDraw


; This procedure is used by the PopUp procedure.  It redraws the entire
; contents of the popup window.
;
Proc PopRedraw(Start)
;Private Start           ;Location within PopupList to begin redraw
   Canvas Off
   SetMargin C+2
   @ R+2,C+2
   For Z from 1 to Size            ;Redraw all information in the menu box
      ? substr(strval(PopupList[PopupStart[Num]+Start+Z])+
        spaces(PopupLen[Num]),1,PopupLen[Num]-3)
   Endfor
   SetMargin Off
   @R+3,C+1
   If Start=0          ;Are there records above?
      Then ?? " "      ; No- Remove up arrow
      Else ?? ""      ; Yes- Place up arrow to signify more records
   Endif
   @R+Size+2,C+1
   If Start+Size=PopupNumber[Num]  ;Are there records below?
      Then ?? " "                  ; No- Remove down arrow
      Else ?? ""                  ; Yes- Place down arrow to signify more
   Endif
   Canvas On

Endproc

WriteLib AppLib PopRedraw
Release Procs PopRedraw


;
; This procedure is used by the PopUp procedure.  It searches the list of menu
; option for a selection beginning with the symbol pressed.
;
Proc PopSearch(Char)
Private ;Char            ;Character that was pressed as a key press code
   Uchr,                 ;The character converted to a 1 char string
   Z,                    ;Counter
   Posn,                 ;Posion of the 1st menu option matching the key pressed
   counter               ;Counter for # of times found

  If Char < 32               ;Is Char a normal ASCII Character?
     Then Beep                ;No
     Return FALSE
    Else Uchr = Upper(Chr(Char)) ;Yes convert to an 'A1' String
  Endif

  Posn = 0                   ;Posn set to 0 to indicate not found
  counter = 0                ;Counter for # of times found set to 0

  For Z from (choice+1) to PopupNumber[num]  ;Search option below this one
    If Uchr = Upper(Substr(PopupList[PopupStart[Num]+Z],1,1))
      Then
      counter = counter + 1
       if counter = 1 then
        Posn = Z
       endif
       if counter > 1 then
         Quitloop
       endif
    Endif
  Endfor

  If counter < 2 Then           ;If match not found,
    For Z from 1 to choice   ;Search options above this one
      If Uchr = Upper(Substr(PopupList[PopupStart[Num]+Z],1,1))
        Then
         counter = counter + 1
         if counter = 1 then
           Posn = Z
         endif
         if counter > 1 then
           Quitloop
         endif

      Endif
    Endfor
  Endif

  If Posn = 0                ;Still not found?
    Then Beep                ;Invalid key
         Return FALSE
  Endif                      ;Posn is option that matches-determin how to redraw
  Switch
    Case (Posn > Choice) and ((Posn - Choice) <=
         (Size - MenuPos))   :         ;Option is on the menu
            PopDraw()                  ;Remove current highlight
            MenuPos = MenuPos + Posn - Choice
            Choice  = Posn             ;New option and position on the menu
            Style Reverse
            PopDraw()                  ;Highlight new option
            Style

    Case (Posn > Choice) and           ;Option is below Menu and more options
         (PopupNumber[num]-Posn>=Size):;than the menu's size are below
            PopRedraw(Posn-1)          ;Redraw at the selected option
            Choice  = Posn
            MenuPos = 1

    Case (Posn > Choice)   :           ;Option is below Menu, less options
                                       ;than the menu's size are below
            PopRedraw(PopupNumber[num]-Size) ;Redraw as if End key were pressed
            Choice  = Posn
            MenuPos = Posn - PopupNumber[num]+ Size
                                       ; Match appears above the current option

    Case (Choice - Posn) < MenuPos :   ;Option is on the menu
            PopDraw()                  ;Remove current highlight
            MenuPos = MenuPos - Choice + Posn
            Choice  = Posn             ;New option and position on the menu
            Style Reverse
            PopDraw()                  ;Highlight new option
            Style

    Case (Posn > Size)               : ;Option is above Menu and more options
            PopRedraw(Posn-1)          ;than the menu's size are above match
            Choice  = Posn
            MenuPos = 1

    Otherwise                        : ;Option is on 1st menu
            PopRedraw(0)               ;Draw from top
            Choice  = Posn
            MenuPos = Posn

   EndSwitch

   if counter > 1 then
    return FALSE
   endif

   if size < PopupNumber[Num] then
     return FALSE
   endif

 return TRUE

EndProc

WriteLib AppLib PopSearch
Release Procs PopSearch

; End of script