#include <windows.h>
#include <goto.hpp>
#pragma hdrstop

//
//  Definition of exported functions
//
 
#define EXPPLUS  _pascal _loadds _export

 


//
// Normal Libmain and WEP. 
//
 
HANDLE hMod = 0;
 
#pragma argsused
int EXPPLUS LibMain
    (
   HANDLE   hModule,
   WORD     wDataSeg,
   WORD     cbHeapSize,
   LPSTR    lpszCmdLine
)
{
   hMod = hModule;
   return TRUE;
}
 
#pragma argsused
int EXPPLUS WEP(int bSystemExit )
{
   return 1;
}
 
 

//
// Main stuff
//

//
// lineToGoTo is a global variable that is return. Note this is
// the simple way of returning arguments. It will not work for 
// MultiInstance applications. But it shows the very basics of
// how to call a dialog box.
//

 
int lineToGoTo = 0;

//
// GotoLineDlgProc is the main rountine for handling the dialog box.
//
 
#pragma argsused
int EXPPLUS  GotoLineDlgProc
    (
   HWND   hDlg,
   WORD   msg,
   WPARAM wParam,
   LPARAM lParam
)
{
   int success = FALSE;
 
   switch(msg)
      {
      case WM_INITDIALOG:
			lineToGoTo = -1;
         return(TRUE);

      case WM_COMMAND:
         {
         switch(wParam)
            {
            case IDOK:
               lineToGoTo = GetDlgItemInt(hDlg, ID_LINE, &success, FALSE);
               EndDialog(hDlg, TRUE);
               return TRUE;
 
            case IDCANCEL:
               EndDialog(hDlg, FALSE);
               return(TRUE);
            }
         break;
         }
 
      }
   return(FALSE);
}
 


// 
// gotoDialog the procedure that is called by ObjectPal to show the
// dialog.
//
//   USES  GOTO
//      GotoDialog(hWnd CWORD) CWORD
//   ENDUSES
//
//   METHOD SomeObjectPalMethod()
//       var lineNo SmallInt endvar
//       lineNo = GotoDialog(windowHandle())
//       .. do something with lineNo
//   ENDMETHOD
//
//
//  The extern "C" is very important. It tells the C++ compiler
//  not to do the normal name mangling
//

extern "C" int EXPPLUS gotoDialog(HWND hWnd)
{
   FARPROC lpProc = (FARPROC) MakeProcInstance( (FARPROC)GotoLineDlgProc, hMod);
   DialogBoxParam(hMod, "GotoLine", hWnd, lpProc, 0);
   FreeProcInstance(lpProc);
   return lineToGoTo;
}
 
 
