Clear
Release Vars ALL

Message "Loading..."
Sleep 1000

If NOT IsTable("Calendar") Then
   Message "Cannot locate Calendar table. Press any key to leave script."
   n = GetChar()
   Return
EndIf

If NOT IsTable("Orders") Then
   Message "Cannot locate Orders table. Press any key to leave script."
   n = GetChar()
   Return
EndIf

If NOT IsTable("Help") Then
   Message "Cannot locate Help table. Press any key to leave script."
   n = GetChar()
   Return
EndIf

If NRecords("Calendar") < 12 Then
   Play "CFill"
Endif

PROC CalHelp()                            ; Called by pressing F1

     Cursor OFF
     If Table() <> "Help" Then
        MoveTo "Help"
     Else
        Home
        MoveTo "Orders"
     EndIf

ENDPROC

PROC Toggle()                             ; Called by pressing F3

     Cursor OFF
     If Table() = "Help" Then
        Beep
        Return
     EndIf
     If Table() = "Orders" Then
        MoveTo "Calendar"
        If lastkey = "F3" Then
           MoveTo Field todayfld          ; Put cursor on current date
        Else
           MoveTo Field fldname           ; Put cursor on last cal field
        EndIf
     Else
        MoveTo Record recmarker           ; Re-indexes calendar to
        lastkey = "F3"                    ; current month (optional).
        MoveTo "Orders"
     EndIf

ENDPROC

PROC LockCal()                            ; Called by pressing F4

     Cursor OFF                           ; Returns to Orders table
     If Table() = "Calendar" Then         ; and leaves current cal image
        fldname = Field()
        lastkey = "F4"
        MoveTo "Orders"
     Else
        Beep
     EndIf

ENDPROC

PROC UseDate()                            ; Called by pressing F5

     Cursor OFF
     If Table() = "Calendar" Then
        If Field() <> "Year" AND Field() <> "Month"
           AND Not IsBlank([]) Then
           orderday = []                  ; Get value for date
           ordermonth = [No]
           orderyear = StrVal([Year])
           datevar = DateVal(ordermonth + "/" + orderday + "/" + orderyear)
           fldname = Field()
           lastkey = "F4"
           Cursor OFF
           MoveTo [Orders->Contact Date]
           If IsBlank([]) Then
              [] = datevar                ; Put date into Orders table
           Else
              Beep                        ; Non-date warning
              Message "Contact Date field must be blank (press any key)"
              n = GetChar()
           EndIf
           Cursor NORMAL
        Else
           Beep
        EndIf
     Else
        Beep
     EndIf

ENDPROC

curday   = Day(Today())                    ; Get current day
curmonth = Moy(Today())                    ; Get current month
curyear  = Year(Today())                   ; Get current year
lastkey  = "F3"                            ; Initialize variable

View "Calendar"                            ; Locate mm/dd/yy record

MoveTo [Year]
Locate curyear                             ; Locate current year
While Substr([Month], 1,3) <>  curmonth
      Down                                 ; Locate current month
EndWhile
recmarker = RecNo()                        ; Set record marker
                                           ; for use with F4
While Strval(curday) <> []
      Right                                ; Locate current day
EndWhile
todayfld = Field()                         ; Set field for current day

Edit "Orders"
FormKey

While True

      line_1 = Format("W80,AC", " Editing Orders Table ")
      line_2 = Format("W80,AC", "Calendar Demo")

      Wait Table
      Prompt line_1,
             line_2

      Until "F1", "F2", "F3", "F4", "F5", "Esc"

      Switch
      Case retval = "F1"  : CalHelp()
      Case retval = "F2"  : Cursor OFF
                            DO_IT!
                            Message "Saving entries"
                            Sleep 1000
                            QuitLoop
      Case retval = "F3"  : Toggle()
      Case retval = "F4"  : LockCal()
      Case retval = "F5"  : UseDate()
      Case retval = "Esc" : Cursor OFF
                            CancelEdit
                            Message "Canceling changes"
                            Sleep 1000
                            QuitLoop
      EndSwitch

EndWhile
ClearAll
Clear
