;---------------------------------------------------------------------
;   Script: CFill
; Function: Fills Calendar table with date ranges
;   Author: Rick Paulson, CIS ID 70540,702
;     Date: April 23, 1993
;---------------------------------------------------------------------
Clear
Release Vars ALL

PROC GetYears()   ; Get range variables for Calendar table

     Clear
     @ 0,0
     ?? "Enter begining year for Calendar table: "
     Style Attribute 116
     @ 0,40
     Accept "S" Min 1000 Picture "####" Required
     To startyear

     If retval = False Then
        Quit
     EndIf

     Style
     @ 1,0
     ?? "Enter ending year for Calendar table: "
     Style Attribute 116
     @ 1,40
     Accept "S" Min 1000 Required
     To endyear

     If retval = False Then
        Quit
     EndIf
     Style

ENDPROC

PROC FillCal(mm,yy)  ; Fill table with calendar info

     Switch          ; Set variables for each month
     Case mm = 1  :  numdays = 31      ; number of days in JAN
                     monthstr = "January"
                     monthnum = "1"

     Case mm = 2  :  If Mod(y,4) = 0 Then
                        numdays = 29   ; number of days for leap year
                     Else
                        numdays = 28   ; number of days in FEB
                     EndIf
                     monthstr = "February"
                     monthnum = "2"

     Case mm = 3  :  numdays = 31      ; number of days in MAR
                     monthstr = "March"
                     monthnum = "3"

     Case mm = 4  :  numdays = 30      ; number of days in APR
                     monthstr = "April"
                     monthnum = "4"

     Case mm = 5  :  numdays = 31      ; number of days in MAY
                     monthstr = "May"
                     monthnum = "5"

     Case mm = 6  :  numdays = 30      ; number of days in JUN
                     monthstr = "June"
                     monthnum = "6"

     Case mm = 7  :  numdays = 31      ; number of days in JUL
                     monthstr = "July"
                     monthnum = "7"

     Case mm = 8  :  numdays = 31      ; number of days in AUG
                     monthstr = "August"
                     monthnum = "8"

     Case mm = 9  :  numdays = 30      ; number of days in SEP
                     monthstr = "September"
                     monthnum = "9"

     Case mm = 10 :  numdays = 31      ; number of days in OCT
                     monthstr = "October"
                     monthnum = "10"

     Case mm = 11 :  numdays = 30      ; number of days in NOV
                     monthstr = "November"
                     monthnum = "11"

     Case mm = 12 :  numdays = 31      ; number of days in DEC
                     monthstr = "December"
                     monthnum = "12"
     EndSwitch

     datevar = DateVal(Strval(mm) + "/1/" + Strval(yy))  ; Current month
     day_1 = DOW(datevar)  ; Day of week for 1st day of current month

     Switch   ; Locate cursor in 1st day field
     Case day_1 = "Sun" : MoveTo [Day 1]
     Case day_1 = "Mon" : MoveTo [Day 2]
     Case day_1 = "Tue" : MoveTo [Day 3]
     Case day_1 = "Wed" : MoveTo [Day 4]
     Case day_1 = "Thu" : MoveTo [Day 5]
     Case day_1 = "Fri" : MoveTo [Day 6]
     Case day_1 = "Sat" : MoveTo [Day 7]
     EndSwitch

     For n From 1 To numdays  ; Fill in dates for rest of current month
         [] = StrVal(n)
         Right
     EndFor

     [No]    = monthnum       ; Fill in month number (as a string)
     [Month] = monthstr       ; Fill in month name
     [Year]  = y              ; Fill in year number (as a number)

ENDPROC

Message "Verifying system date: " + StrVal(Today()) + " (press any key)"
n = GetChar()

If NOT IsTable("Calendar") Then
   Message "Cannot locate Calendar table. Press any key to leave script."
   n = GetChar()
   Return
EndIf

If NOT IsTable("Orders") Then
   Message "Cannot locate Orders table. Press any key to leave script."
   n = GetChar()
   Return
EndIf

GetYears()

Cursor OFF
Empty "Calendar"
Edit  "Calendar"

For y From startyear To endyear

    Message "Calculating dates for " + StrVal(y)
    For m From 1 To 12
        FillCal(m,y)
        Down
    EndFor

EndFor

Release Vars ALL
DO_IT!
ClearAll
