/* Copyright (c) 1991 Informant Communications Group.
 * All rights reserved.
 * Redistribution and use in source and binary forms are
 * freely permitted provided that the above copyright
 * notice and attribution are duplicated in all such forms.
 *
 * Source code for popup calendar article appearing in the
 * May 91 issue of the 'Paradox Informant'.
 *
 * Written in Turbo C, a product of Borland International
 */
  #include <stdlib.h>
  #include <conio.h>
  #include <dos.h>
  #include <bios.h>

  #define ESC   27
  #define UP   328
  #define LT   331
  #define RT   333
  #define DN   336

  /* global variables */
  int day,month,year,
      leap,weekday,
      end_date,mo,yr;

  /* the following arrays each contain
  /* two sets of data, one for a regular
  /* year and one for a leap year
  */
  int days_in_month[2][13]=
  {
    {0,31,28,31,30,31,30,31,31,30,31,30,31},
    {0,31,29,31,30,31,30,31,31,30,31,30,31},
  };

  int julian_day[2][14]=
  {
    {0,0,31,59,90,120,151,181,212,243,273,304,334,365},
    {0,0,31,60,91,121,152,182,213,244,274,305,335,366}
  };

  char month_name[13][4]=
  {
    "",
    "JAN","FEB","MAR","APR","MAY","JUN",
    "JUL","AUG","SEP","OCT","NOV","DEC",
  };

  /* storage for screen area saved before
  /* opening window; requires 2 bytes per
  /* character: 32 cols * 11 rows * 2
  */
  char win[704];

  struct text_info win_info;
  struct date today;

  union REGS regs;

  /* function prototypes */
  void calendar_month(void);
  void fill_in_month(void);
  void get_start_day(void);
  void show_cur(void);
  void hide_cur(void);
  int  getkey(void);
  void open_window(void);
  void close_window(void);
  void draw_border(void);

  void main(void)
  {
    /* get current month and year */
    getdate(&today);
    mo=today.da_mon;
    yr=today.da_year;

    /* turn the cursor off */
    hide_cur();

    /* display the calendar */
    calendar_month();

    /* turn the cursor back on before
    /* before exiting the program
    */
    show_cur();
  }

  void calendar_month(void)
  {
    int	c=0;

    open_window();
    draw_border();

    gotoxy(4,4);cputs("Su  Mo  Tu  We  Th  Fr  Sa");
    gotoxy(3,11);cprintf(" %c%c Month ",24,25);
    gotoxy(22,11);cprintf(" %c%c Year ",27,26);

    fill_in_month();

    while(c!=ESC)
    {
      c=getkey();
      switch(c)
      {
        case(UP):
          if(mo!=1)
          { 
            mo-=1;
          }
          else if(yr>1950)
          {
            mo=12;
            yr-=1;
          } 
          else
          {
           continue;
          }
          break;
        case(LT):
          if(yr>1950)
          {
            yr-=1;
          }
          else
          {
            continue;
          }
          break;
        case(RT):
          if(yr<2099)
          {
            yr+=1;
          }
          else
          {
            continue;
          }
          break;
        case(DN):
          if(mo!=12)
          {
            mo+=1;
          }
          else if(yr<2099)
          {
            mo=1;
            yr+=1;
          }
          else
          {
            continue;
          }
          break;
        case(ESC):
          close_window();
          return;
        default:
          putch('\a');
          continue;
      }
      fill_in_month();
    }
  }

  void fill_in_month(void)
  {
    register int i,j;
    static int k,first_line;
    static char blankline[]="                          ";

    gotoxy(4,2);cprintf("%s",month_name[mo]);
    gotoxy(26,2);cprintf("%4d",yr);

    get_start_day();
    first_line=8-weekday;

    gotoxy(4,5);cputs(blankline);
    gotoxy(4*weekday-2,5);
    for(i=1;i<=first_line;i++)
      cprintf("%4d",i);

    for(j=1;j<=(end_date-first_line)/7;j++)
    {
      gotoxy(2,j+5);
      for(i=i,k=i+6;i<=k;i++)
        cprintf("%4d",i);
    }

    gotoxy(4,10);cputs(blankline);
    gotoxy(4,j+5);cputs(blankline);
    if(i<=end_date)
    {
      gotoxy(2,j+5);
      for(i=i;i<=end_date;i++)
        cprintf("%4d",i);
    }
  }

  void get_start_day(void)
  {
    static int add_days;

    if((yr % 4)==0)
      leap=1;
    else
      leap=0;

    add_days=((yr-1949)/4)+yr-1950;
    weekday=((julian_day[leap][mo]+add_days) % 7)+1;

    end_date=days_in_month[leap][mo];
  }

  void show_cur(void)
  {
    regs.h.ch=6;
    regs.h.cl=7;
    regs.h.ah=1;
    int86(0x10,&regs,&regs);
  }

  void hide_cur(void)
  {
    regs.h.ch=15;
    regs.h.ah=1;
    int86(0x10,&regs,&regs);
  }

  int getkey(void)
  {
    static int key,hi,lo;

    key=bioskey(0);
    lo=key & 0x00ff;
    hi=(key & 0xff00) >> 8;

    return((lo == 0) ? hi+256 : lo);
  }

  void open_window(void)
  {
    gettextinfo(&win_info);
    gettext(43,5,74,15,win);

    textattr(RED+(LIGHTGRAY<<4));
    window(43,5,74,15);
    clrscr();
  }

  void close_window(void)
  {
    puttext(43,5,74,15,win);
    window(win_info.winleft,
           win_info.wintop,
           win_info.winright,
           win_info.winbottom);
    textattr(win_info.attribute);
    gotoxy(win_info.curx,win_info.cury);
  }

  void draw_border(void)
  {
    register int i;

    for(i=1;i<=9;i++)
    {
      putch(186);
      gotoxy(32,i);
      putch(186);
    }
    putch(200);
    for(i=1;i<=30;i++)
    {
      putch(205);
    }
    putch(188);
    gotoxy(1,1);
    insline();
    putch(201);
    for(i=1;i<=30;i++)
      putch(205);
    putch(187);

    gotoxy(1,3);
    putch(199);
    for(i=1;i<=30;i++)
      putch(196);
    putch(182);
  }

