;libname = application["libname"]

;============================================================================
; Author.....: Eka S. Sundjaja [72560,1630]
; Last update: 1/31/93
;
; You have a royalty-free right to use, modify, reproduce and distribute
; this file (and/or any modified version) in any way you find useful,
; provided that you agree that the author has no warranty, obligation
; or liability for its contents.
;============================================================================
;
; Calculator
; attributes:
;   calculator.value
;   calculator.storedvalue
;   calculator.displayval
;   calculator.ispoint
;   calculator.operator
; services/methods:
;   calculator.set( startrow,startcol )
;   calculator!dialog( startrow,startcol )
;   calculator_dlogproc( ,,,, )
;   calculator_ctagproc()
;   calculator_numbertagproc( eventvalue )
;   calculator_pointtagproc( eventvalue )
;   calculator_backspacetagproc( eventvalue )
;   calculator_operatorproc( eventvalue )
;   calculator!trimdecimals( oldvalue )

;------------------------------------------------------calculator_dlogproc()
proc calculator_dlogproc( triggertype, tagvalue, eventvalue, elementvalue )
  private
    keyvalue,
    keycode

  switch
    case triggertype = "UPDATE" :                                  ;--UPDATE
      switch
        case tagvalue = "ctag" :
          calculator_ctagproc()

        case tagvalue = "zerotag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "onetag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "twotag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "threetag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "fourtag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "fivetag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "sixtag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "seventag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "eighttag" :
          calculator_numbertagproc( eventvalue )
        case tagvalue = "ninetag" :
          calculator_numbertagproc( eventvalue )

        case tagvalue = "multtag"   :
          calculator_operatorproc( eventvalue )
        case tagvalue = "divtag"    :
          calculator_operatorproc( eventvalue )
        case tagvalue = "plustag"   :
          calculator_operatorproc( eventvalue )
        case tagvalue = "minustag"  :
          calculator_operatorproc( eventvalue )
        case tagvalue = "equaltag"  :
          calculator_operatorproc( eventvalue )

        case tagvalue = "pointtag" :
          calculator_pointtagproc( eventvalue )

        case tagvalue = "backspacetag" :
          calculator_backspacetagproc( eventvalue )

      endswitch

    case eventvalue["TYPE"] = "KEY" :                             ;--KEY
      keycode = eventvalue["KEYCODE"]
      keyvalue = chr(keycode)
      switch
        case keycode = asc("Esc") :
          canceldialog
          return false

        case keycode = asc("C") :
          selectcontrol "ctag"
          calculator_ctagproc()

        case keycode = asc("0") :
          selectcontrol "zerotag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("1") :
          selectcontrol "onetag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("2") :
          selectcontrol "twotag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("3") :
          selectcontrol "threetag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("4") :
          selectcontrol "fourtag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("5") :
          selectcontrol "fivetag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("6") :
          selectcontrol "sixtag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("7") :
          selectcontrol "seventag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("8") :
          selectcontrol "eighttag"
          calculator_numbertagproc( keyvalue )
        case keycode = asc("9") :
          selectcontrol "ninetag"
          calculator_numbertagproc( keyvalue )

        case keycode = asc("*") :
          selectcontrol "multtag"
          calculator_operatorproc( keyvalue )
        case keycode = asc("/") :
          selectcontrol "divtag"
          calculator_operatorproc( keyvalue )
        case keycode = asc("+") :
          selectcontrol "plustag"
          calculator_operatorproc( keyvalue )
        case keycode = asc("-"):
          selectcontrol "minustag"
          calculator_operatorproc( keyvalue )
        case keycode = asc("=") :
          selectcontrol "equaltag"
          calculator_operatorproc( keyvalue )
        case keycode = asc("Enter") :
          selectcontrol "equaltag"
          calculator_operatorproc( "=" )

        case keycode = asc(".") :
          selectcontrol "pointtag"
          calculator_pointtagproc( keyvalue )

        case keycode = asc("backspace") :
          selectcontrol "backspacetag"
          calculator_backspacetagproc( keyvalue )

      endswitch

  endswitch
;  message "calculator.value :", calculator.value
  repaintdialog

endproc
;writelib libname calculator_dlogproc
;release procs calculator_dlogproc

;--------------------------------------------------------calculator_ctagproc()
proc calculator_ctagproc()
  release vars
    calculator.value,
    calculator.storedvalue,
    calculator.operator,
    calculator.displayval,
    calculator.ispoint
  calculator.value        = "0"
  calculator.displayval   = calculator.value
  calculator.ispoint      = FALSE
endproc
;writelib libname calculator_ctagproc
;release procs calculator_ctagproc


;----------------------------------------------------calculator_numbertagproc()
proc calculator_numbertagproc( eventvalue )

  if isassigned( calculator.operator ) and
     ( calculator.operator = "=" ) then
    calculator_ctagproc()
  endif

  calculator.value = calculator.value+strval(eventvalue)
  if calculator.ispoint then
    calculator.value = calculator!trimdecimals( calculator.value)
  endif
  calculator.displayval = calculator.value

endproc
;writelib libname calculator_numbertagproc
;release procs calculator_numbertagproc

;-------------------------------------------------calculator_pointtagproc()
proc calculator_pointtagproc( eventvalue )

  if not calculator.ispoint then
    if isassigned( calculator.value ) then
      calculator.value = calculator.value+strval(eventvalue)
    else
      calculator.value = strval(eventvalue)
    endif
    calculator.ispoint = TRUE
  endif
  calculator.displayval = calculator.value

endproc
;writelib libname calculator_pointtagproc
;release procs calculator_pointtagproc

;------------------------------------------------calculator_backspacetagproc()
proc calculator_backspacetagproc( eventvalue )
  private
    strlen,
    lastval

  if calculator.displayval = calculator.value then
    strlen = len(calculator.value)
    if (strlen-1)<1 then
      strlen = 2
    endif

    ;--get last trailing digit
    lastval = substr( calculator.value,strlen-1,1 )
    if lastval = "." then
      strlen= strlen-1
      calculator.ispoint = FALSE
    endif

    ;--get leading digits
    calculator.value = substr( calculator.value,1,strlen-1 )
    calculator.displayval = calculator.value
  else
    calculator_ctagproc()
  endif

endproc
;writelib libname calculator_backspacetagproc
;release procs calculator_backspacetagproc

;--------------------------------------------------calculator_operatorproc()
proc calculator_operatorproc( eventvalue )
  private
    wfrmt,
    tempval

 ;global
 ;  calculator.operator,
 ;  calculator.storedvalue

  if isassigned( calculator.storedvalue ) then
    if calculator.operator<>"=" then
      execute "result="+strval(numval(calculator.storedvalue))
                       +calculator.operator
                       +strval(numval(calculator.value))
      calculator.storedvalue = calculator!trimdecimals( strval(result) )
    endif
  else
    calculator.storedvalue = calculator.value
  endif
  calculator.operator     = eventvalue
  calculator.value        = "0"
  calculator.displayval   = calculator.storedvalue
  calculator.ispoint      = FALSE
;  message " stored :",calculator.storedvalue,
;          " value :",calculator.value,
;          " operator :",calculator.operator
;  sleep 1000

endproc
;writelib libname calculator_operatorproc
;release procs calculator_operatorproc

;----------------------------------------------------calculator!trimdecimals()
proc calculator!trimdecimals( oldvalue )
  private
    decpos,
    declen,
    strlen,
    wfrmt,
    tmpval

  strlen = len( oldvalue )
  decpos = search( ".",oldvalue )
  if decpos = 0 then
    decpos = strlen
  endif
  declen = strlen - decpos
  if declen > 2 then
    declen = 2
  endif
  if declen = 0 then
    wfrmt = "w"+strval(strlen+1)
  else
    wfrmt = "w"+strval(strlen+1)+"."+strval(declen)
  endif
  tmpval = format( wfrmt,numval(oldvalue) )
  return "0"+strval(numval(tmpval))

endproc
;writelib libname calculator!trimdecimals
;release procs calculator!trimdecimals

;---------------------------------------------------calculator!dialogbox()
proc calculator!dialogbox( startrow,startcol )

  showdialog ""
    proc "calculator_dlogproc"
      trigger "UPDATE"
      key "-","+","*","/","=",".","C","Esc","Backspace","Enter",
          "1","2","3","4","5","6","7","8","9","0"

    @ startrow,startcol height 13 width 28
    frame single from 0,2 to 2,23
    paintcanvas attribute 127 2,3,2,23
    paintcanvas attribute 127 0,23,2,23

    @ 1,4 ?? format("w18.2,ar,ec",numval(calculator.displayval))

    pushbutton                      ;7
      @3,0 width 5
      "7"
      value "7" tag "seventag"
    to retval

    pushbutton                      ;8
      @3,5 width 5
      "8"
      value "8" tag "eighttag"
    to retval

    pushbutton                      ;9
      @3,10 width 5
      "9"
      value "9" tag "ninetag"
    to retval

    pushbutton                      ;*
      @3,15 width 5
      "*"
      value "*" tag "multtag"
    to retval

    pushbutton                      ;/
      @3,20 width 5
      "/"
      value "/" tag "divtag"
    to retval

    pushbutton                      ;4
      @5,0 width 5
      "4"
      value "4" tag "fourtag"
    to retval

    pushbutton                      ;5
      @5,5 width 5
      "5"
      value "5" tag "fivetag"
    to retval

    pushbutton                      ;6
      @5,10 width 5
      "6"
      value "6" tag "sixtag"
    to retval

    pushbutton                      ;+
      @5,15 width 5
      "+"
      value "+" tag "plustag"
    to retval

    pushbutton                      ;-
      @5,20 width 5
      "-"
      value "-" tag "minustag"
    to retval

    pushbutton                      ;1
      @7,0 width 5
      "1"
      value "1" tag "onetag"
    to retval

    pushbutton                      ;2
      @7,5 width 5
      "2"
      value "2" tag "twotag"
    to retval

    pushbutton                      ;3
      @7,10 width 5
      "3"
      value "3" tag "threetag"
    to retval

    pushbutton                      ;C
      @7,15 width 5
      "C"
      value "C" tag "ctag"
    to retval

    pushbutton                      ;
      @7,20 width 5
      "\17"
      value "backspace" tag "backspacetag"
    to retval

    pushbutton                      ;0
      @9,0 width 5
      "0"
      value "0" tag "zerotag"
    to retval

    pushbutton                      ;.
      @9,5 width 5
      "."
      value "." tag "pointtag"
    to retval

    pushbutton                      ;=
      @9,10 width 5
      "="
      value "=" tag "equaltag"
    to retval

    pushbutton                      ;OK
      @9,15 width 10
      "~O~K" OK
      value "" tag ""
    to retval
  enddialog

  return numval(calculator.displayval)

endproc
;writelib libname calculator!dialogbox
;release procs calculator!dialogbox

;-----------------------------------------------------------calculator.set()
proc calculator.set( startrow,startcol )
 ;global
 ;  calculator.value,
 ;  calculator.displayval,
 ;  calculator.ispoint

  calculator.value        = "0"
  calculator.displayval   = calculator.value
  calculator.ispoint      = FALSE
  cursor off
  retval = calculator!dialogbox( startrow,startcol )
  release vars
    calculator.storedvalue,
    calculator.value,
    calculator.displayval,
    calculator.ispoint,
    calculator.operator
  cursor normal
  return retval

endproc
;writelib libname calculator.set
;release procs calculator.set


fieldval = calculator.set( 5,20 )
message fieldval
sleep 1000