*** ---------------------------------------------------------------- ***
*** ---  System: Azalea Database Extensions
*** ---  Program: FMT_C39.PRG for Microsoft FoxPro
*** ---  Copyright 1994 Jerry Whiting All Rights Reserved
*** ---  Azalea Software, Inc. 206 932.4030  azalea@igc.org 72627,746
*** ---  All Rights Reserved. Unauthorized Use Prohibited        
*** ---------------------------------------------------------------- ***
*** --- Description: This function validats and formats a passed 
***                  in Code 39 String
*** --- Validations Performed:
*** ---     1. Checks parameter passed in to see that it is in the valid
*** ---        set of ASCII characters.
*** --- Formatting performed:
*** ---     1. Concatenates "*" to beginning and end of string.
*** ---     2. Replaces all <spaces> with underscore "_" character
*** ---------------------------------------------------------------- ***
*** --- Parameters: lc_c39str : Code 39 String to be formatted
*** ---             lc_asc_set: ASCII set to test for
*** ---                         SHORT = A-Z,0-9, -.*$/+% <space>
*** ---                         SHORT_WITH_CHECKDIGIT = include check digit
*** ---                         LONG  = ASCII 0-127
*** --- NOTE. If this is a LONG string then the string is converted
*** ---       withing the validation program.
*** ---------------------------------------------------------------- ***
*** --- Returns: If bad parameter string passed: "-Bad Parameter-"
*** ---          If bad ASCII character: "-Bad ASCII-"
*** ---------------------------------------------------------------- ***
*** --- Sample call: lc_fmtc39 = fmt_c39("VB3 0001","SHORT")
*** ---              ? lc_fmtc39
*** ---       Output: *VB3_0001*
*** ---------------------------------------------------------------- ***
parameters lc_c39str, lc_asc_set
private lc_retval, ll_goodasc

lc_retval  = ""  && return value initialized to error

*** --- make sure that we got a character
if type("lc_c39str") # "C" .or. type("lc_asc_set") # "C" 
  lc_retval = "-Bad Parameter-"
  return lc_retval
endif


*** --- process set depending upon ASCII set passed in 
do case
   case lc_asc_set == "SHORT"
      ll_goodasc = l_short(lc_c39str)

      *** --- convert spaces to underscores
      lc_c39str = strtran(lc_c39str," ","_")
		
   case lc_asc_set == "SHORT_WITH_CHECKDIGIT"
      ll_goodasc = l_short(lc_c39str)

      lc_c39Str = lc_c39Str + l_chkdig(lc_c39Str)

      *** --- convert spaces to underscores
      lc_c39str = strtran(lc_c39str," ","_")

   case lc_asc_set == "LONG"
      ll_goodasc = l_long(@lc_c39str) && long sets pass the parameter by
                                      && reference because of special 
                                      && formatting
   otherwise   
     lc_retval = "-Bad Parameter-"
     return lc_retval
endcase

*** --- if the check of the string turned out OK return true
if ll_goodasc
   lc_retval = "*" + lc_C39Str + "*"
else
   lc_retval = "-Bad ASCII-"
endif
   
return lc_retval


*** --- function l_short
*** --- this function checks to see if the passed in character string
*** --- is in the 44 character set for Code 39
function l_short
parameters lc_ascstr
private ll_retval, ln_kounter

*** --- initialize return value
ll_retval = .t.

*** --- retrieve characters from passed in string
for ln_kounter = 1 to len(lc_c39str)

    *** --- check to see if the character is in the ASCII set
    *** --- if not return FALSE value
    if ! substr(lc_ascstr,ln_kounter,1) $ "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%"
       ll_retval = .f.
      exit
   endif
endfor

return ll_retval

*** --- function l_long
*** --- this function checks to see if the passed in character string
*** --- is in the lower 128 ASCII characters set for Code 39
*** --- NOTE: This function modifies the passed in value. 
*** --- LC_ASC_STR is passed to this function by REFERENCE.
function l_long
parameters lc_ascstr
private lc_storage, lc_char, ll_retval, ln_kounter

*** --- initialize variables
ll_retval   = .t.    && return value
lc_storage  = ""     && This variable is used for temporary storage
                     && as the parameter is passed by reference and
                     && it is our goal to change it.

*** --- retrieve characters from passed in string
for ln_kounter = 1 to len(lc_ascstr)
    lc_char = substr(lc_ascstr,ln_kounter,1)


    *** --- process character 
    *** --- validate and convert depending upon its ASCII Value
    do case
       case asc(lc_char) = 0
          lc_storage = lc_storage + "%U"
       case asc(lc_char) >= 1 and asc(lc_char) <= 26
          lc_storage = lc_storage + "$" + chr(asc(lc_char) + 64)
       case asc(lc_char) >= 27 and asc(lc_char) <= 31
          lc_storage = lc_storage + "%" + chr(asc(lc_char) + 38)
       case asc(lc_char) = 32
          lc_storage = lc_storage + "_"
       case asc(lc_char) >= 33 and asc(lc_char) <= 44
          lc_storage = lc_storage + "/" + chr(asc(lc_char) + 32)
       case asc(lc_char) >= 45 and asc(lc_char) <= 46
          lc_storage = lc_storage + lc_char
       case asc(lc_char) = 47
          lc_storage = lc_storage + "/O"
       case asc(lc_char) >= 48 and asc(lc_char) <= 57
          lc_storage = lc_storage + lc_char
       case asc(lc_char) = 58
          lc_storage = lc_storage + "/Z"
       case asc(lc_char) >= 59 and asc(lc_char) <= 63
          lc_storage = lc_storage + "%" + chr(asc(lc_char) + 11)
       case asc(lc_char) = 64
          lc_storage = lc_storage + "%V"
       case asc(lc_char) >= 65 and asc(lc_char) <= 90
          lc_storage = lc_storage + lc_char
       case asc(lc_char) >= 91 and asc(lc_char) <= 95
          lc_storage = lc_storage + "%" + chr(asc(lc_char) - 16)
       case asc(lc_char) = 96
          lc_storage = lc_storage + "%W"
       case asc(lc_char) >= 97 and asc(lc_char) <= 122
          lc_storage = lc_storage + "+" + chr(asc(lc_char) - 32)
       case asc(lc_char) >= 123 and asc(lc_char) <= 126
          lc_storage = lc_storage + "%" + chr(asc(lc_char) - 43)
       case asc(lc_char) = 127
          lc_storage = lc_storage + "%T"
       otherwise 
          ll_retval = .f.
          exit
    endcase
endfor

*** --- change passed in variable
lc_ascstr = lc_storage

return ll_retval

*** --- This function returns a check digit for a code 39 string.
function l_chkdig
parameters lcC39Str
private lnKounter, lnValue, lcCharSet, lcRetval, lcChar
lnValue = 0
lcRetVal = ""
lcCharSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%"

For lnKount = 1 To Len(lcC39Str)
  strChar = substr(lcC39Str, lnKount, 1)

  *** --- find the location of this character in the valid set of characters
  *** --- subtract 1 to make sure this because the character set values are
  *** --- 0 based
  lnValue = lnValue + (at(strChar, lcCharSet) - 1)
Endfor
    
lcRetval = substr(lcCharSet, mod(lnValue,43) + 1,1)

return lcRetval



