; BUNDLE.SC *** By Jan R. Wilson (407) 984-5238

; NOTE: to use this script, you must have a Paradox .DB non-indexed
;       table with zip codes in field [Zip] at least 5 characters (A5),
;       and a field [Bundle] of at least 6 characters (A6).
;       And the table STATES.DB must also be in the directory, set in
;       the following statement:

FileDirectory = DIRECTORY()  ; sets to current working directory

;       Note that any backslashes must be doubled, if you want to use
;       a directory other than the current one.

; TO USE: Play this script, then print labels in a report similar to:
;
; page
; group Bundle
; ************
; *          *
; * [Bundle] *
; *          *
; ************
;
; group Zip
; form
; [Name]
; [Addr1]
; [Addr2]
; [City], [State] [Zip]
;
;
; form
; group Zip
; group Bundle
; page


; Prepare files & variables
;   Get filename
;   Sort on [Zip]

MinPile = 10               ; Set to 10 unless debugging
SHOWTABLES                 ; Show a list of tables
  FileDirectory            ; Directory to use
  "Select table to bundle, or ESC to abort"
  TO AddrTable             ; Name of table
IF AddrTable = "None" THEN
  MESSAGE "No .DB tables found"
  QUIT
ENDIF
IF AddrTable = "Esc" THEN
  MESSAGE "Aborting at your request"
  QUIT
ENDIF
IF FIELDNO("Bundle",AddrTable) = "Error" THEN
  MESSAGE "No [Bundle] field found"
  QUIT             ;can't continue if no Bundle field
ENDIF
CLEARIMAGE
SORT AddrTable ON "Zip"

VIEW "States"      ;to translate zip codes to states
EDIT AddrTable
SCAN               ;blank all bundle field
  [Bundle] = ""
ENDSCAN

PROC StateAbbr(Z3)
  MOVETO "States"
  WHILE ((Z3 > [MaxZip]) AND NOT ATLAST())
    DOWN           ;find the state that has this zip3
  ENDWHILE
  Z3 = [State]     ;put it back in z3 just to save it
  MOVETO AddrTable
  RETURN Z3        ;return the state
ENDPROC

HOME               ;back to top of file
MESSAGE "Initializing"
LastZip5 = SUBSTR([Zip],1,5)
LastZip3 = SUBSTR(LastZip5,1,5)
LastState = StateAbbr(LastZip3)
Zip5ct = 0
Zip3ct = 0
Statect = 0
Zip5bg = 1
Zip3bg = 1
Statebg = 1
Msg = "Beginning Scan"
SCAN               ;file is sorted by zip
  CurRec = RECNO()
  Zip5 = SUBSTR([Zip],1,5)
  MESSAGE Msg+"  "+Zip5
  IF SUBSTR([Zip],1,1) > "9" THEN      ;assume its intl
    [Bundle] = "Z-INTL"
    LOOP
  ENDIF
  IF Zip5 = LastZip5 THEN    ;5 digit match
    Zip5ct = Zip5ct+1        ;incr count of zip5s
    Zip3ct = Zip3ct+1        ;incr count of zip3s
    Statect = Statect+1      ;incr count of states
  ELSE                       ;it is not a match
    IF Zip5ct >= MinPile THEN     ;we have enought to make a D pile
      Msg = "Made D"+LastZip5
      FOR n FROM Zip5bg TO CurRec-1    ;check the block since beginning
        MOVETO RECORD n
        IF ISBLANK([Bundle]) THEN      ;include it in this bundle
          IF LastZip5 = SUBSTR([Zip],1,5) THEN
            [Bundle] = "D"+LastZip5    ;make it a D bundle
          ENDIF
        ENDIF
      ENDFOR
      MOVETO RECORD CurRec        ;back to where we were
      Zip3ct = Zip3ct - Zip5ct    ;subtract the zip5 count from others
      Statect = Statect - Zip5ct
    ENDIF
    LastZip5 = Zip5          ;this is now lastzip5
    Zip5ct = 1
    Zip5bg = CurRec          ;set count for zip5s

    Zip3 = SUBSTR([Zip],1,3)      ;test for zip3s
    IF Zip3 = LastZip3 THEN       ;could be a string of zip3s
      Zip3ct = Zip3ct+1           ;incr counts
      Statect = Statect+1
    ELSE                     ;it is not a zip3 match, zip3 bundle?
      IF Zip3ct >= MinPile THEN   ;if so there is a zip3 pile
        Msg = "Made 3--"+LastZip3
        FOR n FROM Zip3bg TO CurRec-1  ;for each since beginning of pile
          MOVETO RECORD n
          IF ISBLANK([Bundle]) THEN    ;just to be sure
            IF LastZip3 = SUBSTR([Zip],1,3) THEN
              [Bundle] = "3--"+LastZip3     ;set for 3 code
            ENDIF
          ENDIF
        ENDFOR
        MOVETO RECORD CurRec      ;back to now
        Statect = Statect - Zip3ct     ;subtract the zip3 from state count
      ENDIF
      LastZip3 = Zip3   ;new last zip3
      Zip3ct = 1
      Zip3bg = CurRec

      State = StateAbbr(Zip3)     ;get the state
      IF State = LastState THEN   ;if same, incr count
        Statect = Statect+1
      ELSE                        ;else not same
        IF Statect >= MinPile THEN     ;enough in state count for pile?
          Msg = "Made S - "+LastState
          FOR n FROM Statebg TO CurRec-1    ;for each in pile
            MOVETO RECORD n
            IF ISBLANK([Bundle]) THEN [Bundle] = "S - "+LastState ENDIF
          ENDFOR
          MOVETO RECORD CurRec    ;back to now
        ENDIF
        LastState = State         ;reset state name
        Statect = 1
        Statebg = CurRec
      ENDIF

    ENDIF
  ENDIF
ENDSCAN
IF Zip5ct >= MinPile THEN         ;zip5 pile left over?
  MESSAGE "Made final D"+LastZip5
  FOR n FROM Zip5bg TO CurRec     ;for each since begin of zip5
    MOVETO RECORD n
    IF ISBLANK([Bundle]) THEN
      IF LastZip5 = SUBSTR([Zip],1,5) THEN
        [Bundle] = "D"+LastZip5   ;make a D bundle
      ENDIF
    ENDIF
  ENDFOR
  Zip3ct = Zip3ct - Zip5ct        ;decr counts
  Statect = Statect - Zip5ct
ENDIF
IF Zip3ct >= MinPile THEN         ;zip3 pile left over?
  MESSAGE "Made final 3--"+LastZip3
  FOR n FROM Zip3bg TO CurRec     ;for each since begin of zip3
    MOVETO RECORD n
    IF ISBLANK([Bundle]) THEN
      IF LastZip3 = SUBSTR([Zip],1,3) THEN
        [Bundle] = "3--"+LastZip3      ;make a 3 bundle
      ENDIF
    ENDIF
  ENDFOR
  Statect = Statect - Zip3ct      ;decr counts
ENDIF
IF Statect >= MinPile THEN        ;state pile left over?
  MESSAGE "Made final S - "+LastState
  FOR n FROM Statebg TO CurRec    ;for each since begin of state
    MOVETO RECORD n
    IF ISBLANK([Bundle]) THEN
      [Bundle] = "S - "+LastState ;make S bundle
    ENDIF
  ENDFOR
ENDIF
MESSAGE "Bundling MIXED STATES"
SCAN
  IF ISBLANK([Bundle]) THEN
    [Bundle] = "Mix St"           ;any remaining are mixed states
  ENDIF
ENDSCAN
DO_IT!
RELEASE PROCS StateAbbr           ;free up memory
RELEASE VARS All
