; Box2.sc
; Alan Zenreich  September 1986
;
; Writes centered, colored box with message at specified line on screen
; it allows for up to 3 lines of text, all centered with the box width
; accomodating the largest line.
;
; I have included all sorts of error checking for starting line, and
; since you may use any or all of prompt1, prompt2, or prompt3, I put in
; a few ISASSIGNED(prompt#) statements, in case you forget to declare the
; variables.  All this errorchecking may, of course be removed.
;
; I have also included a demo procedure below: TESTBOX()
;
; Inspired by and modified from Mesage() by Rick Alber, April 1986
; Unlike Mesage(), it does not affect the text outside of the box
;

;----------------------------------------------------------------------
PROC box2(prompt1,prompt2,prompt3,S,L)
 PRIVATE w,wb,c,width,prompt_counter,topline,botline
;
; prompt1  prompt2  and prompt3 are the text lines to be placed in the box.
; A  max of 74 characters is permitted to allow for border.
; If Len(Prompt#)>74 then Substr(Prompt#,1,74) will be used
; Any or all of the prompts may be used, the box height is adjusted accordingly.
;
; S is color Style Attribute of the box
; ** note remember to reset the Style attribute after box is run if necessary

; L is the line number for the top of the box (0-22)
; If the Line you chose would cause the box to extend beyond the bottom of the
; screen, the box is automatically moved up the appropriate number of lines.

; C is calculated as starting column number

; W is the String value of the width of the + the characters ",AC"
;   it is used in the Format command

; WB is the String value of the width+6 and the characters ",AC"
;   it is used in the Format command to print the top and bottom border


;----------------------------------------------------------------------
              ;--   error checking
;
;-- check for string length errors

  IF LEN(prompt1)>74 THEN
    prompt1=SUBSTR(Prompt1,1,74)
  ENDIF

  IF LEN(prompt2)>74 THEN
    prompt2=SUBSTR(Prompt2,1,74)
  ENDIF

  IF LEN(prompt3)>74 THEN
    prompt3=SUBSTR(Prompt3,1,74)
  ENDIF



;-- make sure box will not run off the bottom of the screen
  prompt_counter=0
  If ISASSIGNED(prompt1) THEN prompt_counter=Prompt_counter+1 ENDIF
  If ISASSIGNED(prompt2) THEN prompt_counter=Prompt_counter+1 ENDIF
  If ISASSIGNED(prompt3) THEN prompt_counter=Prompt_counter+1 ENDIF


  SWITCH
    CASE prompt_counter=3 and L>20: L=20
    CASE prompt_counter=2 and L>21: L=21
    CASE prompt_counter=1 and L>22: L=22
  ENDSWITCH

;-- check for invalid attribute assignment
  SWITCH
    CASE  NOT ISASSIGNED(S) : S=112    ;--defaults to inverse video
    CASE  S>255 :S=112
  ENDSWITCH

;-- if L is left out, box will start at top of screen
    IF NOT ISASSIGNED(L) THEN L=0 ENDIF


   ;-- end of error checking section
;----------------------------------------------------------------------------



;-- calculate format and column information as well as top and bottom of box

;-- checks for longest line
  width=0
  IF ISASSIGNED(prompt1) THEN width=MAX(width,LEN(prompt1)) ENDIF
  IF ISASSIGNED(prompt2) THEN width=MAX(width,LEN(prompt2)) ENDIF
  IF ISASSIGNED(prompt3) THEN width=MAX(width,LEN(prompt3)) ENDIF


W="W"+STRVAL(width)+",AC"    ;-- sets format for maximum length prompt
WB="W"+STRVAL(width+6)+",AC" ;-- allows for centering to and bottom borders
C=INT((80-(width+6))/2)      ;-- starting column

topline = ""+Fill("",width)+"ͻ"
botline = ""+Fill("",width)+"ͼ"

;-- Display the box  -------------------------------------------------------

STYLE ATTRIBUTE S

@L,C   ?? FORMAT(WB,topline)
L=L+1

IF ISASSIGNED(prompt1) and prompt1<>"" THEN
@L,C ?? "  "+FORMAT(W,prompt1)+"  "
L=L+1
ENDIF

IF ISASSIGNED(prompt2) and prompt2<>"" THEN
@L,C ?? "  "+FORMAT(W,prompt2)+"  "
L=L+1
ENDIF

IF ISASSIGNED(prompt3) and prompt3<>"" THEN
@L,C ?? "  "+FORMAT(W,prompt3)+"  "
L=L+1
ENDIF

@L,C ?? FORMAT(WB,botline)


;-- clean up


ENDPROC      ;-- box3()


;------------------------------------------------------------------------
           ;if you want to test the box try the testbox procedure below

Proc TestBox2()
;                       ;--set up defaults for test
l=0                     ;--line 0
s=112                   ;--reverse video

@0,0 clear eol ?? "Prompt1 for box? "
                   Accept "A80" to PROMPT1
                        ; if longer than 74  it will be trimmed

@2,0 clear eol ?? "Prompt2 for box? "
                   Accept "A80" to PROMPT2
                        ; if longer than 74  it will be trimmed

@4,0 clear eol ?? "Prompt3 for box? "
                   Accept "A80" to PROMPT3
                        ; if longer than 74  it will be trimmed

@6,0 clear eol ?? "Top of box at line #(0-22) "
                   Accept "s" to L


@7,0 clear eol ?? "Style Attribute (0-255) "
                   Accept "s" MAX 255 default 112 to S

box2(prompt1,prompt2,prompt3,S,L)
message "Press any key"
x=getchar()

EndProc      ;-- testbox2()
;--------------------------------------------------------------------------

Testbox2()  ;-- runs the test

;--------------------------------------------------------------------------
             