; Box1 procedure             Alan Zenreich Sept 1986
;
; Writes centered, colored box with a single line message at specified
; line on the screen.
;
; Inspired by and modified from Mesage() by Rick Alber, April 1986
; unlike Mesage(), it does not affect the text outside of the box

;-----------------------------------------------------------------------

PROC box1(prompt,S,L)        ;-- begin procedure
  PRIVATE w,c,topline,botline

; prompt is the text to put on the line, max 74 characters (allows for border)
;   if Len(Prompt)>74 then Substr(Prompt,1,74) will be used

; S is color Style Attribute of the box
; ** note remember to reset the Style attribute after box is run if necessary

; L is the line number for the top of the box (0-22)
; if L is entered as a number >22 then it will be reset to L=22

; C is calculated as starting column number

; W is the String value of the width of the prompt+6 characters+",AC"
;   it is used in the Format command

;-- check for errors

  IF LEN(prompt)>74 THEN
    prompt=SUBSTR(Prompt,1,74)
  ENDIF

  IF L>22 THEN
    L=22
  ENDIF

  IF s>255 THEN
    s=112   ;reverse video
  ENDIF


;-- calculate format and column information as well as top and bottom of box

W=STRVAL(LEN(prompt)+6)+",AC"
C=INT((80-(LEN(Prompt)+6))/2)

topline = "IMM"+Fill("M",LEN(prompt))+"MM;"
botline = "HMM" + Fill("M",LEN(prompt))+"MM<"

;-- Display the box

STYLE ATTRIBUTE S
@L,C   ?? FORMAT(W,topline)
@L+1,C ?? FORMAT(W,":  "+prompt+"  :")
@L+2,C ?? FORMAT(W,botline)


;-- clean up


ENDPROC


;------------------------------------------------------------------------
           ;if you want to test the box try the testbox procedure below

Proc TestBox1()
;                       ;--set up defaults for test
Prompt="This is a test"
l=0                     ;--line 0
s=112                   ;--reverse video

@0,0 clear eol ?? "Text for box? "
                   Accept "A80" to PROMPT
                        ; if longer than 74  it will be trimmed

@2,0 clear eol ?? "Top of box at line #(0-22) "
                   Accept "s" to L


@3,0 clear eol ?? "Style Attribute (0-255) "
                   Accept "s" MAX 255 default 112 to S

box1(prompt,S,L)
message "Press any key"
x=getchar()

EndProc


Testbox1()  ;-- runs the test

;----------------------------------------------------------------
  