; Usutl


AppLib = "Usutl"
Createlib AppLib


proc HelpKey()

  Help
  Echo Normal

  while (HelpMode() <> "None")
   KeyPress getchar()
  endwhile

  Echo Off
endproc

WriteLib AppLib HelpKey
Release Procs HelpKey


proc ToggleForm(formToggle, frm, QEdit)

  if (formToggle) then
    if (inFormView) then
      FormKey

      if (QEdit) then
        ; make sure the table to edit is first on the workspace
        FirstShow
      endif
    else
      PickForm frm
    endif

    inFormView = (not inFormView)    ; toggle value of variable inFormView
  else
    Beep
  endif
endproc

WriteLib AppLib ToggleForm
Release Procs ToggleForm


; procedure which accepts a value of type dt, with
;    default value dv.  The user prompt is prmpt, and the
;    value is accepted on line l.

proc EnterVal(prmpt, dt, dv, l)
private x, t

  Style Attribute SysColor(0)         ; write prmpt
  @ 0, 0 ?? prmpt
  Style Attribute SysColor(2)
  if (l = 1) then
    @ 1, 0
  endif

  x = ""                ; accept value from user
  t = type(dv)
  Cursor Normal
  if (t = dt or (t = "N" and (dt = "$" or dt = "S"))) then
    Accept dt Default dv To x
  else
    Accept dt To x
  endif
  EscEnter = not retval
  Cursor Off

  Style Attribute SysColor(0) ;clear the prompt and value from the screen
  @ 0, 0
  Clear

  return x
endproc

WriteLib AppLib EnterVal
Release Procs EnterVal


proc QueryDoIt()
Private Qord

  Message "Processing query..."

  Qord = QueryOrder()                ; save current query order
  SetQueryOrder TableOrder           ; set to tableorder

  Do_It!                             ; perform the query for the operation

  if (Qord = "TableOrder") then     ; reset to prior order
    SetQueryOrder TableOrder
  else
    SetQueryOrder ImageOrder
  endif

  msg = window()
  tbl = table()
  ClearAll
  Clear

  if (ApplicErrorRetVal) then        ; structures not match?
    return FALSE
  endif

  if (msg <> "") then
    Message msg
    Sleep 2000
    Clear
  endif
    
  if (tbl <> "Answer") then
    return FALSE
  endif

  return TRUE
endproc

WriteLib AppLib QueryDoIt
Release Procs QueryDoIt


proc ReportTable(rptTbl, sourceTbl, rpt, dest, destFile)

  ; check for empty table, don't report on it if it is empty
  if (isempty(rptTbl)) then
   Message "No records to report on"
   Sleep 3000
   return FALSE
  endif

  if (upper(sourceTbl) <> upper(rptTbl)) then
    ; copy only if not the same table
    CopyReport sourceTbl rpt rptTbl rpt

    ; structures not match?
    if (ApplicErrorRetVal) then
      return FALSE
    endif
  endif

  Menu {Report} {Output}
  Select rptTbl

  if (ApplicErrorRetVal) then    ; table not exist?
    Menu Esc
    return FALSE
  endif

  if (menuchoice() = "") then
    Menu Esc
    Message rptTbl, " table is password-protected"
    return FALSE                 ; was asking for password
  endif

  Select rpt                     ; report not exist?
  if (ApplicErrorRetVal) then
    Menu Esc
    return FALSE
  endif

  switch
    case dest = "Printer":
      Message "Checking to see if the printer is ready..."

      retval = printerstatus()
      if (not retval) then
        Message "Please turn on your printer. Press any key when ready."
        retval = getchar()

        retval = printerstatus()
      endif

      if (not retval) then
        Message "Printer not ready. Report is cancelled."
        Menu Esc
      else
        Message "Report being sent to printer..."
        {Printer}
      endif

    case dest = "Screen":
      {Screen}

    case dest = "File":
      Message "Report being sent to file " + destFile
      {File}
      Select destFile

      if (menuchoice() = "Cancel") then
        {Replace}
      endif
  endswitch

  Clear
  Menu Esc

  return not ApplicErrorRetVal
endproc

WriteLib AppLib ReportTable
Release Procs ReportTable


; procedure which renames a table to a new name using a specified prefix

proc RenamePre(oldName, pre, n, putMsg)
private name

  while (TRUE)
    name = pre + strval(n)

    if (not istable(name)) then
      Rename oldName name
    
      if (putMsg) then
        Message oldName, " table renamed to ", name,
                "; press any key to continue"

        Beep Beep
        c = getchar()
      endif

      return n + 1
    endif

    n = n + 1
  endwhile
endproc

WriteLib AppLib RenamePre
Release Procs RenamePre


; procedure to rename all occurrances of the table oldPre* to newPre##

proc RenameSet(oldPre, newPre)
private oldName, i, n

  oldName = oldPre
  n = 1

  for i from 1
    if (not istable(oldName)) then
      QuitLoop
    endif

    n = RenamePre(oldName, newPre, n, TRUE)

    oldName = oldPre + strval(i)
  endfor

endproc

WriteLib AppLib RenameSet
Release Procs RenameSet


proc SaveList(tblPre)
private i, renTbls, x

  Array renTbls[10]	;maximum number of tables to rename
  ClearAll
  Edit "List"
  CtrlHome   ; get to first field where the names of the tables to
  Right      ; rename are

  i = 0
  scan for [] <> ""                ; rename all the Entry/KeyViol tables
    i = i + 1                      ; increment array index
    renTbls[i] = []                ; save name of table to rename
    [] = tblPre + strval(i - 1)    ; substitute new name in table
  endscan

  Do_It!
  ClearAll

  for x from 1 to i
    i = RenamePre(renTbls[x], tblPre, x, FALSE)
  endfor

  Menu {Modify} {Restructure} {List}    ; add the "form" field to the table
  End
  Down "Form" Right "A2"
  Do_It!
  ClearAll

endproc

WriteLib AppLib SaveList
Release Procs SaveList


proc CreateList(tbl, tblPre, sourceTbl)
private i, newTbl, srcTbl

  ClearAll

  i = RenamePre(tbl, tblPre, 1, FALSE)    ; rename the entry/keyviol table
  newTbl = tblPre + strval(i - 1)
  srcTbl = Directory() + sourceTbl

  Create "List" upper(tbl) + " Table" : "A" + strval(len(newTbl)),
                "BASE Table"          : "A" + strval(len(srcTbl)),
                "Form"                : "A2"

  View "List"        ; put the table names in the List table
  EditKey
  Right
  [] = newTbl
  Right
  [] = srcTbl
  Do_It!
  ClearAll

endproc

WriteLib AppLib CreateList
Release Procs CreateList


proc PrintList(frm, listPre)
private ans

  ; let the user know what the form used was so they can use
  ;    Modify/FormAdd/TablesAdd to add the renamed tables to
  ;    the original tables if necessary

  View "List"
  EditKey
  CtrlEnd
  [] = frm
  Do_It!
  CtrlHome

  RenamePre("List", listPre, 1, FALSE)
  Echo Normal
  Echo Off

  ShowMenu "PrintReport" : "Print a quick report of the table",
           "Continue" : "Continue without printing a quick report"
      To ans

  if (ans = "PrintReport") then
    ApplicErrorRetVal = FALSE
    InstantReport

    if (ApplicErrorRetVal) then
      Message "Please turn on your printer; press a key when ready"
      c = getchar()

      ApplicErrorRetVal = FALSE
      InstantReport

      if (ApplicErrorRetVal) then
        Message "Cancelling quick report"
        Sleep 2000
      endif
    endif
  endif
endproc

WriteLib AppLib PrintList
Release Procs PrintList


; procedure to rename keyviol table if it exists before a
;   data entry or after an edit or data entry

proc KECheck(beforeDE, renEntry, sourceTbl, frm)
private renList, tblPre, listPre, oldList, tmp, tbl, ans

  if (beforeDE) then
    ClearAll

    listPre = "KL"
    oldList = "List"

    RenameSet("Entry", "EN")        ; rename all entry tables
    RenameSet("Keyviol", "KV")      ; rename all keyviol tables

    if (istable("List")) then
      RenamePre("List", listPre, 1, TRUE)
    endif
  else
    if (renEntry) then
      ; keep full path name for new tables names since the original names
      ;   in the List table are full names as well
      tbl = "Entry"
      tblPre = Directory() + "EN"

      listPre = "EL"
      oldList = "KeepEntry"
    else
      ; keep full path name for new tables names since the original names
      ;   in the List table are full names as well
      tbl = "KeyViol"
      tblPre = Directory() + "KV"

      listPre = "KL"
      oldList = "KeyViol List"
    endif

    if (nimages() > 0 and table() = "List") then
      SaveList(tblPre)
      PrintList(frm, listPre)
    else
      if (istable(tbl)) then
        CreateList(tbl, tblPre, sourceTbl)
        PrintList(frm, listPre)
      endif
    endif
  endif

  ClearAll
  Clear
endproc

WriteLib AppLib KECheck
Release Procs KECheck


proc EdFldView(prompt1, prompt2)
private s

  while (TRUE)
    FieldView

    Wait Field
        Prompt prompt1, prompt2
        Until "F2", "Enter", "CtrlBackspace", "F1"

    switch
      case retval = "F1":
        HelpKey()

      otherwise:
        if (retval = "CtrlBackspace") then
          CtrlBackspace
        endif

        QuitLoop

    endswitch
  endwhile

endproc

WriteLib AppLib EdFldView
Release Procs EdFldView


proc EntryDoIt(sourceTbl, frm)

  Message "Posting new records..."
  Do_It!

  ; save keyviol/entry tables
  KECheck(FALSE, ApplicErrorRetVal, sourceTbl, frm)
  ApplicErrorRetVal = FALSE    ; reset to FALSE in case error was set

  ClearAll
  if (istable("Entry")) then   ; make sure Entry table is gone when done
    Delete "Entry"
  endif

  Clear
endproc

WriteLib AppLib EntryDoIt
Release Procs EntryDoIt


proc EntryCancel()
private ans

  ShowMenu "No": "Do not cancel the data entry session.",
           "Yes" : "Cancel the data entry session."
     To ans

  if (ans = "Yes") then
    Message "Cancelling data entry"
    Sleep 2000
    CancelEdit

    ClearAll
    Clear
    return TRUE
  endif

  return FALSE
endproc

WriteLib AppLib EntryCancel
Release Procs EntryCancel


proc EntryTable(sourceTbl, mapTbl, frm, formToggle)
private inFormView, inMultiForm, prmpt1, prmpt2
 
  KECheck(TRUE, TRUE, sourceTbl, frm)

  Menu {Modify}

  if (mapTbl = "") then     ; single-table data entry
    {DataEntry}
    Select sourceTbl
  else                      ; multi-table data entry
    {MultiEntry} {Entry}
    Select sourceTbl
    Select mapTbl
  endif

  if (ApplicErrorRetVal) then
    Menu Esc
    return FALSE
  endif

  if (menuchoice() <> "Error") then
    Menu Esc
    Message sourceTbl, " table is password-protected"
    Sleep 2000
    return FALSE
  endif

  if (frm = "") then
    inFormView = FALSE
    inMultiForm = FALSE
  else
    RequiredCheck Off
    PickForm frm
    RequiredCheck On

    if (ApplicErrorRetVal) then    ; make sure can use form
      CancelEdit
      ClearAll
      return FALSE
    endif

    inMultiForm = IsMultiForm(sourceTbl, frm)

    inFormView = TRUE
  endif

  prmpt = "[F2] - Data entry completed, Esc - Cancel data entry, Ctrl-U - Undo last change"

  while (TRUE)
    Wait Table
       Prompt prmpt
       Until "F7", "FieldView", "F35", "F2", "Esc", "F1", "F3", "F4"

    switch
      case retval = "F7":
        ToggleForm(formToggle, frm, FALSE)

      case retval = "FieldView" or retval = "F35":
        EdFldView(prmpt, "")

      case retval = "F1":
        HelpKey()

      case retval = "Esc":
        if (EntryCancel()) then
          return FALSE
        endif

      case retval = "F3":
        if (inMultiForm and inFormView) then
          UpImage
        else
          Beep
        endif

      case retval = "F4":
        if (inMultiForm and inFormView) then
          DownImage
        else
          Beep
        endif

      otherwise:
        EntryDoIt(sourceTbl, frm)
        return TRUE
    endswitch
  endwhile
endproc

WriteLib AppLib EntryTable
Release Procs EntryTable


proc EditCancel(useDelTable)
private ans

  ShowMenu "No": "Do not cancel the edit session.",
           "Yes" : "Cancel the edit session."
     To ans

  if (ans = "Yes") then
    Message "Cancelling edit"
    Sleep 2000
    CancelEdit

    if (useDelTable) then
      Delete "Deleted"
    endif

    ClearAll
    Clear
    return TRUE
  endif

  return FALSE
endproc

WriteLib AppLib EditCancel
Release Procs EditCancel


; performs Do_It! for a single-table edit session

proc SEditDoIt()

  Do_It!

  ClearAll
  Clear
endproc

WriteLib AppLib SEditDoIt
Release Procs SEditDoIt


; performs Do_It! for a single-table edit session which used a query to 
;    select the records to edit
;    NOTE: assumes that sourceTbl has been assigned the name of the map table
;          used in the edit, and that useDelTable has been assigned TRUE if
;          the Deleted table is used for holding the deleted records from the
;          answer table and FALSE otherwise

proc QEditDoIt()

  Do_It!

  Message "Posting changes..."

  UpImage
  if (useDelTable) then
    Subtract "Deleted" sourceTbl
    Delete "Deleted"
  endif

  Add "Answer" sourceTbl

  ClearAll
  Clear
endproc

WriteLib AppLib QEditDoIt
Release Procs QEditDoIt


proc EditTable(edTbl, sourceTbl, mapTbl, frm, formToggle,
               doitProc, delProc, prmpt2, update, useDelTable, QEdit)
private inFormView, inMultiForm, edImage, delImage

  if (frm <> "" and upper(edTbl) <> upper(sourceTbl)) then
    ; copy only if a form is being used and the tables are not the same

    Menu {tools} {Copy} {JustFamily}
        Select sourceTbl 
        Select edTbl
    {Replace}

    ; structures not match?
    if (ApplicErrorRetVal) then
      return FALSE
    endif
  endif

  Edit edTbl
  if (ApplicErrorRetVal) then
    return FALSE
  endif

  if (useDelTable) then
    edImage = imageno()			; get ANSWER table image number

    RequiredCheck Off
    MoveTo "Deleted"			; get DELETED table image number
    delImage = imageno()
    MoveTo edImage			; go back to ANSWER table
    RequiredCheck On
  endif

  if (frm = "") then
    inFormView = FALSE
    inMultiForm = FALSE
  else
    RequiredCheck Off
    PickForm frm
    RequiredCheck On

    if (ApplicErrorRetVal) then    ; make sure can use form
      CancelEdit
      ClearAll
      return FALSE
    endif

    inMultiForm = IsMultiForm(sourceTbl, frm)

    inFormView = TRUE
  endif

  if (update) then
    ImageRights Update
  endif

  if (useDelTable) then
    if (formToggle or frm = "") then
      FirstShow
    endif
  endif

  prmpt1 = "[F2] - Complete edit, [Esc] - Cancel edit, Ctrl-U - Undo last change"

  while (TRUE)
    Wait Table
        Prompt prmpt1, prmpt2
        Until  "Del", "F7", "FieldView", "F35", "F2", "Esc", "F1", "F3", "F4"

    switch
      case retval = "Del":
        if (delProc = "") then
          Message "Cannot delete a record"
          Sleep 2000
        else
          ExecProc delProc
        endif

      case retval = "F7":
        ToggleForm(formToggle, frm, QEdit)

      case retval = "FieldView" or retval = "F35":
        EdFldView (prmpt1, prmpt2)

      case retval = "F1":
        HelpKey()

      case retval = "F2":
        ExecProc doitProc    ; some doit procs assume global vars are set
        return TRUE

      case retval = "Esc":
        if (EditCancel(useDelTable)) then
          return FALSE
        endif

      case retval = "F3":
        if (inMultiForm and inFormView) then
          UpImage
        else
          Beep
        endif

      case retval = "F4":
        if (inMultiForm and inFormView) then
          DownImage
        else
          Beep
        endif

    endswitch
  endwhile

endproc

WriteLib AppLib EditTable
Release Procs EditTable


proc ApplicErrorProc()
private err, ErrorProc, eMsg, msg, b

  err = ErrorCode()
  ApplicErrorRetVal = TRUE

  if ((err = 3 or err = 4) and sysmode() = "DataEntry") then
    Menu {KeepEntry}          ; save in entry table(s)
  else
    eMsg = ErrorMessage()
    if (not match(eMsg, "..Run Error: ..", b, msg)) then
      if (not match(eMsg, "..Syntax Error: ..", b, msg)) then
        msg = eMsg
      endif
    endif

    Message msg
    Sleep 2000
  endif
    
  return 1                    ; skip command causing error
endproc

WriteLib AppLib ApplicErrorProc
Release Procs ApplicErrorProc


