; Uscpl


AppLib = "Uscp"
Createlib AppLib


proc CkTblRights(tbl)
private rt, ans, zzzcolor

  while (TRUE)
    rt = tablerights(tbl, "ReadOnly") 
    if (rt) then
      QuitLoop
    endif

    @ 1, 0
    ?? "Enter the password for the " + tbl + " table."
    @ 0, 0 Clear Eol
    ?? "Password: "
    zzzcolor = int(SysColor(0))
    Style Attribute ((zzzcolor * 16) + zzzcolor)
    Accept "a50" Required To ans
    Style Attribute SysColor(0)

    rt = retval
    if (not rt) then
      QuitLoop
    endif

    Password ans
  endwhile

  @ 1, 0 Clear Eol
  @ 0, 0 Clear Eol
  return rt
endproc

WriteLib AppLib CkTblRights
Release Procs CkTblRights


proc CopyApplication()
private msg, todrive, todir, mdir, ndir, c

  Echo Off
  todir = ""

  Clear
  @ 2, 0
  PutCpScriptHelp()

  @ 1, 0 ?? "Enter the name of the directory you wish to copy the application to."
  while (TRUE)
    @ 0, 0 ?? "Directory: "
    Accept "a60" Default todir Required To todir

    if (not retval) then
      Clear
      Message "Cancelling copy of the application"
      Sleep 3000
      Exit
    endif

    if (substr(todir, len(todir), 1) <> "\\") then
      todir = todir + "\\"
    endif

    if (direxists(todir) = -1) then
      Message "Invalid directory name"
      Loop
    endif

    if (not match(todir, "@:..", todrive)) then
      todrive = substr(directory(), 1, 1)
    endif

    if (not drivestatus(todrive)) then
      Message "Drive not ready"
    else
      QuitLoop
    endif
  endwhile

  Clear
  ndir = ""
  for l from len(todir) to 1 step -1
    c = substr(todir, l, 1)
    if (c = "\\" or c = ":") then
      if (l > 1) then
        mdir = substr(todir, 1, l - 1)

        if (direxists(mdir) = 1) then
          mdir = mdir + "\\"
          QuitLoop
        endif

        if (c = ":") then
          mdir = substr(todir, 1, 2)
          QuitLoop
        endif

        ndir = "\\" + ndir
      else
        mdir = "\\"
        QuitLoop
      endif
    else
      ndir = c + ndir
    endif
  endfor

  while (match(ndir, "..\\..", c, ndir))
    mdir = mdir + c
    Run NoRefresh "mkdir " + mdir

    if (direxists(mdir) = 0) then
      Message "Could not create directory -- application not copied"
      Sleep 3000
      Exit
    endif

    mdir = mdir + "\\"
  endwhile

  msg = "Copying the application files"
  Style Attribute SysColor(3) @ 24, 76 - len(msg) ?? msg
  Style Attribute SysColor(3) + 128  ?? "... "
  Style

  if (substr(todir, len(todir), 1) = "\\") then
    todir = substr(todir, 1, len(todir) - 1)
  endif

  CopyAppObjects(todir)

  Reset
  msg = "Application files successfully copied"
  @ 24, 0 Clear Eol
  Style Attribute SysColor(3) @ 24, 79 - len(msg) ?? msg
  Style
  Sleep 3000
endproc

WriteLib AppLib CopyApplication
Release Procs CopyApplication


proc PutCpScriptHelp()

Text
 The Paradox Personal Programmer ͻ
                                                                              
                                                                              
  Enter the name of the directory in which to copy the application.          
͹
 The copy script copies the files needed to run the application into the      
 subdirectory you name.  If the named subdirectory does not exist, the        
 copy script will create it for you.                                          
                                                                              
 When naming the subdirectory, it is preferable to use its full path          
 name.  For example, C:\paradox\sample specifies that you want to use         
 the \sample subdirectory under the \paradox directory on your C: drive.      
                                                                              
 The copy script does not copy any lookup tables you may have specified in    
 defining a validity check for data entry or editing.  You must also copy     
 any objects referenced by a script you've attached to a menu selection.      
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
ͼ

EndText

endproc

Writelib AppLib PutCpScriptHelp
Release Procs PutCpScriptHelp


proc CopyAppObjects(todir)

  Run NoRefresh "copy Us.sc " + todir + " >nul"
  Run NoRefresh "copy Usg.sc " + todir + " >nul"
  Run NoRefresh "copy Us*.lib " + todir + " >nul"
  Run NoRefresh "del " + todir + "\\Uscp.lib > nul"

  Run NoRefresh "copy Usq1.sc " + todir + " >nul"

  if (CkTblRights("Bond")) then
    Copy "Bond" todir + "\\Bond"
  endif

endproc

Writelib AppLib CopyAppObjects
Release Procs CopyAppObjects

