LIBNAME = "PopWaite"
CREATELIB LIBNAME

Proc ZIP_MENU(Start_Row,ListLength,Start_Col )

  Private ;menu_item,
          current,          ;procedure exits with: [Enter]- Select
          last_key, next_key,          ;                  or: [Esc]  - Cancel
          find_key
End_Row = Start_Row+ListLength+1
Window_End = ListLength + Start_Row
Window_Top = Start_Row + 1
current = 1
ArrayTotal = NRECORDS(TABLE())
;ListWidth = NUMVAL(SUBSTR(FIELDTYPE(),2,LEN(FIELDTYPE())))
Page=1
LastPage = INT((ArrayTotal-1)/ListLength)+1
BC =  4 ;Border Color
TC = 91 ;Text Color
CC = 14 ;Cursor Color
;  Home                                 ;
                                       ;NOTE: For best results, <field_name>
  Cursor Off                           ;      should be indexed, either as a
  Canvas Off                           ;      Primary Key or by using the
                                       ;      PAL "INDEX MAINTAINED" command.
ShowBorder()
ShowNewPage(Page,TC)

  While CharWaiting()                  ;clear keyboard buffer
    retval = GetChar()                 ;of any pending keystrokes
  EndWhile

  last_key = ""                        ;initialize keycode variable
;EBUG
  While (True)                         ;LOOP TO TRAP KEYSTROKES:
  ;-------------------------------------------------------------
    next_key = KEYCODE_MENU()          ;get next keycode value from keyboard
      IF next_key = -83 THEN     ;Delete a POPUP Description
        DeletePopUpRecord()
        current = 1
        ArrayTotal = NRECORDS(TABLE())
        Page=1
        LastPage = INT((ArrayTotal-1)/ListLength)+1
                                       ;NOTE: For best results, <field_name>
        Cursor Off                           ;      should be indexed, either as a
        Canvas Off                           ;      Primary Key or by using the
                                       ;      PAL "INDEX MAINTAINED" command.
        ShowBorder()
        ShowNewPage(Page,TC)
        LOOP
      ENDIF
    Switch

      Case next_key = -82 :                  ;exit on Insert
         InsertPopUpRecord()
         IF retval THEN
           RETURN TRUE
         ENDIF

      Case next_key = 13 :                    ;exit on [Enter]
         MOVETO RECORD current
         STYLE
         RETURN TRUE

      Case next_key =  27:                    ;exit on [Enter]
         style
         QuitLoop          ;     or [Esc]


      Case next_key =  8: last_key =""      ;loop on [BackSpace]
                          Home              ;to restart search
      Otherwise:

           next_key = Chr(next_key)         ;convert keycode value to symbol
           find_key = last_key + next_key   ;concatenate symbols, then search:
           Locate Next Pattern ( find_key + ".." )
           last_key = find_key              ;reset stored keycode values
           IF retval THEN
             current = RECNO()
             NewPage = INT((current-1)/ListLength)+1
             IF NewPage <> Page THEN
               ShowNewPage(NewPage,TC)
             ENDIF
             Page = NewPage
           ENDIF
    EndSwitch
    IF last_key = "" THEN
      Message FIELD()+" List - Page "+STRVAL(Page)+ " of "+STRVAL(LastPage)
    ELSE
      Message "Search Keys: " + last_key
    ENDIF
  ;-------------------------------------------------------------
  EndWhile                             ;END OF KEY TRAPPING LOOP

  If next_key = 13                     ;process [Enter] (value selected)
    Then
         menu_item = PopUp[current]
         If menu_item <> []   ;if user pressed , then "re-locate":
           Then
                Locate Next menu_item
         EndIf
         Return True
    Else
         Return False                  ;otherwise, [Esc] (cancel)
  EndIf

EndProc
writelib LIBNAME Zip_Menu
release procs Zip_menu
?? "."

;------------------------------------------------------------------------------
; Display field values and trap for keystroke processing:
;------------------------------------------------------------------------------

Proc KEYCODE_MENU()
  Private first_record, i, char

  first_record = RecNo()               ;store table record position
  Canvas Off
                                       ;draw 'middle' of window box
  Canvas On

  MoveTo Record first_record           ;return to original record


  While (True)                         ;LOOP TO DISPLAY POP-UP MENU:
  ;-----------------------------------------------------------------
    HIGHLIGHT_BAR(CC)                  ;highlight <current> selection

    char = GetChar()                   ;read character from keyboard

    HIGHLIGHT_BAR(TC)                  ;re-draw menu selection & process
;EBUG                                  ;keystroke values:  ANY ALPHA KEY,
    Switch                             ;or ENTER,ESC,UP,DOWN,HOME,END

      Case char > 48                   ;Alphanumeric key ... send to call for
       And char < 123 : QuitLoop       ;use in LOCATE PATTERN command

      Case char =  13                  ;Enter... selection made
        Or char =  27 : QuitLoop       ;Esc  ... cancel

      Case char = -82    ;Ins
        Or char = -83 :  ;Del
                        QuitLoop

      Case char = -72 : ;Up
        IF current > 1 THEN
          current = current -1
          NewPage = INT((current-1+ListLength)/ListLength)
            IF NewPage <> Page THEN
              ShowNewPage(NewPage,TC)
              Page = NewPage
            ENDIF
        ENDIF
        last_key =""      ;loop on [BackSpace]
        Home              ;to restart search
        Message FIELD()+" List - Page "+STRVAL(Page)+ " of "+STRVAL(LastPage)


      Case char = -80 : ;Down
        IF current <ArrayTotal THEN
          current = current +1
          NewPage = INT((current-1+ListLength)/ListLength)
            IF NewPage <> Page THEN
              ShowNewPage(NewPage,TC)
              Page = NewPage
            ENDIF
        ENDIF

        last_key =""      ;loop on [BackSpace]
        Home              ;to restart search
        Message FIELD()+" List - Page "+STRVAL(Page)+ " of "+STRVAL(LastPage)

      Case char = -71 :
        current = 1 ;home
        NewPage = INT((current+1+ListLength)/ListLength)
        IF Page <> 1 THEN
          current = 1
          ShowNewPage(NewPage,TC)
          Page = 1
        ENDIF
        last_key =""      ;loop on [BackSpace]
        Home              ;to restart search
        Message FIELD()+" List - Page "+STRVAL(Page)+ " of "+STRVAL(LastPage)


      Case char = -79 : ;End
        current = ArrayTotal
        IF Page <> LastPage THEN
          Page = LastPage
          ShowNewPage(Page,TC)
        ELSE
        ENDIF
        last_key =""      ;loop on [BackSpace]
        Home              ;to restart search
        Message FIELD()+" List - Page "+STRVAL(Page)+ " of "+STRVAL(LastPage)

      Case char = -81 : ;PgDn
        IF Page < LastPage THEN
          current = (Page * ListLength)+1
          Page = Page + 1
          ShowNewPage(Page,TC)

        ENDIF
        last_key =""      ;loop on [BackSpace]
        Home              ;to restart search
        Message FIELD()+" List - Page "+STRVAL(Page)+ " of "+STRVAL(LastPage)

      Case char = -73 : ;PgUp
        IF Page > 1 THEN
          current = ((Page-2) * (ListLength))+1
          Page = Page - 1
          ShowNewPage(Page,TC)
        ENDIF
        last_key =""      ;loop on [BackSpace]
        Home              ;to restart search
        Message FIELD()+" List - Page "+STRVAL(Page)+ " of "+STRVAL(LastPage)

      Case char =   8 : QuitLoop       ;BackSpace - clear <find_key>, restart

      Otherwise       : Beep           ;Illegal keys
    EndSwitch
  ;----------------------------------------------------------------
  EndWhile                             ;END OF LOOP TO DISPLAY MENU

  Return char                          ;send PAL keycode back to call

EndProc
writelib LIBNAME KeyCode_Menu
release procs KeyCode_menu
?? "."


; ---------------------------------------------------------------------------
;  Clear the popup window
; ---------------------------------------------------------------------------
proc ShowBorder()
  Style Attribute BC
  @ Start_Row,Start_Col ??   ""+ FILL("",ListWidth)+"Ŀ"
  @ Start_Row,Start_Col + 2 ?? "Find: "+ Field() +" "
  For i From Start_Row + 1 To End_Row - 1
    @ i,Start_Col ?? ""+ SPACES(ListWidth+2)+""
  EndFor
  @ End_Row,Start_Col   ??   ""+ FILL("",ListWidth)+""
  Style
  Message FIELD()+" List - Page "+STRVAL(Page)+ " of "+STRVAL(LastPage)
endproc

writelib LIBNAME ShowBorder
release procs ShowBorder
?? "."


; ---------------------------------------------------------------------------
; Scan in pop up window values to be called by pop waite
; ---------------------------------------------------------------------------
proc SetPopWaite()
MOVETO [Description]
  IF ISEMPTY ("PopUp") THEN
    EDITKEY
    [] = "Temporary Record"
    DO_IT!
  ENDIF
  Array PopUp[NRECORDS(TABLE())]                  ;array stores field values for menu
   ListWidth = 0
   Scan                    ; to a string value before assigning it
     PopUp[[#]] = Strval([])
     ListWidth = Max(Len(PopUp[[#]]),ListWidth)  ;Update max. width
   Endscan
endproc

writelib LIBNAME SetPopWaite
release procs SetPopWaite
?? "."





; ---------------------------------------------------------------------------
; Get category for education hours master table
; ---------------------------------------------------------------------------
proc GetPopWaite()
         Menu {ValCheck} {Define} Enter {TableLookup} {Popup} {JustCurrentField}
         {HelpAndFill}
         ;IMAGERIGHTS
         ECHO NORMAL
         PROMPT " Type in Who the Check is Made Out To and Press [Enter], Press [Esc] to Cancel ",
                " [BackSpace] Removes Search Keys: [Ins]ert New Record, [Del]ete Current Record"
         ECHO OFF

         HELP
         Zip_Menu(4,16,37)
         IF TABLE() = "Checks" OR TABLE() = "Auto" THEN
           RETURN TRUE
         ENDIF
         IF retval THEN
           DO_IT!
           Menu {ValCheck} {Clear} {Field} Enter
           Menu {ValCheck} {Define} Enter {Picture} TYPEIN "*{ ,.}!*{{ ,.}*{ ,.}!,@}"
           ENTER
           ENTER
           OldAmount = []
           PROMPT Prompt1,Prompt2
           RETURN TRUE
         ELSE
           Esc
           Menu {ValCheck} {Clear} {Field} Enter
           Menu {ValCheck} {Define} Enter {Picture} TYPEIN "*{ ,.}!*{{ ,.}*{ ,.}!,@}"
           ENTER
           PROMPT Prompt1,Prompt2
           RETURN TRUE
         ENDIF
endproc

writelib LIBNAME GetPopWaite
release procs GetPopWaite
?? "."

;------------------------------------------------------------------------------
; Draw current menu/value selection in reverse video:
;------------------------------------------------------------------------------
Proc HIGHLIGHT_BAR( color_value )
  Style Attribute color_value
  Window_Top = MOD(current+ListLength-1,ListLength) + Start_Row +1

  @ Window_Top, Start_Col+1
  menu_item = PopUp[current]
  ?? " " + menu_item + Spaces(ListWidth+1 - Len (menu_item))
EndProc
writelib LIBNAME HighLight_Bar
release procs HighLight_Bar
?? "."

; ---------------------------------------------------------------------------
; Paint a new page of the popup table onto the screen
; ---------------------------------------------------------------------------
proc ShowNewPage(NewPage,color_value)
Style Attribute color_value
RememberRecord = current
Window_Top = Start_Row + 1
current = (NewPage-1) * (ListLength)+1
CANVAS OFF
FOR i FROM 1 to ListLength
  @ Window_Top, Start_Col+1
  IF current <= ArrayTotal THEN
    menu_item = PopUp[current]
    ?? " " + menu_item + Spaces(ListWidth+1 - Len (menu_item))
  ELSE
    STYLE ATTRIBUTE TC
    ?? Spaces(ListWidth+2)

  ENDIF

  Window_Top = Window_Top +1
  current = current + 1
ENDFOR
CANVAS ON
current = RememberRecord
endproc

writelib LIBNAME ShowNewPage
release procs ShowNewPage
?? "."

; ---------------------------------------------------------------------------
; Routine for deleting a record from the popup table
; ---------------------------------------------------------------------------
proc DeletePopUpRecord()
BigMess("Deleting Record")
DeleteRecord = PopUp[current]
Esc
DO_IT!
FORMKEY
MOVETO [Popup->Description]
LOCATE DeleteRecord
EditKey
IF RETVAL THEN
  DEL
ENDIF
DO_IT!
SetPopWaite()
DownImage
FORMKEY
EditKey
HELP
endproc

writelib LIBNAME DeletePopUpRecord
release procs DeletePopUpRecord
?? "."
; ---------------------------------------------------------------------------
; Place a new record in the popup table
; ---------------------------------------------------------------------------
proc InsertPopUpRecord()

BEEP
LittleMess("[Esc]ape to Cancel")
@1,0 CLEAR EOL
@0,0 ?? "Enter the New Check Description... " CLEAR EOL
STYLE REVERSE
CURSOR BOX
ACCEPT "A31" PICTURE "*{ ,.}!*{{ ,.}*{ ,.}!,@}" REQUIRED
  TO Description
STYLE
CURSOR OFF
IF retval = FALSE THEN
  RETURN FALSE
ENDIF
Esc
Menu {ValCheck} {Clear} {Field} ENTER
[] = Description
;PROMPT Prompt1,Prompt2
;RETURN TRUE
DO_IT!
FORMKEY
MOVETO [Popup->Description]
EDITKEY
INS
[] = Description
DO_IT!
SetPopWaite()
DownImage
FORMKEY
EditKey
PROMPT PROMPT1,PROMPT2
RETURN TRUE

endproc

writelib LIBNAME InsertPopUpRecord
release procs InsertPopUpRecord
?? "."






;INFOLIB LIBNAME
