;Nick Waite  CompuServe[75056,513] Checks Program ver. 1.0  10/88
LIBNAME = "DoWaite"
CREATELIB LIBNAME

;==============================================================================
; PROC DoWaite() handles the editing portion of the program.
;
; During the editing phase, the table that records the checkbook function
; fills in the date which is recorded in the "Default" table (available from
; the main menu. If a complete date (both month and day) is in the "Default"
; table, the date will be completely filled in and move on through the automatic
; numbering phase. If the date is partial, it will pause on the date before
; automatic numbering is accomplished.  Because I use two different types of
; checks (those that I fill out by hand, and those that are printed) I have
; designed this program to number off of the previous numbered check.
;
; When you are reconsiling your bank statement, press the [F5] key.
; To locate the first record which has an "N" in the cancelled field.  If this
; is the record that the bank statement says it has received, [Alt F6] will change
; the "N" to "Y" and move you to the next item that needs to be reconsiled.
;
; * Note to new finance wizzards - the reconsiled amount is the amount the bank
;        says you have in your account. This will be the banks term of
;        -Ending Balance- on your bank statement. If you have distributed
;        checks, made deposites, or used a bank instateller for cash, then
;        these are checks outstanding, deposites outstanding, or instateller
;        outstanding. When you do the status function [Alt F10] while in
;        "EDIT" you will get all of this information as well as what your
;        Real Balance is.
;==============================================================================
PROC DoWaite()
PRIVATE FieldName,RememberTable,Nickey
PROMPT1 = " [F5] Sweep [F6] SweepNext      [Alt F6] Change N -> Y        [F2] When through "
PROMPT2 = " [Ins]ert New Record, [Del]ete Current Record "

EDITKEY
CheckNumber = [CheckNumber]
FORMKEY
WHILE TRUE
retval = TRUE
IF TABLE() <> "Default" THEN
  OldAmount = [Amount]
  OldCleared = [Cleared]
ENDIF
SWITCH
  CASE FIELD() = "Date" :
    A_Date()
  CASE FIELD() = "CheckNumber" :
    A_CheckNumber()
  CASE FIELD() = "Description" :
    A_Description()
ENDSWITCH
IF retval = FALSE THEN
  LOOP
ENDIF


CURSOR OFF
      WAIT FIELD PROMPT PROMPT1,PROMPT2
        UNTIL -60, ;DO_IT!
              -75, ;left
              -77, ;Right
              -65, ;"F7"
              -66, ;"F8"
              -67, ;"F9"
              -68, ;"F10"
              -81, ;"PgDn"
              -73, ;"PgUp"
              -83, ;"Del"
              -113,;"F40"
              -71, ;"Home"
              -79, ;"End"
              -109,;"F36"
              -59, ;"F1"
              -108,;"F35"
              -63, ;"F5"
              -64, ;"F6"
              -82, ;"Ins"
              -61, ;"F3",
              13,  ;enter
              -80, ;down
              -72  ;up
      Nickey = retval

      IF retval = -83 AND TABLE() = "Default" THEN ;del
        DEL
        MOVETO [Month]
        LOOP
      ENDIF

      ;need to catch alt F6 here
      IF Nickey = -109 AND FIELD() = "Cleared" AND [Cleared] = "N" AND
        ISASSIGNED(kgs_sweepval) THEN
        [Cleared] = "Y"
      ENDIF

     ;Depart Switch
      retval = TRUE
      SWITCH

        CASE FIELD() = "Amount" :
          IF [] <> OldAmount THEN
            D_Amount()
          ENDIF

        CASE FIELD() = "Date" :
          D_Date()
        CASE FIELD() = "CheckNumber" :
          D_CheckNumber()
        CASE FIELD() = "Description" :
          D_Description()
        CASE FIELD() = "Cleared" :
          D_Cleared()

        CASE FIELD() = "Day" :
          D_Day()
      ENDSWITCH
     ;Catch RETURN False from depart procedure and don't pass to keystrokes
     IF retval = FALSE THEN
       KeyChoice = FALSE
       LOOP
     ELSE
      KeyChoice = TRUE
     ENDIF

      SWITCH

        CASE Nickey = -83 : ;del
          Deleter()

        CASE Nickey = -82 : ;ins
          Inserter()


        CASE Nickey = 13  OR Nickey = -80  OR ;enter down
             Nickey = -72 OR Nickey = -75  OR ;right left
             Nickey = -77  : ;up
          IF KeyChoice THEN
            KeyPress Nickey
          ENDIF

        CASE Nickey = -61 : ;"F3"
          IF TABLE() = "Checks" AND FIELD() = "Description" THEN
            GetPopWaite()
            IF retval = FALSE THEN
              LOOP
            ENDIF

          ENDIF

        CASE Nickey = -63 : ;"F5"
          IMAGERIGHTS UPDATE
          Sweep()
          IMAGERIGHTS

        CASE Nickey = -108 : ;"F35"
          FieldView
          WAIT FIELD PROMPT "Insert Mode","[Enter] When through"
            UNTIL "Enter"

        CASE Nickey = -64 : ;"F6"
          IMAGERIGHTS UPDATE
          SweepNext()
          IMAGERIGHTS

        CASE Nickey = -59 : ;"F1"
          RememberTable = TABLE()
          MOVETO [Default->Month]


        CASE Nickey = -65 : ;"F7"
          MOVETO "Checks"
          CheckNumber = [CheckNumber]
          END
        CASE Nickey = -66 : ;"F8"
          MOVETO "Deposit"
          END
        CASE Nickey = -67 : ;"F9"
          MOVETO "Savings"
          END

        CASE Nickey = -68 : ;"F10"
          MOVETO "Insta"
          END

        CASE Nickey = -71 OR ;Home
             Nickey = -79 OR ;End
             Nickey = -73 OR ;PgUp
             Nickey = -81:   ;PgDn
             IF KeyChoice THEN
               IF TABLE() = "Checks" AND ATLAST() THEN
                 CheckNumber = [CheckNumber]
               ENDIF
               KeyPress Nickey
               CtrlHome
             ENDIF

        CASE Nickey = -113 : ;"F40" Status calculation routine
          RememberField = FIELD()
          RememberRecord = RECNO()
          RememberTable = TABLE()
          Do_It!
          GetStatus()
          MOVETO "Checks"
          EDITKEY
          FORMKEY
          MOVETO RememberTable
          MOVETO RECORD RememberRecord
          MOVETO FIELD RememberField


        CASE Nickey = -60 : ;"F2"
          IF TABLE() = "Default" THEN
;            MOVETO RememberTable
            LOOP
          ENDIF
          IF KeyChoice THEN
            DO_IT!
            CLEARALL
            CLEAR
            RETURN
          ENDIF


       CASE Nickey = -109 : ;"F36"
             IF FIELD() = "Cleared" THEN
               ; Balance and reconsile functions already taken care from above
               ; if approporiate
               SweepNext()
             ENDIF
      ENDSWITCH
      ENDWHILE
ENDPROC
writelib LIBNAME DoWaite
release procs DoWaite
?? "."


PROC MakeKey(FieldName)
PRIVATE nw
     nw =     ( (TODAY()-1/1/80) * 86400 ) +
              ( NUMVAL(SUBSTR(TIME(),1,2)) * 3600 ) +
              ( NUMVAL(SUBSTR(TIME(),4,2)) * 60 ) +
              ( NUMVAL(SUBSTR(TIME(),7,2)) +
                RAND() )
IF FieldName = "Key" THEN
  [Key] = nw
ELSE
  [CheckNumber] = nw
ENDIF
ENDPROC
WRITELIB LIBNAME MakeKey
RELEASE PROCS ALL




PROC GetStatus()
;PRIVATE TotalChecks,TotalTeller,TotalDeposites

          {Ask} {Checks} MOVETO [Amount] CHECKPLUS
          [Cleared] = "N"
          Do_It!
          RChecks = CSUM("Answer","Amount")
          ClearImage
          MOVETO "Checks(Q)"
          ClearImage

          {Ask} {Insta} MOVETO [Amount] CHECKPLUS
          [Cleared] = "N"
          Do_It!
          RInsta = CSUM("Answer","Amount")
          ClearImage
          MOVETO "Insta(Q)"
          ClearImage

          {Ask} {Deposit} MOVETO [Amount] CHECKPLUS
          [Cleared] = "N"
          Do_It!
          RDeposit = CSUM("Answer","Amount")
          ClearImage
          MOVETO "Deposit(Q)"
          ClearImage

          {Ask} {Savings} MOVETO [Amount] CHECKPLUS
          [Cleared] = "N"
          Do_It!
          RSavings = CSUM("Answer","Amount")
          ClearImage
          MOVETO "Savings(Q)"
          ClearImage

          TotalChecks    = CSUM("Checks","Amount")
          TotalInsta     = CSUM("Insta","Amount")
          TotalDeposit   = CSUM("Deposit","Amount")
          SetUp          = CSUM("Setup","Amount")

          Balance = (Setup+TotalDeposit)-(TotalInsta+TotalChecks)
          RBalance = (Setup+RDeposit)-(RChecks-RInsta)
          SBalance = CSUM("Savings","Amount")

ENDPROC
WRITELIB LIBNAME GetStatus
RELEASE PROCS GetStatus


; ---------------------------------------------------------------------------
; Program Main Menu
; ---------------------------------------------------------------------------
proc Main()
VIEW "Popup"
SetPopWaite()
CLEARIMAGE
GetDefault()
GetStatus()
@22,60 CLEAR EOL

WHILE TRUE

MenuText(1)

SHOWMENU
 "EDIT":"Edit Databases",
 "Auto":"Edit or Add Records From The Auto(matic) Database to the Checks Database",
 "Print":"Print Checks and Other Reports",
 "Maintenance":"Backup, Archive, Unarchive, Restructure, or SetUp Program Files",
 "Leave":"Leave the Application"
TO look
SWITCH
  CASE look = "EDIT":
      STYLE ATTRIBUTE 155
      @MenuRow+1,MenuCol
      ?? FORMAT("W35,ac","LOADING DATABASES")
      STYLE
      VIEW "Popup" VIEW "Checks"
      END
      DoWaite()

 ; CASE look = "DEFAULT":
 ;     DEFAULT()

  CASE look = "Auto":
    Auto()


  CASE look = "Print":
        PrintMenu()

  CASE look = "Maintenance":
        MaintenanceMenu()


  CASE look = "Leave":
    ;ByeBye()
    RETURN


ENDSWITCH
ENDWHILE
endproc

writelib LIBNAME Main
release procs Main
?? "."

; ---------------------------------------------------------------------------
; Determines the default date from the default table
; ---------------------------------------------------------------------------
proc GetDefault()
EDIT "Default"
CheckDate()
DO_IT!
CLEARIMAGE
endproc

writelib LIBNAME GetDefault
release procs GetDefault
?? "."

; ---------------------------------------------------------------------------
; Fills in default field values, keys, and runs date routine
; ---------------------------------------------------------------------------
proc A_Date()
IF (TABLE() = "Deposit" OR TABLE() = "Insta") AND (ISBLANK([])) THEN
   MakeKey("Key")
ENDIF
IF TABLE() = "Savings" AND ISBLANK([CheckNumber])  THEN
  MakeKey("CheckNumber")
ENDIF
IF ISBLANK([]) THEN
  [Cleared] = "N"
  TYPEIN DateField
  IF DateFill THEN ;UP
  ELSE
    WAIT FIELD Prompt " Complete Field then Press [Enter] "
      UNTIL 13,-83
      IF retval = -83 THEN ;delete
        Deleter()
        RETURN FALSE
      ENDIF
  ENDIF
  ENTER
  RETURN FALSE

ENDIF
endproc

writelib LIBNAME A_Date
release procs A_Date
?? "."

;A_CheckNumber
; ---------------------------------------------------------------------------
; Arrive procedure automaticaly fills in check numbers
; ---------------------------------------------------------------------------
proc A_CheckNumber()
PRIVATE test
IF ISBLANK([]) THEN
  CheckNumber = CheckNumber+1
  [] = CheckNumber
  DOWN
  ECHO NORMAL
  ECHO OFF

;  AzOkKey() ; Special routine for handling keyviolations in the
;            ; Checks table
;  IF retval THEN
;    DOWN
;    ECHO NORMAL
;    ECHO OFF
;  ENDIF
RETURN FALSE
ENDIF
endproc

writelib LIBNAME A_CheckNumber
release procs A_CheckNumber
?? "."

; ---------------------------------------------------------------------------
; Call by F3 to this routine - user wantes to fill in description field
; in the checks table
; ---------------------------------------------------------------------------
proc PopRoutine()
 IF TABLE() = "Checks" AND FIELD() = "Description" AND ISBLANK([]) THEN
    GetPopWaite()
;    IF NOT ISBLANK([]) THEN
;       ENTER
;    ENDIF
 ENDIF
endproc

writelib LIBNAME PopRoutine
release procs PopRoutine
?? "."

; ---------------------------------------------------------------------------
; keep user from moving up on a form while in the date field
; ---------------------------------------------------------------------------
proc D_Date()
IF Nickey = -72 OR Nickey = -75 THEN ;up left
  RETURN FALSE
ELSE
  RETURN TRUE
ENDIF
endproc

writelib LIBNAME D_Date
release procs D_Date
?? "."

; ---------------------------------------------------------------------------
; Check for key violation when leaving the CheckNumber field
; ---------------------------------------------------------------------------
proc D_CheckNumber()
IF ISBLANK([]) THEN
  RETURN FALSE
ENDIF
RETURN TRUE
;IF NewData THEN
;  AzOkKey() ; Special routine for handling keyviolations in the
;            ; Checks table
;ENDIF
endproc

writelib LIBNAME D_CheckNumber
release procs D_CheckNumber
?? "."

; ---------------------------------------------------------------------------
; Depart procedure which keeps the user from moving down while in
; the Cleared field
; ---------------------------------------------------------------------------
proc D_Cleared()
IF ISBLANK([]) THEN
  [] = "N"
ENDIF

IF [] <> OldCleared THEN
;Check switch considers new cleared field = "N" (not cleared) -> redice "R"strings
SWITCH
  CASE TABLE() = "Checks" :
    IF [Cleared] = "N" THEN
      RChecks = RChecks + [Amount]
    ELSE
      RChecks = RChecks - [Amount]
    ENDIF

  CASE TABLE() = "Insta" :
    IF [Cleared] = "N" THEN
      RInsta = RInsta + [Amount]
    ELSE
      RInsta = RInsta - [Amount]
    ENDIF

  CASE TABLE() = "Deposit" :
    IF [Cleared] = "N" THEN
      RDeposit = RDeposit + [Amount]
    ELSE
      RDeposit = RDeposit - [Amount]
    ENDIF

  CASE TABLE() = "Savings" :
    IF [Cleared] = "N" THEN
      RSavings = RSavings + [Amount]
    ELSE
      RSavings = RSavings - [Amount]
    ENDIF

ENDSWITCH
ENDIF
IF Nickey = 13 OR Nickey = -80 OR Nickey = -77 THEN ;enter down right
  RETURN FALSE
ENDIF
RETURN TRUE
endproc

writelib LIBNAME D_Cleared
release procs D_Cleared
?? "."

; ---------------------------------------------------------------------------
; Depart procedure which keeps user from moving up while in the auto
; table
; ---------------------------------------------------------------------------
proc D_Description()
;Menu {ValCheck} {Clear} {Field} Enter
IF ISBLANK([Cleared]) THEN
  [Cleared] = "N"
ENDIF
RETURN TRUE
endproc

writelib LIBNAME D_Description
release procs D_Description
?? "."

; ---------------------------------------------------------------------------
; Call the popup routine if the description field in the checks table is
; blank
; ---------------------------------------------------------------------------
proc A_Description()
IF ISBLANK([]) AND TABLE() <> "Deposit" THEN
  GetPopWaite()
  IF retval = FALSE THEN
    RETURN FALSE
  ENDIF
ENDIF
endproc

writelib LIBNAME A_Description
release procs A_Description
?? "."

; ---------------------------------------------------------------------------
; Double check users request to delete a record
; ---------------------------------------------------------------------------
proc Deleter()
PRIVATE safe
  BEEP
  SHOWMENU
    "NO":"Do not delete this record",
    "YES":"Delete this Record" TO safe
     SWITCH
       CASE safe = "NO":
         RETURN TRUE
       CASE safe = "YES":
         [Amount] = 0
         D_Amount()
         DEL
         CtrlHome
         IF TABLE() = "Checks" THEN
           CheckNumber = [CheckNumber]
         ENDIF
         ;ArriveProc = FALSE
         RETURN TRUE
       ENDSWITCH
endproc

writelib LIBNAME Deleter
release procs Deleter
?? "."

;;==============================================================================
;; PROC DEFAULT() Sets up the default day that is used when creating new checks,
;; and Printing checks.  If you are adding old check records to the checks
;; table, you may only want the month to be entered into the default table.
;; This will cause the program to fill in the month with a "/" so you only have
;; to enter the day [Enter].  This speeds up the processing of adding old hand
;; written checks.  Then change to the default to todays date (or anyother date)
;; to do your batch of checks that are written on the same day.  I do this when
;; I'm data entering checks I am going to print.
;;==============================================================================
;PROC Default()
;EDIT "Default"
;FORMKEY
;WHILE TRUE
;  WAIT RECORD PROMPT " [F2] When through",
;                     " "
;
;  UNTIL "F2", "Del" , "Ins"
;    SWITCH
;      CASE retval = "Del":
;        DEL
;
;      CASE retval = "Ins":
;        [Month] = STRVAL(MONTH(TODAY()))
;        [Day] = STRVAL(DAY(TODAY()))
;
;      CASE retval = "Esc":
;        DO_IT!
;        CLEARIMAGE
;        CLEAR
;        RETURN
;      CASE retval = "F2":
;          CheckDate()
;          DO_IT!
;          CLEARIMAGE
;          CLEAR
;          RETURN
;    ENDSWITCH
;
;ENDWHILE
;
;ENDPROC
;WriteLib LIBNAME Default
;RELEASE PROCS Default

; ---------------------------------------------------------------------------
; Depart day field in default table
; ---------------------------------------------------------------------------
proc D_Day()
IF ISASSIGNED(Nickey) THEN
  IF Nickey = -75 THEN ;left
    LEFT
    RETURN FALSE
  ENDIF
ENDIF
IF Nickey = -83 THEN   ;delete
  DEL
ENDIF
CheckDate()
IF ISASSIGNED(RememberTable) THEN
  MOVETO RememberTable
ENDIF
RETURN FALSE
endproc

writelib LIBNAME D_Day
release procs D_Day
?? "."

;; ---------------------------------------------------------------------------
;; Move from month field to day field in the default table
;; ---------------------------------------------------------------------------
;proc D_Month()
;IF Nickey = -77 OR Nickey = 13 THEN   ;right enter
;  RIGHT
;ELSE
;  CheckDate()
;ENDIF
;RETURN FALSE
;endproc
;
;writelib LIBNAME D_Month
;release procs D_Month
;?? "."

; ---------------------------------------------------------------------------
; Figures out if the date values in the default table are ok
; ---------------------------------------------------------------------------
proc CheckDate()
IF NOT ISBLANK([Month]) AND NOT ISBLANK([Day]) THEN
  DateField = [Month]+"/"+[Day]+"/"+ SUBSTR(STRVAL(YEAR(TODAY())),3,2)
  DateFill = TRUE
ENDIF
IF ISBLANK([Month]) THEN
  DateField = ""
  DateFill = FALSE
ENDIF
IF ISBLANK([Day]) AND NOT ISBLANK([Month])THEN
  DateField = [Month]+"/"
  DateFill = FALSE
ENDIF

endproc

writelib LIBNAME CheckDate
release procs CheckDate
?? "."




; ---------------------------------------------------------------------------
; See if it is ok to insert depending on whether the user is in the checks
; table of the default table
; ---------------------------------------------------------------------------
proc Inserter()
IF TABLE() = "Default" THEN
  [Month] = STRVAL(MONTH(TODAY()))
  [Day] = STRVAL(DAY(TODAY()))
  RETURN
ENDIF
IF TABLE() = "Checks" THEN
  CheckNumber = [CheckNumber]
ENDIF
PGDN
IF ATLAST() AND ISBLANK([Date]) THEN
  ;moved past the end - no need to insert
  CtrlHome
ELSE
  INS
  CtrlHome
ENDIF

endproc

writelib LIBNAME Inserter
release procs Inserter
?? "."


; ---------------------------------------------------------------------------
; Data has been changed in amount field - need to update reconsiliation
; and or balance
; ---------------------------------------------------------------------------
proc D_Amount()

SWITCH
  CASE TABLE() = "Checks" :
    IF [Cleared] = "N" THEN
      RChecks = RChecks - OldAmount + [Amount]
    ENDIF
    Balance = Balance + OldAmount - [Amount]
    TotalChecks = TotalChecks - OldAmount + [Amount]
  CASE TABLE() = "Insta" :
    IF [Cleared] = "N" THEN
      RInsta = RInsta - OldAmount + [Amount]
    ENDIF
    Balance = Balance + OldAmount - [Amount]
    TotalInsta = TotalInsta - OldAmount + [Amount]

  CASE TABLE() = "Deposit" :
    IF [Cleared] = "N" THEN
      RDeposit = RDeposit - OldAmount + [Amount]
    ENDIF
    Balance = Balance - OldAmount + [Amount]
    TotalDeposit = TotalDeposit - OldAmount + [Amount]

  CASE TABLE() = "Savings" :
    IF [Cleared] = "N" THEN
      RSavings = RSavings - OldAmount + [Amount]
    ENDIF
    SBalance = SBalance - OldAmount + [Amount]

ENDSWITCH
RETURN TRUE
endproc

writelib LIBNAME D_Amount
release procs D_Amount
?? "."



infolib LIBNAME
