;Nick Waite  CompuServe[75056,513] Checks Program ver. 1.0  10/88
LIBNAME = "Utility"
CREATELIB LIBNAME

; ---------------------------------------------------------------------------
; This proc creates the menu splash screen
; ---------------------------------------------------------------------------
proc MenuText(MenuMessage)
PRIVATE MenuMessage

MenuRow = 13   ;initialize varable which indicates menu row information
MenuCol = 23   ;initialize varable which indicates menu column information
CANVAS OFF
SETMARGIN 4
STYLE ATTRIBUTE 91
   @3,0
   TEXT

߱
                                                               
  
                                                             

ı
                                                        
                                           ı
                                                                
                                           ı
                                                                
                                           ı
                                                                
ı
                                                        
ı

ENDTEXT
STYLE ATTRIBUTE 27
@21,4 ?? FORMAT("w72"," No Copy Right Intended                               Nick Waite  VPHS")
@22,4 ?? FORMAT("w72"," No Rights Reserved ")
STYLE ATTRIBUTE 79
@4,9 ?? FILL(CHR(223),61)
@5,9 ?? FORMAT("w63,ac","EZ-FINANCIAL SYSTEM")
@6,9 ?? FILL(CHR(220),61)


STYLE ATTRIBUTE 112
@5,70 ??  FILL(CHR(219),2)
@6,70 ??  FILL(CHR(219),2)
@7,11 ??  FILL(CHR(219),61)

@10,19 ?? FILL(CHR(223),43)
@11,19 ?? "  "+FILL(CHR(205),37)+"  "

FOR X FROM 12 TO 15
@X,19 ?? "  "+SPACES(37)+"  "
ENDFOR

@16,19 ?? "  "+FILL(CHR(205),37)+"  "
@17,19 ?? FILL(CHR(220),43)

STYLE ATTRIBUTE 27
@12,23 ?? SPACES(35)
@15,23 ?? SPACES(35)


@MenuRow+1,MenuCol
?? FORMAT("W35,ac","Public Domain Version 5.0")
@MenuRow,MenuCol
style
SWITCH
  CASE MenuMessage = 1:
     ?? FORMAT("w35,ac","MAIN MENU")
     LittleMess(strval(MEMLEFT()) + " Bytes of Memory Left")

  CASE MenuMessage = 2:
     ?? FORMAT("w35,ac","PRINT MENU")
     LittleMess("[Esc]ape to Return to Main Menu")

ENDSWITCH

CANVAS ON

;==============================================================================
; I like to keep track of what my memory alocation.  It helps me decided
; when to break a routine into smaller units (Procedures) in order to save
; memory for the real work at hand.
;==============================================================================
endproc

writelib LIBNAME MenuText
release procs MenuText
?? "."



PROC BigMess ( msg )                     ; Procedure for generating messages
PRIVATE msg
   CURSOR OFF
   @ 22, position clear EOL
   position = 80 - len (" " +  msg + "...")
   style reverse
   @ 22, position ?? " " + msg
   style reverse, blink
                  ??  "..."
   style

ENDPROC
Writelib "Utility" BigMess
RELEASE PROCS ALL

PROC LittleMess ( msg )                     ; Procedure for generating messages
PRIVATE msg
   CURSOR OFF
   @ 22, position clear EOL
   position = 80 - len (" " +  msg +" " )
   style reverse
   @ 22, position ?? " " + msg + " "
   style

ENDPROC
Writelib "Utility" LittleMess
RELEASE PROCS ALL

PROC Sweep()

;--------------------------------------------------------;
; fieldview behaves strangely at times                   ;
; so just don't deal with it                             ;
; paradox ver2 ctrl-z "zoom" doesn't work with it either ;
;--------------------------------------------------------;
IF ISFIELDVIEW()
  THEN
    BEEP
    MESSAGE "Press Enter to leave FieldView"
    SLEEP 3000
    RETURN
ENDIF
;-----------------------------;
;intialize variable           ;
;-----------------------------;
IF NOT ISASSIGNED(kgs_sweepval)
  THEN kgs_sweepval = ""
ENDIF
formchk=""        ;initalize formview flag

;----------------------------------------;
;check if image is in form or table view ;
;----------------------------------------;
;IF ISFORMVIEW() OR ISMULTIFORM(TABLE(),FORM())
;  THEN
;    formchk = "Y"
;    FORMKEY
;ENDIF
fld=FIELD()       ;get current field
CtrlEnd           ;go to last field
lastfld = FIELD() ;get last field

MOVETO FIELD fld  ;move back to current field

;-----------------------;
;prompt for a value.    ;
;-----------------------;
@0,0 ?? "Value: " CLEAR EOL
@1,0 ?? "Enter value or value with pattern(..) to search for" CLEAR EOL
@0,8

;---------------------------------------------------------------------------;
;I put the previously searched value as a default but if you wish to        ;
;disable this, eliminate the DEFAULT statement                              ;
;---------------------------------------------------------------------------;
CURSOR NORMAL      ;turn on cursor for input
;ACCEPT "A54" PICTURE "*@" DEFAULT STRVAL(kgs_sweepval)
ACCEPT "A54" PICTURE "*{ ,.}!*{{ ,.}*{ ,.}!,@}" DEFAULT STRVAL(kgs_sweepval)

 TO kgs_sweepval
CURSOR OFF
;------------------------------------------------;
;if user presses ESC then return to paradox      ;
;------------------------------------------------;
IF retval = FALSE
  THEN
    IF formchk = "Y"
      THEN FORMKEY
    ENDIF
  RETURN
ENDIF
;-----------------------------;
;move to first field in image ;
;-----------------------------;
;MOVETO [#]
CTRLHOME
;----------------------------------------------------------------------------;
;This section will put up a "Pop-Up" window on the screen, just comment      ;
;this out if you don't want to use it.  You can re-position the window by    ;
;changing these two row and column numbers                                   ;
;----------------------------------------------------------------------------;
rw=6   ;set row for upper egde of window
cl=16  ;set column for left edge of window
IF MONITOR() = "Color"
  THEN STYLE ATTRIBUTE 79
  ELSE STYLE REVERSE
ENDIF
@rw,cl   ?? "                                               "
@rw+1,cl ?? "  Searching                                    "
@rw+2,cl ?? "                                               "
STYLE ATTRIBUTE 207
@rw+1,cl+11 ?? "..."
IF MONITOR() = "Color"
  THEN STYLE ATTRIBUTE 0
       @rw+3,cl+1 ?? ""
       STYLE ATTRIBUTE 0
       @rw+1,cl+47 ?? ""
       @rw+2,cl+47 ?? ""
ENDIF
IF MONITOR() = "Color"
  THEN STYLE ATTRIBUTE 79
  ELSE STYLE REVERSE
ENDIF
@rw+1,cl+15 ?? FORMAT("W32,AC",FIELD())
;----------------------------------------------------------------------------;
;This FOR loop moves through all the fields, starting with the first field,  ;
;until the value is located.  Every time there is a move to the next field,  ;
;the fieldtype is checked.  An attempt is made to convert the value to the   ;
;current fieldtype. If this attempt fails it moves on to the next field.     ;
;If the types match, then a LOCATE is done on that field, placing the cursor ;
;on the record, highlighting the value if appropriate, and exiting the loop. ;
;If there is NO matching value found in that field then we move on to the    ;
;next field until all the fields have been searched.                         ;
;----------------------------------------------------------------------------;
CURSOR OFF
i=1
FOR i FROM i TO NFIELDS(TABLE())
  CURSOR OFF

  ;updates search window with field that is currently being searched
  @rw+1,cl+15 ?? FORMAT("W32,AC",FIELD())

  ;puts displays field currently beign searched in status line
  ;at bottom of screen.  This is an alternative to the "pop-up" window
  ;STYLE REVERSE
  ;@24,0 ?? " "+SPACES(14)+"Searching: "
  ;@24,27 ?? FORMAT("W30,AC", FIELD())+SPACES(21)+" "

  CURSOR OFF
  ;------------------------------------------------------;
  ;Convert kgs_sweepval back to a string if necessary    ;
  ;------------------------------------------------------;
  IF SUBSTR(TYPE(kgs_sweepval),1,1) <> "A"
    THEN kgs_sweepval = STRVAL(kgs_sweepval)
  ENDIF
  ;------------------------------------------------------------------;
  ;this switch/case is the section that does the data type checking, ;
  ;locating & conversion and is the most important part of the code  ;
  ;------------------------------------------------------------------;
  SWITCH
    CASE SUBSTR(FIELDTYPE(),1,1) = "A" : LOCATE PATTERN kgs_sweepval
    CASE (FIELDTYPE() = "N") OR (FIELDTYPE() = "S") :
      IF NUMVAL(kgs_sweepval) = "Error"
        THEN
          retval = FALSE
          IF FIELD() <> lastfld
            THEN RIGHT LOOP
          ENDIF
        ELSE
          kgs_sweepval = NUMVAL(kgs_sweepval)
          LOCATE kgs_sweepval
      ENDIF
    CASE FIELDTYPE() = "D" :
      IF DATEVAL(kgs_sweepval) = "Error"
        THEN
          retval = FALSE
          IF FIELD() <> lastfld
            THEN RIGHT LOOP
          ENDIF
        ELSE
          kgs_sweepval = DATEVAL(kgs_sweepval)
          LOCATE kgs_sweepval
      ENDIF
    CASE FIELDTYPE() = "$" :
      IF NUMVAL(kgs_sweepval) = "Error"
        THEN
          retval = FALSE
          IF FIELD() <> lastfld
            THEN RIGHT LOOP
          ENDIF
        ELSE
          kgs_sweepval = NUMVAL(kgs_sweepval)
          LOCATE kgs_sweepval
      ENDIF
  ENDSWITCH
  CURSOR OFF
  ;---------------------------------------------------------------------;
  ;The following section is mostly here to imitate the reverse video    ;
  ;highlighting that Ctrl-Z does in Paradox when a record is located.   ;
  ;This section handles some of the stange things involved with the     ;
  ;way FieldView behaves and handles situations where a column has      ;
  ;been narrowed in the display image (form or table view) with the     ;
  ;Image menu choice.  If some of the code seems obscure, stepping      ;
  ;through it with the debugger will show what is going on.             ;
  ;---------------------------------------------------------------------;
  SWITCH
    CASE retval = TRUE :
;      IF formchk = "Y"       ;switch back to form view if necessary
;        THEN FORMKEY
;      ENDIF
      SYNCCURSOR
      FIELDVIEW
      rightcol = COL()
      HOME
      SYNCCURSOR
      leftcol = COL()
      ENTER
      Menu  ;this bit of weirdness is because fieldview leaves the value
      Esc   ;on the workplace "shifted": moving the cursor behind the scenes
            ;restores it to its normal postion in the field
      SYNCCURSOR
      IF (leftcol = rightcol) OR FIELDTYPE() = "N"
        THEN
          STYLE REVERSE    ;if the display image was narrowed to the point
          ?? " "           ;of value truncation or if the field is numeric
          SLEEP 100        ;it's not worth the trouble to do the reverse
          STYLE            ;highlighting on the entire value so just put
          RETURN           ;up a simple blip
        ELSE
          CURSOR OFF
          ;this is where the reverse video display stuff is done
          STYLE REVERSE
          SWITCH
            ;too much hassle with N fields to bother
            ;with display stuff, just locate
            CASE FIELDTYPE() = "N" :
            CASE FIELDTYPE() = "$" :
              SYNCCURSOR
              @ ROW(), (COL()-3)-LEN([])
              ?? FILL(" ",LEN([])+3)
              @ ROW(), (COL()-3)-LEN([])
              ?? []
            OTHERWISE:
              SYNCCURSOR
              @ ROW(), COL()-LEN([])
              ?? FILL(" ",LEN([]))
              @ ROW(), COL()-LEN([])
              ?? []
          ENDSWITCH
          SLEEP 100
          STYLE
          RETURN
      ENDIF
    CASE retval = FALSE :
      IF FIELD() = lastfld
        THEN
            CTRLHOME            ;I'm doing this rather than a simple
          WHILE FIELD() <> fld  ;"moveto field fld" because this will
            RIGHT               ;restore the image exactly the way it was

          ENDWHILE              ;more often
          IF formchk = "Y"
            THEN FORMKEY
          ENDIF
          ;----------------------------------------------------------------;
          ;This will "pop-up" an overlapping window with a Match not found ;
          ;message                                                         ;
          ;----------------------------------------------------------------;
          CURSOR OFF
          IF MONITOR() = "Color"
            THEN STYLE ATTRIBUTE 48
            ELSE STYLE REVERSE
          ENDIF
          @rw+2,cl+6 ?? "                                                   "
          @rw+3,cl+6 ?? "   Match not found:                                "
          @rw+4,cl+6 ?? "                                                   "
          IF MONITOR() = "Color"
            THEN
              STYLE ATTRIBUTE 0
              @rw+5,cl+7 ?? ""
              STYLE ATTRIBUTE 0
              @rw+3,cl+57 ?? ""
              @rw+4,cl+57 ?? ""
          ENDIF
          IF MONITOR() = "Color"
            THEN STYLE ATTRIBUTE 48
            ELSE STYLE REVERSE
          ENDIF
          @rw+3,cl+26 ?? FORMAT("W30,AC",kgs_sweepval)
          BEEP
          SLEEP 2000
          STYLE
          RETURN
        ELSE
          RIGHT
      ENDIF
  ENDSWITCH
ENDFOR
CURSOR OFF
ENDPROC
WRITELIB LIBNAME Sweep
RELEASE PROCS Sweep


PROC sweepnext()
CURSOR OFF
;------------------------------------------------------------;
; Make sure variable carried over from Sweep.sc is available ;
;------------------------------------------------------------;
IF NOT ISASSIGNED(kgs_sweepval)
  THEN
    @24,66 CLEAR EOL
    STYLE REVERSE
    @24,53 ?? " No Sweep value specified "
    STYLE
    SLEEP 3000
    RETURN
ENDIF
;------------------------------------------------------;
; fieldview behaves strangely at times                 ;
; so just won't deal with it                           ;
; paradox ver2 ctrl-z "zoom" won't work with it either ;
;------------------------------------------------------;
IF ISFIELDVIEW()
  THEN
    BEEP
    MESSAGE "Press Enter to leave FieldView"
    SLEEP 3000
    RETURN
ENDIF

formchk=""           ;initalize formview flag
first_fld_search=""  ;initalize first time field search flag

;----------------------------------------;
;check if image is in form or table view ;
;----------------------------------------;

;UNLOCKRECORD
;IF ISFORMVIEW() OR ISMULTIFORM(TABLE(),FORM()) THEN
;    formchk = "Y"
;    FORMKEY
;ENDIF

;IF FIELD() = "#"  ;no point searching for next occurence
;  THEN RIGHT
;ENDIF


fld = FIELD()        ;get current field
last_recno = RECNO() ;get current recno()
CtrlEnd              ;go to last field
lastfld = FIELD()    ;get last field
;MOVETO [#]           ;better visual results than moving directly
MOVETO FIELD fld     ;to field (in table view)

;----------------------------------------------------------------------------;
;This section will put up a "Pop-Up" window on the screen, just comment      ;
;this out if you don't want to use it.  You can re-position the window by    ;
;changing these two row and column numbers                                   ;
;----------------------------------------------------------------------------;
rw=6  ;set row for upper egde of window
cl=16  ;set column for left edge of window
IF MONITOR() = "Color"
  THEN STYLE ATTRIBUTE 79
  ELSE STYLE REVERSE
ENDIF
@rw,cl   ?? "                                               "
@rw+1,cl ?? "  Searching:                                   "
@rw+2,cl ?? "                                               "
STYLE ATTRIBUTE 207
@rw+1,cl+11 ?? "..."
IF MONITOR() = "Color"
  THEN STYLE ATTRIBUTE 0
       @rw+3,cl+1 ?? ""
       STYLE ATTRIBUTE 0
       @rw+1,cl+47 ?? ""
       @rw+2,cl+47 ?? ""
ENDIF
IF MONITOR() = "Color"
  THEN STYLE ATTRIBUTE 79
  ELSE STYLE REVERSE
ENDIF
@rw+1,cl+15 ?? FORMAT("W32,AC",FIELD())

;----------------------------------------------------------------------------;
;This is the main loop for continuing the sweep of the table.  It starts at  ;
;current cursor location and goes until the last field of the current image  ;
;is searched.  It's basically like Sweep but there is a SKIP to the next     ;
;record if it's the same field.  If it's performing the first LOCATE         ;
;in a field, it has to avoid the SKIP or the first record won't be included  ;
;in the search                                                               ;
;----------------------------------------------------------------------------;

WHILE (FIELD() <> "#")
  CURSOR OFF
  ;updates search window with field that is currently being searched
  @rw+1,cl+15 ?? FORMAT("W32,AC",FIELD())

  ;------------------------------------------------------;
  ;Convert kgs_sweepval back to a string if necessary    ;
  ;------------------------------------------------------;
  IF SUBSTR(TYPE(kgs_sweepval),1,1) <> "A"
    THEN kgs_sweepval = STRVAL(kgs_sweepval)
  ENDIF
  CURSOR OFF
  ;------------------------------------------------------------------;
  ;this switch/case is the section that does the data type checking, ;
  ;locating & conversion and is the most important part of the code  ;
  ;------------------------------------------------------------------;
  SWITCH
    CASE ATLAST() :   ;if you're at the end there's no point searching
      retval = FALSE  ;anymore
    CASE SUBSTR(FIELDTYPE(),1,1) = "A" :
      IF first_fld_search = "Y"
        THEN
          LOCATE NEXT PATTERN kgs_sweepval
          first_fld_search = "N"
        ELSE
          SKIP                             ;skip to next record
          LOCATE NEXT PATTERN kgs_sweepval ;then use locate pattern command
      ENDIF                                ;for non-case sensitive search
    CASE (FIELDTYPE() = "N") OR (FIELDTYPE() = "S") : ;convert search string
      IF NUMVAL(kgs_sweepval) = "Error"  ;if it can't be converted
        THEN
          retval = FALSE
          IF FIELD() <> lastfld
            THEN
              RIGHT                     ;then move on to top of next field
              HOME
              first_fld_search = "Y"
              LOOP
          ENDIF
        ELSE
          kgs_sweepval = NUMVAL(kgs_sweepval) ;if it can be converted here
          IF first_fld_search = "Y"
            THEN
              LOCATE NEXT kgs_sweepval        ;then locate
              first_fld_search = "N"
            ELSE
              SKIP
              LOCATE NEXT kgs_sweepval
          ENDIF
      ENDIF
    CASE FIELDTYPE() = "D" :               ;convert search string to date
      IF DATEVAL(kgs_sweepval) = "Error"    ;if you can't convert it
        THEN
          retval = FALSE
          IF FIELD() <> lastfld
            THEN
              RIGHT                        ;then move on to top of next field
              HOME
              first_fld_search = "Y"
              LOOP
          ENDIF
        ELSE
          kgs_sweepval = DATEVAL(kgs_sweepval)
          IF first_fld_search = "Y"
            THEN
              LOCATE NEXT kgs_sweepval
              first_fld_search = "N"
            ELSE
              SKIP
              LOCATE NEXT kgs_sweepval
          ENDIF
      ENDIF
    CASE FIELDTYPE() = "$" :               ;same as above for currency field
      IF NUMVAL(kgs_sweepval) = "Error"
        THEN
          retval = FALSE
          IF FIELD() <> lastfld
            THEN
              RIGHT
              HOME
              first_fld_search = "Y"
              LOOP
          ENDIF
        ELSE
          kgs_sweepval = NUMVAL(kgs_sweepval)
          IF first_fld_search = "Y"
            THEN
              LOCATE NEXT kgs_sweepval
              first_fld_search = "N"
            ELSE
              SKIP
              LOCATE NEXT kgs_sweepval
          ENDIF
      ENDIF
  ENDSWITCH
  CURSOR OFF
  ;---------------------------------------------------------------------;
  ;The following section is mostly here to imitate the reverse video    ;
  ;highlighting that Ctrl-Z does in Paradox when a record is located.   ;
  ;This section handles some of the stange things involved with the     ;
  ;way FieldView behaves and handles situations where a column has      ;
  ;been narrowed in the display image (form or table view) with the     ;
  ;Image menu choice.  If some of the code seems obscure, stepping      ;
  ;through it with the debugger will show what is going on.             ;
  ;---------------------------------------------------------------------;
  SWITCH
    CASE retval = TRUE :
      IF formchk = "Y"
        THEN FORMKEY
      ENDIF
      SYNCCURSOR
      FIELDVIEW
      leftcol = COL()
      HOME
      SYNCCURSOR
      rightcol = COL()
      ENTER
      Menu  ;this bit of weirdness is because fieldview leaves the value
      Esc   ;on the workplace "shifted" moving the cursor behind the scenes
            ;restores it
      SYNCCURSOR
      IF (leftcol = rightcol) OR FIELDTYPE() = "N"
        THEN
          STYLE REVERSE  ;if the display image was narrowed to the point
          ?? " "         ;of truncation or if the field is numeric
          SLEEP 100      ;it's not worth the trouble to do the reverse
          STYLE          ;highlighting on the entire value so I just put
          RETURN         ;up a simple blip
        ELSE
          CURSOR OFF
          ;this is where the reverse video display stuff is done
          STYLE REVERSE
          SWITCH
            ;too much hassle with N fields to bother
            ;with display stuff, just locate
            CASE FIELDTYPE() = "N" :
            CASE FIELDTYPE() = "$" :
              @ ROW(), (COL()-3)-LEN([])
              ?? FILL(" ",LEN([])+3)
              @ ROW(), (COL()-3)-LEN([])
              ?? []
            OTHERWISE:
              @ ROW(), COL()-LEN([])
              ?? FILL(" ",LEN([]))
              @ ROW(), COL()-LEN([])
              ?? []
          ENDSWITCH
          SLEEP 300
          STYLE
          RETURN
      ENDIF
    CASE retval = FALSE :
      IF FIELD() = lastfld
        THEN
;          MOVETO [#]            ;I'm doing this rather than a simple
          CTRLHOME
          WHILE FIELD() <> fld  ;"moveto field fld" because this will
            RIGHT               ;restore the image exactly the way it was
          ENDWHILE              ;more often
          MOVETO RECORD last_recno
          IF formchk = "Y"
            THEN FORMKEY
          ENDIF
          CURSOR OFF

          ;----------------------------------------------------------------;
          ;This will "pop-up" an overlapping window with a Match not found ;
          ;message                                                         ;
          ;----------------------------------------------------------------;
          IF MONITOR() = "Color"
            THEN STYLE ATTRIBUTE 48
            ELSE STYLE REVERSE
          ENDIF
          @rw+2,cl+6 ?? "                                                   "
          @rw+3,cl+6 ?? "   Match not found:                                "
          @rw+4,cl+6 ?? "                                                   "
          BEEP
          IF MONITOR() = "Color"
            THEN
              STYLE ATTRIBUTE 0
              @rw+5,cl+7 ?? ""
              STYLE ATTRIBUTE 0
              @rw+3,cl+57 ?? ""
              @rw+4,cl+57 ?? ""
          ENDIF
          IF MONITOR() = "Color"
            THEN STYLE ATTRIBUTE 48
            ELSE STYLE REVERSE
          ENDIF
          @rw+3,cl+26 ?? FORMAT("W30,AC",kgs_sweepval)
          SLEEP 2000
          STYLE
          RETURN
        ELSE
          RIGHT
          HOME
          first_fld_search = "Y" ;set flag for first time search in next field
      ENDIF
  ENDSWITCH
ENDWHILE
ENDPROC
WRITELIB LIBNAME SweepNext
RELEASE PROCS SweepNext


;==============================================================================
; PROC SETUP() Establishes the amount that you started with in your checking
; account.  This is amount is used to calculate your checking account
; status.
;==============================================================================
PROC SetUpTable()
LittleMess("[Esc]ape to Return to Main Menu")
@1,0 ?? "Enter the Checking Account Starting Amount" CLEAR EOL
@0,0 ?? "Value: " CLEAR EOL
STYLE REVERSE
CURSOR BOX      ;turn on cursor for input

ACCEPT "$" DEFAULT SetUp REQUIRED
 TO SetUp

@0,0  CLEAR EOL
@1,0  CLEAR EOL
CURSOR OFF
STYLE
IF retval = FALSE THEN
  RETURN
ELSE
  EDIT "SetUp"
  [Amount] = SetUp
  DO_IT!
  CLEARIMAGE
  BigMess("Recalculating Stats")
  GetStatus()
ENDIF
ENDPROC
WriteLib LIBNAME SetUpTable
RELEASE PROCS SetupTable

; ---------------------------------------------------------------------------
; Archive all information in the subdirectory into a zip file
; ---------------------------------------------------------------------------
proc MaintenanceMenu()
@MenuRow,MenuCol
?? FORMAT("W35,ac","MAINTENANCE MENU")

LittleMess("[Esc]ape to Return to Main Menu")
  SHOWMENU
    "BackUp" : "BackUp Databases",
    "Archive" : "Archive old records that have been Cleared",
    "UnArchive" : "UnArchive old records that have been Cleared",
    "Restructure" : "Restructure (Give Back Disk Space) Databases",
    "SetUp":"Enter the Amount You Are Starting With In Your Checking Account"

  TO test
  SWITCH
    CASE test = "Esc":

    CASE test = "Archive":
      DoArchive()

    CASE test = "UnArchive":
      Unarchive()

    CASE test = "BackUp":
      @MenuRow+1,MenuCol
      ?? FORMAT("W35,ac","BackUp Routine")
      SETDIR SDIR()
      RUN "PKARC U BANK *.*"
      CopyFile()

    CASE test = "SetUp":
      SetUpTable()

    CASE test = "Restructure":
      DoRestructure()

  ENDSWITCH
endproc

writelib LIBNAME MaintenanceMenu
release procs MaintenanceMenu
?? "."
;==============================================================================
; AUTO() Copies records from the "Auto"(matic) table into the "Checks" table.
; These are bills you pay that are consistant from month to month.  These
; Bills would include housepayment/rent, carpayment, Alamony (shiver), etc.
; The checknumbering scheme is the highest checknumber plus one through the
; automatic list.  The default day is TODAY, just incase you forgot to set the
; default.
;==============================================================================

PROC AUTO()
PRIVATE test,checknumber,Choice
@MenuRow,MenuCol
?? FORMAT("W35,ac","AUTO MENU")
WHILE TRUE
SHOWMENU
  "Edit" : "Edit the Auto Database",
  "Add" : "Add Checks from the Auto Database to the Checks Database"

TO Choice
  SWITCH
    CASE Choice = "Add"  :
      QUITLOOP
    CASE Choice = "Edit" :
      VIEW "PopUp"
      VIEW "Auto"
;      EDITKEY
      DoWaite()
      RETURN
    CASE Choice = "Esc" :
      RETURN
  ENDSWITCH

ENDWHILE
    IF isempty("Auto") THEN
      MESSAGE "The Auto(matic) Table is Empty, Press Any Key to Continue."
      test = getchar()
      RETURN
    ELSE
      @12,13 ?? "ͻ"
      @13,13 ?? "                                                    "
      @14,13 ?? "                                                    "
      @15,13 ?? "ͼ"
      STYLE REVERSE
      @13,15 ??   " AUTO(matic) RECORDS WILL BE COPIED TO THE CHECKS "
      @14,15 ??   " TABLE, PRESS [Esc] TO ABORT, OR ANY KEY TO COPY. "
      STYLE

      test = getchar()
      IF test = 27 THEN
        RETURN
      ENDIF
      IF ISEMPTY("Auto") THEN
        LittleMess("No Records Found in the Autobase")
        SLEEP 2000
        RETURN
      ENDIF

      BigMess("Copying Records")

      {Ask} {Auto} [Date] = "CHANGETO TODAY"

      Do_It!
      ClearAll
      CheckNumber = CMAX("Checks","CheckNumber")
      EDIT "Auto"
      SCAN
      CheckNumber = CheckNumber + 1
      [CheckNumber] = CheckNumber
      ENDSCAN
      Do_It!
      RChecks = RChecks + CSUM("Auto","Amount")
      Balance = Balance - CSUM("Auto","Amount")
      TotalChecks = TotalChecks+CSUM("Auto","Amount")
      MOVETO [Description]
      LOCATE "First Interstate Bank Of Cal."
      IF retval THEN
        COPYTOARRAY Nick
        EDIT "Savings"
        INS
        COPYFROMARRAY Nick
        SBalance = SBalance + [Amount]
        RSavings = RSavings + [Amount]
        DO_IT!
      ENDIF
      ClearAll
      ADD "Auto" "Checks"
      ClearAll
    ENDIF
ENDPROC
WriteLib LIBNAME  Auto
RELEASE PROCS  Auto

; ---------------------------------------------------------------------------
; Archive Old Records
; ---------------------------------------------------------------------------
proc DoArchive()
LittleMess("Press [Esc]ape to Cancel")
;@0,1 CLEAR EOL
@0,0 ?? "Enter the YEAR you want to Archive.. " CLEAR EOL
STYLE REVERSE
CURSOR BOX
ACCEPT "A4" PICTURE "####" DEFAULT STRVAL(YEAR(TODAY())-1) REQUIRED TO Date
STYLE
CURSOR OFF
@0,0 CLEAR EOL
IF retval = FALSE THEN
  RETURN
ELSE
  Date = STRVAL(NUMVAL(Date) + 1)
  Date = "1/1/"+Date
ENDIF
@MenuRow,MenuCol
STYLE BLINK
?? FORMAT("W35,ac","ARCHIVING")
STYLE
@22,0 CLEAR EOL
BigMess("Archiving Cleared Checks Older Than " +STRVAL(Date)+ " to \"OldCheck\"")
{Ask} {Checks} "DELETE"
[Date] = "< "+Date
[Cleared] = "Y"
DO_IT!
ADD "Deleted" "OldCheck"
CLEARALL
BigMess("Archiving Cleared Deposits Older Than " +STRVAL(Date)+ " to \"OldDepos\"")
{Ask} {Deposit} "DELETE"
[Date] = "< "+Date
[Cleared] = "Y"
DO_IT!
ADD "Deleted" "OldDepos"
CLEARALL
BigMess("Archiving Cleared InstaTellers Older Than " +STRVAL(Date)+ " to \"OldInsta\"")
{Ask} {Insta} "DELETE"
[Date] = "< "+Date
[Cleared] = "Y"
DO_IT!
ADD "Deleted" "OldInsta"
CLEARALL
BigMess("Recalculating Stats")
ResetSetup()
GetStatus()
LittleMess("Done!")
SLEEP 500
endproc

writelib LIBNAME DoArchive
release procs DoArchive
?? "."

; ---------------------------------------------------------------------------
; Wave Bye Bye
; ---------------------------------------------------------------------------
proc ByeBye()
Clear
Cursor Off
R=11 C=35 SM=C-1
PaintCanvas Attribute 9 0,0,24,79
@ R-3,C+6 Style Attribute 9+128 ?? "BYE BYE!"
SetMargin SM
Style Attribute 14
@ R,C
TEXT
 
<
 
ENDTEXT
PaintCanvas Attribute 14 R+1,0,11,79
PaintCanvas Attribute  9 R+1,C,R+2,C+1
For X From 1 to 5
    @ R,C+1 ?? "/"
    Sleep 100
;    @ R,C+1 ?? "_"
    @ R,C+1 ?? ""

    Sleep 100
EndFor
    @ R,C+1 ?? " "
    @ R+1,C+1 ?? ">"
Sleep 1000
endproc

writelib LIBNAME ByeBye
release procs ByeBye
?? "."

; ---------------------------------------------------------------------------
; Copy Backup to Floppy Drive
; ---------------------------------------------------------------------------
proc CopyFile()
LittleMess("Place BackUp Disk in A: and Press Any Key, [Esc]ape to Return to Main Menu")
STYLE ATTRIBUTE 27
@MenuRow+1,MenuCol
?? FORMAT("W35,ac","File Transfer Routine")
STYLE

test = getchar()
IF test = 27 THEN
  RETURN
ENDIF
WHILE TRUE
  IF DRIVESTATUS("A") = FALSE THEN
    BEEP
    LittleMess("A:Drive Not ready, Put a disk in A: and press a key, [Esc]ape to cancell")
    test = getchar()
    IF test = 27 THEN
      RETURN
    ELSE
      LOOP
    ENDIF
  ENDIF

IF ISFILE("A:\\BANK.ARC") THEN
  IF FILESIZE("BANK.ARC")+10000 >
     DRIVESPACE("A") + FILESIZE("A:\\BANK.ARC") THEN
    BEEP
    LittleMess("Not enough room on A:, change disk and press a key, [Esc]ape to cancell")
    test = getchar()
    IF test = 27 THEN
      RETURN
    ELSE
      LOOP
    ENDIF
  ENDIF
ENDIF

IF NOT ISFILE("A:\\BANK.ARC") THEN
  IF FILESIZE("BANK.ARC")+10000 >
     DRIVESPACE("A") THEN
    BEEP
    LittleMess("Not enough room on A:, change disk and press a key, [Esc]ape to cancell")
    test = getchar()
    IF test = 27 THEN
      RETURN
    ELSE
      LOOP
    ENDIF
  ENDIF
ENDIF
BigMess("Copying Bank.arc to A:Drive")
@0,0
RUN NOREFRESH "COPY BANK.ARC A: > NUL"
RETURN
ENDWHILE

endproc

writelib LIBNAME CopyFile
release procs CopyFile
?? "."

; ---------------------------------------------------------------------------
; Make changes to set up table after records have been archived or
; unarchived
; ---------------------------------------------------------------------------
proc ResetSetup()
OldReconsile = SetUp + (TotalDeposit-RDeposit)-(TotalInsta-RInsta)-(TotalChecks-Rchecks)
GetStatus()
NewReconsile = SetUp + (TotalDeposit-RDeposit)-(TotalInsta-RInsta)-(TotalChecks-Rchecks)
IF NewReconsile <> OldReconsile THEN
  EDIT "SetUp"
  SWITCH
    CASE OldReconsile < NewReconsile :
      [Amount] = ROUND([Amount] - (NewReconsile-OldReconsile),2)
    CASE OldReconsile > NewReconsile :
      [Amount] = ROUND([Amount] + (OldReconsile-NewReconsile),2)
  ENDSWITCH
  DO_IT!
  CLEARIMAGE
ENDIF
endproc

writelib LIBNAME ResetSetup
release procs ResetSetup
?? "."

; ---------------------------------------------------------------------------
; Restructure all databases
; ---------------------------------------------------------------------------
proc DoRestructure()
BigMess("Restructuring Checks")
{Modify} {Restructure} {Checks}
DO_IT!
CLEARIMAGE
BigMess("Restructuring Insta")
{Modify} {Restructure} {Insta}
DO_IT!
CLEARIMAGE
BigMess("Restructuring Deposit")
{Modify} {Restructure} {Deposit}
DO_IT!
CLEARIMAGE


BigMess("Restructuring OldCheck")
{Modify} {Restructure} {OldCheck}
DO_IT!
CLEARIMAGE
BigMess("Restructuring OldInsta")
{Modify} {Restructure} {OldInsta}
DO_IT!
CLEARIMAGE
BigMess("Restructuring OldDepos")
{Modify} {Restructure} {OldDepos}
DO_IT!
CLEARIMAGE

endproc

writelib LIBNAME DoRestructure
release procs DoRestructure
?? "."


; ---------------------------------------------------------------------------
;
; ---------------------------------------------------------------------------
proc UnArchive()
BigMess("UnArchiving OldChecks")
ADD "OldCheck" "Checks"
CLEARIMAGE
EMPTY "OldCheck"
BigMess("UnArchiving OldDepos")
ADD "OldDepos" "Deposit"
CLEARIMAGE
EMPTY "OldDepos"
BigMess("UnArchiving OldInsta")
ADD "OldInsta" "Insta"
CLEARIMAGE
EMPTY "OldInsta"
IF ISTABLE("Keyviol") THEN
  DELETE "KeyViol"
ENDIF

ResetSetup()
GetStatus()
endproc

writelib LIBNAME UnArchive
release procs UnArchive
?? "."





;infolib "LIBRARY"
