;Nick Waite  CompuServe[75056,513] Checks Program ver. 1.0  10/88
LIBNAME = "Reports"
CREATELIB LIBNAME

;==============================================================================
; PROC CheckPrint() Prints checks. The Report that is used is "Printer" "R"
; It is setup for an IBM ProPrinter and my brand of computerized checks. Use
; the Paradox2 to change the report spec to fit your own situation. You may
; note the use of imbedded escape strings in the present report that changes the
; type styles in the report. These were of course done using the calculated
; field option. There is another routine in here which I downloaded from
; CompuServe Bor App, which converts the dollar amount of the check into english
; words. Author - Unknown. You may want to develop other report specs inside of
; this procedure.
;==============================================================================
PROC CLOSED CheckPrint()
USEVARS position,autolib,datefill,mo,da,StrAmt,Cents,
        SpellAmt,test,printday,amt,DateField
LittleMess("[Esc]ape to Return to Main Menu")
@1,0 ?? "Enter the Check Print Date" CLEAR EOL
@0,0 ?? "Value: " CLEAR EOL
STYLE REVERSE
CURSOR BOX      ;turn on cursor for input
ACCEPT "D" DEFAULT TODAY() REQUIRED
 TO PrintDay
@0,0  CLEAR EOL
@1,0  CLEAR EOL
CURSOR OFF
STYLE
IF retval = FALSE THEN
  RETURN
ENDIF

     @12,9 ?? "ͻ"
     @13,9 ?? "                                                            "
     @14,9 ?? "                                                            "
     @15,9 ?? "ͼ"
STYLE REVERSE
      @13,11 ?? " CHECKS WILL BE PRINTED ACCORDING TO THE DEFAULT SETTINGS "
      @14,11 ?? "                                                          "
      @14,11 ?? " OF "+strval(printday)+". [Esc] TO ABORT, OR PRESS ANY KEY TO PRINT. "
STYLE

      test = getchar()
      IF test = 27 THEN
        RETURN
      ENDIF

BigMess("Processing Query")
{Ask} {Checks} CHECKPLUS MOVETO [Date] TYPEIN PrintDay
Do_It!
ClearAll

IF isempty("Answer") THEN
  LittleMess("No Records Found!")
  SLEEP 2000
  RETURN
ENDIF


{Modify} {Restructure} {Answer} Down Down Down Ins Right
 "String" Right  "A70" Do_It! ClearAll

stramt = ""


EDIT "Answer"
moveto [String]

SCAN
amt = [Amount]
tomoney(amt,stramt)
StrAmt = SpellAmt + "and " + Cents + "/100 Dollars"
[] = stramt
ENDSCAN
Do_It!
ClearAll
{Tools} {Copy} {JustFamily} {Printer} {Answer} {Replace}
Printer_Proc("Answer","R")
ENDPROC
writelib LIBNAME CheckPrint
RELEASE PROCS CheckPrint



; Following procedure is called by TOMONEY to identify characteristic
; of number.

Proc CLOSED HundsVal(Num)
USEVARS position,autolib,Hun,Ten,One,Str,Onestr,Tenstr,Cents

  Hun = Int(Num / 100)                  ; determine number of hundreds
  Num = Num - (Hun * 100)               ;   tens and units
  Ten = int(Num / 10)
  Num = Num - (Ten * 10)
  One = Int(Num)
  Str = ""                              ; begin building string
  If Hun > 0 then
    Str = Str + OneStr[Hun] + "Hundred "
  EndIf
  If Ten > 0 then
    If Ten > 1 then
      Str = Str + TenStr[Ten]           ; values 20 - 99
     else
      Str = Str + OneStr[One + 10]      ; values 1 - 19
    EndIf
   else
    If One > 0  then
      Str = Str + OneStr[One]           ; values 1 - 9
    Endif
  EndIf
  If One > 0 and Ten > 1  then
    Str = Str + OneStr[One]           ; values 1 - 19
  Endif
  Return Str
EndProc

; Following procedure is called by TOMONEY to generate thousands

Proc CLOSED GenVal(Num)
USEVARS position,autolib,Thou,Str,Onestr,Tenstr,Cents
  Thou = Int(Num / 1000)                ; determine number of thousands
  Num = Num - (Thou * 1000)
  Str = HundsVal(Thou)                  ; generate thousands if any
  If Str <> "" then
    Str = Str + "Thousand "
  EndIf
  Return Str + HundsVal(Num)            ; generate rest of number
EndProc


PROC CLOSED ToMoney(amt,stramt)
USEVARS position,autolib,SpellAmt,Onestr,Tenstr,Stramt,amt,printday,test,Offset,Cents
;PRIVATE amt,printday,test,Offset,Cents

;  Procedure to convert numeric values into words for printing checks.
;  Returns the character string for the words.

; This script is an example of how one might convert
; numeric values into their English word equivalents.

  Array OneStr[19]
  Array TenStr[9]

; assign array values

  OneStr[1] = "One "
  OneStr[2] = "Two "
  OneStr[3] = "Three "
  OneStr[4] = "Four "
  OneStr[5] = "Five "
  OneStr[6] = "Six "
  OneStr[7] = "Seven "
  OneStr[8] = "Eight "
  OneStr[9] = "Nine "
  OneStr[10] = "Ten "
  OneStr[11] = "Eleven "
  OneStr[12] = "Twelve "
  OneStr[13] = "Thirteen "
  OneStr[14] = "Fourteen "
  OneStr[15] = "Fifteen "
  OneStr[16] = "Sixteen "
  OneStr[17] = "Seventeen "
  OneStr[18] = "Eighteen "
  OneStr[19] = "Nineteen "

  TenStr[1] = "?"
  TenStr[2] = "Twenty "
  TenStr[3] = "Thirty "
  TenStr[4] = "Forty "
  TenStr[5] = "Fifty "
  TenStr[6] = "Sixty "
  TenStr[7] = "Seventy "
  TenStr[8] = "Eighty "
  TenStr[9] = "Ninety "

  StrAmt = Format("W9.2,SU",Amt)


  Offset = Search(".",StrAmt) + 1
  Cents  = SubStr(StrAmt,Offset,2)
  SpellAmt = GenVal(Amt)
  If SpellAmt = "" then
    SpellAmt = "0 "
  EndIf
   RETURN
ENDPROC     ; End of TOMONEY procedure
WriteLib LIBNAME  HundsVal,GenVal,ToMoney
RELEASE PROCS  HundsVal,GenVal,ToMoney

PROC PrintMenu()
WHILE TRUE
MenuText(2)
    SHOWMENU
      "Checks":"Print Checks",
      "Check Summary":"Print a Check Summary Report",
      "Deposit Summary":"Print a Deposit Summary Report",
       SA+" Summary":"Print a "+SA+" Summary Report"

    TO pm
       SWITCH
         CASE pm = "Esc" :
          RETURN

         CASE pm = SA+" Summary":
           SavingsSummary()


         CASE pm = "Checks":
           CheckPrint()
           @22,0 CLEAR EOL

         CASE pm = "Check Summary":
           CheckSummary()

         CASE pm = "Deposit Summary":
           DepositSummary()

       ENDSWITCH
ENDWHILE
ENDPROC
WriteLib LIBNAME PrintMenu
RELEASE PROCS ALL

PROC CheckSummary()
                  STYLE ATTRIBUTE 155
                  @14,23 ?? FORMAT("w35,ac","FINDING CHECK SUMMARY INFORMATION")
                  STYLE

                  BigMess("Selecting Records")

                  {Ask} {Checks} [Amount] = "calc sum"
                  MOVETO [Description] CHECK
                  TYPEIN "calc count all"

                  DO_IT!
                  ClearAll
                  VIEW "Answer"
                  WAIT TABLE PROMPT " [F2] or [Esc]ape When Through                  Current Check Total = $"+STRVAL(CSUM("Answer","Sum of Amount")),
                                    " [Alt F7] To print                                         "
                                     + STRVAL(NRECORDS("Answer")) + " Records Generated"
                  UNTIL "F2","F37","Esc"
                      IF retval = "F37" THEN
                      CLEAR
                      Printer_Proc("Answer","R")
                      ENDIF
                  ClearAll
                  CLEAR

ENDPROC
WriteLib LIBNAME CheckSummary
RELEASE PROCS CheckSummary

PROC DepositSummary()

                  STYLE ATTRIBUTE 155
                  @14,23 ?? FORMAT("w35,ac","FINDING DEPOSIT SUMMARY INFORMATION")
                  STYLE

                  BigMess("Selecting Records")

                  {Ask} {Deposit} [Amount] = "calc sum all"
                  MOVETO [Description] CHECK
                  TYPEIN "calc count all"
                  DO_IT!
                  ClearAll
                  VIEW "Answer"
                  WAIT TABLE PROMPT " [F2] or [Esc]ape When Through                Current Deposit Total = $"+STRVAL(CSUM("Answer","Sum of Amount")),
                                    " [Alt F7] To print                                          "
                                     + STRVAL(NRECORDS("Answer")) + " Records Generated"
                  UNTIL "F2","F37","Esc"
                      IF retval = "F37" THEN
                      CLEAR
                      Printer_Proc("Answer","R")
                      ENDIF
                  ClearAll
                  CLEAR

ENDPROC
WriteLib LIBNAME DepositSummary
RELEASE PROCS DepositSummary

PROC Printer_Proc(Report_Table_Name,Report_Choice)
PRIVATE Report_Table_Name, Report_Choice
;This procedure is called from the main printer script.  Remember to include
;The Report Table Name and the Form that you want to use.


@22,0 CLEAR EOL
        IF isempty(Report_Table_Name) THEN
          {Tools} {More} {Directory} ENTER {OK}
          BEEP
          LittleMess("No records to report on")
          SLEEP 2000
          RETURN
        ENDIF

        Menu {Report} {Output} SELECT Report_Table_Name
        SELECT Report_Choice

        LittleMess("Checking to see if the printer is ready")
        retval = printerstatus()

        if (not retval) then
          LittleMess("Please turn on your printer. Press any key when ready")
          retval = getchar()
          BigMess("Checking printer again")
          retval = printerstatus()
        endif

        if (not retval) then
          RESET
          {Tools} {More} {Directory} ENTER {OK}
          BigMess("Printer not ready. Report is cancelled")
          BEEP
          SLEEP 1500 CLEAR
          RETURN
        else
          BigMess("Report being sent to printer")
;          {Screen}
          {Printer}
          RESET
          {Tools} {More} {Directory} ENTER {OK}

        endif

ENDPROC

WRITELIB LIBNAME Printer_Proc
RELEASE PROCS Printer_Proc

PROC SavingsSummary()

                  STYLE ATTRIBUTE 155
                  @14,23 ?? FORMAT("w35,ac","FINDING "+FORMAT("cu",SA)+ " SUMMARY")
                  STYLE

                  BigMess("Selecting Records")

                  {Ask} {Savings} [Amount] = "calc sum"
                  MOVETO [Description] CHECK
                  TYPEIN "calc count all"

                  DO_IT!
                  ClearAll
                  VIEW "Answer"
                  test = "Current "+SA+" Total = $"+STRVAL(CSUM("Answer","Sum of Amount")*SF)

                  WAIT TABLE PROMPT " [F2] or [Esc]ape When Through "+ FORMAT("w48,ar",test),
                                    " [Alt F7] To print                                         "
                                     + STRVAL(NRECORDS("Answer")) + " Records Generated"
                  UNTIL "F2","F37","Esc"
                      IF retval = "F37" THEN
                      CLEAR
                      Printer_Proc("Answer","R")
                      ENDIF
                  ClearAll
                  CLEAR

ENDPROC
WriteLib LIBNAME SavingsSummary
RELEASE PROCS ALL

infolib LIBNAME



