;************************************************************************
;  The following Library of procedures are:
;
;     Copyrighted (c) 1993 Micro-Phyla Systems  All Rights Reserved
;
;  You are welcome to use and change the following code for your applications.
;  The only requirements are:
;       1) That you include the above copyright on all code.
;       2) That you let me know of any suggestions or problems you might
;          have so I can make this utility better. This is a new utility
;          and therefore may NOT have all the bugs worked out yet. Your
;          suggestions will very much be appreciated.
;
;  Included is a complete messaging utility that is described at the beginning
;  of that group of code.  Also included are several procedures from Dan Paolini.
;  You are expected to include his copyrights.
;
;          Enjoy
;                      John B. Moore, Micro-Phyla Systems
;**************************************************************************
; ============================================================
; 04-17-93
; Master backup procedure
; ------------------------------------------------------------
PROC BakUp_u()
   PRIVATE Procname.a,
           bakdrive_n,
           disktype_n,
           d_l,
           v_l,
           t_l,
           all_l,
           c_l,
           okbutton_v,
           datadir_a,
           configdir_a,
           valchkdir_a,
           temptabdir_a
   Procname.a = "BakUp_u"
    IF ISFILE(DIRECTORY()+"bakup.sc") THEN
       PLAY  DIRECTORY()+"bakup"
    ELSE
      ;--setup standard defaults
      bakdrive_n = 1
      disktype_n = 1
      d_l = true
      c_l = false
      v_l = false
      t_l = false
      all_l = false
    ENDIF
    ;--runtime defaults..
    directory_a = DIRECTORY()
    ;--check for temp backup directory
   IF DirExists("BAKTEMP") = 0 THEN
      Run NOREFRESH "MD BAKTEMP"
   ENDIF
   ;--hardwired defaults that only can be changed here. You have four
   ;  possible directories you can backup.  Change these settings to
   ;  match your system
   targetdir_a  = directory_a+"BAKTEMP\\"   ;temp storage of bak file
   datadir_a    = directory_a+"D\\"         ;Main data directory
   configdir_a  = directory_a+"C\\"         ;Config directory
   valchkdir_a  = directory_a+"V\\"         ;Lookup and valcheck directory
   temptabdir_a = directory_a+"T\\"         ;Report spec tables directory
   okbutton_v = false


  SHOWDIALOG "Backup/Restore Utility"
     PROC "BakUpproc_l"
      TRIGGER "ACCEPT","UPDATE"
     @1,7 HEIGHT 22 WIDTH 64

     ; PaintPAL_Frame_Begin
     FRAME DOUBLE FROM 0,1 TO 4,60
     PAINTCANVAS ATTRIBUTE 127 0,1,0,60
     PAINTCANVAS ATTRIBUTE 127 0,1,4,1
     PAINTCANVAS ATTRIBUTE 112 4,2,4,60
     PAINTCANVAS ATTRIBUTE 112 0,60,4,60
     ; PaintPAL_Frame_Begin
     FRAME SINGLE FROM 11,1 TO 19,35
     PAINTCANVAS ATTRIBUTE 112 11,1,11,35
     PAINTCANVAS ATTRIBUTE 112 11,1,19,1
     PAINTCANVAS ATTRIBUTE 127 19,2,19,35
     PAINTCANVAS ATTRIBUTE 127 11,35,19,35
     ; PaintPAL_Frame_Begin
     FRAME DOUBLE FROM 8,39 TO 19,60
     PAINTCANVAS ATTRIBUTE 127 8,39,8,60
     PAINTCANVAS ATTRIBUTE 127 8,39,19,39
     PAINTCANVAS ATTRIBUTE 112 19,40,19,60
     PAINTCANVAS ATTRIBUTE 112 8,60,19,60
     ; PaintPAL_Static_Text_Begin
     PAINTCANVAS FILL " " ATTRIBUTE 112 1,3,3,58
     @1,3 ?? "Select the paramenters for this backup or restore"
     @2,3 ?? "session.  Use the Tab key or the mouse to move between"
     @3,3 ?? "items."
     PAINTCANVAS ATTRIBUTE 112 1,3,3,58

     RADIOBUTTONS @6,5 HEIGHT 4 WIDTH 23
        "A-Drive 3.5 disk",
        "A-Drive 5.25 disk",
        "B-Drive 3.5 disk",
        "B-Drive 5.25 disk"
        TAG "drive"
        TO bakdrive_n
     LABEL @5,1
        "Bakup Drive Type:"
        FOR "drive"

     RADIOBUTTONS @6,40 HEIGHT 2 WIDTH 19
        "HighDensity",
        "DoubleDensity"
        TAG "disk"
        TO disktype_n
     LABEL @5,32
        "Disk Capacity:"
        FOR "disk"

     ;- if you changed the directory defintions above you will need to
     ;  change the descriptions below
     CHECKBOXES @13,3 HEIGHT 5 WIDTH 31
        TAG "bakdir"
        "Main Data Directory" TO d_l,
        "Valcheck Directory" TO v_l,
        "Template Directory" TO t_l,
        "Configuration Directory" TO c_l,
        "Backup Entire Application" TO all_l
     LABEL @11,9
        "Bakup Directories"
        FOR "bakdir"

     PUSHBUTTON @9,40 WIDTH 20
        "Format Disk"
        VALUE "format"
        TAG "format"
        TO okbutton_v

     PUSHBUTTON @11,40 WIDTH 20
        "Clear Disk"
        VALUE "clear"
        TAG "clear"
        TO okbutton_v

     PUSHBUTTON @13,40 WIDTH 20
        "Start Backup"
        VALUE "bakup"
        TAG "bakup"
        TO okbutton_v

     PUSHBUTTON @15,40 WIDTH 20
        "Start Restore"
        VALUE "restore"
        TAG "restore"
        TO okbutton_v

     PUSHBUTTON @17,40 WIDTH 20
        "Cancel"
        CANCEL
        DEFAULT
        VALUE "cancel"
        TAG "cancel"
        TO okbutton_v
  ENDDIALOG

   Paintbackground_u(13)
   ECHO OFF
   QuickMsg_u("Saving Defaults")
   SAVEVARS bakdrive_n,
           disktype_n,
           d_l,
           v_l,
           t_l,
           all_l,
           c_l
   MENU "TRS" SELECT "savevars"
               SELECT DIRECTORY()+"bakup"
               IF MENUCHOICE() = "Cancel" THEN
                  SELECT "Replace"
               ENDIF
   QuickMsg_u("")
   ECHO NORMAL
   RETURN true
ENDPROC
;("BakUp_u")

; ============================================================
; 04-18-93
; Dbox proc for BakUp_n()
; ------------------------------------------------------------
PROC BakUpproc_l(trigger_a,tag_a,event_v,element_a)
   PRIVATE Procname.a
   Procname.a = "BakUpproc_l"
   SWITCH
      CASE  (trigger_a = "ACCEPT" OR
            trigger_a = "UPDATE") AND tag_a = "format" :
             BakFormat_u()
             RETURN true
      CASE  (trigger_a = "ACCEPT" OR
            trigger_a = "UPDATE") AND tag_a = "clear" :
             RETURN BakClearDisk_l()
      CASE  (trigger_a = "ACCEPT" OR
             trigger_a = "UPDATE") AND tag_a = "bakup" :
             RETURN BakDobackup_l()
      CASE  (trigger_a = "ACCEPT" OR
             trigger_a = "UPDATE") AND tag_a = "restore" :
            RETURN BakDoRestore_l()
   ENDSWITCH
   RETURN true
ENDPROC
;("BakUpproc_l")

; ============================================================
; 04-18-93
; backup control proc
; ------------------------------------------------------------
PROC BakDobackup_l()
   PRIVATE Procname.a,
           targetfloppy_a
   Procname.a = "BakDobackup_l"
;;  "Main Data Directory"       = d_l, =  datadir_a
;;  "Valcheck Directory"        = v_l, =  valchkdir_a
;;  "Template Directory"        = t_l, =  temptabdir_a
;;  "Configuration Directory"   = c_l, =  configdir_a
;;  "Backup Entire Application" = all_l

   IF bakdrive_n < 3 THEN
       targetfloppy_a = "A:\\"
   ELSE
       targetfloppy_a = "B:\\"
   ENDIF
   PmessageBanner_u("Backing Up - Please Standby...!", 32,
                     "wallpaperoff", 13,"statuson", "gaugeoff")
   PmessageStatus_u("Checking file and drive status...")
   IF  (d_l OR all_l) AND
       BakCompress_l(datadir_a,targetdir_a,"DBAK") THEN
         IF NOT BakCopyToDisk_l(targetdir_a,targetfloppy_a,"DBAK.ZIP") THEN
            PmessagePutaway_u()
            RETURN false
         ENDIF
   ENDIF
   PmessageStatus_u("Checking file and drive status...")
   IF  (v_l OR all_l) AND
       BakCompress_l(valchkdir_a,targetdir_a,"VBAK") THEN
         IF NOT BakCopyToDisk_l(targetdir_a,targetfloppy_a,"VBAK.ZIP") THEN
            PmessagePutaway_u()
            RETURN false
         ENDIF
   ENDIF
   PmessageStatus_u("Checking file and drive status...")
   IF  (t_l OR all_l) AND
       BakCompress_l(temptabdir_a,targetdir_a,"TBAK") THEN
         IF NOT BakCopyToDisk_l(targetdir_a,targetfloppy_a,"TBAK.ZIP") THEN
            PmessagePutaway_u()
            RETURN false
         ENDIF
   ENDIF
   PmessageStatus_u("Checking file and drive status...")
   IF  (c_l OR all_l) AND
       BakCompress_l(configdir_a,targetdir_a,"CBAK") THEN
         IF NOT BakCopyToDisk_l(targetdir_a,targetfloppy_a,"CBAK.ZIP") THEN
            PmessagePutaway_u()
            RETURN false
         ENDIF
   ENDIF
   PmessagePutaway_u()
   Paintbackground_u(13)
   RETURN true
ENDPROC
;("BakDobackup_l")

; ============================================================
; 04-18-93
; restore control module
; ------------------------------------------------------------
PROC BakDoRestore_l()
   PRIVATE Procname.a,
           sourcefloppy_a
   Procname.a = "BakDoRestore_l"
;;  "Main Data Directory"       = d_l, =  datadir_a
;;  "Valcheck Directory"        = v_l, =  valchkdir_a
;;  "Template Directory"        = t_l, =  temptabdir_a
;;  "Configuration Directory"   = c_l, =  configdir_a
;;  "Backup Entire Application" = all_l
   IF bakdrive_n < 3 THEN
       sourcefloppy_a = "A:\\"
   ELSE
       sourcefloppy_a = "B:\\"
   ENDIF
   PmessageBanner_u("Restoring - Please Standby...!", 32,
                     "wallpaperoff", 13,"statuson", "gaugeoff")
   IF  d_l or all_l AND
       msConfirm_l("Insert Disk that contains Main Data File !",
                     110,"",2,"Restore","Cancel",true) THEN
       WHILE true
         PmessageStatus_u("Checking file and drive status...")
         IF ISFILE(sourcefloppy_a+"DBAK.ZIP") AND
           BakExplode_l(sourcefloppy_a,datadir_a,"DBAK") THEN
           QUITLOOP
         ELSE
            IF msConfirm_l("The Main Data File is not on this disk !",
                        110,"",2,"TryAgain","Cancel",true) THEN
                        LOOP
            ELSE QUITLOOP ENDIF
         ENDIF
       ENDWHILE
   ENDIF
   IF  v_l or all_l AND
       msConfirm_l("Insert Disk that contains Valcheck Data File !",
                     110,"",2,"Restore","Cancel",true) THEN
       WHILE true
         PmessageStatus_u("Checking file and drive status...")
         IF ISFILE(sourcefloppy_a+"VBAK.ZIP") AND
           BakExplode_l(sourcefloppy_a,valchkdir_a,"VBAK") THEN
           QUITLOOP
         ELSE
            IF msConfirm_l("The Valcheck Data File is not on this disk !",
                        110,"",2,"TryAgain","Cancel",true) THEN
                        LOOP
            ELSE QUITLOOP ENDIF
         ENDIF
       ENDWHILE
   ENDIF
   IF  t_l or all_l AND
       msConfirm_l("Insert Disk that contains Template Data File !",
                     110,"",2,"Restore","Cancel",true) THEN
       WHILE true
         PmessageStatus_u("Checking file and drive status...")
         IF ISFILE(sourcefloppy_a+"TBAK.ZIP") AND
           BakExplode_l(sourcefloppy_a,temptabdir_a,"TBAK") THEN
           QUITLOOP
         ELSE
            IF msConfirm_l("The Template Data File is not on this disk !",
                        110,"",2,"TryAgain","Cancel",true) THEN
                        LOOP
            ELSE QUITLOOP ENDIF
         ENDIF
       ENDWHILE
   ENDIF
   IF  c_l or all_l AND
       msConfirm_l("Insert Disk that contains Configure Data File !",
                     110,"",2,"Restore","Cancel",true) THEN
       WHILE true
         PmessageStatus_u("Checking file and drive status...")
         IF ISFILE(sourcefloppy_a+"CBAK.ZIP") AND
           BakExplode_l(sourcefloppy_a,configdir_a,"CBAK") THEN
           QUITLOOP
         ELSE
            IF msConfirm_l("The Configure Data File is not on this disk !",
                        110,"",2,"TryAgain","Cancel",true) THEN
                        LOOP
            ELSE QUITLOOP ENDIF
         ENDIF
       ENDWHILE
   ENDIF
   PmessagePutaway_u()
   Paintbackground_u(13)
   RETURN true
ENDPROC
;("BakDoRestore_l")

; ============================================================
; 04-17-93
; FORMATS DISK
; ------------------------------------------------------------
PROC BakFormat_u()
   PRIVATE Procname.a
   Procname.a = "BakFormat_u"
;; Requires Dos 5 or greater.
;;     bakdrive_n
;;        "A-Drive 3.5 disk", = 1
;;        "A-Drive 5.25 disk",= 2
;;        "B-Drive 3.5 disk", = 3
;;        "B-Drive 5.25 disk" = 4
;;     disktype_n
;;        "HighDensity", = 1
;;        "DoubleDensity"= 2
   SWITCH
      CASE  bakdrive_n = 1  AND
            disktype_n = 1  :
            RUN BIG "FORMAT A: /f:1440"
      CASE  bakdrive_n = 2  AND
            disktype_n = 1  :
            RUN BIG "FORMAT A: /f:1200"
      CASE  bakdrive_n = 1  AND
            disktype_n = 2  :
            RUN BIG "FORMAT A: /f:720"
      CASE  bakdrive_n = 2  AND
            disktype_n = 2  :
            RUN BIG "FORMAT A: /f:360"
      CASE  bakdrive_n = 3  AND
            disktype_n = 1  :
            RUN BIG "FORMAT B: /f:1440"
      CASE  bakdrive_n = 4  AND
            disktype_n = 1  :
            RUN BIG "FORMAT B: /f:1200"
      CASE  bakdrive_n = 3  AND
            disktype_n = 2  :
            RUN BIG "FORMAT B: /f:720"
      CASE  bakdrive_n = 4  AND
            disktype_n = 2  :
            RUN BIG "FORMAT B: /f:360"
  ENDSWITCH
  RETURN TRUE
ENDPROC
;("BakFormat_u")

; ============================================================
; 04-17-93
; clears disk by deleting all files on target disk
; ------------------------------------------------------------
PROC BakClearDisk_l()
   PRIVATE Procname.a
   Procname.a = "BakClearDisk_l"
   QuickMsg_u("Checking drive")
   SWITCH
      CASE  bakdrive_n = 1  OR
            bakdrive_n = 2  :
          target_a = "A:\\"
      CASE  bakdrive_n = 3  OR
            bakdrive_n = 4  :
          target_a = "B:\\"
   ENDSWITCH
   WHILE true
      IF DRIVESTATUS(SUBSTR(target_a,1,1)) AND
         msConfirm_l("WARNING !! All files will be deleted..!",
                     110,"",2,"DeleteFiles","Cancel",true) THEN
            QuickMsg_u("")
            QuickMsg_u("Clearing drive")
            RUN BIG NOREFRESH "ECHO Y|DEL "+target_a+"*.* >>NUL"
      ELSE
         IF msConfirm_l("Disk missing in assigned drive. Insert Disk!",
                     110,"",2,"TryAgain","Cancel",true) THEN
                     LOOP
         ELSE
            QuickMsg_u("")
            RETURN false
         ENDIF
      ENDIF
      QuickMsg_u("")
      RETURN true
   ENDWHILE
ENDPROC
;("BakClearDisk_l")


; ============================================================
; 04-17-93
; Copies file to disk
; ------------------------------------------------------------
PROC BakCopyToDisk_l(source_a,target_a,file_a)
   PRIVATE Procname.a
   Procname.a = "BakCopyToDisk_l"
  IF ISFILE(source_a+file_a) THEN
      WHILE true
      IF DRIVESTATUS(SUBSTR(target_a,1,1)) THEN
         IF DIREXISTS(source_a) = 1 AND
            DIREXISTS(target_a) = 1 THEN
            WHILE true
               IF DRIVESPACE(SUBSTR(target_a,1,1)) > FILESIZE(source_a+file_a) THEN
                  PmessageStatus_u("Copying "+file_a+" to "+target_a)
                  RUN BIG NOREFRESH "COPY " +source_a+file_a+
                                       " "+target_a+" >>nul"
                  RUN BIG NOREFRESH "DEL "+source_a+file_a
               ELSE
                  IF msConfirm_l("Insufficient space on Disk, Insert New Disk.",
                              110,"",2,"TryAgain","Cancel",true) THEN
                              LOOP
                  ELSE RETURN false ENDIF
               ENDIF
               RETURN true
         ENDWHILE
         ELSE
            GeneralMessage_u("Sorry, either the target or the source drive is/"+
                           "not a valid DOS drive. Please check this and   /"+
                           "try again.        <Enter> continues....        /")
            RETURN false
         ENDIF
      ELSE
         IF msConfirm_l("Disk missing in assigned drive. Insert Disk!",
                     110,"",2,"TryAgain","Cancel",true) THEN
                     LOOP
         ELSE RETURN false ENDIF
      ENDIF
      RETURN true
      ENDWHILE
   ENDIF
   RETURN true
ENDPROC
;("BakCopyToDisk_l")


; ============================================================
; 04-17-93
; zips a single directory and places it in target
; ------------------------------------------------------------
PROC BakCompress_l(source_a,target_a,zipfile_a)
   PRIVATE Procname.a,
           drive_a
   Procname.a = "BakCompress_l"
   drive_a  = SUBSTR(DIRECTORY(),1,1)
   IF DIREXISTS(source_a) = 1 AND
      DIREXISTS(target_a) = 1 AND
      DRIVESPACE(drive_a) > 2000000 THEN
      PmessageStatus_u("Compressing files in "+source_a)
      RUN BIG NOREFRESH "PKZIP -a " +target_a +zipfile_a+
                               " "+source_a+"*.* >>nul"
   ELSE
      GeneralMessage_u("Sorry, your DriveSpace has dropped below 2 meg./"+
                       "Therefore this operation can not be completed. /"+
                       "Exit program and archive files to create more  /"+
                       "more space.       <Enter> continues....        /")
       RETURN false
   ENDIF
   RETURN true
ENDPROC
;("BakCompress_l")

; ============================================================
; 04-17-93
; restores ziped file to assigned directory
; ------------------------------------------------------------
PROC BakExplode_l(source_a,target_a,zipfile_a)
   PRIVATE Procname.a,
           drive_a
   Procname.a = "BakExplode_l"
   drive_a  = SUBSTR(DIRECTORY(),1,1)
   IF DIREXISTS(source_a) = 1 AND
      DIREXISTS(target_a) = 1 AND
      DRIVESPACE(drive_a) > 2000000 THEN
      PmessageStatus_u("Restoring "+zipfile_a+" to "+target_a)
      RUN BIG NOREFRESH "PKUNZIP -O " +source_a+"\\"+zipfile_a+
                               " "+target_a+"\\ >>nul"
   ELSE
      GeneralMessage_u("Sorry, your DriveSpace has dropped below 2 meg./"+
                       "Therefore this operation can not be completed. /"+
                       "Exit program and archive files to create more  /"+
                       "more space.       <Enter> continues....        /")
       RETURN false
   ENDIF
   RETURN true
ENDPROC
;("BakExplode_l")


; ============================================================
; 10-05-92
; Creates a variable length message window in the lower
; center of the workspace, single line. Cannot exceed 65 characters
; A null string "" cancels window
; The string "work" places the window with "Working...!" in it.
; ------------------------------------------------------------
PROC QuickMsg_u(msg_a)
   PRIVATE Procname.a,
           current_h,
           width_n,
           origincol_n
   Procname.a = "QuickMsg_u"
   ;---check for null string to cancel window if it exists
   IF  msg_a = "" THEN
      ChiseledBoxDestructor_l("QUICK")
      RETURN
   ENDIF
   ;--check and see if window already exists, if so clear IT
      IF ISASSIGNED(g_handle_bag["QUICK"]) THEN
         ChiseledBoxDestructor_l("QUICK")
      ENDIF
   ;--first make sure string is not to large,
   msg_a = SUBSTR(msg_a,1,65)
   IF msg_a = "work" THEN
      width_n = 12 + 4
   ELSE
      width_n = LEN(msg_a) + 13
      wmsg_n = LEN(msg_a)
   ENDIF
   origincol_n = INT((80 - width_n)/2)
   ;--create window
      ChiseledBoxMaker_u(19,origincol_n,width_n,3,
                         32,47,"QUICK")
   ;--write text to box
   IF msg_a = "work" THEN
      STYLE ATTRIBUTE 46
          @ 1,2 ?? "Working"
      STYLE ATTRIBUTE 164
          @ 1,9 ?? "....!"
      STYLE
   ELSE
      STYLE ATTRIBUTE 32
          @ 1,2 ?? msg_a
      STYLE ATTRIBUTE 164
          @ 1,wmsg_n + 2 ?? "....!"
      STYLE
   ENDIF
ENDPROC
;("QuickMsg_u")


; ============================================================
; 10-05-92
; Creates a window with chisled box double border
; Also creates a global handle in g_handle_bag  Dynarray  with
; index specified with var index_a
; ------------------------------------------------------------
PROC ChiseledBoxMaker_u(row_n,col_n,width_n,height_n,color_n,hilite_n,index_a)
   PRIVATE Procname.a,
           current_h,
           fcurrent_h
   Procname.a = "ChiseledBoxMaker_u"
   ;----grab current table image cursor location
   IF NIMAGES() > 0 THEN
     WINDOW HANDLE IMAGE IMAGENO() TO current_h
     WINDOW HANDLE FORM TO fcurrent_h
   ENDIF
   IF NOT ISASSIGNED(g_handle_bag) THEN
      DYNARRAY g_handle_bag[]
   ENDIF
   ;---create dynarray attributes to format the window canvas
   DYNARRAY attrib_bag[]
              attrib_bag["CANVASHEIGHT"] = height_n
              attrib_bag["CANVASWIDTH"]  = width_n
              attrib_bag["CANCLOSE"]     = false
              attrib_bag["CANMAXIMIZE"]  = false
              attrib_bag["CANMOVE"]      = false
              attrib_bag["CANRESIZE"]    = false
              attrib_bag["ECHO"]         = true
              attrib_bag["HASFRAME"]     = false
              attrib_bag["STYLE"]        = color_n

   WINDOW CREATE FLOATING @ row_n ,col_n
          HEIGHT height_n
          WIDTH width_n
          ATTRIBUTES attrib_bag TO  g_handle_bag[index_a]
   ;---set canvas to canvas window
   SETCANVAS g_handle_bag[index_a]
   ;--create chiseled frame  in the canvas window
   FRAME DOUBLE FROM 0,0 TO height_n-1, width_n - 1
   PAINTCANVAS ATTRIBUTE hilite_n 0,0,height_n-1,0
   PAINTCANVAS ATTRIBUTE hilite_n 0,0,0,width_n - 2
   ;--return cursor to original location
   IF NIMAGES() > 0 THEN
     IF fcurrent_h <> 0 THEN
        WINDOW SELECT fcurrent_h
        WINDOW SELECT fcurrent_h
      ELSE
         WINDOW SELECT current_h
         WINDOW SELECT current_h
      ENDIF
   ENDIF
ENDPROC
;("ChiseledBoxMaker_u")

; ============================================================
; 10-05-92
; Closes box created by "ChiseledBoxMaker_u"
; Returns true if successful, false if window handle does not exist
; ------------------------------------------------------------
PROC ChiseledBoxDestructor_l(index_a)
   PRIVATE Procname.a,
           current_h
   Procname.a = "ChiseledBoxDestructor_l"
      IF ISASSIGNED(g_handle_bag[index_a]) AND
         ISWINDOW(g_handle_bag[index_a]) THEN
         WINDOW HANDLE CURRENT TO current_h
         WINDOW SELECT g_handle_bag[index_a]
         WINDOW CLOSE
         IF ISWINDOW(current_h) THEN
           WINDOW SELECT current_h
           WINDOW SELECT current_h
         ENDIF
         RELEASE VARS g_handle_bag[index_a] , attrib_bag
         SETCANVAS DEFAULT
         RETURN true
      ELSE
         RETURN false
      ENDIF
ENDPROC
;("ChiseledBoxDestructor_l")

; ============================================================
; 09-07-92
; General message utility
;  -each "line" must be followed by a "/"
; ------------------------------------------------------------
PROC GeneralMessage_u(text_a)
   PRIVATE Procname_a,
           dialog_w,
           lines_n,
           maxline_n,
           row_n,
           column_n,
           oldcolor_bag,
           newcolor_bag,
           oldcanvas_h
   Procname.a = "GeneralMessage_u"
     DYNARRAY message_bag[]
     lines_n = 1
     maxline_n = 0
     WHILE MATCH(text_a,"../..",message_bag[STRVAL(lines_n)],text_a)
          maxline_n = MAX(LEN(message_bag[STRVAL(lines_n)]),maxline_n)
          lines_n = lines_n +1
     ENDWHILE
     IF lines_n = 0 THEN
        maxline_n = LEN(text_a)
     ENDIF
     row_n = INT((23 -lines_n+4)/2)
     column_n = INT((79-maxline_n+4)/2)
      GETCOLORS TO oldcolor_bag
        DYNARRAY newcolor_bag[]
           newcolor_bag[1032] = 32
           newcolor_bag[1031] = 32
           newcolor_bag[1045] = 32
           newcolor_bag[1036] = 32
           newcolor_bag[1042] = 78
        SETCOLORS FROM newcolor_bag
        BEEP BEEP SLEEP 100 BEEP BEEP SLEEP 100 BEEP BEEP

  SHOWDIALOG "Message"
      PROC "InsertMessage_u" TRIGGER "OPEN"
     @row_n,column_n HEIGHT lines_n + 4 WIDTH maxline_n +4

     PUSHBUTTON @lines_n,INT((maxline_n/2)-6) WIDTH 12
        "Continue"
        OK
        DEFAULT
        VALUE true
        TAG "continue"
        TO okkey_l
  ENDDIALOG
  SETCOLORS FROM oldcolor_bag
  SETCANVAS DEFAULT
ENDPROC
;("GeneralMessage_u")

; ============================================================
; 09-07-92
; A dialog proc for inserting message into GeneralMessage_u
;  --the vars a,b,c,d are dummy place holders
; ------------------------------------------------------------
PROC InsertMessage_u(a,b,c,d)
   PRIVATE Procname.a,
           n
   Procname.a = "InsertMessage_u"
      WINDOW HANDLE DIALOG TO dialog_w
      SETCANVAS dialog_w
      FOR n FROM 1 TO lines_n - 1
       @ n-1 ,1
         ?? FORMAT("W"+STRVAL(maxline_n)+",AC",message_bag[STRVAL(n)])
      ENDFOR
      PAINTCANVAS ATTRIBUTE 32 0,1,lines_n+1,maxline_n+1
ENDPROC
;("InsertMessage_u")

;;;****************************************************************************
;;;          PROCESS AND WORKING MESSAGE HANDLER UTILITY
;;;
;;;    REQUIRED PROCS:  PmessageBanner_u   --Places banner on desktop with
;;;                                          title. Loads Status and Guage
;;;                                          boxes as required.
;;;                     PmessageStatus_u   --Insert message into Banner
;;;                     PmessageGuage_u    --Update Guage into Banner
;;;                     PaintBackground_u  --Places fullscreen canvas window
;;;                                          as a background wallpaper.
;;;                     PmessageDestruct_u --Removes all global vars AND windows
;;;                     PmessagePutaway_u  --puts message away in neverland
;;;                     PmessageGet_u      --bring existing message back
;;;
;;;     Global vars created:
;;;                     gms_attributes_bag[]  -- window attributes
;;;                     gms_handle_w          -- banner window handle
;;;                     gms_message_bag[]     -- internal window coordinates
;;;                     gms_wallpaper_l       -- existance of wallpaper
;;;                     gms_wallpaper_w       -- wallpaper window handle
;;;
;;;      Sample calls
;;;
;;;         ;---call without gauge, status or wallpaper
;;;         PmessageBanner_u("Working message by itself",
;;;                           32,
;;;                           "wallpaperoff",
;;;                           13,
;;;                           "statusoff",
;;;                           "gaugeoff")
;;;          ;---put message away but keep on desktop
;;;            PmessagePutaway_u()
;;;          ;---bring message back -same message
;;;            PmessageGet_u("",true,false)
;;;          ;---bring message back -different message
;;;            PmessageGet_u("We can also change the message name...",true,false)
;;;          ;----message to status window
;;;            PmessageStatus_u("Writing to status window")
;;;          ;----gauge in for loop
;;;            FOR n FROM 1 TO 500
;;;                  PmessageGauge_u(500,n)
;;;                  SLEEP 100
;;;            ENDFOR
;;;          ;----clear desktop and memory of message system
;;;            PmessageDestruct_u()
;;;
; ===========================================================================
; Main processing message setup procedure
; ---------------------------------------------------------------------------
PROC PmessageBanner_u(pheader_a,
                      pcolor_n,
                      pwallpaper_a,     ;wallpaperon,wallpaperoff
                      pwallpapercolor_n,
                      pstatus_a,        ;statuson,statusoff
                      pgauge_a)         ;gaugeon, gaugeoff
   PRIVATE  Procname_a,
            srow_n,
            scol_n,
            length_n,
            width_n,
            pgauge_l,
            statusline_n,
            pwallpaper_l,
            depthcolor_n,
            pstatus_l
   Procname_a = "PmessageBanner_u"

   ;----------------default size vars--------------
   srow_n = 8
   scol_n = 13
   width_n = 53
   ;------set specific parameters for window------

   SWITCH
      CASE pgauge_a = "gaugeon" AND
           pstatus_a = "statuson" :
               pgauge_l = true
               pstatus_l = true
               length_n = 10
               statusline_n = 7
      CASE pgauge_a = "gaugeoff" AND
           pstatus_a = "statuson" :
               pgauge_l = false
               pstatus_l = true
               length_n = 6
               statusline_n = 3
      CASE pgauge_a = "gaugeon" AND
           pstatus_a = "statusoff" :
               pgauge_l = true
               pstatus_l = off
               length_n = 8
               statusline_n = 3
      CASE pgauge_a = "gaugeoff" AND
           pstatus_a = "statusoff" :
               pgauge_l = false
               pstatus_l = false
               length_n = 3
               statusline_n = 0
   ENDSWITCH
  ;-----------wallpaper----------------
  IF ISASSIGNED(gms_wallpaper_l) THEN
     SWITCH
       CASE NOT gms_wallpaper_l AND
              pwallpaper_a = "wallpaperon" :
               gms_wallpaper_l = true
               Paintbackground_u(pwallpapercolor_n)
               CANVAS ON
       CASE  gms_wallpaper_l AND
              pwallpaper_a = "wallpaperoff" :
               gms_wallpaper_l = false
               WINDOW SELECT  gms_wallpaper_w
               WINDOW CLOSE
      ENDSWITCH
   ELSE ; its the first call
      IF pwallpaper_a = "wallpaperon" THEN
               gms_wallpaper_l = true
               Paintbackground_u(pwallpapercolor_n)
               CANVAS ON
      ELSE
         gms_wallpaper_l = false
      ENDIF
   ENDIF
  IF NOT ISASSIGNED(gms_message_bag["ROW"]) THEN
     DYNARRAY gms_attributes_bag[]
              gms_attributes_bag["CANVASHEIGHT"] = 12
              gms_attributes_bag["CANVASWIDTH"]  = 55
              gms_attributes_bag["CANCLOSE"]     = false
              gms_attributes_bag["CANMAXIMIZE"]  = false
              gms_attributes_bag["CANMOVE"]      = false
              gms_attributes_bag["CANRESIZE"]    = false
              gms_attributes_bag["ECHO"]         = true
              gms_attributes_bag["HASFRAME"]     = false
              gms_attributes_bag["STYLE"]        = pcolor_n
       ;---------build window in neverland---
       WINDOW CREATE FLOATING @ -100,-100
              HEIGHT  length_n +1  WIDTH width_n
              ATTRIBUTES  gms_attributes_bag TO gms_handle_w
      ;----create global array to pass to message and gauge procs----
      DYNARRAY gms_message_bag[]
            gms_message_bag["ROW"]            = srow_n
            gms_message_bag["COLUMN"]         = scol_n
            gms_message_bag["STATUSPOSITION"] = statusline_n
            gms_message_bag["LENGTH"]         = length_n
            gms_message_bag["WIDTH"]          = width_n
            gms_message_bag["ISSTATUSON"]     = pstatus_l
            gms_message_bag["ISGAUGEON"]      = pgauge_l
            gms_message_bag["COLOR"]          = pcolor_n
   ELSE  ; it is already here and we must reset the size and canvas
            gms_message_bag["STATUSPOSITION"] = statusline_n
            gms_message_bag["LENGTH"]         = length_n
            gms_message_bag["WIDTH"]          = width_n
            gms_message_bag["ISSTATUSON"]     = pstatus_l
            gms_message_bag["ISGAUGEON"]      = pgauge_l
            gms_message_bag["COLOR"]          = pcolor_n
            ;---reset attributes-----
            gms_attributes_bag["STYLE"] = pcolor_n
            gms_attributes_bag["HEIGHT"] = length_n + 1
            gms_attributes_bag["WIDTH"] = width_n

            WINDOW MOVE gms_handle_w to  -100,-100
            SETCANVAS gms_handle_w
            WINDOW SELECT gms_handle_w
            CLEAR
            WINDOW SETATTRIBUTES gms_handle_w FROM gms_attributes_bag
            CANVAS ON
            PAINTCANVAS ATTRIBUTE pcolor_n
               0,0,length_n,width_n
    ENDIF
     ;-------------Place top and bottom border--------------------------
   PAINTCANVAS FILL  ""
        BACKGROUND
         0,0,0,width_n
   PAINTCANVAS FILL ""
        BACKGROUND
         length_n,0,length_n,width_n
     ;-------------Place banner header---------------
        @ 1,INT((width_n - LEN(pheader_a))/2)
         ?? pheader_a
        PAINTCANVAS ATTRIBUTE 78
         1,INT((width_n - LEN(pheader_a))/2)-1,1,INT((width_n - LEN(pheader_a))/2)+LEN(pheader_a)+1
        STYLE ATTRIBUTE pcolor_n
         @ 2,INT((width_n - LEN(pheader_a))/2)
           ?? FILL("",LEN(pheader_a)+3)
         @ 1,INT((width_n - LEN(pheader_a))/2)+LEN(pheader_a)+2
           ?? ""
        STYLE
  depthcolor_n = pcolor_n + 15 - MOD(pcolor_n,16)
  IF pgauge_l  THEN
     ;-------------Place gauge-----------------------
     FRAME DOUBLE FROM  3,2 TO 3+2+1,2+(width_n-5)+1
        ;-----------shading on box-------------

        PAINTCANVAS ATTRIBUTE depthcolor_n
            3,2,3,2+(width_n-5)
        PAINTCANVAS ATTRIBUTE depthcolor_n
            3,2,3+3,2
        ;-----------gauge makers------------------
        STYLE ATTRIBUTE pcolor_n
        @ 4,6
          ?? "0                 50                100"
        STYLE
   ENDIF
   ;--------------Place status --------------------------
   IF pstatus_l THEN
        FRAME DOUBLE FROM  statusline_n,2 TO statusline_n+1+1,2+(width_n-5)+1
        ;-----------shading on box-------------
        PAINTCANVAS ATTRIBUTE depthcolor_n
            statusline_n,2,statusline_n,2+(width_n-5)
        PAINTCANVAS ATTRIBUTE depthcolor_n
            statusline_n,2,statusline_n+2,2
        ;---------- status ------------
        STYLE ATTRIBUTE pcolor_n
            @statusline_n+1,4 ?? "Status:"
        STYLE ATTRIBUTE 174
           @ statusline_n+1,24 ?? "Working...!"
        STYLE
    ENDIF
    ;-----move window onto workspace----
    WINDOW MOVE gms_handle_w to srow_n,scol_n
ENDPROC
;("PmessageBanner_u")

; ============================================================
; 09-09-92
; Puts existing message away
; ------------------------------------------------------------
PROC PmessagePutaway_u()
   PRIVATE Procname.a
   Procname.a = "PmessagePutaway_u"
   IF ISWINDOW(gms_handle_w) THEN
      WINDOW MOVE gms_handle_w TO -1000 , -1000
   ENDIF
   IF ISASSIGNED(gms_wallpaper_w) THEN
      IF ISWINDOW(gms_wallpaper_w) THEN
         WINDOW MOVE gms_wallpaper_w TO -1000 , -1000
      ENDIF
   ENDIF
ENDPROC
;("PmessagePutaway_u")

; ============================================================
; 09-09-92
; Gets message in neverland and puts on workspace
; ------------------------------------------------------------
PROC PmessageGet_u(newtitle_a,banner_l,wallpaper_l)
   PRIVATE Procname.a
   Procname.a = "PmessageGet_u"
   IF ISASSIGNED(gms_wallpaper_w) THEN
     IF ISWINDOW(gms_wallpaper_w) AND
        wallpaper_l THEN
        WINDOW MOVE gms_wallpaper_w TO  0,0
     ENDIF
   ENDIF
   IF ISWINDOW(gms_handle_w) AND
      banner_l THEN
      IF newtitle_a <> "" THEN
        SETCANVAS gms_handle_w
        ;--overwrite existing title---
        STYLE ATTRIBUTE  gms_message_bag["COLOR"]
         @ 1,0 ?? FILL(" ",gms_message_bag["WIDTH"])
        ;---place new title----
        @ 1,INT((gms_message_bag["WIDTH"] - LEN(newtitle_a))/2)
         ?? newtitle_a
        PAINTCANVAS ATTRIBUTE 78
         1,INT((gms_message_bag["WIDTH"] - LEN(newtitle_a))/2)-1,1,
           INT((gms_message_bag["WIDTH"] - LEN(newtitle_a))/2)+LEN(newtitle_a)+1
         @ 2,INT((gms_message_bag["WIDTH"] - LEN(newtitle_a))/2)
           ?? FILL("",LEN(newtitle_a)+3)
         @ 1,INT((gms_message_bag["WIDTH"] - LEN(newtitle_a))/2)+LEN(newtitle_a)+2
           ?? ""
        STYLE
      ENDIF
      WINDOW MOVE gms_handle_w TO   gms_message_bag["ROW"] , gms_message_bag["COLUMN"]
   ENDIF
ENDPROC
;("PmessageGet_u")


; ===========================================================================
; Inserts message into status box
; ---------------------------------------------------------------------------
PROC PmessageStatus_u(msg_a)
   PRIVATE  Procname_a,
            offset_n,
            H
   Procname_a = "PmessageStatus_u"
;;   GLOBAL   gms_message_bag["ROW"] = srow_n
;;            gms_message_bag["COLUMN"] = scol_n
;;            gms_message_bag["STATUSPOSITION"] = statusline_n
;;            gms_message_bag["LENGTH"] = length_n
;;            gms_message_bag["WIDTH"] = width_n
;;            gms_message_bag["ISSTATUSON"] = pgauge_l
;;            gms_message_bag["ISGAUGEON"] = pgauge_l
;;            gms_message_bag["COLOR"] = pcolor_n
    ;-----------restore working flasher---------------------
    H = GETCANVAS()
    SETCANVAS gms_handle_w
IF ISASSIGNED(gms_message_bag["ISSTATUSON"]) AND
   gms_message_bag["ISSTATUSON"] THEN
    IF msg_a = "" THEN
        STYLE ATTRIBUTE gms_message_bag[7]
            @gms_message_bag["STATUSPOSITION"]+1,4 ?? "Status:"+FILL(" ",38)
        STYLE ATTRIBUTE 174
            @ gms_message_bag["STATUSPOSITION"]+1,24 ?? "Working...!"
        STYLE
    ELSE
    ;----------make sure the message doesn't spill over-------
    msg_a = SUBSTR(msg_a,1,44)
    ;----------locate beginning of message-------------------
    offset_n = 44 - LEN(msg_a)
    ;----------place message--------------------------------
        STYLE ATTRIBUTE gms_message_bag["COLOR"]
            ;---restore status and clear------------
            @ gms_message_bag["STATUSPOSITION"]+1,4
            ?? "Status:"+FILL(" ",38)
            ;-----place new message-----------
            @ gms_message_bag["STATUSPOSITION"]+1,4+offset_n ?? msg_a
        STYLE
    ENDIF
ENDIF
SETCANVAS H
ENDPROC
;("PmessageStatus_u")


PROC Paintbackground_u(bgcolor_n)
   PRIVATE  Procname_a,
            ms_attr_bag
   Procname_a = "Paintbackground_u"
   ;--if wallpaper already exists on the desktop use it..
   IF ISASSIGNED(gms_wallpaper_w) THEN
      IF ISWINDOW(gms_wallpaper_w) THEN
         WINDOW MOVE gms_wallpaper_w TO 0,0
         RETURN
      ENDIF
   ENDIF
   ;----otherwise create a new one..
     DYNARRAY ms_attr_bag[]
              ms_attr_bag["CANCLOSE"]     = false
              ms_attr_bag["CANMAXIMIZE"]  = false
              ms_attr_bag["CANMOVE"]      = false
              ms_attr_bag["CANRESIZE"]    = false
              ms_attr_bag["ECHO"]         = true
              ms_attr_bag["HASFRAME"]     = false
              ms_attr_bag["STYLE"] = bgcolor_n
       WINDOW CREATE FLOATING @ 0,0
              HEIGHT 25  WIDTH 80
              ATTRIBUTES  ms_attr_bag TO gms_wallpaper_w
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      0,0,2,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      2,0,4,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      4,0,6,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      6,0,8,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      8,0,10,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      10,0,12,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      12,0,14,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      14,0,16,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      16,0,18,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      18,0,20,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      20,0,22,79
   PAINTCANVAS FILL "" ATTRIBUTE bgcolor_n
      22,0,24,79
   PAINTCANVAS FILL FORMAT("W80,AC","Copyright (c) 1993  Micro-Phyla Systems  All Rights Reserved") ATTRIBUTE bgcolor_n
      24,0,24,79
ENDPROC
;("Paintbackground_u")


; ===========================================================================
; updates gauge on message window
; ---------------------------------------------------------------------------
PROC PmessageGauge_u(totalcount_n,currentcount_n)
   PRIVATE  Procname_a
   Procname_a = "PmessageGauge_u"
;;   GLOBAL   gms_message_bag["ROW"] = srow_n
;;            gms_message_bag["COLUMN"] = scol_n
;;            gms_message_bag["STATUSPOSITION"] = statusline_n
;;            gms_message_bag["LENGTH"] = length_n
;;            gms_message_bag["WIDTH"] = width_n
;;            gms_message_bag["ISGAUGEON"] = pgauge_l
;;            gms_message_bag["COLOR"] = pcolor_n
;;            gms_attributes_bag["MAXIMIZED"] = true
   IF ISASSIGNED(gms_message_bag["ISGAUGEON"]) AND
      gms_message_bag["ISGAUGEON"] THEN
        ;-----------gauge incrementer------------------
        SETCANVAS gms_handle_w
        STYLE ATTRIBUTE 36
        @ 5,5
          ?? ""+FILL("",INT(currentcount_n/(totalcount_n/40)))+""
        STYLE
   ENDIF
ENDPROC
;("PmessageGauge_u")



; ============================================================
; 09-09-92
; Releases all globals  and closes any message windows...
; ------------------------------------------------------------
PROC PmessageDestruct_u()
   PRIVATE Procname.a
   Procname.a = "PmessageDestruct_u"
   IF ISASSIGNED(gms_handle_w) THEN
     IF ISWINDOW(gms_handle_w) THEN
        WINDOW SELECT gms_handle_w
        WINDOW CLOSE
     ENDIF
   ENDIF
   IF ISASSIGNED(gms_wallpaper_w) THEN
     IF ISWINDOW(gms_wallpaper_w) THEN
        WINDOW SELECT gms_wallpaper_w
        WINDOW CLOSE
     ENDIF
   ENDIF
   RELEASE VARS      gms_attributes_bag,   ; -- window attributes
                     gms_handle_w      ,   ; -- window handle
                     gms_message_bag   ,   ; -- internal window coordinates
                     gms_wallpaper_l   ,   ; -- existance of wallpaper
                     gms_wallpaper_w      ; -- wallpaper window handle
ENDPROC
;("PmessageDestruct_u")


; ============================================================
; 12-17-92
; Sets a general color for dbox and background, and contrasting
; buttons
; ------------------------------------------------------------
PROC SetColorDbox_u(dcolor_n,bcolor_n) ;SETCOLORS FROM oldcolor_bag
   PRIVATE Procname_a,
           dcolor_bag
   Procname_a = "SetColorDbox_u"
  GETCOLORS TO oldcolor_bag
  ;--offsetcolor
  IF dcolor_n = 112 THEN
      boff_n = 63
  ELSE
     boff_n = 127
  ENDIF
  DYNARRAY dcolor_bag[]
     dcolor_bag[1032] = dcolor_n ; frame
     dcolor_bag[1036] = dcolor_n ; general text
     dcolor_bag[1040] = SetTextColor_n(bcolor_n,"black") ; normal button
     dcolor_bag[1041] = SetTextColor_n(bcolor_n,"yellow") ; default button
     dcolor_bag[1045] = SetTextColor_n(dcolor_n,"black") ; button shadow
     dcolor_bag[1044] = SetTextColor_n(bcolor_n,"lightblue") ;  hotkey shade
     dcolor_bag[1042] = SetTextColor_n(boff_n,"black") ;   selected button
  SETCOLORS FROM dcolor_bag
ENDPROC
;("SetColorDbox_u")

; ============================================================
; 12-10-92
; sets a text color from color word, no space between
; multi words ..ie  "lightgray"  not.. "light gray"
; ------------------------------------------------------------
PROC SetTextColor_n(currentcolor_n,textcolor_a)
   PRIVATE Procname.a,
           retcolor_n
   Procname.a = "SetTextColor_n"
   backgrd_n = Roundit_n((INT(currentcolor_n/16))*16,0)
   SWITCH
      CASE SEARCH(textcolor_a,"black")>0: retcolor_n = backgrd_n + 0
      CASE SEARCH(textcolor_a,"blue")>0: retcolor_n = backgrd_n + 1
      CASE SEARCH(textcolor_a,"green")>0: retcolor_n = backgrd_n + 2
      CASE SEARCH(textcolor_a,"cyan")>0: retcolor_n = backgrd_n + 3
      CASE SEARCH(textcolor_a,"red")>0: retcolor_n = backgrd_n + 4
      CASE SEARCH(textcolor_a,"magemta")>0: retcolor_n = backgrd_n + 5
      CASE SEARCH(textcolor_a,"brown")>0: retcolor_n = backgrd_n + 6
      CASE SEARCH(textcolor_a,"yellow")>0: retcolor_n = backgrd_n + 14
      CASE SEARCH(textcolor_a,"white")>0: retcolor_n = backgrd_n + 15
      CASE SEARCH(textcolor_a,"lightgray")>0: retcolor_n = backgrd_n + 7
      CASE SEARCH(textcolor_a,"darkgray")>0: retcolor_n = backgrd_n + 8
      CASE SEARCH(textcolor_a,"lightblue")>0: retcolor_n = backgrd_n + 9
      CASE SEARCH(textcolor_a,"lightgreen")>0: retcolor_n = backgrd_n + 10
      CASE SEARCH(textcolor_a,"lightcyan")>0: retcolor_n = backgrd_n + 11
      CASE SEARCH(textcolor_a,"lightred")>0: retcolor_n = backgrd_n + 12
      CASE SEARCH(textcolor_a,"lightmagenta")>0: retcolor_n = backgrd_n + 13
      OTHERWISE:
         GeneralMessage_u("ERROR !! In SetTextColor procedure, match not/"+
                          "found for arguement provided..               /")
           retcolor_n  = currentcolor_n
  ENDSWITCH
  RETURN retcolor_n
ENDPROC
;("SetTextColor_n")

; - Developed by Michael Ax
PROC Roundit_n(number_n,places_n)
    PRIVATE a,n
    IF number_n < 0 THEN
        a = "-"
        ELSE
        a = ""
    ENDIF
  n = NUMVAL(a+STRVAL(ROUND(ABS(number_n +NUMVAL(a+STRVAL(.5*POW(10,-(1+places_n))))),places_n)))
  RETURN n
ENDPROC
;("Roundit_n")


; ===========================================================================
;       TITLE: msAlertDialog_u
;     RETURNS: No Value
; DESCRIPTION: Dialog PROC for IDLE events in Messages
;              Copyright (c) 1992 - DataStar International & Dan Paolini
; ---------------------------------------------------------------------------
PROC msAlertDialog_u(            ; Alert Siren in Idle Dialog Box
         type_a,                 ; EVENT or TRIGGER
         tag_a,                  ; Control element tag or null
         event_v,                ; DynArray of GetEvent, or control value
         element_a)              ; Checkbox label or null
;Global  alert_n                 ; Alert Value from dBox (0 - 5)
;Global  onceflag_l              ; For non-continuous Alert (1, 2)
   IF NOT IsAssigned(onceflag_l) THEN
      onceflag_l = true
   ENDIF
   SWITCH
      CASE alert_n = 1 AND onceflag_l :
         Beep Sleep 50
         Beep Sleep 50
         Beep
         onceflag_l = false            ; Turns off subsequent Alerts
      CASE alert_n = 2 AND onceflag_l :
         Sound 770 150
         Sound 440 150
         Sound 770 150
         Sound 440 150
         Sound 770 150
         onceflag_l = false            ; Turns off subsequent Alerts
      CASE alert_n = 3  :
         Beep Sleep 50 Beep Sleep 300
      CASE alert_n = 4  :
         Sound 300 50 Sleep 100
         Sound 300 50 Sleep 100
         Sound 150 50 Sleep 100
         Sound 150 50 Sleep 100
         Sleep 200
      CASE alert_n = 5  :
         Sound 770 150
         Sound 440 150
   ENDSWITCH
ENDPROC
;("msAlertDialog_u")

; ===========================================================================
;       TITLE: msConfirm_l
;     RETURNS: Logical true/false if User Confirmed/Canceled
; DESCRIPTION: Generic Continue-or-Cancel Message routine
;                 Alert 0 = No sound
;                 Alert 1 = Three beeps
;                 Alert 2 = Siren, short (high-low-high-low-high)
;                 Alert 3 = Two beeps, continuous
;                 Alert 4 = Two high beeps, two low beeps, continuous
;                 Alert 5 = Siren, continuous
;              Copyright (c) 1992 - DataStar International & Dan Paolini
; ---------------------------------------------------------------------------
PROC msConfirm_l(                ; Confirmation DialogBox
         msg_a,                  ; Message to display (< 70 chars)
         att_n,                  ; Color for message (not DialogBox!)
         colors_y,               ; Dynarray of custom colors
         alert_n,                ; Sound level of Alert (0 - 4)
         pbok_a,                 ; Label of CONTINUE Pushbutton
         pbcxl_a,                ; Label of CANCEL Pushbutton
         confirm_l)              ; Should Confirm be default?
Private  width_n,                ; Width of Dialog Box
         a1, a2,                 ; Match variables
         n1, n2,                 ; Button length comparisons
         pblen_n,                ; Width of Pushbuttons
         pb_a,                   ; Value of selected Pushbutton
         onceflag_l,             ; True = Non-continuous Alert
         oldcolors_bag,            ; Previous Color Set
         retval_l                ; Value to return
   SetCanvas DEFAULT
   SetColorDbox_u(96,64) ;SETCOLORS FROM oldcolor_bag
   onceflag_l = alert_n < 3

   width_n = Max(Len(msg_a) + 4,Len(pbok_a) + Len(pbcxl_a) + 24)
   a1 = ""
   a2 = pbok_a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n1 = Len(a1+a2)
   a1 = ""
   a2 = pbcxl_a

   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n2 = Len(a1+a2)
   pblen_n = Max(n1,n2)+4

   IF confirm_l THEN                   ; Confirm button is DEFAULT
      SHOWDIALOG "Press <Enter> to Confirm"
                  PROC "msAlertDialog_u" IDLE
                  @ 7,Int((80-width_n)/2)
                  HEIGHT 7 WIDTH width_n
                  Style ATTRIBUTE att_n
                  @ 1, 1 ?? Format("w"+StrVal(width_n-4)+",ac",msg_a)
                  PUSHBUTTON  @ 3,5
                              WIDTH pblen_n pbok_a OK DEFAULT
                              VALUE "OK" TAG "OK" TO pb_a
                  PUSHBUTTON  @ 3,width_n-pblen_n-7
                              WIDTH pblen_n pbcxl_a CANCEL
                              VALUE "Cancel" TAG "Cancel" To pb_a
      ENDDIALOG
   ELSE                                ; Cancel button is DEFAULT
      SHOWDIALOG "Press <Enter> to Cancel"
                  PROC "msAlertDialog_u" IDLE
                  @ 7,Int((80-width_n)/2)
                  HEIGHT 7 WIDTH width_n
                  Style ATTRIBUTE att_n
                  @ 1, 1 ?? Format("w"+StrVal(width_n-4)+",ac",msg_a)
                  PUSHBUTTON  @ 3,5
                              WIDTH pblen_n pbcxl_a CANCEL DEFAULT
                              VALUE "Cancel" TAG "Cancel" To pb_a
                  PUSHBUTTON  @ 3,width_n-pblen_n-7
                              WIDTH pblen_n pbok_a OK
                              VALUE "OK" TAG "OK" TO pb_a
      ENDDIALOG
   ENDIF
   retval_l = retval
   SETCOLORS FROM oldcolor_bag
   Return retval_l
ENDPROC
;("msConfirm_l")

