; AZCONFIG.SC  Version 1.2  March 5, 1988
;
; Copyright Alan Zenreich 1987, 1988       Zenreich Systems  (212) 691-0170
;
; The procedures included in this script are reresentative of the type of
; utility programming that I enjoy.
;
; The procedures are not guaranteed to work with your version of Paradox, but
; are incredibly useful when it works.
;
; This is not a commercial product, so  Zenreich Systems disclaims any liablity
; for it's use and consequences of decisions made on its use.
;
; I do publish a very useful commercial product:
;         ParaLex, the Documentor for Paradox Applications
; Contact Zenreich Systems at the address below for more information.
;
; Although the procedures are Copyright 1988 Alan Zenreich, you are hereby
; granted the use of any of these Procs in your scripts, provided that you
; retain the original names of my procedures.
; (I usually include an acknowledgement in my script comments if I use other
;  peoples' code in this way.)
; If you distribute them, please do so UNALTERED.
;
;
; Two conventions used below are worth noting.
;  1) I preface all variables with the letter "z"
;  2) I preface all procedure names with the letters "az"
;
; The reason for these conventions are simple, they avoid potential conflict
; with future reserved words that Paradox may use, and also designate procedures
; as being written by me ("az" are my initials).
;
; The procedures assume that you know how to program using procedures and
; private variables.  If you are not well versed in these techniques, then
; by all means use the code below to acquaint yourself with them.  HOWEVER, the
; dsitribution of this script does not entitle you to telephone support for
; those new to programming who wish to understand the implementation of
; procedures.  I would, however, like to hear from other system developers and
; consultants with comments about these procs and about ParaLex in general.
; I wish to foster a developers 'community' that freely
; talks with one another.  This is the purpose of making these procs available,
; as well as the reason that I spend so much time writing about Paradox, and
; time spent answering questions on the various Paradox oriented bulletin
; boards.
;
; I hope you find the following code useful, and instructive.  There is no
; sense in trying to reinvent the wheel.
;
;                              Alan Zenreich
;                              Zenreich Systems
;                              78 Fifth Avenue
;                              New York, NY 10011
;                              (212) 691-0170
;
;
;
;
;
PROC azConfig()
  PRIVATE zchoice, autolib
  IF VERSION()<2 THEN
    QUIT "Sorry, this procedure only works with version 2"
  ENDIF
  CURSOR OFF
  IF NOT IsFile(SDIR()+"Azconfig.lib") THEN  ; check for existance of library
    QUIT "Sorry, can't find AZCONFIG.LIB"
  ENDIF
  AUTOLIB=SDIR()+"azconfig"                  ; auto locating of procedures
  WHILE true
    CLEAR
    @2,0  ??FILL("",80)
    @4,0
    TEXT
This script should be able to document your current Paradox2 configuration.
It is not guaranteed to work with all Paradox2 configurations, but it probably
will do just fine.  The procedure DOES NOT ALTER your configuration in any way.

{Print}     sends the current configuration to the printer.
{Screen}    sends the data to the screen.
{Table}     creates a table called AZCONFIG in the current directory and loads
            the data into it.  You can then design your own reports, etc.
{ViewTable} views AZCONFIG once created.
{MoreInfo}  describes explicit use of the procs in the AZCONFIG library.

The procs use restricted (pronounced "dangerous if misused") techniques.
I will not divulge the code, so don't ask me for details, just enjoy (and report
any bugs).  This is Azconfig version 1.2.

Written by: Alan Zenreich     Publisher of ParaLex, the Paradox Documentor.
            Zenreich Systems
            78 Fifth Avenue
            New York, NY  10011
            (212) 691-0170
    ENDTEXT

    SHOWMENU             ; display a menu
    "Printer":"Send current configuration to printer",
    "Screen":"Send current configuration to screen",
    "Table":"Send current configuration to AZCONFIG table",
    "ViewTable":"View current AZCONFIG table",
    "MoreInfo":"Decribe explicit use of these procs",
    "Quit" : "Return to Paradox"
    TO zchoice

    SWITCH
      CASE zchoice="Esc" OR zchoice="Quit":     ; time to get out
        RETURN
      CASE zchoice="ViewTable":                 ; lets view the table
        IF NOT IsTable("azconfig") THEN
          MESSAGE "AZCONFIG table not created yet, press any key"
          zchoice=GETCHAR()
        ELSE
          VIEW "azconfig"
          WHILE true
            WAIT TABLE
              PROMPT "Viewing AZCONFIG table, press [F2] to exit"
            UNTIL "F2",15,-24   ; includes eliminating todos
            IF RETVAL="F2" THEN
              ClearImage
              QUITLOOP
            ELSE
              BEEP
            ENDIF
          ENDWHILE
        ENDIF
      CASE zchoice="MoreInfo":
        @4,0 CLEAR EOS
        TEXT
The procedures can be called explicitly by your scripts by invoking the
following any of the following from the AZCONFIG.LIB:

   azConfigPrinter()   Outputs configuration to printer.
   azConfigScreen()    Outputs configuration to screen.
   azConfigTable()     Creates AZCONFIG table, and leaves it on the disk.
                       (if AZCONFIG exists, a Cancel/Replace menu will appear).

There is one more proc in the library:

   azIsBlankZero()     which returns a TRUE if blanks are treated as zeros or
                       a FALSE if blanks are ignored in calulations.
        ENDTEXT

        SHOWMENU
        "MainMenu":"Return to main configuration menu"
        TO zchoice

      OTHERWISE:
        @0,1 CLEAR EOL
        @0,0 ??"Working"
        STYLE BLINK
        ??"...."
        STYLE
        EXECPROC "azConfig"+zchoice  ; execute the appropriate procedure
    ENDSWITCH
  ENDWHILE
ENDPROC

azconfig()  ; invoke the proc
