;*************************************************************************
;   System : Message Handler
;   File Name : MsgHAND.SC
;   By : M. Makler
;   Last modified:6/10/93
;*************************************************************************

;*************************************************************************
; THIS FREEWARE HAS BEEN PREPARED BY:
;
; MICHAEL MAKLER
; 10221 SLATER AVE
; #103-315
; FOUNTAIN VALLEY, CA 92708
; (714) 571-8510
;
; IF YOU FIND IT USEFUL A DONATION NOT TO EXCEED $35.00 WOULD BE
; APPRECIATED.
;
; FEEL FREE TO USE AND DISTRIBUTE THIS CODE OR ANY PORTIONS OF IT
; WITH YOUR APPLICATION.  IF YOU USE IT PLEASE RETAIN MY COPY
; RIGHT.  IF YOU PLACE IT ON BBS OR DISTRIBUTE IT PLEASE DELIVER
; THE FULL PACKAGE.
;
; EVERY EFFORT HAS BEEN MADE TO TEST AND VALIDATE THIS SYSTEM
; HOWEVER NO GUARANTEES OR WARRANTIES FOR FITNESS OF USE ARE
; EXPRESSED OR IMPLIED.
;
; IF YOU FIND ANY BUGS OR ADD FEATURES PLEASE LET ME KNOW.
; IF YOU HAVE ANY SUGGESTIONS OR CRITICISMS PLEASE LET ME KNOW.
;
; THANK YOU,
; MIKE MAKLER
; Copyright (c) 1993    Michael Makler
;*************************************************************************
;DefDisk.S   = "C:"

;****************************************************************
;
; Name: MsgHand.A
;
; Notes: Main Routine of a Table Based Message Handler
;        This routine will handle Message strings that are constant
;        as well as those with Variable Arguments.
;
; - These procedures provide a table based Message display System that can be
;      used to display Error Messages, Prompt Messages and Informative
;      Messages
;
;      The MSGHAND.A procedure can handle a table of Messages of unlimited
;      size.
;
; - Some variables are 'global' I Have defined them in the Beginning of
;   MSGHAND.A but Typically I make a Call to a Routine Called
;   InitGlobalVars.A in the very beginning of My Program
;   I would Place them There.   All System Wide Globals end in _GL.
;   Some Globals Like Size.N and Msgtext.S are Only Global
;   to the Message Handler routines and are Released before exiting
;   the message handler system
;
;
;*************************************************************
; - This Routine is Designed to Handle Messages with Variables
;   Built In.  It does this by taking advantage of the ** EXECUTE **
;   Command Built in to Paradox.  At present it only works on
;   lines that do String Concatenation Using the "+" operator.
;   This can easily be Extended to Function calls By looking for
;   Parenthesis or text strings by looking for Quotes or . . .
;   but every  case I have ever Used has a Fixed String with a
;   Concatenation operator.
;
;   As an Example to Send A message
;   Cannot Enter EDIT Table - ACINV Not Found
;
;    Where the Table name is NOT KNOWN in Advance place the
;    Following Line in MSGTXT field in your Table
;
;    "Cannot Enter Edit - " + EditTab.S + " Not Found"
;
;    The Quotes are very Important and must not be left Out.
;
;    Your Variable Name in this Case Edittab.s needs to be a Global
;    variable so that the Msghand.A has access to it.  If necessary
;    Set a Local to a global before calling MsgHand.A and release upon
;    Return to your calling Program.
;
;    It is also important that all Variables be Strings
;
;     So any functions or variables that return numeric or date values
;     need to have the Strval() function built into the text line
;
;     THUS
;    "Space Left = " + DiskSpace ("C")  ;*****  IS  NOT CORRECT
;
;    It Should be
;    "Space Left = " + Strval(Diskkspace("C"))
;
;*************************************************************
;
;   ****************************************************************
;   Format of TABIN.S
;       MSGIDX    A6*
;       MSGNUM    S*
;       MSgTXT    A60
;       Type      A1  (E - Error, P - Prompt, D - Display, O - Other
;                      M - Multi-Use)  ;This field not used here, It
;                                      is handy if you want to create a
;                                      report by message Type  (This Field
;                                      is Optional
;   (See Table Below)
;   ****************************************************************
;
;  Table Structure: Tabin.S
;  ͻ
;     1  MsgIdx                     A6*   
;     2  Msgnum                     S*    
;     3  Msgtxt                     A60   
;     4  Type                       A1      This Field is Optional
;                                              I use it to Produce Reports of
;                                              only Error Messages, or Only
;                                              Display Messages
;
;
;
;  - NOTE:
;     MSGTXT does not have to be an A60, I wouldn't make it larger then A60
;     but any smaller string will work as well.
;
;     Also other fields can exist in the table such as MSGDESC.
;     You can place a message discription here and then reference it
;     it an error report that gets placed in a user manual.
;
;  Table Name: C:\User\MsgTab
;  MsgIdxMsgnumMsgTxtType
;      1  Err1         1  Error Backup Aborted                                       E
;      2  Err1         2  Destination Drive Not Ready                                E
;      3  Err2         1  Printer Not Ready                                          E
;      4  Err3         1  Calculation Aborted                                        E
;      5  Err3         2  Negative Square Root Invalid                               E
;      6  Err4         1  "Invalid File Name - " + FileName.S                        E
;      7  Proc01       1   "Importing Data for Ascii File - " + AscciFile.S          P                                 D
;      8  Proc01       2   This is very Time Consuming                               D
;      9  Proc01       3   Processing....                                            D
;      7  Proc02       1   The Machine Is Busy                                       D
;      8  Proc02       2   Pressing <Ctrl-ALT-Del> or                                D
;      9  Proc02       3   Rebooting the system may cause SEVERE DATA DESTRUCTION    D
;     10  Pmpt01       1   The Action You Requested is Very Time Consuming           P
;     11  Pmpt01       2   It May Take 5 Minutes or More                             P
;     12  Pmpt01       3   Are You Sure you Want to Continue                         P
;     13  Pmpt01       4           CONTINUE (YES/NO) :                               P
;     14  ZZZZZZ       1                                                             T
;
; Calling Arguments:
;        Tabin.S     - Name of Input Table
;        MsgIdx.S    - Index Number of Error Message  (A6)
;        Mtype.S     - Message Type ("Error", "Prompt", "Display")
;        Att.N       - Screen Attribute     (Valid Paradox Attribute Number
;                      If -1 use Default
;        ClearFlag.L - If True Clear the Screen Before Displaying Message
;        StrikeKey.L - If True Display Strike any key when ready
;                      Else leave Help screen on for Dur.n
;        Line.N      - Starting line for Screen Display
;                      If -1 Use Default
;        Dur.n       - Number of Seconds to Display Help Screen
;                      If -1 use Default
;
;
;
;   -ERROR MESSAGES
;          Table - <TABIN.S>  Not Found   -  MSGHAND.A was called with a
;                                            Bad Table Name
;
;          Message - <MSGIDX.S>  Not In Table - <TABIN.S>  -
;                                            The Message Index was not in the
;                                            table.
;
;          Messsage - <MSGIDX.S>     Not Terminated in Table - <TABIN.S>
;                                            There was not Following record
;                                            in <TABIN.S> with a message Number
;                                            of 1.
;
;          Message Display Type - <MTYPE.S> is Not Valid
;                                            Currently supported display types
;                                            are: Error, Display, Prompt.
;
;          Message is to Big, Size = <SIZE.N> - Messages cannot be longer then
;                                               15 lines.
;
;
; - example call:
;      MsgHand.A ("C:\\User\\MsgTab", "Error", "Err1", -1, True, False,-1,2000)
;
;
; - Limitations:  This Routine Assumes your Messages will be No Longer
;                 then 15 Lines.  It also will automaticlly place
;                 the Message if startLine.N added to Size.N
;                 is greater then 16 for error Messages or 18 for
;                 Display and Prompt Messages.
;
;                 By design the screen is not cleared when you exit the
;                 Message Handler.
;
;                 I HAVEN'T TAKEN ADVANTAGE OF THE WINDOW OR
;                 DIALOGUE PROCEDURES OF PARADOX 4 BUT THAT
;                 WOULDN'T BE A HARD PORT I GUESS I'M KIND OF
;                 USE TO THIS AND I LIKE IT
;
; Copyright (c) 1993 Michael Makler
;****************************************************************************
PROC MsgHand.A (Tabin.S, MsgIdx.S, Mtype.S, Att.N, ClearFlag.L, StrikeKey.L,
                Line.N, Dur.N)

   PRIVATE ProcName.s,  ; Used by Error Handler Routine
           Istable.L,   ; Does Table Exist
           FirstRec.N,  ; Record Number  of First Line of Message
           LastRec.N,   ; Record Number of Last Line of Message
           I.N,         ; Loop Counter
           Rcount.N,    ; Record Counter into Message Array
           Plus.N       ; Is there a "+" in Message String

   SetSwap 50000
   ;****************************************************
   ; Globals     (in Form <VAR>_GL
   ;****************************************************
   DisplayColor_GL  = 112                ; Default Colors for Display Messages
   ErrorColor_Gl    = 79                 ; Default Colors for Error Messages
   PromptColor_GL   = 112                ; Default Colors for Prompt Messages
   Pause_Gl         = 2000               ; Default Delay Time for Message Display
   Monitor_GL       = Upper (Monitor())  ; Default Monitor Type
   MaxMSGSize_GL    = 15                 ; Maximum Number of Lines for Messages
   StrikeMsg_GL     = "Strike Space Bar When Ready"  ; Display Pause Message
   ErrorMsg_GL      = "Error    Error   Error"       ; Top Line of Error Message



   ProcName.S = "MsgHand.A"
   Istable.L = IsTable (Tabin.S)

   If Not Istable.L
      Then  If ClearFlag.L
               Then Clear
            Endif ;**** ClearFlag.L ****
            Beep Beep Beep
            Message  "Table - " + Tabin.S + " Not Found"
            Sleep 3000
            Return   ;Table not found so exit
   Endif ;*** Not Istable.L ***

   View Tabin.s
   Moveto Field "MSGIDX"
   Locate MsgIdx.S
   If Not Retval
      then If ClearFlag.L
              Then Clear
           Endif ;**** ClearFlag.L ****
           ClearImage
           Beep Beep Beep
           Message  "Message - " + MsgIDx.S + "    Not In Table - " + Tabin.S
           Sleep 3000
           Return ; Message not Found
   Endif ;*** Not Retval ***

   Firstrec.N = RecNo ()
   Skip
   MoveTo Field "MSGNUM"
   Locate Next 1
   If Not Retval
      then If ClearFlag.L
              Then Clear
           Endif ;**** ClearFlag.L ****
           ClearImage
           Beep Beep Beep
           Message  "Messsage - " + MsgIDx.S + "    Not Terminated in Table - " + Tabin.S
           Sleep 3000
          Return ;Invalid Message Pointer
   Endif ;*** Not RetVal ***

   LastRec.N = Recno () - 1

   Size.N = LastRec.N - FirstRec.N + 1

;**********************************************************************
;        If Message is To Big Produce Error
;************************************************************************
    If Size.N > MaxMSGSize_GL
       then If ClearFlag.L
               Then Clear
            Endif ;**** ClearFlag.L ****
            ClearImage
            Beep Beep Beep
            Message  "Message - " +MsgIdx.S + " is to Big, Size = " + StrVal (Size.N)
            Sleep 3000
            Return
    Endif ; *** Size.N > MaxMSGSize_GL ***



   Array MsgText.S [Size.n]
   RCount.N = FirstRec.N

   For I.N from 1 to Size.N Step 1
       Moveto Record Rcount.N
       Msg.S = [Msgtxt]
       Plus.N = Search ("+",Msg.S)
       If Plus.N > 0
          then Execute "MsgText.S[i.n] = " + Msg.S
          Else MsgText.S[i.n] = Msg.S
       Endif ;*** Plus.N > 0 ***
       Rcount.N = Rcount.N + 1
   Endfor ;*** I.N from 1 to Size.N step 1 ***
   ClearImage
   Mtype.S = Upper (Mtype.S)




   Cursor Off
   Switch     ;*** Based on Message Type ***
      Case Mtype.S =  "DISPLAY":  PlaceDispMsg.A   (Line.N, Att.N, Dur.n, StrikeKEY.L,Mtype.s,ClearFlag.L)
      Case Mtype.S =  "ERROR"  :  PlaceErrorMsg.A  (Line.N, Att.N, Dur.n, StrikeKEY.L,Mtype.s,ClearFlag.L)
      Case Mtype.S =  "PROMPT" :  PlaceDispMsg.A   (Line.N, Att.N, Dur.n, StrikeKEY.L,Mtype.S,ClearFlag.L)
      OtherWise                :  If ClearFlag.L
                                     Then Clear
                                  Endif ;**** ClearFlag.L ****
                                  Beep Beep Beep
                                  Message  "Message Display Type - " + Mtype.S + " is Not Valid"
                                  Sleep 3000
   EndSwitch  ;*** Based on Message Type ***
   Cursor Normal

   Release Vars MsgText.S,
                Size.N
   Return
ENDPROC ;**** MsgHand.A ****
WRITELIB LibName.a MsgHand.A
RELEASE PROCS      MsgHand.A
?? "+"



;****************************************************************
; Name:  ClearLines.A
; Notes: This Routine will clear the lines where the Messages are displayed.
;
; Inputs:
;         FirstLine.N   - First Line to Clear
;
;         Lastline.n    - Last Line to clear
;
;         ClearFlag.L   - If True Clear whole Screen otherwise just Clear Lines
;
;
; Copyright (c) 1991 Michael Makler
;****************************************************************
Proc ClearLines.A (FirstLine.N, LastLine.N, ClearFlag.L)
   Private I.N ;loop Counter

   If ClearFlag.L
      Then Clear
      Else For I.N from firstline.n to lastline.n step 1
               @ I.N, 0
               Clear Eol
           EndFor ;*** I.N from firstline.n to lastline.n step 1 ***
   Endif ;**** ClearFlag.L ****
   Return
ENDPROC ;**** ClearLines.A ****
WRITELIB LibName.a ClearLines.A
RELEASE PROCS      ClearLines.A
?? "+"


;****************************************************************
; Name:  FinishMsg.A
; Notes: This Routine will do the Finish Message Processing.
;        It will Either Pause for Dur.N or it Will
;        Display a Message to Strike a Key When Ready
;
; Globals:
;         StrikeMsg_GL - Message to Display "Strike any Key When Ready"
;
;         Pause_GL     - Amount of Time to Pause Display
;
; Inputs:
;         Strikekey.l   - If True then pause screen till user strikes a key
;
;         Endline.n     - Last Line of Display
;
;         Dur.N         - Amount of Time in Thousandths of a Second
;                         to Display Error Message
;                         (I.E. 1000 = 1 sec)
;                         (Only Valid Is StrikeKeY.L is False)
;                         (If -1 use Default)
;
; Copyright (c) 1991 Michael Makler
;****************************************************************
Proc FinishMsg.A (StrikeKey.L, EndLine.N, Dur.N)
   Private N



   If StrikeKey.L
      then WHILE CHARWAITING()        ; Clear KeyBoard Buffer
            N = GETCHAR()
           ENDWHILE ;*** CharWaitIng() ***

           @ EndLine.N , 10
           ?? StrikeMsg_GL
           Beep  Beep Beep
           Sleep 1000
           Beep beep  Beep
           N = GetChar()

      Else If Dur.N = -1
              Then Dur.N = Pause_Gl
           Endif ;*** Dur.N = -1 ***

           Beep beep Beep
           Sleep Dur.N
           Beep beep beep
   Endif ;*** StrikeKey.L ***


   Return
ENDPROC ;**** FinishMsg.A ****
WRITELIB LibName.a FinishMsg.A
RELEASE PROCS      FinishMsg.A
?? "+"

;****************************************************************
; Name:  FrameMsg.A
; Notes: This Routine will place the frame around the Message
;
; Globals:
;         Monitor_GL   - Type of Monitor ("COLOR", "MONO", "B&W")
;
;         Pause_GL     - Amount of Time to Pause Display
;
; Inputs:
;         Startline.   - First Line of Display
;
;         Endline.n     - Last Line of Display
;
;         Att.N         - Paradox Color Attribute
;
;         Mtype.S       - Message Type (Error, Display Prompt)
;
; Copyright (c) 1991 Michael Makler
;****************************************************************
Proc FrameMsg.A (StartLine.N, EndLine.N, Att.N, Mtype.s)
Private ScreenColor.N     ; Screen Color Attributes

     ;***************************************************
     ; Get ScreenColor
     ;***************************************************
     IF Att.N < 0 or Att.N > 255  ;If Attribute value not Valid
        then Mtype.S = Upper (Mtype.S)
             Switch ;*** Message Type ****
                 Case Mtype.S = "ERROR"   : ScreenColor.N = ErrorColor_Gl
                 Case Mtype.S = "DISPLAY" : Screencolor.N = DisplayColor_GL
                 Case Mtype.S = "PROMPT"  : ScreenColor.N = PromptColor_GL
                 OtherWise                : ScreenColor.N = DisplayColor_GL
             EndSwitch  ;*** Message Type ***
        Else ScreenColor.N = Att.N
     Endif ;*** Att.N = -1 ***


     If Monitor_GL = "COLOR"
        Then   PaintCanvas Attribute ScreenColor.N
                           StartLine.N - 1 , 00 ,EndLine.N + 1, 79
               Style Attribute   ScreenColor.N
        Else   PaintCanvas  Border fill chr(254)
                            Intense
                            StartLine.N - 1,00 ,Endline.N + 1,79
               Style Intense
     Endif ;**** Monitor_GL = "COLOR" ****

   Return
ENDPROC ;**** FrameMsg.A ****
WRITELIB LibName.a FrameMsg.A
RELEASE PROCS      FrameMsg.A
?? "+"

;****************************************************************
; Name:  PlaceDispMsg.A
; Notes: Places a Variable Length Display Message on the Screen
;
; Globals: MsgText.S       -  This is an Array containing each line of the
;                             Message to Display
;
;          Size.N          - This is the Size of The Message Array
;
;
; Inputs: StartLine.N   - Line Number to Start Message Display on.
;                         (If -1 then Center it)
;
;        Att.N          - foreground and background color of boxed
;                         Message Text.  (If -1 Use Default)
;                         for a red background on a white foreground pass 89
;                         64+15  (64 = red background, 15 = white foreground)
;                         See appendix A of Paradox User Guide
;                         for Complete list of colors
;
;         Dur.N         - Amount of Time in Thousandths of a Second
;                         to Display Error Message
;                         (I.E. 1000 = 1 sec)
;                         (Only Valid Is StrikeKeY.L is False)
;                         (If -1 use Default)
;
;         StrikeKey.L   - If True display Message
;                         Strike Any Key when Ready
;
;         Mtype.S       - Message Type (Error, Display Prompt)
;
;         ClearFlag.L   - If True Clear whole Screen otherwise just Clear Lines
;
; Copyright (c) 1991 Michael Makler
;****************************************************************
Proc PlaceDispMsg.A (  StartLine.N, Att.N, Dur.n, StrikeKey.L, Mtype.S, ClearFlag.L)
    ;*************************
    ;*  locals
    ;**************************
    Private Endline.N,        ; Last Line of Message
            I.N ,             ; Loop Counter
            MsgLine.N,        ; Line Number to Display
            ProcName.S,       ; Name of this procedure for Error Handling
            S.N,              ; Total Size with Blank Lines and Strike
                              ; Key Prompt Built In
            Total.N           ; Total lines Used


    ProcName.S = "PlaceDispMsg.A"
    ;**************************************************************
    ; Calculate StartLine
    ;**************************************************************
    Total.N = Startline.N + Size.N
    If StartLine.n = -1  or Total.N > 18
       then If StrikeKey.L
               Then S.N = Size.N + 5
               Else S.N = Size.N + 3
            Endif  ;**** StrikeKey.L ****
            StartLine.N = Int (13 - (S.N/2))   ; Center Text on Screen
    Endif ;*** StartLine.N = -1 or Total.N > 18 ***

    If  StartLine.N < 2
        Then StartLine.N = 2
    Endif ;*** StartLine.N < 2 ***

    ;******************************************************************
    ;* Calculate EndLine.N
    ;******************************************************************
    Endline.N = StartLine.N + Size.N - 1
    If StriKekey.L
       then EndLine.N = EndLine.N + 2
    Endif ;*** StrikeKey.L ***


    Canvas Off
    ;*****************************************************************
    ;   Clear display Lines
    ;*****************************************************************
    ClearLines.A (StartLine.n - 1, Endline.N + 1 ,ClearFlag.L)

    FrameMsg.A (StartLine.N, EndLine.N, Att.N, Mtype.S)

    For I.N from 1 to Size.N Step 1
        MsgLine.N = StartLine.N + I.N  -1
        @ MsgLine.N, 10
        ?? MSGText.S [I.N]
    EndFor ;*** I.N from 1 to Size.N Step 1***
    Canvas On
    FinishMsg.A (StrikeKey.L, EndLine.N, Dur.n)

EndProc ;*** PlaceDispMsg.A  ***
WriteLib LibName.A PlaceDispMsg.A
Release Procs PlaceDispMsg.A
?? "+"


;****************************************************************
; Name:  PlaceErrorMsg.A
; Notes: Places a Variable Length Error Message on the Screen
;
; Globals: MsgText.S       -  This is an Array containing each line of the
;                             Message to Display
;
;          Size.N          - This is the Size of The Message Array
;
; Inputs: StartLine.N   - Line Number to Start Message Display on.
;                         (If -1 then Center it)
;
;        Att.N          - foreground and background color of boxed
;                         Message Text.  (If -1 Use Default)
;                         for a red background on a white foreground pass 89
;                         64+15  (64 = red background, 15 = white foreground)
;                         See appendix A of Paradox User Guide
;                         for Complete list of colors
;
;         Dur.N         - Amount of Time in Thousandths of a Second
;                         to Display Error Message
;                         (I.E. 1000 = 1 sec)
;                         (Only Valid Is StrikeKeY.L is False)
;                         (If -1 use Default)
;
;         StrikeKey.L   - If True display Message
;                         Strike Any Key when Ready
;
;         Mtype.S       - Message Type (Error, Display Prompt)
;
;         ClearFlag.L   - If True Clear whole Screen otherwise just Clear Lines
;
; Copyright (c) 1991 Michael Makler
;****************************************************************
Proc PlaceErrorMsg.A (  StartLine.N, Att.N, Dur.n, StrikeKey.L, Mtype.S ,ClearFlag.L)
    ;*************************
    ;*  locals
    ;**************************
    Private Endline.N,        ; Last Line of Message
            I.N ,             ; Loop Counter
            MsgLine.N,        ; Line Number to Display
            ProcName.S,       ; Name of this Procedure for Error Handling
            S.N,              ; Message Size with Blank Lines and Error
                              ; Prompt and Strike any Key Prompt Built In
            Total.N           ; Total Lines of Display Image

    ProcName.S = "PlaceErrorMsg.A"
    ;**************************************************************
    ; Calculate StartLine
    ;**************************************************************
    Total.N = StartLine.N + Size.N
    If StartLine.n = -1   or Total.N > 16
       then If StrikeKey.L
               Then S.N = Size.N + 7
               Else S.N = Size.N + 5
            Endif  ;**** StrikeKey.L ****
            StartLine.N = Int (13 - (S.N/2) ) ; Center Text on Screen
    Endif ;*** StartLine.N = -1

    If  StartLine.N < 2
        Then StartLine.N = 2
    Endif ; *** StartLine.N < 2 ***

    ;******************************************************************
    ;* Calculate EndLine.N
    ;******************************************************************
    Endline.N = StartLine.N + Size.N + 1 ; Allow for Error Message
    If StriKekey.L
       then EndLine.N = EndLine.N + 2
    Endif ;*** StrikeKey.L ***

    Canvas Off
    Clearlines.A (Startline.N -1, Endline.n + 1 ,ClearFlag.L)

    FrameMsg.A (StartLine.N, EndLine.N, Att.N, Mtype.s)


    @ StartLine.N, 10
    ??  ErrorMsg_GL
    For I.N from 1 to Size.N Step 1
        MsgLine.N = StartLine.N + I.N + 1
        @ MsgLine.N, 10
        ?? MSGText.S [I.N]
    EndFor ;*** I.N from 1 to Size.N Step 1 ***

    Canvas ON
    FinishMsg.A (StrikeKey.L, EndLine.N, Dur.n)

    Return
EndProc ;*** PlaceErrorMsg.A  ***
WriteLib LibName.A PlaceErrorMsg.A
Release Procs PlaceErrorMsg.A
?? "+"
