;; ask library
;; created by Greg Collver

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Copyright (C) 1992 Josephine County School District
;; Permission is granted to any individual or institution
;; to use, copy, or redistribute this program so long as
;; this copyright notice is retained.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Run this program and include the following statement:
;;      autolib = "asklib"
;; at the beginning of your script and you can code your
;; queries within your scripts w/o using ask/querysave.
;;
;; For instance:
;;      askselect("student","stuno,name,birthdate")
;;      asktype("gl","10")
;;      askdo("")
;; will create an answer table with stuno, name and birthdate for
;;      all 10th grade students.
;; The optional parameter in askdo will automatically rename the
;; answer table for you.
;; The functions are:
;;
;; askselect("table","col1,col2...")
;;      checkmarks the columns in the table
;; asktype("column","@")
;;      creates an example element using the column name
;; asktype("column","@abc")
;;      create and example element abc"
;;      multiple asktypes are allowed in the same column,
;;      it will automatically insert a comman between them for you.
;; askdelete("table")
;;      sets up a delete ask form with "delete" for table
;; askinsert("table")
;;      sets up an insert ask form
;; askset("table")
;;      sets up a set ask form
;; askdo("optionalname")
;;      processes query and renames answer table to "optionalname"
;; askcreate("table","col1=type1, col2=type2 ...")
;;      will create a table with col1 etc.

;; I create this program after getting frustrated with the querysave
;; scripts and wishing I had something more like SQL to code my
;; scripts with.

createlib "asklib"

proc askdelete(tabname)
        {ask} typein tabname enter
        typein "delete"
endproc

proc askinsert(tabname)
        {ask} typein tabname enter
        typein "insert"
endproc

proc askset(tabname)
        {ask} typein tabname enter
        typein "set"
endproc

proc askselect(tabname,columns)
        private wfieldname, wfieldnameend
        {ask} typein tabname enter
        if (columns="") then
                return
        endif
        if (columns="*") then
                keypress "f6"
                return
        endif
        while (true)
                wfieldnameend = search(",",columns)
                if (wfieldnameend>0) then
                        wlen = len(columns) - wfieldnameend
                        wfieldname = substr(columns,1,wfieldnameend-1)
                        columns = substr(columns,wfieldnameend+1,wlen)
                else
                        wfieldname = columns
                endif
                moveto field wfieldname
                keypress "f6"
                if (wfieldnameend=0) then
                        quitloop
                endif
                while (substr(columns,1,1)=" " and len(columns)>0)
                        wlen = len(columns) - 1
                        columns = substr(columns,2,wlen)
                endwhile
        endwhile

endproc

proc asktype(fieldname,qtext)
        private wex, q1
        moveto field fieldname
        if (fieldstr()<>"") then
                typein ", "
        endif
        if (qtext="_" or qtext="@") then
                keypress "f5"
                typein fieldname
                return
        endif
        while (true)
                wex = search("@",qtext)
                if (wex>0) then
                        wlen = len(qtext) - wex
                        typein substr(qtext,1,wex - 1)
                        keypress "f5"
                        qtext = substr(qtext,wex + 1, wlen)
                else
                        typein qtext
                        quitloop
                endif
        endwhile
endproc

proc askdo(tabname)
        do_it!
        if (tabname<>"") then
                rename "answer" tabname
        endif
        clearall
endproc  


proc askcreate(tabname,columns)
        private wfieldname, wtype, i, lastfield
        if (istable(tabname)) then
                message "askcreate: (" + tabname + ") exists!"
                sleep 2000
                return
        endif
        if (columns="") then
                return
        endif
        {create} typein tabname enter
        lastfield = 0
        while (true)
                ;; parse out first field spec
                i = search(",",columns) ; find end of 1st field
                if (i>0) then ;; must be more than one field
                        wlen = len(columns) - i
                        wfieldname = substr(columns,1,i-1)
                        columns = substr(columns,i+1,wlen)
                else
                        wfieldname = columns
                        lastfield = 1
                endif
                
                ;; parse the field name & type
                i = search("=",wfieldname)
                if (i>0) then ;; found the equal sign
                        wlen = len(wfieldname) - i
                        wtype = substr(wfieldname,i+1,wlen)
                        wfieldname = substr(wfieldname,1,i-1)
                        typein wfieldname tab typein wtype enter
                endif
                
                if (lastfield=1) then
                        quitloop
                endif
                
                while (substr(columns,1,1)=" " and len(columns)>0)
                        wlen = len(columns) - 1
                        columns = substr(columns,2,wlen)
                endwhile
        endwhile
        do_it!
endproc


writelib "asklib" askselect, asktype, askdo, askinsert, askcreate, askset,
        askdelete
