; SETKEY -46 Play "ALTC"  ; change script name and any pathnames as required
;
; Requires Paradox v4.5 for DOS
;
; Here's a quick script to make it a little easier when designing forms
; in PDOX. Simply add the first line above to your INIT script and reload
; Paradox.
;
; Edit a form, color the form in its basic color then place a border on
; the form and press [ALT C] - presto the box should be displayed
; with shadow and sunny lines.
; The box can either be single or double border.
;
; You can also add text on the top line and this is displayed in a contrasting
; color. eg.
;    This is TextĿ
;                       
;                       
;                       
;                       
;    
;
; The code is fairly simple, you can modify and customize to your hearts
; content.
;
; Have fun...
;
; (c) AdSus Computer Systems
;     Adrian Williams
;     PO Box 62
;     Napier, New Zealand
;     [100026,220]

;[]-------------------------------------------------------------------[]
;        TITLE: ALTC_COLOR                    (c) AdSus Computer Systems
;      RETURNS: no value
;  DESCRIPTION: selects the appropriate color from the background
; DATE WRITTEN: Thu  28-07-1994   Time: 17:55:47
;      VERSION: 1.00
;[]-------------------------------------------------------------------[]
Proc ALTC_COLOR(clr)
Private B,x

     B=int(CursorAttr()/16)                              ; get the bkground color

     Home                                                ; position the palette
     For x from 1 to b                                   ; select bkground color
         Down
     endFor

;Ŀ
; colors for the Sunny Lines 
;
     If upper(CLR)="SUNNY" then
        Switch
           Case b=1 : Left Left Left Left Left Left Left ; Bright Blue on blue
           Case b=2 : Left Left Left Left Left Left      ; Bright Green on Green
           Case b=3 : Left Left Left Left Left           ; Bright Cyan on Cyan
           Case b=4 : Left Left Left Left                ; Bright Red on Red
           Case b=5 : Left Left Left                     ; Bright Mgnta on Magenta
           Case b=6 : Left Left                          ; Yellow on Brown
           Case b=7 : Left                               ; White on Gray
        endSwitch
     endIf

;Ŀ
; colors for the text on the first line 
;
     If upper(CLR)="LETTER" then
        Switch
           Case b=1 : Left                               ; White on Blue
           Case b=2 : Left                               ; White on Green
           Case b=3 : Left                               ; White on Cyan
           Case b=4 : Left                               ; White on Red
           Case b=5 : Left Left                          ; Yellow on Magneta
           Case b=6 : Left Left                          ; Yellow on Brown
           Case b=7 : Left                               ; White on Gray
        endSwitch
     endIf
endProc

;[]-------------------------------------------------------------------[]
;        TITLE: ALTC                          (c) AdSus Computer Systems
;      RETURNS: no value
;  DESCRIPTION: Paints a box on a Paradox Form
; DATE WRITTEN: Thu  28-07-1994   Time: 17:56:02
;      VERSION: 1.00
;[]-------------------------------------------------------------------[]
Proc Closed Altc()
;Ŀ
; color the top line 
;
    Right
    While Cursorchar()<>""  and                   ; find the starting point
          Cursorchar()<>""
      if colno()=79 then Down endif
      Right
    endwhile

    Menu {Style} {Color} {Area} Enter
    While Cursorchar()<>"" and
          Cursorchar()<>""
      if colno()=79 then Down endif
      Right
    endwhile
    left enter ALTC_COLOR("Shadow") enter

;Ŀ
; color the right hand vertical line 
;
    Right
    Menu {Style} {Color} {Area} Enter

    While Cursorchar()<>"" and
          Cursorchar()<>""
      if rowno()=24 then Quitloop endif
      Down
    endwhile
    enter ALTC_COLOR("Sunny") enter

;Ŀ
; color the bottom line 
;
    Menu {Style} {Color} {Area} Enter
    While Cursorchar()<>"" and
          Cursorchar()<>""
      if colno()=1 then QuitLoop endif
      Left
    endwhile
    Right enter ALTC_COLOR("Sunny") Enter

;Ŀ
; color the left hand vertical line 
;
    Left
    Menu {Style} {Color} {Area} Enter
    While Cursorchar()<>"" and
          Cursorchar()<>""
      if rowno()=1 then Quitloop endif
      Up
    endwhile
    enter Home ALTC_COLOR("Shadow") enter

;Ŀ
; Now color any text on the top line 
;
    x=colno()                                ; remember the current pos
    While Cursorchar()<>"" and
          Cursorchar()<>""
       Right
       if Cursorchar()<>"" and
          Cursorchar()<>"" and
          Cursorchar()<>"" and
          Cursorchar()<>"" then
          Menu {Style} {Color} {Area} Enter
          While Cursorchar()<>"" and
                Cursorchar()<>"" and
                Cursorchar()<>"" and
                Cursorchar()<>""
                right
          endWhile
          Left Enter ALTC_COLOR("Letter")  Enter
          Quitloop
       endif
    Endwhile
    CtrlHome
    While colno()<>x Right endWhile          ; return to cursor pos
endproc

;Ŀ
; Run the procedure from here...     
;
If upper(SYSMODE())<>"FORM" then
   KeyPress -46
Else
   ALTC()
endif
