/*
C source begins
written for Borland C++ 3.1 compiler

filepoke.c
(c) 1994 Norm Bowler.  All Rights Reserved

Extremely simple utility which allows you to poke bytes
into a file at a specified location.  First arg is path to file;
Second arg is zero-based offset; succeeding args are string representations
of integers 0 to 255 inclusive.
*/

//includes
#include <stdio.h>
#include <stdlib.h>


main (int argc, char * argv []) {

  //vars
  int lp;
  long l;
  FILE *fp;

  //arg check
  if (argc <4 ) {
    puts("\nFILEPOKE.EXE (c) 1994 Norm Bowler");
    puts("This util pokes bytes into a file at a specified location.");
    puts("\nUSAGE: FILEPOKE filename zerobasedoffset int [int int...]");
    puts("int is a string representation of an integer, 0 to 255 inclusive.");
    return 1;
  }

  //open output file
  if ((fp=fopen(argv[1],"rb+"))==NULL ) {
    puts("Can't open output file.");
    return 1;
  }

  //position file pointer
  l=atol(argv[2]);
  fseek(fp, l, SEEK_SET );

  //write out bytes
  for (lp=3;lp<argc;lp++)
    fputc(atoi(argv[lp]),fp);

  //close output
  fclose(fp);

  //good exit
  return 0;
}