;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure Accept2
;Source File     : ACCEPT2.SC
;Author          : Christopher Reid
;                  Insight Research
;                  P. O. Box 73001
;                  Davis, CA   95617
;                  Phone: (916) 758-4945
;Informant Issue : February 1991
;Description     : Accept2 is an provides enhancements to the PAL ACCEPT
;                  command. It allows for editing in field view rather than
;                  just [Backspace] and [Ctrl][Backspace] as with the ACCEPT
;                  command.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

proc closed accept2(def)
  usevars retaccept

  retaccept  = true
  done       = false
  insertmode = true

  pos      = 1
  x        = col()
  y        = row()
  instring = def

  while not done
    cursor off
    @ y,x
    ?? instring
    @ y,x+pos-1
    if insertmode then
      cursor normal
    else
      cursor box
    endIf

    c = getchar()

    switch
      case c = 8    :

        if pos <> 1 then
           pos = pos - 1
           instring = substr(instring,1,pos-1) +
                      substr(instring,pos+1,len(instring));
           @ y, x + len(instring)
           ?? " "
           endIf

      case c = 13   :

         done = true

      case c = 27   :

        done = true
        retaccept = false
        instring = ""

      case c = -75  :

        if pos <> 1 then
           pos = pos - 1
        endIf

      case c = -77  :

        if pos <= len(instring) then
           pos = pos + 1;
        endif

      case c = -71  :

        pos = 1;

      case c = -79  :

         pos = len(instring) + 1

      case c = -82  :

         insertmode = not insertmode;

      case c = -83  :

        instring = substr(instring,1,pos-1) +
                   substr(instring,pos+1,len(instring))
        @ y, x + len(instring)
        ?? " "

      otherwise     :

        if c >= 32 then
           before = substr(instring,1,pos-1)
           if insertmode then
                after = substr(instring,pos,len(instring))
              else
              after = substr(instring,pos+1,len(instring))
           endIf
           instring = before + chr(c) + after
           pos = pos + 1
        endIf
    endswitch
  endwhile
  cursor normal
  return instring
endproc

createlib "accept2"
writelib "accept2" accept2
