;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedures CalcMain, Do4Function, EditTape
;Source File     : ACALC.SC
;Author          : Ernie Camacho
;                  E=MC^2
;                  711 College St.
;                  Woodland, CA   95695
;                  Phone: (916) 666-3887
;Informant Issue : January 1992
;Description     : A pop-up PAL calculator. Please note the tables and forms
;                  for this routine are also contained in ACALC.ZIP.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

proc Do4Function()
;global vars in: ThisEntry.n     ;contents of [CALC -> ENTRY]
;                Keyval.v        ;key pressed for operation + - * /

private  PrevBalance.n

   upimage                           ;to the Tape table
   end                               ;move to last record in table
   if not isblank([Balance]) then
      PrevBalance.n = [Balance]
   else
      PrevBalance.n = 0
   endif

   if isblank(ThisEntry.n) then         ;just operator was given.
      if not isblank([Entry]) then
         ThisEntry.n = [Entry]          ;ditto previous entry
      else
         ThisEntry.n = 0
      endif
   endif
   down                                 ;open a new record
   [Entry] = ThisEntry.n                ; & fill it in
   [Operator] = strval(Keyval.v)
   switch
      case Keyval.v = "+":
         [Balance] = PrevBalance.n + [Entry]
      case Keyval.v = "-":
         [Balance] = PrevBalance.n - [Entry]
      case Keyval.v = "*":
         [Balance] = round((PrevBalance.n * [Entry]),2)
      case Keyval.v = "/":
         [Balance] = round((PrevBalance.n / [Entry]),2)
   endswitch
   downimage                              ;back to CALC table
   [Entry] = blanknum()                   ;blank out input field
endproc
;=========================================================================

proc CalcMain()
;global vars in: CalcDir.a       ;Where script & tables live
private N,
        KeyVal.v,
        ThisEntry.n,
        PrevBalance.n
   ;-----------------------------------------------
   ;Structure Of: TAPE                Structure Of: CALC
   ;ͻ   ͻ
   ;   1  Entry           N           1  Entry           N     
   ;   2  Operator        A1    
   ;   3  Balance         N     
   ;-----------------------------------------------
   coedit CalcDir.a+"CALC"       ;CALC table residing in its 'home' directory.
   pickform 1                    ;multi-table unlinked form
   ;--note that using 'empty table' instead of blanknum() would throw me into
   ;  table view.
   [Entry] = blanknum()          ;blank out data input field
   ;--the embedded TAPE table should always have 17 blank rcds at the top.
   upimage                       ;to the TAPE table image
   if nrecords(table()) < 17 then
      downimage                  ;explicite move. Do_it! by itself does this.
      do_it!                     ;get out of coedit mode
      upimage                    ;back up to TAPE
      empty table()
      coeditkey                  ;get back into coedit mode
      for N from 1 to 17         ;Fill up the 17 rows in the TAPE image
         ins                     ;open up a new record
         [operator] = " "        ; & put something in it
      endfor
      ;--have last rcd show a zero balance
      end
      [Balance] = 0
      [Operator] = "="
   endif
   ;--insure that the last rcd is at the bottom of the image
   setrecordposition nrecords(table()) nrows()
   downimage

   ;--Sit in the CALC table's data entry field until an operation key is pressed
   while true         ;[CALC -> ENTRY] field wait-field loop
      wait field
         prompt "F2 to end,    PGUP to edit tape"
      until "+", "-", "*", "/", "=", "F2", "PgUp", 3

      KeyVal.v = retval
      switch
         case KeyVal.v = "+" :
            ThisEntry.n = [Entry]
            Do4Function()

         case KeyVal.v = "-" :
            ThisEntry.n = [Entry]
            Do4Function()

         case KeyVal.v = "*" :
            ThisEntry.n = [Entry]
            Do4Function()

         case KeyVal.v = "/" :
            ;--we have to divide by a non-zero number
            if not isblank([Entry]) then
               if [Entry] = 0 then                  ;Calc->Entry = 0
                  message "You can't divide by 0."
                  beep sleep 500 beep sleep 500 beep sleep 1000
                  loop
               else
                  ThisEntry.n = [Entry]
               endif
            else       ;[Entry] is blank.  let's see what the tape has
               upimage                    ;to TAPE table
               if isblank([Entry]) or
                [Entry] = 0   then
                  message "You can't divide by 0."
                  beep sleep 500 beep sleep 500 beep sleep 1000
                  downimage               ;back to CALC table
                  loop
               else
                  ThisEntry.n = [Entry]   ;ditto previous entry
                  downimage               ;back to CALC table
               endif
            endif
            Do4Function()

         case KeyVal.v = "=" :                ;Finish off a sequence
            upimage                           ;to TAPE table
            end                               ;move to last record in table
            if [Operator] <> "=" then         ;we haven't done this before
               if not isblank([Balance]) then
                  PrevBalance.n = [Balance]   ;ditto previous entry
               else
                  PrevBalance.n = 0
               endif
               down                           ;open a new record
               [Balance] = PrevBalance.n      ; & fill it in
               [Operator] = strval(Keyval.v)
            endif
            ;--set up zero balance for next sequence
            down                              ;open another rcd
            [Operator] = " "                  ; a blank one
            down                              ;and another rcd
            [Balance] = 0                     ; with a zero balance
            [Operator] = "="

            downimage                         ;back to the CALC table
            [Entry] = blanknum()              ;blank out the input field

         case KeyVal.v = 3 :                  ;Ctl-C Clear tape
            do_it!                            ;get out of coedit mode
            upimage                           ;go to TAPE image
            empty table()
            ;--place 20 blank rcds in the table
            coeditkey                         ;back into coedit mode
            for N from 1 to 20
               ins                            ;open a new record
               [Operator] = " "               ; & put something in it
            endfor
            ;--have last rcd show a zero balance
            end
            [Balance] = 0
            [Operator] = "="
      ;     setrecordposition recno() nrows() ;put last rcd at bottom of image
            downimage
            [Entry] = blanknum()              ;blank out input field

         case KeyVal.v = "F2":
            do_it!
            quitloop

         case KeyVal.v = "PgUp":
            EditTape()

         otherwise : beep

      endswitch                  ;Calc table
   endwhile ;true         ;[CALC -> ENTRY] field wait-field loop
endproc

;=========================================================================
proc EditTape()
private PrevBalance.n,
        ThisEntry.n

   upimage                    ;move up to the Tape table
   moveto [Entry]
   while true                 ;wait on Tape table
      wait table
         prompt "Esc to return to calculator, F10 to Recalculate Tape"
         until "CtrlPgUp","CtrlPgDn","F3","F4", "F10", "Esc"

      switch           ;Tape table
         case retval = "F10" :      ;recalculate tape with changed entries
            PrevBalance.n = 0       ;initialize var
            scan
               if not isblank([Entry]) then
                  ThisEntry.n = [Entry]
               else
                  ThisEntry.n = 0
               endif

               switch                     ;checking operator
                  case [Operator] = "+":
                     [Balance] = PrevBalance.n + ThisEntry.n
                  case [Operator] = "-":
                     [Balance] = PrevBalance.n - ThisEntry.n
                  case [Operator] = "*":
                     [Balance] = round((PrevBalance.n * ThisEntry.n),2)
                  case [Operator] = "/":
                     if ThisEntry.n <> 0 then
                        [Balance] = round((PrevBalance.n / ThisEntry.n),2)
                     else
                        message "You can't divide by 0."
                        beep sleep 500 beep sleep 500 beep sleep 1000
                        quitloop   ;get out of scan loop, back to wait table
                     endif
                  case [Operator] = "=":
                     [Balance] = PrevBalance.n
                     ;--in case you chgd an operator to '='
                     [Entry]   = blanknum()
               endswitch                  ;checking operator

               ;--we're done with this record. store this balance as
               ;  previous-balance for use on the next record.
               if not isblank([Balance]) then
                  if [Operator] = "=" then
                     ;--in case you chgd an operator to '='
                     PrevBalance.n = 0
                  else
                     PrevBalance.n = [Balance]
                  endif
               else
                  PrevBalance.n = 0
               endif
            endscan ;for not isblank([Balance])

         case retval = "Esc" :
            ;--if you don't want to resync last rcd to last row, remove this.
            setrecordposition nrecords(table()) nrows()
            downimage                  ;move back down to the CALC table
            quitloop

         otherwise : beep

      endswitch           ;Tape table
   endwhile ;true                 ;wait on Tape table
endproc
;==============================================================================


;==============================================================================
;==============================================================================

;--Here is the script section that calls the CalcMain proc to do the work

;--store name of the "home" directory where this script and tables are kept
CalcDir.a = sdir()

;if isassigned(AutoLib) then    ;use this if you place the ACalc procs in
;   AutoLibOld = AutoLib        ;a library.  Be sure to reset AutoLib when
;endif                          ;ACalc is done.
;AutoLib = sdir()+"ACALCLIB"

;--check to see if the Calc table is here in the "home" directory
if not isfile(CalcDir.a+"Calc.db") then
   message "Error!  CALC table not found in " + CalcDir.a + ". Press a key."
    beep sleep 50 beep
    retval = getchar()
    release vars CalcDir.a
    quit
endif

;--Calc can only be run in Main mode.  Check it.
if sysmode() <> "Main" then
   message "Error!  You must be in Main mode (not Edit). Press a key."
    beep sleep 50 beep
    retval = getchar()
    release vars CalcDir.a
    quit
endif

;--Everything seems to be ok.  Let's call up the calculator
CalcMain()

;--all done. clean up the workspace & memory
clearimage     ;remove CALC/TAPE image from workspace

release procs CalcMain, Do4Function, EditTape
release vars CalcDir.a
quit
;;----------------------------------------------------------------
;  A one-line setkey script can be placed in your working directory,
;  or inserted into your init.sc start-up script:
;    ;ACalcKey.SC
;    setkey -46  play "c:\\calc\\ACalc"      ;Alt-C  or whatever you like
;  This will make the calculator appear to pop-up in your working directory.
;;----------------------------------------------------------------
;
;---------------  end of script ----------------------------------
