;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : Tables, scripts
;Source File     : REPORT.SC
;Author          : Luke Chung
;                  President
;                  Financial Modeling Specialists, Inc.
;                  8027 Leesburg Pike, Suite 410
;                  Vienna, Virginia 22182
;                  USA
;                  703-356-4700, Fax 703-448-3861
;                  Compuserve: 73710,463
;
;Informant Issue : September 1992
;
;Description     : A demo showing the creation of multiple one-to-many relationships
;                  in a single report
;
; Paradox Informant
; 10519 E Stockton Blvd
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740
;
; Licensed software Copyright (C) 1992 Financial Modeling Specialists, Inc.
;
; You are welcome to use the procedures in this script provided you include
; our copyright notice at the top of your script.
;
; 04/20/92-Created by Luke Chung
;
; Submitted to the Paradox Informant 
;
; Presentation: Creating Complex Paradox Reports with Intermediate ASCII Files.
;
;           by: Luke Chung
;               President
;               Financial Modeling Specialists, Inc.
;               8027 Leesburg Pike, Suite 410
;               Vienna, Virginia 22182
;               USA
;               703-356-4700, Fax 703-448-3861
;               Compuserve: 73710,463

; OVERVIEW
; Create a loan overview report -- includes actions & media detail.
; Uses import of ASCII files.
;
; There are three table containing the data we wish to combine:
;   LOANS      Main table, one record for each loan, general loan information.
;   ACTIONS    Each loan has several actions.
;   MEDIA      Each loan may involve several currencies.
; Each of these tables has a report which creates an ASCII file.
; A REPORT table imports the ASCII files from the three tables and combines
; them into a single report.
; A multi-table form is available on the LOANS table to see the relationships.
;
; See the conference paper for more details.

; PARADOX SORT ORDER
; Because of different Paradox sort orders, this program automatically
; indexes the tables if key fields are not found.  Should you have a problem
; due to sort order differences, just delete all the *.PX files.

; PARADOX ASCII SETTINGS
; Because the sample reports expect a specific Paradox ASCII custom config-
; uration setting, a warning message will appear if it is not set properly.
; This script expects separator as comma, delimiter as ", and only strings
; delimited.

; REPORT SETTINGS
; The report on the REPORT table is set for the HP Laserjet.  If you don't
; have a Laserjet or compatible, modify the setup string.

; PROCEDURE      DESCRIPTION               CREATED     MODIFIED    CALLED BY
; CreateReport.u Main procedure            04/22/92-LC             end of script
; CheckKeys.u    Key tables                04/22/92-LC             CreateReport.u
; SetupKeys.u    Check & setup key fields  04/22/92-LC             CreateReport.u
; AsciiOk.l      Check ASCII settings      04/21/92-LC 04/22/92-LC CreateReport.u
; RepAscii.u     Print to file, import     04/20/92-LC 04/22/92-LC CreateReport.u
; PrintScreen.u  Send report to screen     04/22/92-LC             CreateReport.u

; Main procedure to create reports.
; Called by end of script.
proc CreateReport.u()
  private proc.a, Report.t, Loans.t, Actions.t, Media.t
  proc.a = "CreateReport.u"
  Report.t  = "Report"            ; Report table.
  Loans.t   = "Loans"             ; Loan table (contains data).
  Actions.t = "Actions"           ; Loan table (contains data).
  Media.t   = "Media"             ; Loan table (contains data).
  clear

  ? "Checking if tables are properly keyed"
  CheckKeys.u(Actions.t, 3)                           ; Check key fields.
  CheckKeys.u(Media.t, 3)                             ; Check key fields.

  ? "Checking if Paradox settings are okay"
  AsciiOk.l()                                         ; See if ASCII settings okay.

  if retval then
    ? "Paradox settings are okay"
    empty Report.t                                    ; Empty report.

    RepAscii.u(Loans.t,   "R", Report.t)              ; Get Loan data.
    RepAscii.u(Actions.t, "R", Report.t)              ; Get Action data.
    RepAscii.u(Media.t,   "R", Report.t)              ; Get Media data.

    ? "Preparing to display results"
    PrintScreen.u(Report.t, "R")                      ; Send report to screen.
  endif
endproc

; Check key fields.
; This application does not index the tables until you run it the first time.
; This allows it to use your sort order.
; INPUT: Table.t        Table to place key fields.
;        KeyFld.n       Number of key fields.
; Called by CreateReport.u.
proc CheckKeys.u(Table.t, KeyFld.n)
  private proc.a, x
  proc.a = "CheckKeys.u"
  if nkeyfields(Table.t) = 0 then
    Menu {Modify} {Restructure}
      select Table.t
      right right
      for x from 1 to KeyFld.n
        "*"  down                           ; Add "*" to end of field type.
      endfor
    do_it!  clearall
  endif
endproc

; Check to see if ASCII settings are okay for ASCII import reports.
; Returns TRUE if ASCII settings okay, FALSE if not.
; Called by CreateReport.u.
proc AsciiOk.l()
  private proc.a, temp.t
  proc.a = "AsciiOk.l"
  temp.t = "temp"
  create Temp.t
    "Alpha"  : "A1",
    "Number" : "N"
  edit Temp.t
    [Alpha]  = "A"
    [Number] = 1.5
  do_it!  clearall
  Menu {Tools} {ExportImport} {Export} {Ascii} {Delimited}
    select Temp.t                                ; Export table to Ascii file.
    select Temp.t                                ; Export to TEMP.TXT file.
  if menuchoice() = "Cancel" then {Replace} endif
  Menu {Tools} {ExportImport} {Import} {Ascii} {Text}
    select Temp.t                                ; Import table as TEXT.
    select Temp.t                                ; Replace current Temp table.
  if menuchoice() = "Cancel" then {Replace} endif
  view Temp.t
    ok.l = ([Text] = "\"A\",1.5")      ; Check if results come back as expected.
                                       ; In this example, we are looking for:
                                       ;   " delimiters, comma separator,
                                       ;   delimiters only around strings.
  clearall
  if not ok.l then
    clear
    @5,0  text
      This program expects your Paradox custom configuration to have
      certain ASCII settings.  Please change your settings so that:

                           Delimiters are quotes:   "

                           Separators are commas:   ,

                           Only strings are delimited.

    endtext
    message "Press any key"
    retval = getchar()                 ; Wait for key press.
  endif
  return ok.l
endproc

; Send report to file, import into final table.
; INPUT: Table.t        Table with report to print.
;        Rep.a          Report to print.
;        Report.t       Table which imports ASCII report.
; Called by CreateReport.u.
proc RepAscii.u(Table.t, Rep.a, Report.t)
  private proc.a, Ascii.a
  proc.a = "RepAscii.u"
  ? "Creating "+Table.t+" report"
  if not isempty(Table.t) then
    Ascii.a = privdir()+"xxxascii"
    Menu {Report} {Output}
      select Table.t  select Rep.a
      {File}
    select Ascii.a+".sc"                               ; Export to script file...easier to delete.
    if menuchoice() = "Cancel" then {Replace} endif
    Menu {Tools} {ExportImport} {Import} {Ascii} {AppendDelimited}
      select Ascii.a+".sc"
      select Report.t
    if menuchoice() = "NewEntries" then {NewEntries} endif
    Menu {Tools} {Delete} {Script} select Ascii.a {Ok}      ; Delete ASCII file.
  endif
  clearall
endproc

; Send report to file and browse with README.COM.
; A temporary file is created with an *.SC extension.
; This makes it easier to delete with a {Tools} {Delete} {Script} command
; rather than a RUN "DEL file"
; INPUT: Table.t        Table to print.
;        Rep.a          Report to use.
; Called by CreateReport.u.
proc PrintScreen.u(Table.t, Rep.a)
  private proc.a, temp.a
  proc.a = "PrintScreen.u"
  temp.a = "xxxtemp"
  Menu {Report} {SetPrinter} {Override} {Setup} { }   ; Override setup string, so it does not appear on screen.
  Menu {Report} {Output}
    select Report.t
    select Rep.a
  {File} select temp.a+".sc"                          ; File name is XXXTEMP.SC
  if menuchoice() = "Cancel" then {Replace} endif
  Menu {Report} {SetPrinter} {Regular}                ; Reset setup string.
  run big "README "+temp.a+".sc"                      ; Browse file.
  Menu {Tools} {Delete} {Script} select temp.a {Ok}   ; Delete temp file.
endproc

CreateReport.u()        ; Start first script.
