Procedure Zscale(Zmin, Zmax : Real; Var Z1, Z2, Zinc : Real; Var Ndivs, Pwr : 
  Integer);

(*  Given values for Zmin and Zmax, procedure returns 
    (1)  Z1 : the value to write at the left end of the axis
    (2)  Z2 : the value to write at the right end of the axis
    (3)  Zinc : the increment to use between tic marks
    (4)  Ndivs : number of divisions to be used
    (5)  Pwr : ALL ABOVE MUST BE MULTIPLIED BY 10**Pwr
*)
Var
  Temp : Real;
  Function Floor(X : Real) : Real;
  Begin
    Floor := Int(X);
  End;
  Function Ceil(X : Real) : Real;
  Begin
    If X = Int(X) Then Ceil := X
    Else
      If X > 0.0 Then Ceil := Int(X+1.0)
      Else Ceil := Int(X-1.0);
  End;
  Function Log10(X : Real) : Real;
  Begin
    Log10 := Ln(X)/Ln(10.0);
  End;

Begin
  If Zmin > Zmax Then
    Begin
      Temp := Zmax;
      Zmax := Zmin;
      Zmin := Temp;
    End;
  If (Zmin = 0.0) And (Zmax = 0.0) Then Zmax := 1.0;
  If Zmin = Zmax Then
    Begin
      If Zmin < 0.0 Then
        Zmax := 0.9*Zmin
      Else
        Zmax := 1.1*Zmin;
    End;
  Zinc := (Zmax-Zmin)*0.2;
  Temp := Log10(Zinc);
  If Temp >= 0.0 Then Pwr := Trunc(Floor(Temp))
  Else
    Pwr := Trunc(Ceil(Temp));
  If Zinc > 1.0 Then Inc(Pwr);
  Temp := Zinc*PwrI(10.0, -Pwr);
  Zinc := 0.1;
  If Temp > 0.1 Then Zinc := 0.2;
  If Temp > 0.2 Then Zinc := 0.25;
  If Temp > 0.25 Then Zinc := 0.5;
  If Temp > 0.5 Then Zinc := 1.0;
  Zinc := Zinc*PwrI(10.0, Pwr);
  If Zmin < Int(Zmin/Zinc)*Zinc Then
    Zmin := (Int(Zmin/Zinc)-1)*Zinc
  Else
    Zmin := Int(Zmin/Zinc)*Zinc;
  If Zmax > Int(Zmax/Zinc)*Zinc Then
    Zmax := (Int(Zmax/Zinc)+1)*Zinc
  Else
    Zmax := Int(Zmax/Zinc)*Zinc;
  Zinc := Zinc*PwrI(10.0, -Pwr);
  Z1 := Zmin*PwrI(10.0, -Pwr);
  Z2 := Zmax*PwrI(10.0, -Pwr);
  Ndivs := Round((Z2-Z1)/Zinc);
End;
