(***************************************************************************************************************************)
(*                                                                                                                         *)
(*		Zip Studio 1.2 COPYRIGHT 1993, 1994 Denis CHEVRON                                                                    *)
(*    Source File: ZIP.PAS                                                                                                 *)
(*    Description: Pascal Source file to encapsulate the ZDLL12A.DLL file to provide the functionality to                  *)
(*                 Borland Pascal developers.  This version was written for BP v7.0 but contains nothing that              *)
(*                 would prohibit its adaption to earlier versions.                                                        *)
(*    Date:        Wed Jul 13 17:06:53 1994                                                                                *)
(*    Author:      Brad Stowers, CIS: 72733,3374                                                                           *)
(*                               Internet: brad.stowers@delta.com                                                          *)
(*                                                                                                                         *)
(***************************************************************************************************************************)
(*                                                                                                                         *)
(*		To Zip, Put ZDLL12A.DLL and ZDLL12B.DLL in your applications directory and add this unit to your USES clause.        *)
(*    By using this unit, you are NOT required to use LoadLibrary and FreeLibrary.  Simply call these parameters as you    *)
(*    would any other unit.                                                                                                *)
(***************************************************************************************************************************)

unit Zip;

interface

uses WinTypes;

(***************************************************************************************************************************)
(* The ZIP.INC file contains constants that will be useful when calling these functions.  By including it here, you don't  *)
(* have to include it in your own program.  Do have a look at it so that you will know what is available.                  *)
(***************************************************************************************************************************)

{$I ZIP.INC }

(* Initialization function *)
  procedure ZipInit(YourName, Password: pChar);          { required.  If you aren't a registered user, set         }
                                                         { YourName to 'TEST' and Password to ''                   }

(* Main functions *)
  function  AddFileToZip(ZipFile, Mask: pChar;           { Zip a file }
                         OverwriteMode: integer;
                         StorePath, Recurse: boolean;
                         ParentWnd: hWnd): integer;
  function  ZipDeleteFiles(ZipFile, Files: pChar;
                           ParentWnd: hWnd): integer;    { Delete files in a Zip }
  function  ZipRepare(ZipFile: pChar;
                      ParentWnd: hWnd): integer;         { Recreate the Zip file }
  function  ZipSetComment(ZipFile, Comment: pChar;
                          ParentWnd: hWnd): integer;     { Set the Zip Comment }


(* Helpers *)
  function  ZipSetLanguage(ZipLanguage: word): boolean;   { Set the Language }
  function  ZipGetReplaceFlag: integer;                   { Return the current overwrite mode }

implementation

  procedure ZipInit;                                      external 'ZDLL12A';
  function  AddFileToZip;                                 external 'ZDLL12A';
  function  ZipDeleteFiles;                               external 'ZDLL12A';
  function  ZipRepare;                                    external 'ZDLL12A';
  function  ZipSetComment;                                external 'ZDLL12A';
  function  ZipSetLanguage;                               external 'ZDLL12A';
  function  ZipGetReplaceFlag;                            external 'ZDLL12A';

end.