(***************************************************************************)
(* Zip Code Search Unit  -  Version 1.00  -  April 11, 1994                *)
(*-------------------------------------------------------------------------*)
(* Copyright (C) 1994 - Mike Krejci - All Rights Reserved                  *)
(*   I release the following code into the public domain.  You may use or  *)
(*   modify this unit for any purpose.  Please feel free to send any       *)
(*   questions or comments you may have to krejcim@aol.com.  If you find   *)
(*   a zip code in error, or one that is missing, please pass that along   *)
(*   to me also as I will make periodic updates to this unit and it's data *)
(*   file.                                                                 *)
(*-------------------------------------------------------------------------*)
(* For an example on using this unit please see ZIPTEST.PAS.  If you have  *)
(* any questions that aren't answered with ZIPTEST.PAS, please feel free   *)
(* to ask.                                                                 *)
(*-------------------------------------------------------------------------*)
(*  ZipUnit V1.00                                                          *)
(*  Programmer: Mike Krejci                                                *)
(*  E-Mail: krejcim@aol.com                                                *)
(*  Postal: PO Box 2128, Corvallis, OR 97330                               *)
(*  Registration Cost: *NONE* *FREE*                                       *)
(***************************************************************************)


UNIT ZipUnit;


INTERFACE


TYPE
  String2 = STRING[2];
  String5 = STRING[5];
  String25 = STRING[25];

  ZipCodeRecType = RECORD
    ZipCode: String5;
    City: String25;
    State: String2;
  END; {ZipCodeRecType}

  PZipCodeObjectType = ^ZipCodeObjectType;
  ZipCodeObjectType = OBJECT
    ZipCodeFile: FILE OF ZipCodeRecType;
    ZipCodeRec: ZipCodeRecType;
    ZipCodeRecord: LONGINT;
    CONSTRUCTOR Init;
    DESTRUCTOR Done;
    FUNCTION TotalZipCodes: LONGINT;
    PROCEDURE GetZipCodeData (ZipCode: String5; VAR City, State: STRING);
  END; {ZipCodeObjectType}


IMPLEMENTATION


CONSTRUCTOR ZipCodeObjectType.Init;

  BEGIN {ZipCodeObjectType.Init}
    FileMode := $42;
    ASSIGN (ZipCodeFile, 'ZIPCODES.DAT');
    RESET (ZipCodeFile);
  END;  {ZipCodeObjectType.Init}


DESTRUCTOR ZipCodeObjectType.Done;

  BEGIN {ZipCodeObjectType.Done}
    CLOSE (ZipCodeFile);
  END;  {ZipCodeObjectType.Done}


FUNCTION ZipCodeObjectType.TotalZipCodes: LONGINT;

  BEGIN {ZipCodeObjectType.TotalZipCodes}
    TotalZipCodes := FILESIZE (ZipCodeFile) - 1;
  END;  {ZipCodeObjectType.TotalZipCodes}


PROCEDURE ZipCodeObjectType.GetZipCodeData (ZipCode: String5; VAR City, State: STRING);

  VAR
    X, L, R: LONGINT;
    DataLine: String5;

  BEGIN {ZipCodeObjectType.GetZipCodeData}
    L := 0;
    R := TotalZipCodes;

    REPEAT
      X := (L + R) DIV 2;
      SEEK (ZipCodeFile, X);
      READ (ZipCodeFile, ZipCodeRec);
      DataLine := ZipCodeRec.ZipCode;

      IF ZipCode < DataLine THEN
        R := X - 1
      ELSE
        L := X + 1;
    UNTIL (ZipCode = DataLine) OR (L > R);

    IF ZipCode = DataLine THEN
      BEGIN
        City := ZipCodeRec.City;
        State := ZipCodeRec.State;
      END
    ELSE
      BEGIN
        City := '';
        State := '';
      END;
  END;  {ZipCodeObjectType.GetZipCodeData}


BEGIN {ZipUnit}
END.  {ZipUnit}
