{ Graphics Demo: It shows the speed of the rectangle filling routines by }
{ drawing ramdon size rectangle centered on the screen of different      }
{ pattern and color.                                                     }
{                                                                        }
{ Written by Abe Achkinazi on August 16, 1986.                           }
{                                                                        }
{ Permission to distribute, change, mutilate and learn from this program }
{ is granted.                                                            }
{                                                                        }
program Rectangles(input, output);
label ErrorExit;

{$I Xgraph.pas }

Const
  { variables defining the Omega array }
  MaxOmega = 4;
  Increment = 0.10;

Type
  OmegaType = Record
                Amplitud : real;
                Step     : real
              end;

var

	GrfData : GraphicsData;
	Regs : VidRegs;

  { Frame buffer size variables }
  LocMinX, LocMaxX, LocMinY, LocMaxY, CenterX, CenterY: integer;

  Omega : array[0..MaxOmega] of OmegaType;
  i : integer;

  ScreenMode : integer;

function GetMode(var ScreenMode: integer):boolean;
{
        Function to check if a parameter was passed and if its valid.
}
var
  Code : integer;
begin
  if (ParamCount < 1) or (ParamCount > 1) then GetMode := false
  else begin { At least has some parameter see if its legal }
    Val(ParamSTR(1), ScreenMode, Code);
    if Code <> 0 then GetMode := false
    else if ScreenMode in [Video320x200BW, Video320x200Color, Video640x200,
       VideoEGA320x200, VideoEGA640x200, VideoEGA640x350Mono, VideoEGA640x350Color,
       VideoMulti640x400, VideoMulti320x400]
    then GetMode := true
    else GetMode := false;
  end;
end; { of GetMode }

function NextValue(var OmegaVar : OmegaType; Inc : real;
                   MinInt, MaxInt : integer             ):integer;
var temp:real;
begin
  with OmegaVar do begin
    temp := sin(Amplitud*Step);
    Step := Step + Inc;
  end;
  NextValue := MinInt + round(((temp+1)/2)*(MaxInt - MinInt));
end; { of NextValue }

procedure Rectangle( DeltaX, DeltaY, Pattern, Color : integer);
begin
  Regs.ax := VidRectFill shl 8 + Color mod 16;
  Regs.cx := CenterX - DeltaX;
  If Regs.cx < 0 then Regs.cx := 0;
  Regs.dx := CenterY - DeltaY;
  if Regs.dx < 0 then Regs.dx := 0;
  Regs.si := CenterX + DeltaX;
  If Regs.si > LocMaxX then Regs.si := LocMaxX;
  Regs.di := CenterY + DeltaY;
  If Regs.di > LocMaxY then Regs.di := LocMaxY;
  Regs.es := GrfData.TextureSeg;
  Regs.bx := GrfData.TextureOff + Pattern*32;
  Intr(VideoInt, Regs);
end; { of Rectangle }

begin { of main }

  Regs.ax := VidSetMode shl 8 + Video80x25Color; { Clear Screen in Alpha }
  Intr(VideoInt, Regs);

  { Check to make sure that video extensions are installed }
  Regs.ax := VidID shl 8; Regs.bx := 0; Intr(VideoInt, Regs);
  if Regs.bx = 0 then begin
    Writeln('Extended Graphics functions not installed.');
    writeln('Hit return to exit');
    readln;
    goto ErrorExit;
  end;

  { See if user passed legal parameter }
  if not GetMode(ScreenMode) then begin
    writeln('Usage: Weaver x');
    writeln('where ''x'' is a legal graphics mode number from this list:');
    writeln;
    writeln(' 4) is CGA 320x200');
    writeln(' 5) CGA 320x200');
    writeln(' 6) CGA 640x200');
    writeln('13) EGA 320x200');
    writeln('14) EGA 640x200');
    writeln('15) EGA 640x350 Monochrome');
    writeln('16) EGA 640x350 Color');
    writeln('20) HP-Multimode 640x400');
    writeln('21) HP-Multimode 320x400');
    writeln;
    writeln(' Please select a mode that your video adapter and monitor');
    writeln(' can use. Otherwise you might damage your equipment !');
    goto ErrorExit;
  end;

  { introduction }
  writeln(' Graphics demo: It shows the speed of the rectangle filling routines');
  writeln(' by drawing random size rectangles centered on the screen. Both the ');
  writeln(' pattern and the color are also randomized.                         ');
  writeln('                                                                    ');
  writeln(' Written by Abe Achkinazi on August 16, 1986.                       ');
  writeln('                                                                    ');
  writeln(' Thanks to Peter S. Stevens and his wonderful book "Handbook of     ');
  writeln(' Regular Patterns: An Introduction to Symmetry in Two Dimensions"   ');
  writeln(' for providing ideas for some of the basic patterns used in the     ');
  writeln(' program.                                                           ');
  writeln;
  writeln(' Permission to distribute, change, mutilate and learn from this        ');
  writeln(' program is granted.                                                   ');
  writeln('                                                                       ');
  delay(3000);

	GraphInit(GrfData, ScreenMode);

  with GrfData do begin
    LocMinX := MinimumX; LocMaxX := MaximumX div BitPixelDensity;
    LocMinY := MinimumY; LocMaxY := MaximumY;
    CenterX := (LocMaxX - LocMinX) div 2; CenterY := (LocMaxY - LocMinY) div 2;
  end;

  { Initial value for Points on sinosoid }
  for i := 0 to MaxOmega do with Omega[i] do begin
    Amplitud := Random;
    Step     := 0;
  end;

  while not KeyPressed do 
    Rectangle( NextValue(Omega[0], Increment, 0, CenterX), { DeltaX }
             NextValue(Omega[1], Increment, 0, CenterY), { DeltaY }
             NextValue(Omega[2], Increment, 0, 15),      { Pattern }
             NextValue(Omega[3], Increment, 1, 15)       { Color }    );

  { ReSet Textmode }
  case ScreenMode of
    4, 5, 6, 13, 14, 15, 16: { Normal Int 10H mode only need to set up AX }
        Regs.ax := VidSetMode shl 8 + Video80x25Color;
    20, 21: begin { For multimode's extra mode must call Extended Video functs }
        Regs.ax := VidExtendedFunctions shl 8 + 5; { Extended Set mode }
        Regs.bx := 03; { adjust to HP's base }
        end
  end;
  Intr(VideoInt, Regs);
  
ErrorExit:;     { Falls to here when there is an error }
end.
