
{$S-,R-,I-,V-,B-}

{XGRAF - V1.01 Scaling Graph and Curve drawing program}
{Copyright (c) 1988 Michael Day - all rights reserved}
{first release 22 October 1988} {first public release}

{This is a shareware program. Refer to the license agreement for further}
{information. If you do not have the license documentation you may}
{obtain it by writting to me at: }

{     Michael Day                                               }
{     C/O Day Research                                          }
{     P.O. Box 22902                                            }
{     Milwaukie, OR 97222                                       }
{                                                               }
{     CIS [73577,2225]                                          }
{     Mike Day  UUCP:...!tektronix!reed!qiclab!bakwatr!mikeday  }

{If you include $10.00 I will also send you a current copy of the full}
{shareware package.}

{Note: If you agree to the terms of the shareware license you may}
{use this program free of royalties, and you may use this program}
{in conjunction with any program you may develop, that XGRAF is a}
{part of, in private or commercial applications free of royalty payments.}
{The catch is that you must provide a copy of any enhancments to XGRAF}
{to be distributed among the other XGRAF developers.}
{See the license agreement for further details.}

{ CUNIT - Curve drawing unit. This unit allows you to draw a curve }
{  from measurement data (array of integers) on a selected area of }
{  the screen. }

Unit CUnit;
interface

uses graph;

{-----------------------------------------------------------------------}
{ sets up curve information based on the indicated graph area }
{ Xmin,Xmax defines the graph area to use. XStart specifies the}
{ starting X values on the graph (that is, the measurement point }
{ that corresponds to the left side of the graph). XRng specifies the }
{ range of values across the graph. PType indicates if the plotting is }
{ linear or Log. NPts specifies how many points there are. XData contains }
{ the points. The X plot points are returned in XPlot. If you wish a point }
{ not to be ploted, you can later go into the XPlot array and insert -1 in }
{ those points you do not want plotted. XRng must always be greater than zero.}
{ It is assumed that the XData array contains integer values between }
{ -32768 > +32767. }

procedure MapXtoScreen(Ptype,Xmin,Xmax,XStart,XRng,NPts:integer;
                       var XData,XPlot);


{--------------------------------------------------------------------------}
{ The YData array contains the measurement point values to be displayed }
{ In order to be displayed the values must be converted to pixel 'y' }
{ addresses on the graph. It is assumed that the YData array contains integer}
{ values between -32768 > +32767. Ymin and Ymax contain the limit information}
{ needed to perform the translation. PType indicates if the plotting is }
{ linear or Log.  YRng is the range of the integers that are allowed to be }
{ plotted on the graph. YStart is the graph measurement starting value. }
{ That is the value that will be plotted at the bottom of the graph.}
{ YRng must always be greater than zero.}

procedure MapYtoScreen(Ptype,Ymin,Ymax,YStart,YRng,Npts:integer;
                       var YData,YPlot);


{-------------------------------------------------------------------------}
{ Draws a curve on the screen }
{ Ctype is the line style to use }
{ any 'x' points which are negative will not be plotted. }
{ note: there has to be at least two points to plot or nothing happens }

procedure DrawCurve(Color,Ctype,Npts,Clip:integer;
                    Xmin,Ymin,Xmax,Ymax:integer;
                    var XPlot,YPlot);


{ ********************************************************************** }

implementation

type  crvIntArray = array[1..32000] of integer;

{cltype - 0 = pixel per X type curve }
{         1 = X plus Y pixel type curve }
{         2 = X plus Y overlap type curve }
{clip   - 0 = do not clip to boundry }
{         1 = limit to provided plot boundry }
{         2 = clip to provided boundry } 

{-----------------------------------------------------------------}
{plot the point on the screen clipping it to the specified boundry}

procedure plot(x,y,c,clip,Xmin,Ymin,Xmax,Ymax:integer);
begin
  if clip > 1 then  {clip to boundry}
  begin
    if x < Xmin then Exit else if x > Xmax then Exit;
    if y < Ymin then Exit else if y > Ymax then Exit;
  end
  else
  if clip > 0 then  {limit to boundry}
  begin
    if x < Xmin then x := Xmin else if x > Xmax then x := Xmax;
    if y < Ymin then y := Ymin else if y > Ymax then y := Ymax;
  end;  
  PutPixel(x,y,c);
end;

{--------------------------------------------}
{plot a line segment on the screen}
procedure DoPlot(x1,y1,x2,y2,cltype,color,clip,
                 Xmin,Ymin,Xmax,Ymax:integer);
var  x,y,xstep,ystep,deltax,deltay,direction:integer;
begin
  x := x1;
  y := y1;
  if x1 = x2 then xstep := 0
  else
    if x1 > x2 then xstep := -1
    else
      xstep := 1;
  if y1 = y2 then ystep := 0
  else
    if y1 > y2 then ystep := -1
    else
      ystep := 1;
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax = 0 then direction := -1
  else
    direction := 0;
  plot(x,y,color,clip,Xmin,Ymin,Xmax,Ymax);   {plot first dot}

  repeat
    if direction < 0 then
    begin
      y := y + ystep;
      direction := direction + deltax;
      if ((direction >= 0) or (cltype > 0)) then
        plot(x,y,color,clip,Xmin,Ymin,Xmax,Ymax);
    end
    else
    begin
      x := x + xstep;
      direction := direction - deltay;
      if ((direction >= 0) or (cltype > 1)) then
        plot(x,y,color,clip,Xmin,Ymin,Xmax,Ymax);
    end;
  until ((y = y2) and (x = x2));
end;


{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                    external access routines                            }
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}


{-----------------------------------------------------------------------}
{ sets up curve information based on the indicated graph area }
{ Xmin,Xmax defines the graph area to use. XStart specifies the}
{ starting X values on the graph (that is, the measurement point }
{ that corresponds to the left side of the graph. XRng specifies the }
{ range of values across the graph. PType indicates if the plotting is }
{ linear or Log. NPts specifies how many points there are. XData contains }
{ the points. The X plot points are returned in XPlot. If you wish a point }
{ not to be ploted, you can later go into the XPlot array and insert -1 in }
{ those points you do not want plotted. XRng must always be greater than zero.}
{ It is assumed that the XData array contains integer values between }
{ -32768 > +32767. }

procedure MapXtoScreen(Ptype,Xmin,Xmax,XStart,XRng,NPts:integer;
                       var XData,XPlot);
var rx,ry:real;
    i,XR,XB,Xsize:integer;
    Xo : longint;
    XD : crvIntArray absolute XData;
    XP : crvIntArray absolute XPlot;

begin
   if XRng < 1 then XR := 1 else XR := XRng;
   Xsize := Xmax - Xmin;
   if PType = 0 then                   {linear plot}
   begin
      for i := 1 to Npts do
        XP[i] := Xmin + ( (longint(XD[i]-XStart)*Xsize) div XR);
   end
   else
   begin                               {log plot}
      if XStart < 1 then
      begin
        XB := 1;
        Xo := succ(longint(abs(XStart)));
      end
      else
      begin
        XB := XStart;
        Xo := 0;
      end;
      ry := ln((XB+XR)/XB);
      for i := 1 to Npts do
      begin
        if longint(XD[i])+Xo < 1 then
        begin
          XP[i] := -1;
        end
        else
        begin
          rx := ln((longint(XD[i])+Xo)/XB);
          XP[i] := integer(Xmin + trunc(rx/ry*Xsize));
        end;
      end;
   end;
end;



{--------------------------------------------------------------------------}
{ The YData array contains the measurement point values to be displayed }
{ In order to be displayed the values must be converted to pixel 'y' }
{ addresses on the graph. It is assumed that the YData array contains integer}
{ values between -32768 > +32767. Ymin and Ymax contain the limit information}
{ needed to perform the translation. PType indicates if the plotting is }
{ linear or Log.  YRng is the range of the integers that are allowed to be }
{ plotted on the graph. YStart is the graph measurement starting value. }
{ That is the value that will be plotted at the bottom of the graph.}
{ YRng must always be greater than zero.}

procedure MapYtoScreen(Ptype,Ymin,Ymax,YStart,YRng,Npts:integer;
                       var YData,YPlot);
var rx,ry:real;
    i,YR,YB,Ysize:integer;
    Yo : longint;
    YD : crvIntArray absolute YData;
    YP : crvIntArray absolute YPlot;

begin
   if YRng < 1 then YR := 1 else YR := YRng;
   Ysize := Ymax - Ymin;
   if PType = 0 then                   {linear plot}
   begin
      for i := 1 to Npts do
        YP[i] := Ymax - ( (longint(YD[i]-YStart)*Ysize) div YR);
   end
   else
   begin                               {log plot}
      if YStart < 1 then
      begin
        YB := 1;
        Yo := succ(longint(abs(YStart)));
      end
      else
      begin
        YB := YStart;
        Yo := 0;
      end;
      ry := ln((YB+YR)/YB);
      for i := 1 to Npts do
      begin
        if longint(YD[i])+Yo < 1 then
        begin
          YP[i] := -1;
        end
        else
        begin
          rx := ln((longint(YD[i])+Yo)/YB);
          YP[i] := integer(Ymax - trunc(rx/ry*Ysize));
        end;
      end;
   end;
end;



{-------------------------------------------------------------------------}
{ Draws a curve on the screen }
{ Ctype is the line style to use }
{ any 'x' points marked with -1 will not be plotted. }
{ note: there has to be at least two points to plot or nothing happens }

procedure DrawCurve(Color,Ctype,Npts,Clip:integer;
                    Xmin,Ymin,Xmax,Ymax:integer;
                    var XPlot,YPlot);

var x1,x2,y1,y2,i:integer;
    XP : crvIntArray absolute XPlot;
    YP : crvIntArray absolute YPlot;

begin
  i := 1;                                 {we start the search at offset 0}
  while ((XP[i] < 0) or (YP[i] < 0)) and (i < Npts) do
    inc(i);                             {find first point to plot (non -1)}
  x1 := XP[i];
  y1 := YP[i];                              {get x1,y1 of first plot point}
  while i < Npts do                   {then go search for the other points}
  begin                                 {until we run out of points to get}
    inc(i);                                 {point to next point to pickup}
    x2 := XP[i];                      {get x2,y2 point of the line segment}
    y2 := YP[i];                  {then go plot the line segment specified}
    if not(x2 < 0) and not(y2 < 0) then
    begin                                     {bypass any point that is -1}
      DoPlot(x1,y1,x2,y2,Ctype,Color,Clip,
             Xmin,Ymin,Xmax,Ymax);              {now plot the line segment}
      x1 := x2;
      y1 := y2;                   {x1,y1 now become x2,y2 and we go search}
    end;                                     {for next x2,y2 point to plot}
  end;
end;


{ ************************************************************************ }

end.
