{ XGRAF demo program - This program demonstrates how to generate a }
{ graph and draw a curve on it using the XGRAF program library }
{ Copyright 1988 by Michael Day, all rights reserved }
{ Program as of 25 October 1988 }

program gdemo;
uses crt,graph,gunit,cunit;

type carray = array[0..15] of byte;
     crvIntArray = array[1..128] of integer;

const Colors2 : carray = (0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
      Colors4 : carray = (0,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3);
      Colors16: carray = (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15);


var grmode,grdriver:integer;
    Xm,Ym,G,iii,ii,i,x : integer;
    gx1,gy1,gx2,gy2:integer;
    xtc,ytc,xgc,ygc,xto,yto,xgt,ygt:integer;
    GridType,XPlotType,YPlotType,NumPts:integer;
    Xstart,Xrange,Ystart,Yrange:integer;
    sa : scalearray;
    y,cy1,cy2,Crv: crvIntArray;
    cy: array[1..20] of crvIntArray;
    XPlot,YPlot:crvIntArray;
    Xvals,Yvals:crvIntArray;
    TotalSpace,WorkSpace,OldMA : longint;
    Gcount,GraphSpace : integer;
    Clip,CurveType:integer;
    Colors : carray;


{-------------------------------------------------------}
{misc error messages ans support routines }

procedure DoGError;
begin
  closegraph;
  writeln('** Graph error ** - ',gErrorMsg(gError));
  readln;
  halt(1);
end;

function fstr(i:integer):string;
var stemp:string;
begin
  str(i,stemp);
  fstr:=stemp;
end;

{----------------------------------------------}
{ start up the graphics interface }

procedure StartGraph;
begin
  detectgraph(grdriver,grmode);
  if GraphResult <> grOk then
  begin
    writeln('** Graph initialization error **');
    readln;
    Halt(1);
  end;

  case grdriver of
    CGA, MCGA, ATT400, EGA64 :
      begin
        grdriver := CGA;
        grmode := CGAC0;
        Colors := Colors4;
      end;
    EGA, VGA, IBM8514 :
      begin
        grdriver := EGA;
        grmode := EGAhi;
        Colors := Colors16;
      end;
    EGAmono, HercMono, PC3270 :
      begin
        {we leave the drivers at default}
        Colors := Colors2;
      end;
    else
    begin
      writeln('** Unknown driver **');
      readln;
      Halt(1);
    end;
  end;
  initgraph(grdriver,grmode,'');
  if GraphResult <> grOk then
  begin
    writeln('** Graph initialization error **');
    readln;
    Halt(1);
  end;

  Xm := pred(GetMaxX div 8);
  Ym := pred(GetMaxY div 5);
  TotalSpace := MaxAvail;
  GraphSpace := sizeof(GraphRecType)+(sizeof(TitleRec)*2)+(sizeof(ScaleRec)*4);
  WorkSpace := TotalSpace div GraphSpace;
  If WorkSpace < 15 then
  begin
    closegraph;
    writeln('** Sorry, not enough memory space to run the demo **');
    readln;
    Halt(1);
  end;

end;

{++++++++++++++++++++++++++++++++++++++++++++}
{The graphs get created here}

procedure MakeThem;
var x1,y1,x2,y2,i:integer;
begin
  G := 1;  {-- create the first graph --}
  if not(gSetGraph(G,white,black,solidfill,GridType)) then doGError;
  if not(gSetTick(G,xtc,ytc,xgc,ygc,xto,yto,xgt,ygt)) then doGError;
  if not(gSetArea(G,0,0,pred(xm)*5,pred(ym)*4)) then doGError;
  if not(gSetTitle(G,gTopTitle,gCenterWrite,0,3,solidfill,'Top Title')) then doGError;
  if not(gSetTitle(G,gBotTitle,gCenterWrite,0,3,solidfill,'Bot Title')) then doGError;
  if not(gSetScale(G,gBotScale,3,white,black,solidfill,sa)) then doGError;
  if not(gSetScale(G,gLeftScale,3,white,black,solidfill,sa)) then doGError;
  if not(gSetScale(G,gTopScale,3,white,black,solidfill,sa)) then doGError;
  if not(gSetScale(G,gRightScale,3,white,black,solidfill,sa)) then doGError;

  G := 2;  {-- create the second graph --}
  x1 := succ(Xm) * 5;
  x2 := pred(Xm) * 7;
  y1 := 0;
  y2 := pred(pred(Ym) * 2);
  if not(gSetTick(G,xtc,ytc,xgc,ygc,xto,yto,xgt,ygt)) then doGError;
  if not(gSetGraph(G,white,black,solidfill,1)) then doGError;
  if not(gSetArea(G,x1,y1,x2,y2)) then doGError;

  G := 3;   {-- create the third graph --}
  y1 := succ(succ(Ym) * 2);
  y2 := pred(Ym) * 4;
  if not(gSetTick(G,xtc shr 1,ytc shr 1,xgc shr 1,ygc shr 1,
                     xto shr 1,yto shr 1,xgt shr 1,ygt shr 1)) then doGError;
  if not(gSetGraph(G,white,black,solidfill,1)) then doGError;
  if not(gSetArea(G,x1,y1,x2,y2)) then doGError;

  {-- create graphs 4 through 7 --}
  x1 := succ(Xm) * 7;
  x2 := pred(Xm) * 8;
  for i := 4 to 7 do
  begin
    G := i;
    y1 := (Ym*(i-4))+4;
    y2 := (Ym*(i-3))-6;
    if not(gSetTick(G,4,6,4,6,1,1,1,1)) then doGError;
    if not(gSetGraph(G,white,black,solidfill,0)) then doGError;
    if not(gSetArea(G,x1,y1,x2,y2)) then doGError;
  end;

  {-- create graphs 8 through 15 -}
  y1 := succ(Ym) * 4;
  y2 := Ym * 5;
  for i := 8 to 15 do
  begin
    G := i;
    x1 := succ(Xm*(i-8));
    x2 := (Xm*(i-7))-4;
    if not(gSetTick(G,7,9,7,9,1,1,1,1)) then doGError;
    if not(gSetGraph(G,white,black,solidfill,3)) then doGError;
    if not(gSetArea(G,x1,y1,x2,y2)) then doGError;
  end;

  {-- now define and allocate the graphs on the heap --}
  for G := 1 to 15 do
  begin
    if not(gDefine(G)) then doGError;
  end;

end;


{=============================================================}
{here is where it all begins }

begin
  StartGraph;  {initialize the system}

  {-- first we create and display the graphs --}
  for G := 1 to 15 do
    if not gAlloc(G) then doGError;   {allocate the graphs}

  for i := 1 to maxscale do  {make some scale labels}
    sa[i] := fstr(i+100);

  Gridtype := 3;            {default values}
  xtc := 4;
  ytc := 4;
  xgc := 16;
  ygc := 16;
  xto := 2;
  yto := 2;
  xgt := 4;
  ygt := 4;
  MakeThem;          {now make the graphs}

  for G := 1 to 15 do
    if not(gDrawFull(G)) then doGError;   {and then draw them}


{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{ now we generate the curves }

  {generate some simple wave shapes}
  for i := 1 to 81 do
  begin
    Xvals[i] := 100*i;
    for ii := 1 to 5 do
    begin
      cy[ii][i] := round(100*cos(2*pi*(i+(ii)*8)/40));
    end;
  end;


  {- try playing with these values to see the different curve styles -}
  Clip := 2;         {0=no clip, 1=limit, 2=clip}
  CurveType := 2;    {0=pixel per X, 1=X plus Y, 2=overlap}
  XPlotType := 0;    {0=linear, 1=log}
  YPlotType := 0;    {0=linear, 1=log}


  {- read the documentation to understand what these values do}
  NumPts := 80;     {assign some default curve values}
  XStart := 100;
  XRange := 7900;
  YStart := -100;
  YRange := 200;

  for ii := 1 to 15 do
  begin
    G := ii;
    if not gPlotArea(G,gx1,gy1,gx2,gy2) then doGError;
    MapXtoScreen(XPlotType,gx1,gx2,Xstart,Xrange,NumPts,Xvals,XPlot);

    for iii := 1 to 3 do
    begin
      Yvals := cy[iii];
      MapYtoScreen(YPlotType,gy1,gy2,Ystart,Yrange,NumPts,Yvals,YPlot);
      DrawCurve(colors[iii],CurveType,NumPts,Clip,
                succ(gx1),succ(gy1),pred(gx2),pred(gy2),XPlot,YPlot);
    end;
  end;

  readln;
  closegraph;
end.


