{A quicky test program for XDUMP V1.x translating screen dump driver}
{Copyright (c) 1988 by Michael Day, all rights reserved}
{first implimentation 1 June 1988}
{this release as of 17 August 1988}

program pd;
uses crt,xdump,graph;
var x,y,i,grdriver,grmode:integer;
    A : string; ch : char;
    good : boolean;
    PrnLArea,PrnUArea:rect;

    PSR : PSptr;    {pointer variable used to access PSrec}

{-----------------------------------------}
{get a Y or N response from keyboard}
function getyorn:char;
var R : string;   A : char;
begin
  repeat
    readln(R);
    if R = '' then
      A := 'Y'
    else
      A := upcase(R[1]);
    if (A <> 'Y') and (A <> 'N') then
      write('Try again:');
  until (A = 'Y') or (A = 'N');
  getyorn := A;
end;

{------------------------------------------}
{get a number from the keyboard}
function getnum:integer;
var t, c : integer;
    A : string;
begin
  repeat
    readln(A);
    if A <> '' then
      val(A,t,c)
    else
    begin
      c := 0;
      t := 0;
    end;
    if c <> 0 then
      write('Try again:');
  until c = 0;
  getnum := t;
end;

{--------------------------------------------------------}
{pick up new screen limit values}
procedure getscrn(var scrnarea:rect);
begin
   with scrnarea do
   repeat
     writeln;
     writeln('Enter Screen area to use (ret for default):');
     write('Enter screen min X value:');
     xmin := getnum;
     write('Enter screen max X value:');
     xmax := getnum;
     write('Enter screen min Y value:');
     ymin := getnum;
     write('Enter screen max Y value:');
     ymax := getnum;
     if xmax = 0 then xmax := GetMaxX; {not allowed to go beyond screen}
     if ymax = 0 then ymax := GetMaxY;
     writeln;
     writeln('Screen area = ',xmin,',',xmax,',',ymin,',',ymax);
     write('Is this correct? (Y or N): ');
   until getyorn = 'Y';
end;


{---------------------------------------------------------}
{get printer limit values}
procedure getprn(var prnarea:rect);
begin
   with prnarea do
   repeat
     writeln;
     writeln('Enter Printer area to use (ret for default):');
     write('Enter printer Min X value:');
     xmin := getnum;
     write('Enter printer Max X value:');
     xmax := getnum;
     write('Enter printer Min Y value:');
     ymin := getnum;
     write('Enter printer Max Y value:');
     ymax := getnum;

     if xmax = 0 then                 {if they enter 0, assume}
     begin                            {predefined values}
       if psr^.LandScape then
       begin
         case psr^.PStype of
           1 : xmax := 799;   {for correct landscape aspect ratio}
           2 : xmax := 399;   {half as many in this mode}
           3 : xmax := 479;   {for correct VGA aspect ratio}
           4 : xmax := 799;   {for special herc mode}
         end;
       end
       else
       begin
         case psr^.PStype of
           1 : xmax := 959;  {upright value, assumes 8x6 picture}
           2 : xmax := 479;  {only half as many in this mode}
           3 : xmax := 575;  {not a valid selction, use max}
           4 : xmax := 959;  {herc mode}
         end;
       end;
     end;
     if ymax = 0 then
     begin
       if psr^.LandScape then
       begin
         case psr^.PStype of
           1 : ymax := 639;   {optimal undistored size for landscape}
           2 : ymax := 639;   {same in this mode}
           3 : ymax := 639;   {for correct VGA aspect ratio}
           4 : ymax := 719;   {for special herc mode}
         end;
       end
       else
       begin               {upright value, assumes 8x6 picture}
         case psr^.PStype of
           1 : ymax := 431;  {upright value, assumes 8x6 picture}
           2 : ymax := 399;  {shortened one just for the heck of it}
           3 : ymax := 431;  {not a valid selction, use max}
           4 : ymax := 431;  {special herc mode}
         end;
       end;
     end;
     writeln;
     writeln('Printer area = ',xmin,',',xmax,',',ymin,',',ymax);
     write('Is this correct? (Y or N): ');
   until GetYorn = 'Y';
end;

{------------------------------------------------------------------}
{force graphics mode to desired state}
procedure ForceMode(var grdriver, grmode : integer);
begin
  case grdriver of
     1 : grmode := 0; {CGA}
     2 : grmode := 0; {MCGA}
     3 : grmode := 1; {EGA}
     4 : grmode := 0; {EGA64}
     5 : grmode := 3; {EGAmono}
     7 : grmode := 0; {Herc}
     8 : grmode := 0; {ATT400}
     9 : grmode := 2; {VGA}
    10 : grmode := 0; {PC3270}
  end;
  SetGraphMode(grmode);   {init any new screen mode}
end;

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{make some stupid assumptions on what the printer should look like}
procedure StartPrn(var PSR:PSptr);
begin
   GetMem(PSR,sizeof(PSrec));
   FillChar(PSR^,sizeof(PSrec),0); {clear prnscr record to zero}
   with PSR^ do
   begin
      GPage := 0;            {use graphics page 0}
      LPTnum := 0;           {assume printer on LPT1}
      ScrnType := grdriver;  {use turbo's driver number}
      PStype := 1;           {use standard mode}
      LandScape := true;     {define the print mode (landscape/upright}
      mono := true;          {assume monochrome mode}

      PrnLArea.Xmin := 0;    {define the printer landscape defaults}
      PrnLArea.Ymin := 0;
      PrnLArea.Xmax := 799;
      PrnLArea.Ymax := 639;

      PrnUArea.Xmin := 0;     {define the printer upright defaults}
      PrnUArea.Ymin := 0;
      PrnUArea.Xmax := 959;
      PrnUArea.Ymax := 431;

      PrnArea := PrnUArea;    {start with upright print default}

      ScrnArea.Xmin := 0;     {define the screen defaults}
      ScrnArea.Ymin := 0;
      ScrnArea.Xmax := 319;   {CGA graphics assumed}
      ScrnArea.Ymax := 199;

      initprn(PSR^);           {now go initialize it}
   end;
end;

{************************************************************************}
{get the parameters to use for testing the printer driver}

begin

  grdriver := detect;   {find out what kind of graphics setup is out there}
  grmode := EGAhi;      {assume EGA for now}
  initgraph(grdriver,grmode,'');  {and initialize it}
  ForceMode(grdriver,grmode);     {force mode to desired default}
  RestoreCrtMode;    {then switch back to crt mode for the following}

    repeat
      writeln('       XDUMP V1.x DEMO program');
      writeln('Written by Michael Day  Copyright (c) 1988');
      writeln('        as of 25 July 1988');
      writeln;        {check if they want to change the screen mode/type}
      good := false;
      write('Screen mode = ',grmode,'  Screen type = ',grdriver);
      write('  Correct? (Y or N): ');
      if GetYorn = 'N' then
      begin
        write('Enter new screen Mode: ');
        grmode := GetNum;
        if (grmode < 0) or (grmode > 3) then grmode := 0;
        write('Enter new screen Type: ');
        grdriver := GetNum;
        if (grdriver < 0) or (grdriver > 10) then grmode := 0;
      end
      else
        good := true;
    until good;

  CloseGraph;                    {close old graphics mode}
  initgraph(grdriver,grmode,'');  {and reinitialize new one}
  RestoreCrtMode;         {and go back to text mode again}

  StartPrn(PSR);  {startup the printer driver}

  with PSR^ do
  begin
    repeat
      writeln;
      with ScrnArea do      {get the screen area to use}
      begin
        if xmax > GetMaxX then xmax := GetMaxX;
        if ymax > GetMaxY then ymax := GetMaxY;
        writeln('Screen Default = ',xmin,',',xmax,',',ymin,',',ymax);
        write('Do you wish to use the default values? (Y or N): ');
        if GetYorn = 'N' then GetScrn(ScrnArea);
      end;

      writeln;
      repeat
        write('Use LandScape or UpRight mode (L or U):');
        readln(A);
        if A = '' then       {check if they want upright or landscape}
          ch := 'L'
        else
          ch := upcase(A[1]);
        if (ch = 'L') then
           LandScape := true
        else
           LandScape := false;
      until (ch = 'L') or (ch = 'U');

      writeln;      {check out which print mode to use}
      repeat
        writeln('Normal = 1, Quick := 2, VGA (landscape) = 3, Herc = 4');
        write('Enter print mode to use (1-4):');
        PStype := GetNum;
      until (PStype > 0) and (PStype < 5);

      writeln;
      if LandScape then
      begin
        with PrnLArea do       {get the landscape printer area to use}
        begin
          writeln('Printer Default = ',xmin,',',xmax,',',ymin,',',ymax);
          write('Do you wish to use the default values? (Y or N):');
          if GetYorn = 'N' then
            GetPrn(PrnLArea);
        end;
        PrnArea := PrnLArea;
      end
      else
      begin                   {or the upright printer area to use}
        with PrnUArea do
        begin
          writeln('Printer Default = ',xmin,',',xmax,',',ymin,',',ymax);
          write('Do you wish to use the default values? (Y or N):');
          if GetYorn = 'N' then
            GetPrn(PrnUArea);
        end;
        PrnArea := PrnUArea;
      end;

      writeln;               {new Coke or Classic?}
      repeat
        write('Use Monochrome or Color printer (M or C):');
        readln(A);
        if A = '' then
          ch := 'M'
        else
          ch := upcase(A[1]);
        if (ch = 'M') then
           mono := true
        else
           mono := false;
      until (ch = 'M') or (ch = 'C');


      writeln;   {now show 'em what they selected}
      with ScrnArea do
        writeln('Screen area = ',xmin,',',xmax,',',ymin,',',ymax);
      with PrnArea do
        writeln('Printer area = ',xmin,',',xmax,',',ymin,',',ymax);
      if LandScape then
        writeln('LandScape mode')
      else
        writeln('UpRight mode');
      if mono then
        writeln('Monochrome printer')
      else
        writeln('Color printer');
      writeln('Print mode = ',PStype);

      write('Is this correct? (Y or N): ');
    until GetYorn = 'Y';
  end;

  {--------------------------------------}
  {setup done, now go do the graphics.}

  SetGraphMode(grmode);   {switch to the selected graphics mode}

  if psr^.mono then          {do up a mono display}
  begin                     {by showing a grid pattern}
    setcolor(white);        {in white}
    i := 0;
    while i < getmaxy do
    begin
      moveto(0,i);
      lineto(getmaxx,i);
      inc(i,8);
    end;
    moveto(getmaxx,0);
    lineto(getmaxx,getmaxy);

    i := 0;
    while i < getmaxx do
    begin
      moveto(i,0);
      lineto(i,getmaxy);
      inc(i,8);
    end;
    moveto(0,getmaxy);
    lineto(getmaxx,getmaxy);


    setfillstyle(solidfill,white);   {then slap a couple of pie slices}
    setcolor(white);                    {on it just for the heck of it}
    pieslice(getmaxx div 4,getmaxy div 2,0,99,50);
    moveto( (getmaxx div 4) + 16,(getmaxy div 2) - 16);
    setcolor(black);
    outtext('1');
    setcolor(white);
    setfillstyle(solidfill,white);
    pieslice(getmaxx div 4 * 3,getmaxy div 2,0,99,50);
    moveto( (getmaxx div 4 * 3) + 16,(getmaxy div 2) - 16);
    setcolor(black);
    outtext('2');
    setcolor(white);
  end

  else

  begin
    for y := 0 to 44 do                 {for color mode we just put up}
      for x := 0 to 79 do               {a simple color pattern}
      begin
        setcolor((x + y) and GetMaxColor);
    {    moveto(x*8,y*8);     }
    {    outtext(char(219)); }  {the block char doesn't print}
    {     outtext(char($40));  }  {with all BGI drivers sigh...}

        setfillstyle(solidfill,(x + y) and GetMaxColor);
        bar(x*8,y*8,x*8+7,y*8+7);       {so do it with a bar}
      end;

    setcolor(cyan);
    moveto(0,0);                        {outlined in cyan}
    lineto(getmaxx,0);                  {(to show edge priorities)}
    lineto(getmaxx,getmaxy);
    lineto(0,getmaxy);
    lineto(0,0);

  end;

  initprn(PSR^);      {now init the XDUMP to the selected values}
  PScreen(PSR^);      {and take a dump}

  if keypressed then ch := readkey; {clear old key if there was an abort}
  repeat until keypressed;          {then wait for any key to exit}

  closegraph;                   {close up shop and go home}
end.


