{**********************************************************************}
{                                                                      }
{ Author:        Michael L. Peters                                     }
{ Date:          February 3, 1992                                      }
{ Purpose:       Turbo Vision Object to display current date on        }
{                DeskTop in the format: DayOfWeek Day-Month-Year       }            
{                                       eg. Mon 3-Feb-1992             }
{                                                                      }
{                                                                      }
{ Copyright (c): Availible to all in the public domain.                }
{ Coments:       Use TestPlat.PAS and DT_Test.PAS to demonstrate this  }
{                unit.  Please leave comments and messages on          }
{                 CompuServe  ID  # 70421,727.                         }            
{                                                                      }
{**********************************************************************}
{2-03-92  11:00pm}

UNIT XDate;

interface

uses DOS, OBJECTS, VIEWS, APP;

type
    PDateView =^TDateView;
    TDateView = object(TView)
      DateStr: string[15];
      Year, Month, Day, DayOfWeek: word;
      Old_day: word;
      constructor Init( var Bounds: TRect);
      procedure Draw; virtual;
      function FSDate: String;
      procedure Update; Virtual;
    end;

implementation

uses Drivers;

{----------- Date Window Object ----------}

constructor TDateView.Init( var Bounds: TRect);
begin
     TView.Init(bounds);
end;

procedure TDateView.Draw;
var
  B: TDrawBuffer;
  C: Byte;
  X: Word;
begin
     getdate(Year, Month, Day, DayOfWeek);
     Old_day := Day;
     DateStr := FSDate;
     C:= GetColor(2);
     MoveChar(B, ' ',C, Size.X);
     MoveStr(B, DateStr, C);
     Writeline(0, 0, Size.X, 1, B);
end;

procedure TDateView.Update;
var
   Dum, New_Day : word;
begin
     getdate(Dum, Dum, New_Day, Dum);
     if New_Day <> Old_Day then
        drawview;
end;

function TDateView.FSDate: String;
const Days : ARRAY[ 0..6 ] OF String[3] = ('Sun', 'Mon', 'Tue','Wed', 'Thu',
                        'Fri', 'Sat' );
      Months : ARRAY[ 1 .. 12 ] OF String[3] = ('Jan', 'Feb','Mar', 'Apr',
                        'May', 'Jun', 'Jul', 'Aug', 'Sep','Oct', 'Nov','Dec');
var
  DayString, YearString: String[4];
Begin
     Str(Day, DayString);
     Str(Year, YearString);
     FSDate := days[DayOfWeek] + ' ' + DayString + '-' + months[Month] +'-' +
               YearString;
end;

end.