{*********************************************************}
{*                   WSHEAP.PAS 1.01                     *}
{*       Copyright (c) TurboPower Software 1993.         *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit WsHeap;
  {-Import unit for WSHEAP.DLL}

interface

const
  {Masks to enable suballocator analysis}
  sfNone = $0000;             {no suballocators}
  sfTPW  = $0001;             {TPW heap block}
  sfLH   = $0002;             {Local heap block}
  sfBC   = $0004;             {BC heap block}
  sfMSC  = $0008;             {MSC heap block}
  sfAll  = $FFFF;             {all available suballocators}

type
  TFlatArray =                {16 bytes}
    record                    {manages a 1D contiguous array of elements}
      aHandle   : Word;       {handle of memory block}
      aSel      : Word;       {selector of memory block}
      aCount    : LongInt;    {current element count}
      aCapacity : LongInt;    {current element capacity}
      aElSize   : Word;       {element size; must be power of two}
      aElGrow   : Word;       {number of elements to grow when needed}
    end;

  THeapState =                {34 bytes}
    record                    {descriptor for saved heap state}
      hGlobal   : TFlatArray; {global blocks}
      hSub      : TFlatArray; {suballocator blocks}
      hSubFlags : Word;       {enabled suballocators}
    end;

  function SaveHeapState(var HS : THeapState; SubFlags : Word) : Word;
    {-Save current heap state, returning 0 if successful}

  function CompareHeapState(var HS : THeapState;
                            DumpFileName : PChar;
                            DumpMsg : PChar) : Word;
    {-Compare current heap state to saved state, returning status code}

  procedure DoneHeapState(var HS : THeapState);
    {-Dispose of saved heap state}

  {Status codes returned by SaveHeapState and CompareHeapState:
          0      success
          8      insufficient memory
       8051      invalid FlatArray element size (internal error)
       8054      GlobalLock failure
       8500      local heap entries not in ascending order
       else      Turbo Pascal I/O result code
  }

implementation

  function SaveHeapState;      external 'WSHEAP' index 1;
  function CompareHeapState;   external 'WSHEAP' index 2;
  procedure DoneHeapState;     external 'WSHEAP' index 3;

end.
