/********************************************************
*                    WSHEAP.H 1.01                      *
*        Copyright (c) TurboPower Software 1993.        *
*                 All rights reserved.                  *
********************************************************/

#if !defined( __WSHEAP_H)
#define __WSHEAP_H

#if !defined(EXPORT)
#define EXPORT _export
#endif

#if defined( __cplusplus )
extern "C" {
#endif  /* __cplusplus */

//Masks to enable suballocator analysis
#define sfNone  0x0000             //no suballocators
#define sfTPW   0x0001             //TPW heap block
#define sfLH    0x0002             //Local heap block
#define sfBC    0x0004             //BC heap block
#define sfMSC   0x0008             //MSC heap block
#define sfAll   0xFFFF             //all available suballocators

typedef struct TFlatArray          //used internally by WSHEAP
{
  WORD    aHandle;                 //handle of memory block
  WORD    aSel;                    //selector of memory block
  long    aCount;                  //current element count
  long    aCapacity;               //current element capacity
  WORD    aElSize;                 //element size; must be power of two
  WORD    aElGrow;                 //number of elements to grow when needed
};

typedef struct THeapState          //stores the heap state
{
  TFlatArray  hGlobal;             //global blocks
  TFlatArray  hSub;                //suballocator blocks
  WORD        hSubFlags;           //enabled suballocators
};
typedef THeapState FAR *PHeapState;

extern WORD FAR EXPORT PASCAL SaveHeapState(PHeapState HS, WORD SubFlags);
  //-Save current heap state, returning 0 if successful

extern WORD FAR EXPORT PASCAL CompareHeapState(PHeapState HS,
                                               LPSTR DumpFileName,
                                               LPSTR DumpMsg);
  //-Compare current heap state to saved state, returning status code

extern VOID FAR EXPORT PASCAL DoneHeapState(PHeapState HS);
  //-Dispose of saved heap state

//Status codes returned by SaveHeapState and CompareHeapState:
//          0      success
//          8      insufficient memory
//       8051      invalid FlatArray element size (internal error)
//       8054      GlobalLock failure
//       8500      local heap entries not in ascending order
//       else      Turbo Pascal I/O result code

#if defined( __cplusplus )
}
#endif  /* __cplusplus */
#endif  /* __WSHEAP_H */
