PROGRAM Wrap_it;

{* -------------------------------------------------------------- *}
{*  WRAP_IT.PAS - a routine to do wordwrap in text files.         *}
{*                                                                *}
{*  Written by LOU GARNER, and released into the public domain.   *}
{*                                                                *}
{* -------------------------------------------------------------- *}

USES
  Crt;    {uses the ReadKey function}

CONST
  MaxChars = 60;    {this is right hand margin}

VAR
  OneLine, Buffer : String[80];
  CharCount : Word;
  OneChar : Char;

BEGIN    {MAIN}
  ClrScr;
  OneLine := '';    {revise to put all in an init module}
  CharCount := 0;
  OneChar := ' ';
  WHILE (OneChar <> #027) DO
    BEGIN
      REPEAT        {one loop per character typed}
        BEGIN
          OneChar := ReadKey;  {get the char W/O echo to the CRT}
          CASE OneChar of
            #08   :  BEGIN                  {backspace}
                       Write(#08,#032,#08); {wipe it off the screen}
                       IF (Length(OneLine) > 0) THEN
                         Delete(OneLine,CharCount,1);
                             {error trap use of BS on Column One}
                       CharCount := Length(OneLine);  {equal to good chars}
                     END;
            #013  :  BEGIN
                       Writeln;          {issue a CR to the screen}
                       CharCount := 0;   {re-init the index}
                       OneLine := '';    {re-init the output line}
                     END;
            #027  :  Exit   {yeah, I know, sloppy exit....}
            ELSE
              BEGIN     {main routine to accept text characters}
                OneLine := OneLine + OneChar;   {add to the output line}
                Write(OneChar);                 {& put it on the screen}
                Inc(CharCount);                 {bump the index}
              END;
            END;
          END;
  UNTIL (CharCount = MaxChars);
         {go to MaxChars before wrapping}

 {word wrapping routine now takes over ... }

     IF (OneLine[CharCount] = #032) THEN   {If end of line is a #032}
       BEGIN
         Writeln;       {issue a CR to the screen}
         CharCount := 0;   {re-init the index}
         OneLine := '';    {re-init the output line}
             {and you're at the start of the new line ... }
       END
     ELSE     {if end of line is <> a space }
       BEGIN
         Buffer := '';   {init the buffer for bopped characters }
         WHILE (OneLine[CharCount] <> #032) DO
                   {until we find a space at which to wrap}
           BEGIN
             Buffer := OneLine[CharCount] + Buffer;
                   {add the character to the FRONT of the buffer}
             Dec(CharCount);    {bump the index DOWN}
             Write(#08,#032,#08);  {wipe out the char on the screen}
           END;

     {by this point we've found a #032, so ... }

         CharCount := 0;             {re-init the index}
         Writeln;                    {issue a CR to the screen}
         Write(Buffer);              {write the buffer to new line
                                         on the screen}
         OneLine := Buffer;          {and catch up the output line}
         Buffer := '';               {re-init the buffer}
     END;
  END;
Writeln;    {Clean up the screen, if necessary}
END.


