Unit WinStack; {$A+,B-,F+,I-,L-,N+,O+,R-,S+,V+}

{ A very simple Window Stack Unit -- by Steve MacGregor, FBI }

Interface
  {NOTE:  This unit calls NEW and DISPOSE, so the using program should
    not call MARK or RELEASE between the first call to CreateWindow
    and the last call to DisposeWindow}

{$L WIN}
  {external procedure definitions are from WIN.COM, provided with the
    Turbo Pascal 5.5 package}

Type
  FrameType = ({style of frame to put around the new window}
    no_frame     {the new window is the *entire* defined area},
    single_frame {frame is a single graphics line},
    double_frame {frame is a double graphics line},
    dash_frame   {frame is dashes (-), bars (|), and plus signs (+)},
    char_frame   {first character of Name is used as frame});

Procedure CreateWindow
  ({save the attributes of the current window, and create a new one}
  MinX, MinY, MaxX, MaxY: byte
    {define a new window, as in CRT unit, including the frame, if any};
  TextAttr: byte
    {attributes of the new window, as in CRT unit}
    {if zero, use attributes from the current window};
  Frame: FrameType
    {chose style of frame, or no_frame}
    {the actual usable window will be reduced by two characters in each
      dimension, unless Frame = no_frame};
  FrameAttr: byte
    {attributes of the frame and Name}
    {if zero, use TextAttr instead};
  Name: string
    {title of window}
    {if Frame = no_frame, Name is printed as the first line in the
      new window, in the attributes defined by FrameAttr}
    {if Frame = char_frame, the first character is used to frame the
      new window, and is then deleted from Name});

Procedure DisposeWindow
  {dispose of the current window, and restore the previous one}
  {if no previous window was stored, just clear the screen};
{#####################################################################P}

Implementation

Uses CRT;

Type
  InfoPtr = ^InfoRecord;
  InfoRecord = record
    CurX, CurY: byte;
    WindMin, WindMax: word;
    TextAttr: byte;
    HasFrame: boolean;
    SaveText: pointer;
    Nxt: InfoPtr
    end {InfoRecord};
  FrameIndex = (up_l,up_r,dn_l,dn_r,horz,vert);

Const
  Inf: InfoPtr =
    nil;
  FrameChars: array [single_frame..char_frame] of record
    Ch: array [FrameIndex] of char
    end {FrameChars} =
      ((Ch:'ڿĳ'),(Ch:'ɻȼͺ'),(Ch:'++++-|'),(Ch:'######'));

Procedure WriteStr (X, Y: Byte; S: String; Attr: Byte);
  External;

Procedure WriteChar (X, Y, Count: Byte; Ch: Char; Attr: Byte);
  External;

Procedure FillWin (Ch: Char; Attr: Byte);
  External;

Procedure WriteWin (var Buf);
  External;

Procedure ReadWin (var Buf);
  External;

Function WinSize: Word;
  External;
{#####################################################################P}

Procedure CreateWindow (MinX, MinY, MaxX, MaxY, TextAttr: byte;
  Frame: FrameType; FrameAttr: byte; Name: string);

Var
  Ptr: InfoPtr;

{======================================================================}

Procedure DrawFrame (Frame: FrameType; W, H: integer);

Var
  L, Y: integer;

Begin {DrawFrame}
With FrameChars[Frame] do begin
  WriteChar (1,1,1,Ch[up_l],FrameAttr);
  WriteChar (2,1,W-2,Ch[horz],FrameAttr);
  WriteChar (W,1,1,Ch[up_r],FrameAttr);
  For Y := 2 to H - 1 do begin
    WriteChar (1,Y,1,Ch[vert],FrameAttr);
    WriteChar (W,Y,1,Ch[vert],FrameAttr)
    end {for J};
  WriteChar (1,H,1,Ch[dn_l],FrameAttr);
  WriteChar (2,H,W-2,Ch[horz],FrameAttr);
  WriteChar (W,H,1,Ch[dn_r],FrameAttr)
  end {with FrameChars[Frame]};
L := length(Name);
If L <> 0 then begin
  If L > W - 2 then byte(Name[0]) := W - 2;
  WriteStr ((W - length(Name)) div 2 + 1,1,Name,FrameAttr)
  end {if L <> 0};
Inc (CRT.WindMin,$0101);
Dec (CRT.WindMax,$0101)
End {DrawFrame};
{=====================================================================P}

Begin {CreateWindow}
If TextAttr = 0 then TextAttr := CRT.TextAttr;
If FrameAttr = 0 then FrameAttr := TextAttr;
New (Ptr);
With Ptr^ do begin
  WindMin := CRT.WindMin;
  WindMax := CRT.WIndMax;
  CurX := CRT.WhereX;
  CurY := CRT.WhereY;
  TextAttr := CRT.TextAttr;
  HasFrame := (Frame <> no_frame);
  Window (MinX,MinY,MaxX,MaxY);
  GetMem (SaveText,WinSize);
  ReadWin (SaveText^);
  Nxt := Inf
  end {with Ptr^};
Inf := Ptr;
If Frame = no_frame then begin
  GoToXY (1,1);
  FillWin (' ',TextAttr);
  If length(Name) <> 0 then begin
    CRT.TextAttr := FrameAttr;
    Writeln (Name)
    end {if length(Name) <> 0}
  end {if Frame = no_frame}
else {Frame <> no_frame} begin
  If Frame = char_frame then
    If length(Name) <> 0 then begin
      FillChar (FrameChars[char_frame],6,Name[1]);
      Delete (Name,1,1)
      end {if length(Name) <> 0};
  DrawFrame (Frame,MaxX-MinX+1,MaxY-MinY+1);
  GoToXY (1,1);
  FillWin (' ',TextAttr)
  end {Frame <> no_frame};
CRT.TextAttr := TextAttr
End {CreateWindow};
{#####################################################################P}

Procedure DisposeWindow;

Var
  Ptr: InfoPtr;

Begin {DisposeWindow}
Ptr := Inf;
If Ptr = nil then begin
  Window (1,1,80,25);
  FillWin (' ',CRT.TextAttr);
  GoToXY (1,1)
  end {if Ptr = nil}
else with Ptr^ do begin
  If HasFrame then begin
    Dec (CRT.WindMin,$0101);
    Inc (CRT.WindMax,$0101)
    end {if HasFrame};
  WriteWin (SaveText^);
  FreeMem (SaveText,WinSize);
  CRT.WindMin := WindMin;
  CRT.WindMax := WindMax;
  CRT.TextAttr := TextAttr;
  GoToXY (CurX,CurY);
  Inf := Nxt;
  Dispose (Ptr)
  end {with Ptr^}
End {DisposeWindow};

{######################################################################}

End {Unit WinStack}.