
{****************************************************************************}
{*                                                                          *}
{*      WinG Doggie sample application converted to Pascal                  *}
{*      by Mike Scott, 5th October 1994, CIS 100140,2420.                   *}
{*                                                                          *}
{*      Has some text added over the dog for an interesting                 *}
{*      effect plus the ability to change the dog's basic colour            *}
{*                                                                          *}
{*      Requires TransBlt.pas and TransBlt.dll.                             *}
{*      The TransBlt.dll is just the TBLT.C and FAST32.ASM in a             *}
{*      DLL with TransparentDIBits exported.                                *}
{*                                                                          *}
{*      Note: the second BitmapInfo and Bits parameters have been           *}
{*            reversed compared to the original TBLT.C. This makes          *}
{*            the parameters consistent - first the BitmapInfo then         *}
{*            the Bits (see TransparentDIBits).                             *}
{*                                                                          *}
{****************************************************************************}

program Doggie ;

{$R doggie.res}

uses WinProcs, WinTypes, Objects, OWindows, ODialogs, Strings,
     WinG, TransBLT, DIBUnit ;

const
  BitmapInfoSize   = sizeof( TBitmapInfoHeader ) + sizeof( TRGBQuad ) * 256 ;
  TransparentColor = $f3 ;
  LogPaletteSize   = sizeof( TLogPalette ) + sizeof( TPaletteEntry ) * 255 ;
  DoggieFileName   = 'doggie2.bmp' ;

{ TMainWindow }

const
  cm_About = 2 ;
  cm_Red   = 100 ;

type
  TBaseColour = ( bc_Red, bc_Green, bc_Blue ) ;

type
  PMainWindow = ^TMainWindow ;
  TMainWindow = object( TWindow )
    constructor Init( AParent : PWindowsObject ;
                      AName   : PChar ) ;
    destructor Done ; virtual ;
    procedure SetupWindow ; virtual ;
    function  GetClassName : PChar ; virtual ;
    procedure GetWindowClass( var AWndClass : TWndClass ) ; virtual ;
    procedure DefCommandProc( var Msg : TMessage ) ; virtual ;
    procedure ClearSystemPalette ;
    procedure PaintMessage ;
    procedure PaintDoggie( ScreenDC : HDC ;
                           X, Y : integer ) ;
    procedure Paint( DC : HDC ;
                     var PaintInfo : TPaintStruct ) ; virtual ;
    procedure SetupPalette ;
    procedure wmSize( var Msg : TMessage ) ; virtual wm_First + wm_Size ;
    procedure wmPaletteChanged( var Msg : TMessage ) ; virtual wm_First + wm_PaletteChanged ;
    procedure wmQueryNewPalette( var Msg : TMessage ) ; virtual wm_First + wm_QueryNewPalette ;
    procedure wmMouseMove( var Msg : TMessage ) ; virtual wm_First + wm_MouseMove ;
    procedure cmAbout( var Msg : TMessage ) ; virtual cm_First + cm_About ;
  private
    DIB : PDIB ;
    WinGDC : HDC ;
    BitmapWidth : integer ;
    BitmapHeight : integer ;
    hPalApp : HPalette ;
    dx, dy : integer ;
    OriginalMonoBitmap : HBitmap ;
    Orientation : integer ;
    BufferHeader : PBitmapInfo ;
    Buffer       : pointer ;
    BaseColour   : TBaseColour ;
  end ;


{ TMainWindow }

constructor TMainWindow.Init( AParent : PWindowsObject ;
                              AName   : PChar ) ;

begin
  inherited Init( AParent, AName ) ;
  dx := 400 ;
  dy := 400 ;
  with Attr do begin
    Menu := LoadMenu( HInstance, 'AppMenu' ) ;
    x := CW_USEDEFAULT ;
    y := CW_USEDEFAULT ;
    w := dx ;
    h := dy ;
  end ;
  OriginalMonoBitmap := 0 ;
  hPalApp := 0 ;
  BaseColour := bc_Blue ;

  { load a DIB }
  DIB := new( PDIB, Init( DoggieFileName ) ) ;

  { init blank DC }
  WinGDC := 0 ;

  { setup bitmap parameters etc. }
  if DIB <> nil then with DIB^ do begin
    BitmapWidth := Width ;
    BitmapHeight := Height ;
  end ;

  { setup buffer bitmap info header }
  GetMem( BufferHeader, BitmapInfoSize ) ;
end ;


destructor TMainWindow.Done ;

begin
  inherited Done ;
  if DIB <> nil then dispose( DIB, Done ) ;
  DeleteObject( SelectObject( WinGDC, OriginalMonoBitmap ) ) ;
  DeleteObject( WinGDC ) ;
  DeleteObject( hPalApp ) ;
  if BufferHeader <> nil then FreeMem( BufferHeader, BitmapInfoSize ) ;
end ;


procedure TMainWindow.SetupWindow ;

begin
  inherited SetupWindow ;
  ClearSystemPalette ;
  CheckMenuItem( Attr.Menu, cm_Red + byte( BaseColour ), MF_CHECKED or MF_BYCOMMAND ) ;
end ;


function  TMainWindow.GetClassName : PChar ;

begin
  GetClassName := 'Pascal Doggie' ;
end ;


procedure TMainWindow.GetWindowClass( var AWndClass : TWndClass ) ;

begin
  inherited GetWindowClass( AWndClass ) ;
  with AWndClass do begin
    Style := CS_BYTEALIGNCLIENT or CS_VREDRAW or CS_HREDRAW or CS_DBLCLKS ;
    hIcon := LoadIcon( HInstance, 'AppIcon' ) ;
    hbrBackground := 0 ;
  end ;
end ;


procedure TMainWindow.DefCommandProc( var Msg : TMessage ) ;

begin
  inherited DefCommandProc( Msg ) ;
  with Msg do if ( wParam in [ cm_Red..cm_Red + 2 ] ) and ( LParam = 0 ) then
  begin

    { base colour changed }
    CheckMenuItem( Attr.Menu, byte( BaseColour ) + cm_Red,
                   MF_UNCHECKED or MF_BYCOMMAND ) ;
    byte( BaseColour ) := wParam - cm_Red ;
    CheckMenuItem( Attr.Menu, wParam, MF_CHECKED or MF_BYCOMMAND ) ;
    SetupPalette ;
    InvalidateRect( HWindow, nil, false ) ;
  end ;
end ;


procedure TMainWindow.ClearSystemPalette ;

var ALogPalette : PLogPalette ;
    i           : integer ;
    DC          : HDC ;
    AnOldPalette : HPalette ;
begin
  GetMem( ALogPalette, LogPaletteSize ) ;
  if ALogPalette <> nil then with ALogPalette^ do begin
    palVersion := $300 ;
    palNumEntries := 256 ;
    for i := 0 to 255 do with palPalEntry[ i ] do begin
      peRed := 0 ;
      peGreen := 0 ;
      peBlue := 0 ;
      peFlags := PC_NOCOLLAPSE ;
    end ;

    { select and realise the palette and clean up }
    DC := GetDC( HWindow ) ;
    AnOldPalette := SelectPalette( DC, CreatePalette( ALogPalette^ ), false ) ;
    RealizePalette( DC ) ;
    DeleteObject( SelectPalette( DC, AnOldPalette, true ) ) ;
    ReleaseDC( HWindow, DC ) ;
    FreeMem( ALogPalette, LogPaletteSize ) ;
  end ;
end ;


procedure TMainWindow.PaintMessage ;

var ALogFont     : TLogFont ;
    AnOldFont    : HFont ;
    ARect        : TRect ;
    OldMode      : integer ;

  procedure DrawIt( AColor : TColorRef ) ;

  var OldColor     : TColorRef ;

  begin
    OldColor := SetTextColor( WinGDC, AColor ) ;
    DrawText( WinGDC, 'Mike''s Doggie!', -1, ARect,
              DT_CENTER or DT_VCENTER or DT_SINGLELINE or DT_NOPREFIX ) ;
    SetTextColor( WinGDC, OldColor ) ;
  end ;

begin
  FillChar( ALogFont, sizeof( ALogFont ), 0 ) ;
  with ALogFont do begin
    lfHeight := 64 ;
    StrCopy( lfFaceName, 'Times New Roman' ) ;
  end ;
  AnOldFont := SelectObject( WinGDC, CreateFontIndirect( ALogFont ) ) ;
  SetRect( ARect, 0, 0, dx, dy ) ;
  OldMode := SetBkMode( WinGDC, TRANSPARENT ) ;
  DrawIt( 0 ) ;
  OffsetRect( ARect, -4, -4 ) ;
  DrawIt( 0 ) ;
  OffsetRect( ARect, -1, -1 ) ;
  DrawIt( RGB( 255, 255, 255 ) ) ;
  SetBkMode( WinGDC, OldMode ) ;
  DeleteObject( SelectObject( WinGDC, AnOldFont ) ) ;
end ;


procedure TMainWindow.PaintDoggie( ScreenDC : HDC ;
                                   X, Y : integer ) ;

var ADestX, ADestY : integer ;

begin
  ADestX := X - BitmapWidth div 2 ;
  ADestY := Y - BitmapHeight div 2 ;

  TransparentDIBits( BufferHeader,
                     Buffer,
                     X - BitmapWidth div 2,
	                   Y - BitmapHeight div 2,
                     DIB^.BitmapInfo,
                     GlobalLock( DIB^.DIBBits ),
                     0, 0 ,
                     DIB_RGB_COLORS,
	                   TransparentColor ) ;
  GlobalUnlock( DIB^.DIBBits ) ;

  { put a message in the middle behind the doggie }
  PaintMessage ;

  { blast on to the screen }
  WinGBitBlt( ScreenDC, ADestX, ADestY, BitmapWidth, BitmapHeight,
		          WinGDC, X - BitmapWidth div 2, Y - BitmapHeight div 2 ) ;
end ;


procedure TMainWindow.Paint( DC : HDC ;
                             var PaintInfo : TPaintStruct ) ;

var AnOldPalette : HPalette ;

begin
  AnOldPalette := SelectPalette( DC, hPalApp, false ) ;
  RealizePalette( DC ) ;
  WinGBitBlt( DC, 0, 0, dx, dy, WinGDC, 0, 0 ) ;
  SelectPalette( DC, AnOldPalette, true ) ;
end ;


procedure TMainWindow.SetupPalette ;

var ALogPalette : PLogPalette ;
    i, n        : integer ;
    AScreenDC   : HDC ;

begin
  if hPalApp <> 0 then begin
    DeleteObject( hPalApp ) ;
    hPalApp := 0 ;
  end ;

	{ create an identity palette from the DIB's color table -
		get the 20 system colors as PALETTEENTRIES }
  GetMem( ALogPalette, LogPaletteSize ) ;
  if ALogPalette <> nil then with ALogPalette^ do begin
    palVersion := $300 ;
    palNumEntries := 256 ;
  	AScreenDC := GetDC( 0 ) ;
	  GetSystemPaletteEntries( AScreenDC, 0, 10, palPalEntry ) ;
    n := 246 ;
  	GetSystemPaletteEntries( AScreenDC, n, 10, palPalEntry[ n ] ) ;
    ReleaseDC( 0, AScreenDC ) ;

    { copy the rest of the colours for the DIB colour table }
    { added BaseColour so that the doggie can be based on red, green or blue }
    case BaseColour of
      bc_Red : begin
        for i := 10 to 245 do
          with palPalEntry[ i ], DIB^.BitmapInfo^.bmiColors[ i ]do
        begin
          peRed := rgbRed ;
          peGreen := rgbGreen ;
          peBlue := rgbBlue ;
          peFlags := PC_NOCOLLAPSE ;
        end ;
      end ;

      bc_Green : begin
        for i := 10 to 245 do
          with palPalEntry[ i ], DIB^.BitmapInfo^.bmiColors[ i ]do
        begin
          peRed := rgbGreen ;
          peGreen := rgbRed ;
          peBlue := rgbBlue ;
          peFlags := PC_NOCOLLAPSE ;
        end ;
      end ;

      else begin
        for i := 10 to 245 do
          with palPalEntry[ i ], DIB^.BitmapInfo^.bmiColors[ i ]do
        begin
          peRed := rgbBlue ;
          peGreen := rgbGreen ;
          peBlue := rgbRed ;
          peFlags := PC_NOCOLLAPSE ;
        end ;
      end ;
    end ;

    { copy from the palette to the WinG bitmap colour table }
    for i := 0 to 255 do
      with BufferHeader^.bmiColors[ i ], palPalEntry[ i ] do
    begin
      rgbRed := peRed ;
      rgbGreen := peGreen ;
      rgbBlue := peBlue ;
      rgbReserved := 0 ;
    end ;

    { if there's a WingDC, change it's colour table }
    if WinGDC <> 0 then
      WinGSetDIBColorTable( WinGDC, 0, 256, @BufferHeader^.bmiColors[ 0 ] ) ;

    { create the application palette, WinGDC and insert the bitmap }
    hPalApp := CreatePalette( ALogPalette^ ) ;

    { tidy up }
    FreeMem( ALogPalette, LogPaletteSize ) ;
  end ;
end ;


procedure TMainWindow.wmSize( var Msg : TMessage ) ;

var ABitmap     : HBitmap ;

    ALogFont     : TLogFont ;
    AnOldFont    : HFont ;
    ARect        : TRect ;
    OldMode      : integer ;

begin
  { get the mouse coordinates }
  dx := Msg.LParamLo ;
  dy := Msg.LParamHi ;

  { setup WinDC etc. }
  if WinGDC <> 0 then begin

    { select a new bitmap }
    with BufferHeader^.bmiHeader do begin
      biWidth := dx ;
      biHeight := dy * Orientation ;
    end ;
    ABitmap := WinGCreateBitmap( WinGDC, BufferHeader, @Buffer ) ;

    { Select it in and delete the old one }
    DeleteObject( SelectObject( WinGDC, ABitmap ) ) ;
  end else begin

    { create a WinGDC, fill in BufferHeader, and create a bitmap }
    with BufferHeader^.bmiHeader do begin
      if WinGRecommendDIBFormat( BufferHeader ) then begin

        { make sure it's 8bpp and remember the orientation }
		    biBitCount := 8 ;
			  biCompression := BI_RGB ;
			  Orientation := biHeight ;
      end else begin

        { create the bitmap header }
        biSize := sizeof(TBitmapInfoHeader ) ;
        biPlanes := 1 ;
        biBitCount := 8 ;
        biCompression := BI_RGB ;
        biSizeImage := 0 ;
        biClrUsed := 0 ;
        biClrImportant := 0 ;
      end ;

      biWidth := dx ;
      biHeight := dy * Orientation ;
    end ;

    { create the application palette, WinGDC and insert the bitmap }
    SetupPalette ;
    WinGDC := WinGCreateDC ;
    ABitmap := WinGCreateBitmap( WinGDC, BufferHeader, @Buffer ) ;
    OriginalMonoBitmap := SelectObject( WinGDC, ABitmap ) ;
  end ;

  { erase the WinGDC }
  PatBlt( WinGDC, 0, 0, dx, dy, BLACKNESS ) ;

  { Stick the doggie into the center of the buffer }
  TransparentDIBits( BufferHeader, Buffer,
                     dx div 2 - BitmapWidth div 2,
                     dy div 2 - BitmapHeight div 2,
                     DIB^.BitmapInfo,
                     GlobalLock( DIB^.DIBBits ),
                     0, 0 ,
                     DIB_RGB_COLORS,
	                   TransparentColor ) ;
  GlobalUnlock( DIB^.DIBBits ) ;

  { put a message over the doggie }
  PaintMessage ;
end ;


procedure TMainWindow.wmPaletteChanged( var Msg : TMessage ) ;

begin
  { standard palette stuff }
  if Msg.wParam <> HWindow then wmQueryNewPalette( Msg ) ;
end ;


procedure TMainWindow.wmQueryNewPalette( var Msg : TMessage ) ;

var DC         : HDC ;
    OldPalette : HPalette ;
    i          : integer ;

begin
  { more standard palette stuff }
  DC := GetDC( HWindow ) ;
  OldPalette := SelectPalette( DC, hPalApp, false ) ;
  i := RealizePalette( DC ) ;
  SelectPalette( DC, OldPalette, true ) ;
  ReleaseDC( HWindow, DC ) ;
  if i <> 0 then InvalidateRect( HWindow, nil, false ) ;
  Msg.Result := i ;
end ;


procedure TMainWindow.wmMouseMove( var Msg : TMessage ) ;

var DC : HDC ;
    AnOldPalette : HPalette ;

begin
  { if the left mouse button is down, drag the doggie }
  if GetKeyState( VK_LBUTTON ) < 0 then begin
    DC := GetDC( HWindow ) ;
    AnOldPalette := SelectPalette( DC, hPalApp, FALSE ) ;
    RealizePalette( DC ) ;
    with Msg do PaintDoggie( DC, LParamLo, LParamHi ) ;
    SelectPalette( DC, AnOldPalette, true ) ;
    ReleaseDC(HWindow, DC ) ;
  end ;
end ;


procedure TMainWindow.cmAbout( var Msg : TMessage ) ;

begin
  Application^.ExecDialog( new( PDialog, Init( @Self, 'AppAbout' ) ) ) ;
end ;


{ TApp }

type
  PApp = ^TApp ;
  TApp = object( TApplication )
    procedure InitMainWindow ; virtual ;
  end ;


{ TApp }

procedure TApp.InitMainWindow ;

begin
  MainWindow := new( PMainWindow, Init( nil, 'Doggie: WinG Sprite Demo in Pascal' ) ) ;
end ;


function  CheckForDoggieFile : boolean ;

var F : file ;
    Temp : array[ 0..255 ] of char ;
    p    : PChar ;

begin
  CheckForDoggieFile := false ;
  assign( F, DoggieFileName ) ;
  reset( F ) ;
  if IOResult = 0 then begin
    close( F ) ;
    CheckForDoggieFile := true ;
  end else begin
    p := DoggieFileName ;
    wvsPrintf( Temp, 'Cannot find %s -'#13#13 +
                     'Please copy this file from the'#13 +
                     'WinG doggie sample directory'#13 +
                     'into this directory and try again.', p ) ;
    MessageBox( 0, Temp, 'Doggie', MB_ICONEXCLAMATION or MB_OK ) ;
  end ;
end ;


{ TApp }

var App : TApp ;

begin
  if CheckForDoggieFile then with App do begin
    Init( 'Doggie' ) ;
    Run ;
    Done ;
  end ;
end.
