{$f+}
UNIT SCREEN;

{
   "Created using Turbo Pascal, copyright (c) Borland International
   1987, 1988."      Turbo Pascal 5.5

   This is a unit which will do the following:

   MONOCHROME          Returns true if monochrome monitor
   PUSH_SCREEN         Store current screen in ram
   POP_SCREEN          Restore screen stored in ram
   CURSORON            Turn cursor off
   CURSOROFF           Turn cursor on
   DRAWBOX             Create and box a window given coordinates (of box)
   WAITFORKEY          Wait for a any key to be pressed
                       (without cursor showing)

   This unit was sparked by a program I read in "Complete Turbo
   Pascal Third Edition" by Jeff Duntemann.  ISBN 0-673-38355-5.
   Copyright (c) 1989 by Scott, Foresman and Company.

}
INTERFACE

USES DOS,CRT;

CONST
  ScreenX = 80;
  ScreenY = 25;   { This could be 43 for the EGA;
                    50 for the VGA;
                    66 for Genuis }
TYPE
  wrdptr  = ^word;
VAR
  XSave,
  YSave              : Integer;
  VideoBufferSize    : Word;
  SavePtr,
  VideoPtr           : wrdptr;
  VideoSeg           : Word;

FUNCTION  MONOCHROME : Boolean;
PROCEDURE CURSORON;
PROCEDURE CURSOROFF;
PROCEDURE WAITFORKEY;
PROCEDURE DRAWBOX(x1,y1,x2,y2:integer);
PROCEDURE PUSH_SCREEN(var saveptr:wrdptr);
PROCEDURE POP_SCREEN(var saveptr:wrdptr);

IMPLEMENTATION

{*********************************************************************}

  FUNCTION MONOCHROME : Boolean;
  VAR
     Regs : Registers;
  BEGIN
    INTR(17,Regs);
    IF (Regs.AX AND $0030) = $30 THEN
      MONOCHROME := True
    ELSE
      MONOCHROME := False
  END;

{*********************************************************************}

  PROCEDURE CURSORON;
  TYPE  adapterTYPE = (none,mda,cga,egamono,egacolor,vgamono,
                       vgacolor,mcgamono,mcgacolor);
  VAR points : byte;
      regs   : registers;

     FUNCTION determinepoints : integer;
     VAR regs:registers;

        FUNCTION QUERYATAPTERTYPE:adapterTYPE;
        VAR regs: registers;
            code: byte;
        BEGIN
          regs.ah:=$1a;
          regs.al:=$00;
          intr($10,regs);
          IF regs.al = $1a THEN
            BEGIN
              CASE regs.bl OF
                 $00 : QUERYATAPTERTYPE:=none;
                 $01 : QUERYATAPTERTYPE:=mda;
                 $02 : QUERYATAPTERTYPE:=cga;
                 $04 : QUERYATAPTERTYPE:=egacolor;
                 $05 : QUERYATAPTERTYPE:=egamono;
                 $07 : QUERYATAPTERTYPE:=vgamono;
                 $08 : QUERYATAPTERTYPE:=vgacolor;
                 $0a,$0c : QUERYATAPTERTYPE :=mcgacolor;
              ELSE
                 QUERYATAPTERTYPE := cga;
              END;
            END
          ELSE
            BEGIN
              regs.ah:=$12;
              regs.bx:=$10;
              intr($10,regs);
              IF regs.bx <> $10 THEN
                BEGIN
                  regs.ah :=$12;
                  regs.bl :=$10;
                  intr($10,regs);
                  IF (regs.bh = 0) THEN
                    QUERYATAPTERTYPE:=egacolor
                  ELSE
                    QUERYATAPTERTYPE:=egamono;
                END
              ELSE
                BEGIN
                  intr($11,regs);
                  code:=(regs.al and $30) shr 4;
                  CASE code OF
                    1 : QUERYATAPTERTYPE := cga;
                    2 : QUERYATAPTERTYPE := cga;
                    3 : QUERYATAPTERTYPE := mda
                  ELSE
                    QUERYATAPTERTYPE:=cga;
                  END;
                END;
              END;
            END;

     BEGIN
       CASE QUERYATAPTERTYPE OF
         cga    : determinepoints:=8;
         mda    : determinepoints:=14;
         egamono,
         egacolor,
         vgamono,
         vgacolor,
         mcgamono,
         mcgacolor:BEGIN
                     WITH regs DO
                      BEGIN
                        ah:=$11;
                        al:=$30;
                        bl:=0;
                      END;
                     intr($10,regs);
                     determinepoints:=regs.cx;
                   END;
       END;
     END;

  BEGIN
    points:=determinepoints;
    mem[$40:$87]:=mem[$40:$87] OR $01;
    WITH regs DO
      BEGIN
        ax:=$0100;
        ch:=points-3;
        cl:=points-1;
      END;
    intr(16,regs);
  END;


{*********************************************************************}

  PROCEDURE CURSOROFF;
  VAR Regs : Registers;
  BEGIN
   WITH regs DO
    BEGIN
      ax:=$0100;
      cx:=$2000;
    END;
   intr(16,regs);
  END;


{*********************************************************************}

  PROCEDURE WAITFORKEY;
  VAR Dummy   : Char;
  BEGIN
    gotoxy(1,1);
    CURSOROFF;
    REPEAT UNTIL KeyPressed;
    Dummy := ReadKey;
    IF Dummy = Chr(0) THEN
       Dummy := ReadKey;
    CURSORON;
  END;

{*********************************************************************}

  PROCEDURE DRAWBOX(x1,y1,x2,y2:integer);
  const
    ULCORNER = CHR(201);
    URCORNER = CHR(187);
    LLCORNER = CHR(200);
    LRCORNER = CHR(188);
    HBAR     = CHR(205);
    VBAR     = CHR(186);
  VAR i:integer;
  BEGIN
    window(1,1,80,25);
    highvideo;
    gotoxy(x1,y1);
    write(ulcorner);
    FOR i:=x1+1 to x2-1 DO
        write(hbar);
    write(urcorner);
    FOR i:=y1+1 to y2-1 DO
        BEGIN
          gotoxy(x1,i);
          write(vbar);
          gotoxy(x2,i);
          write(vbar);
        END;
    gotoxy(x1,y2);
    write(llcorner);
    FOR i:=x1+1 to x2-1 DO
       write(hbar);
    write(lrcorner);
    window(x1+1,y1+1,x2-1,y2-1);
    ClrScr;
  END;

{*********************************************************************}

  PROCEDURE PUSH_SCREEN(var saveptr:wrdptr);
  VAR J:INTEGER;
      VidSegment : Word;
  BEGIN
    XSave := WhereX;
    YSave := WhereY;     { Save the underlying cursor pos. }
    { Allocate memory for stored screen: }
    GetMem(SavePtr,VideoBufferSize);
    IF MONOCHROME THEN
       VidSegment := $B000 { Get a screen buffer origin }
    ELSE
       VidSegment := $B800;
    VideoPtr := Ptr(VidSegment,0);  { Create a pointer to the buffer }
    Move(VideoPtr^,SavePtr^,VideoBufferSize); { Save screen out to the heap }
  END;

{*********************************************************************}

  PROCEDURE POP_SCREEN(var saveptr:wrdptr);
  BEGIN
    Move(SavePtr^,VideoPtr^,VideoBufferSize);  { Bring screen back from heap }
    FreeMem(SavePtr,VideoBufferSize);          { Free up the heap memory     }
    GotoXY(XSave,YSave);                       { Put cursor back where it was}
  END;

{ initialize static variables }
begin
    VideoBufferSize := ScreenX*ScreenY*2;  { E.g., 25 X 80 X 2 = 4000 bytes  }
END. {IMPLEMENTATION}