
unit video;

interface

uses wintypes,winprocs,windos,wincrt,objects,omemory,owindows,odialogs,ostddlgs,strings,
	    mmsystem;
const

 filename = 'c:\video\v4w\porsche.avi';


 DeviceID   : Word    = 0;

type

  pvw = ^vw;
  vw=
  object(twindow)
   MciGenParm   : TMCI_Generic_Parms;
   MciOpenParm  : TMCI_Open_Parms;
   MciPlayParm  : TMCI_Play_Parms;
   MciStatusParm: TMCI_Status_Parms;
   MciSetParm   : TMCI_Set_Parms;
   procedure playvideo(filename:pchar); virtual;
   procedure StopWave;          virtual;
   procedure MciNotify(var msg:tmessage); virtual wm_First + mm_MCINotify;
   procedure wmlbuttonup(var msg:tmessage); virtual wm_first + wm_lbuttonup;
  end;




implementation

var
 videorunning:boolean;



procedure vw.stopwave;
begin
  if DeviceID <> 0 then
  begin
    MciGenParm.dwCallback := 0;
    mciSendCommand(DeviceID, mci_Stop,  mci_Wait, Longint(@MciGenParm));
    mciSendCommand(DeviceID, mci_Close, mci_Wait, Longint(@MciGenParm));
    videorunning := false;
    DeviceID  := 0;
  end;
end;

procedure vw.mcinotify(var msg:tmessage);
begin
 StopWave;
end;



procedure vw.playvideo(filename:pchar);
var
 errmsg : array [0..255] of char;
 res:longint;
begin
 if videorunning then
 begin
  {tempmessage('Already running video or animation...');}
 end
 else
 begin
   MciOpenParm.dwCallback := 0;
   MciOpenParm.wDeviceID  := 0;
   MciOpenParm.wReserved0 := 0;
   MciOpenParm.lpstrDeviceType  := nil;
   MciOpenParm.lpstrElementName := filename;
   MciOpenParm.lpstrAlias       := nil;
   if mciSendCommand(0, mci_Open, (mci_Wait or mci_Open_Element),Longint(@MciOpenParm)) <> 0 then
   begin
      MessageBox(hwindow, 'Problem opening file for this device','Video Player', mb_OK);
   end
   else
   begin
    DeviceID := MciOpenParm.wDeviceID;
    MciPlayParm.dwCallback := hwindow;
    MciPlayParm.dwFrom     := 0;
    MciPlayParm.dwTo       := 0;
    Res := mciSendCommand(DeviceID, mci_Play, mci_Notify,Longint(@MciPlayParm));
    if Res <> 0 then
    begin
     mciGetErrorString(Res, ErrMsg, SizeOf(ErrMsg));
     MessageBox(hwindow, ErrMsg, 'Video Player', mb_OK or mb_IconStop);
     StopWave;
    end
    else
    begin
     videorunning := true;
    end;
   end;
 end;
end;


procedure vw.wmlbuttonup(var msg:tmessage);
begin
 playvideo(filename);
end;






begin
 videorunning := false;
end.