program  DynArrayExample;

uses
  OpCrt,
  OpRoot,
  Vmmngr;

type
  ExpRecord
    = record
       Name : string[25];
       Age,
       Class: word;
      end;
var
  ExpArray  : DynArray;
  RecBuffer : ExpRecord; {buffer to put and get data to and from ExpArray}
  Key,
  Status,
  NbElem,
  NumIncr   : word;
  S         : DosIdStream;

  procedure ShowStatus;
    {-Display status of ExpArray}
  begin
    Writeln('ExpArray size is now : ', ExpArray.GetArraySize);
    Writeln('ExpArray status is   : ', ExpArray.GetStatus);
  end;

  procedure ShowContents(index : word);
    {-Show contents of one element of ExpArray}
  begin
   ExpArray.GetElem(index, RecBuffer);
   Writeln('Element #',index, ' Name  is : ', RecBuffer.Name);
   Writeln('Element #',index, ' Age   is : ', RecBuffer.Age);
   Writeln('Element #',index, ' Class is : ', RecBuffer.Class);
  end;

begin
  Write('Enter the maximum number of elements for the array : ');
  ReadLn(NbElem);
  Write('Enter the minimum increment when growing (number of elements) : ');
  ReadLn(NumIncr);
  ClrScr;
  {Creates a dynamic array of ExpRecord}
  if not ExpArray.Init(NbElem,
                       SizeOf(ExpRecord),
                       NumIncr) then begin
    WriteLn('Failed to Create DynArray,  Status = ', InitStatus);
    Halt;
  end;
  Writeln('After initialization, the array size is 0...');
  ShowStatus;

  {Load RecBuffer}
  Recbuffer.Name  := 'Name0';
  Recbuffer.Age   := 0; {Not realistic but helps seeing how things work}
  RecBuffer.Class := 0;

  {Store RecBuffer in the dynamic array}
  ExpArray.SetElem(0, RecBuffer);

  {Size increase to the minimum increment}
  Writeln('Setting the first element will increase the size to the minimum increment...');
  Writeln('One element occupies ', ExpArray.GetElemSize, ' bytes');
  ShowStatus;
  ShowContents(0);

  {Load another value at maximum index }
  Recbuffer.Name  := 'NameMax';
  Recbuffer.Age   := ExpArray.GetMaxIndex;
  RecBuffer.Class := Recbuffer.Age;
  ExpArray.SetElem(ExpArray.GetMaxIndex, RecBuffer);

  {The size was increased to receive the last element}
  Writeln('Setting the last element will likely require a size increase...');
  ShowStatus;
  ShowContents(ExpArray.GetMaxIndex);

  {Elements non explicitly set are always 0}
  Writeln('You can always assume that an element which has not been set is null...');
  ShowContents(ExpArray.GetMaxIndex-1);
  Writeln('Press any key');
  While not KeyPressed do;
  While Keypressed do Key :=ReadKeyWord;
  ClrScr;

  {Now storing the array in a stream, killing it and reloading it}
  Writeln('Now storing the array...');
  {Create a Stream, check for success}
  if not S.Init('DYNARRAY.STM', SCreate) then begin
    Writeln('Failed to Create Stream,  Status = ', InitStatus);
    Halt;
  end;
  {Register object hierarchy}
  S.RegisterHier(DynArrayStream);
  Status := S.GetStatus;
  if Status <> 0 then begin
    Writeln('Failed to Register objects,  Status = ', Status);
    Halt;
  end;
  S.Put(ExpArray);
  Status := S.GetStatus;
  if Status <> 0 then begin
    WriteLn('Failed to Write ExpArray,   Status = ', Status);
    Halt;
  end;

  Writeln('Now killing ExpArray...');
  ExpArray.Done;
  S.done;

  Writeln('Now reloading ExpArray...');
  {Re-open the existing Stream}
  if not S.Init('DYNARRAY.STM', SOpen) then begin
    Writeln('Failed to Open Stream,  Status = ', InitStatus);
    Halt;
  end;
  {Re-register object hierarchy}
  S.RegisterHier(DynArrayStream);
  Status := S.GetStatus;
  if Status <> 0 then begin
    Writeln('Failed to register objects. Status = ', Status);
    Halt;
  end;
  S.Get(ExpArray);
  Status := S.GetStatus;
  if Status <> 0 then begin
    Writeln ('Failed to read ExpArray. Status = ', Status);
    Halt;
  end;
  S.Done;
  Writeln('Showing ExpArray first and last elements...');
  ShowStatus;
  ShowContents(ExpArray.GetMaxIndex);
  ShowContents(0);
  Writeln;
  Writeln('Press any key');
  While not KeyPressed do;
  While Keypressed do Key :=ReadKeyWord;
  ClrScr;

  {Clearing the array just resets the size to 0 and free all data on the heap}
  {However the array is still active and any element could be set}
  Writeln('Now clearing the array...');
  ExpArray.Clear;
  Writeln('ExpArray size is now ', ExpArray.GetArraySize, ' bytes');
  Writeln('ExpArray still alive : any element can be set.');

  Writeln('Now testing error checking...');
  Writeln('Trying to get the second element of the cleared array...');
  ExpArray.GetElem(2, RecBuffer);
  if ExpArray.GetStatus <> 0 then
     Writeln('Failed to retrieve element data');
  Writeln;
  Writeln('Now trying to setup a very big array (30000 elements)...');
  ExpArray.Done;
  ExpArray.Init(30000, SizeOf(ExpRecord), 100);
  if InitStatus <> 0 then
    WriteLn('Failed to Create DynArray,  Status = ', InitStatus);

  ExpArray.done;
end.
