program VmmTest2;
{-Test program for VMM. This test is much more severe than real world}
{ applications. So don't be afraid by the time it requires to execute}

uses
  Dos,
  Vmmngr;

type
  BytePtr = ^Byte;

const
  AMax = 200;
  SwapFNames : array [1..2] of pathstr = ('VMM1.SWP', 'VMM2.SWP');

var
  VM  : array [1..2] of Vmm;
  A   : array [1..2,1..AMax] of BytePtr;
  i,j : Word;

begin
  for i := 1 to 2 do begin
    if not VM[i].Init(SwapFNames[i]) then begin
      Writeln('Failed to open virtual memory managers');
      Halt;
    end
    else
      Writeln('Virtual Memory Manager #', i, ' initialized');
    (*
    VM[i].vmOptionsOff(vmDeleteSwap); {Uncomment to examine the swap file}
    *)
    {Link object to dereference handler}
    VM[i].LinkToDerefHandler;
    Writeln('Allocating memory blocks for manager #',i, '...');
    for j := 1 to AMax do begin
      VM[i].GetMemV(A[i][j], j*100);
      if A[i][j] <> nil then
        FillChar(VmmDrf(A[i][j])^, j*100, j mod 255);
    end;
    Writeln('Dereferencing manager #', i, ' pointers again...');
    for j := AMax downto 1 do
      if A[i][j] <> nil then
        FillChar(VmmDrf(A[i][j])^, j*100, 255 - j mod 255);
  end;
  for i := 1 to 2 do begin
    (*
    VM[i].LinkToDerefHandler; {not mandatory here but good practice}
    *)
    Writeln('Deallocating blocks in manager #', i);
    for j := 1 to AMax do
      if A[i][j] <> nil then
        VM[i].FreeMemV(A[i][j]);
    Writeln('Destroying memory manager #', i,'...');
    VM[i].Done;
    Writeln('Manager #', i, ' done.');
  end;
end.
