program MRUTest;
uses OWindows, WinTypes, WinProcs, OStdDlgs, OMRUList, WinDOS, Strings, SPopUp;
{$R MRU.RES}
const
     CM_Quit = 108;
     CM_Open = 102;

type
    PWinApp = ^TWinApp;
    TWinApp = object( TApplication )
      procedure InitMainWindow; virtual;
    end;

    PAppWin = ^TAppWin;
    TAppWin = object( TWindow )
      MRU : PMRUList;
      APop : PSPopUp;
      Buf : array[0..fsPathName] of Char;
      IniFile : array[0..fsPathName] of Char;
      KeyName : array[0..31] of Char;
      constructor Init( AParent: PWindowsObject; ATitle: PChar );
      destructor  Done; virtual;
      procedure   Quit( var Msg: TMessage ); virtual CM_First + CM_Quit;
      procedure   FileOp( var Msg: TMessage ); virtual CM_First + CM_Open;
      procedure   CMFile1( var Msg: TMessage ); virtual CM_First + CM_File1;
      procedure   CMFile2( var Msg: TMessage ); virtual CM_First + CM_File2;
      procedure   CMFile3( var Msg: TMessage ); virtual CM_First + CM_File3;
      procedure   CMFile4( var Msg: TMessage ); virtual CM_First + CM_File4;
      procedure   CMFile5( var Msg: TMessage ); virtual CM_First + CM_File5;
      procedure   PopDone( var Msg: TMessage ); virtual WM_First + WM_SPOPUP_DONE;
      procedure   SetupWindow; virtual;
    end;

    constructor TAppWin.Init;
    begin
         inherited Init( AParent, ATitle );
         Attr.Menu := LoadMenu( HInstance, 'MRU1' );
         MRU := new( PMRUList, Init(0,5,0));
         StrCopy( Buf, '*.pas' );
         StrCopy( IniFile, 'test.ini' );
         StrCopy( KeyName, 'MyFiles' );
    end;

    procedure TAppWin.SetupWindow;
    begin
         MRU^.LoadMRUList( Application^.MainWindow^.HWindow, IniFile, KeyName );
    end;

    destructor TAppWin.Done;
    begin
         MRU^.SaveMRUList( IniFile, KeyName );
         inherited Done;
    end;

    procedure TAppWin.Quit;
    begin
         inherited CMExit( Msg );
    end;

    procedure TAppWin.FileOp;
    begin
         if Application^.ExecDialog(New(PFileDialog,
         Init(@Self, PChar(sd_FileOpen), Buf))) = id_OK then
         begin
         MRU^.AddMRUItem( HWindow, Buf );
         end;
    end;

    procedure TAppWin.PopDone;
    begin
         Dispose( APop, Done );
    end;

    procedure TAppWin.CMFile1;
    var
       P : PChar;
    begin
         GetMem( P, 160 );
         MRU^.GetMRUItem( Msg.wParam, P );
         APop := PSPopUp(Application^.MakeWindow(new( PSPopUp, Init(@Self,10,10, P))));
         MRU^.DeleteMRUItem( HWindow, P );
         FreeMem( P, 160 );
    end;

    procedure TAppWin.CMFile2;
    var
       P : PChar;
    begin
         GetMem( P, 160 );
         MRU^.GetMRUItem( Msg.wParam, P );
         APop := PSPopUp(Application^.MakeWindow(new( PSPopUp, Init(@Self,10,10, P))));
         MRU^.DeleteMRUItem( HWindow, P );
         FreeMem( P, 160 );
    end;

    procedure TAppWin.CMFile3;
    var
       P : PChar;
    begin
         GetMem( P, 160 );
         MRU^.GetMRUItem( Msg.wParam, P );
         APop := PSPopUp(Application^.MakeWindow(new( PSPopUp, Init(@Self,10,10, P))));
         MRU^.DeleteMRUItem( HWindow, P );
         FreeMem( P, 160 );
    end;

    procedure TAppWin.CMFile4;
    var
       P : PChar;
    begin
         GetMem( P, 160 );
         MRU^.GetMRUItem( Msg.wParam, P );
         APop := PSPopUp(Application^.MakeWindow(new( PSPopUp, Init(@Self,10,10, P))));
         MRU^.DeleteMRUItem( HWindow, P );
         FreeMem( P, 160 );
    end;

    procedure TAppWin.CMFile5;
    var
       P : PChar;
    begin
         GetMem( P, 160 );
         MRU^.GetMRUItem( Msg.wParam, P );
         APop := PSPopUp(Application^.MakeWindow(new( PSPopUp, Init(@Self,10,10, P))));
         MRU^.DeleteMRUItem( HWindow, P );
         FreeMem( P, 160 );
    end;

    procedure TWinApp.InitMainWindow;
    begin
         MainWindow := new( PAppWin, Init( nil, 'MRU Test' ) );
    end;

var
   WinApp : TWinApp;
begin
     WinApp.Init('WINAPP');
     WinApp.Run;
     WinApp.Done;
end.