{VirtuExm}
{Program to demonstrate the use of VirtuMem.}
{This program builds a linked list with random numbers, a record number,
 and wordS from a test sentence. (Each element of the linked list has one
 word.)  It then sets the element at the head of the list to have the
 lowest number of those randomly generated.  Following that it frees the
 linked list element by element, printing as it goes.}
{This program was written by Wayne Knorr.}
{Program start date:  October 7, 1992.}
{$DEFINE USEEMS}
{$DEFINE COMPUSERVE}
Program VirtuExm;

Uses VirtuMem,Secondar;

Type

     ExamplePtr=^ExampleRec;
     ExampleRec=
        Record
          RecNum     :Integer;
          RndNum     :Word;
          EnglishWord:String;
          Next       :LongInt{ExamplePtr};
        End;

Var

     ExampleHead :LongInt{Virtual ExamplePtr};
     CurExample  :LongInt{Virtual ExamplePtr};
     CurRecordNum:Byte;
     TestSentence:String;

{--------------------}
{ExamplePtrR}
{Virtual deferencing for ExampleRec types.  This routine is useful because
 it saves the need to typecast pointers returned by the routine R.}
Function ExamplePtrR(   Virt :LongInt;
                        Mucky:Integer):ExamplePtr;

Var

     Temp:ExamplePtr;                  {It is useful to define a temporary
                                        variable and do the conversion in
                                        two lines so the structure may be
                                        more easily looked at while
                                        debugging.}

BEGIN

  Temp:=R(Virt,Mucky);                 {Reference the virtual pointer, putting it in real memory}
  ExamplePtrR:=ExamplePtr(Temp);       {Type cast to appropriate pointer type}

END;
{--------------------}
{LMin}
{Compares two Words, copying the least of the two into the first.}
Procedure LMin(var FirstLong :Word;
                   SecondLong:Word);

BEGIN

  If (SecondLong<FirstLong) then
       FirstLong:=SecondLong;

END;
{====================}
bEGIN {Main program.}

  Randomize;
  OpenBook(FALSE);                     {Start VirtuMem, allowing EMS to be used}
  TestSentence:='A dog and a cat ran down the street.';
  CurRecordNum:=1;

  {Build the linked list from tail to head.}
  ExampleHead:=Null;
  While (Pos(' ',TestSentence)<>0) do  {One dynamic record for each word in the test sentence}
     Begin
       CurExample:=ANew(SizeOf(ExampleRec));
       With ExamplePtrR(CurExample,Stay)^ do
          Begin
            RecNum:=CurRecordNum;
            RndNum:=Random(MaxInt);
            EnglishWord:=Copy(TestSentence,1,Pos(' ',TestSentence)-1);        {Extract a word and truncate the sentence}
            TestSentence:=Copy(TestSentence,Pos(' ',TestSentence)+1,255);
            Next:=ExampleHead;
          End;
       Unstay(CurExample);
       ExampleHead:=CurExample;
       CurRecordNum:=CurRecordNum+1;
     End;
  {Pick up the last word.}
  CurExample:=ANew(SizeOf(ExampleRec));
  ExamplePtrR(CurExample,Dirt)^.RecNum:=CurRecordNum;
  ExamplePtrR(CurExample,Dirt)^.RndNum:=Random(MaxInt);
  ExamplePtrR(CurExample,Dirt)^.EnglishWord:=TestSentence;
  TestSentence:='';
  ExamplePtrR(CurExample,Dirt)^.Next:=ExampleHead;
  ExampleHead:=CurExample;
  CurRecordNum:=CurRecordNum+1;

  {Do a simple test involving double dereferencing.}
  If ((ExamplePtrR(ExamplePtrR(CurExample,Clen)^.Next,Clen)^.RndNum mod 2)=0)
    then
       WriteLn('The second link in the list has an even random number, ',
         ExamplePtrR(ExamplePtrR(CurExample,Clen)^.Next,Clen)^.RndNum,'.' );

  {Find the lowest random number in the linked list and make the head's
   random number equal to it.}
  CurExample:=ExampleHead;
  While (CurExample<>Null) do
     Begin
       {Note in the following call, the first parameter is passed using
        'Stay', while the second is passed using 'Clen'.  This is because
        the first is a variable parameter, expected to be in a specific
        place in memory, while the second is a value parameter and is
        not changed at all.  Technically here it is safe to use 'Dirt'
        in place of 'Stay' because LMin makes no calls to the virtual
        memory system and therefore ExampleHead is guaranteed to remain
        in the same real memory location until we return to this portion
        of the program.}
       LMin(ExamplePtrR(ExampleHead,Stay)^.RndNum,
         ExamplePtrR(CurExample,Clen)^.RndNum);
       Unstay(ExampleHead);
       ExamplePtrR(CurExample,Dirt)^.RecNum:=CurRecordNum-
         ExamplePtrR(CurExample,Clen)^.RecNum;                                {Reverse the order of the numbering.}
       CurExample:=ExamplePtrR(CurExample,Clen)^.Next;
     End;

  {Print and disassemble the linked list.}
  CurExample:=ExampleHead;
  While (CurExample<>Null) do
     Begin
       With ExamplePtrR(CurExample,Stay)^ do
          Begin
            WriteLn('Record number ',RecNum);
            Write  ('Has random number ',RndNum);
            WriteLn('        ',EnglishWord);
            ExampleHead:=Next;
          End;
       Unstay(CurExample);
       Depossess(CurExample,SizeOf(ExampleRec));
       CurExample:=ExampleHead;
     End;

  CloseBook;

eND.