program ViArryT1;    {Test ViAray unit      Turbo Pascal 5.5}
{$R-,S-}

uses
  Crt,ViAray;

type
  ElTyp = record     {data structure of each array element}
            Str : string[50];
            Id  : longint;
          end;
var
  ExitSave : pointer;
  Time : longint absolute $0040:$006C;
  A1 : VirArray;
  ElData : ElTyp;
  ListSize,Elements,BuffSize,BuffSize2,Tick1,I,J : longint;
  ElemSize : word;

{$F+} procedure PrgmExit;
begin
  ExitProc := ExitSave;
  if ErrMsg <> '' then Writeln(#13,#10,ErrMsg);
end; {$F-}

begin
  ExitSave := ExitProc;
  ExitProc := @PrgmExit;
  Elements := 150;
  ElemSize := SizeOf(ElData);
  BuffSize :=  441;    {RAM buffer is set unrealistically low for demo use}
  BuffSize2 := 1000;
  Writeln(#13,#10,'Initialize array with ',Elements, ' elements and ',BuffSize,
           ' bytes in RAM buffer');
  Init(A1,true,Elements,ElemSize,BuffSize,'VITST.DAT');
  {  Writeln('BSize: ',A1.BSize,'  SSize: ',A1.SSize);  }
  for I := 0 to Elements-1 do
    begin
      ElData.Id := I;
      Accept(A1,ElData,I);
    end;
  if Elements > 20 then ListSize := 20 else ListSize := Elements;
  Writeln('Retrieve from array ',ListSize, ' elements which have a value',
                                                 ' = to the element number:');
  RandSeed := 1;
  for I := 0 to ListSize-1 do
    begin
      J := Random(Elements);
      Write(J:8);
    end;
  Writeln('Actual retrieved values:');
  RandSeed := 1;
  Tick1 := Time;
  for I := 0 to ListSize-1 do
    begin
      J := Random(Elements);
      Retrieve(A1,ElData,J);
      Write(ElData.Id:8);
    end;
  Writeln('Ticks (18.2/sec): ',Time-Tick1);
  Writeln('Resize RAM buffer from ',BuffSize,' to ',BuffSize2,' bytes',
                        ' and retrieve same data:');
  ReSize(A1,Elements,BuffSize2);
  RandSeed := 1;
  Tick1 := Time;
  for I := 0 to ListSize-1 do
    begin
      J := Random(Elements);
      Retrieve(A1,ElData,J);
      Write(ElData.Id:8);
    end;
  Writeln('Ticks (18.2/sec): ',Time-Tick1);
  J := 1;  I := 10;
  Writeln('Swap data between elements ',J,' and ',I,':');
  Write('Before: ');
  Retrieve(A1,ElData,J);
  Write(ElData.Id:8);
  Retrieve(A1,ElData,I);
  Write(ElData.Id:8);
  Swap(A1,J,I);
  Write('      After: ');
  Retrieve(A1,ElData,J);
  Write(ElData.Id:8);
  Retrieve(A1,ElData,I);
  Write(ElData.Id:8);
  Writeln;
  Writeln('Copy data from element ',J,' to ',I,':');
  Write('Before: ');
  Retrieve(A1,ElData,J);
  Write(ElData.Id:8);
  Retrieve(A1,ElData,I);
  Write(ElData.Id:8);
  Copy(A1,A1,J,I);
  Write('      After: ');
  Retrieve(A1,ElData,J);
  Write(ElData.Id:8);
  Retrieve(A1,ElData,I);
  Write(ElData.Id:8);
  Writeln;
  Destroy(A1);
end.